require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&OPENSSL_SSL_H)) {
    eval 'sub OPENSSL_SSL_H () {1;}' unless defined(&OPENSSL_SSL_H);
    require 'openssl/macros.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub HEADER_SSL_H () {1;}' unless defined(&HEADER_SSL_H);
    }
    require 'openssl/e_os2.ph';
    require 'openssl/e_ostime.ph';
    require 'openssl/opensslconf.ph';
    require 'openssl/comp.ph';
    require 'openssl/bio.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	require 'openssl/x509.ph';
	require 'openssl/crypto.ph';
	require 'openssl/buffer.ph';
    }
    require 'openssl/lhash.ph';
    require 'openssl/pem.ph';
    require 'openssl/hmac.ph';
    require 'openssl/async.ph';
    require 'openssl/safestack.ph';
    require 'openssl/symhacks.ph';
    require 'openssl/ct.ph';
    require 'openssl/sslerr.ph';
    require 'openssl/prov_ssl.ph';
    unless(defined(&OPENSSL_NO_STDIO)) {
	require 'stdio.ph';
    }
    if(defined(&__cplusplus)) {
    }
    eval 'sub SSL_SESSION_ASN1_VERSION () {0x1;}' unless defined(&SSL_SESSION_ASN1_VERSION);
    eval 'sub SSL_MAX_SSL_SESSION_ID_LENGTH () {32;}' unless defined(&SSL_MAX_SSL_SESSION_ID_LENGTH);
    eval 'sub SSL_MAX_SID_CTX_LENGTH () {32;}' unless defined(&SSL_MAX_SID_CTX_LENGTH);
    eval 'sub SSL_MIN_RSA_MODULUS_LENGTH_IN_BYTES () {(512/8);}' unless defined(&SSL_MIN_RSA_MODULUS_LENGTH_IN_BYTES);
    eval 'sub SSL_MAX_KEY_ARG_LENGTH () {8;}' unless defined(&SSL_MAX_KEY_ARG_LENGTH);
    eval 'sub SSL_MAX_PIPELINES () {32;}' unless defined(&SSL_MAX_PIPELINES);
    eval 'sub SSL_TXT_LOW () {"LOW";}' unless defined(&SSL_TXT_LOW);
    eval 'sub SSL_TXT_MEDIUM () {"MEDIUM";}' unless defined(&SSL_TXT_MEDIUM);
    eval 'sub SSL_TXT_HIGH () {"HIGH";}' unless defined(&SSL_TXT_HIGH);
    eval 'sub SSL_TXT_FIPS () {"FIPS";}' unless defined(&SSL_TXT_FIPS);
    eval 'sub SSL_TXT_aNULL () {"aNULL";}' unless defined(&SSL_TXT_aNULL);
    eval 'sub SSL_TXT_eNULL () {"eNULL";}' unless defined(&SSL_TXT_eNULL);
    eval 'sub SSL_TXT_NULL () {"NULL";}' unless defined(&SSL_TXT_NULL);
    eval 'sub SSL_TXT_kRSA () {"kRSA";}' unless defined(&SSL_TXT_kRSA);
    eval 'sub SSL_TXT_kDHr () {"kDHr";}' unless defined(&SSL_TXT_kDHr);
    eval 'sub SSL_TXT_kDHd () {"kDHd";}' unless defined(&SSL_TXT_kDHd);
    eval 'sub SSL_TXT_kDH () {"kDH";}' unless defined(&SSL_TXT_kDH);
    eval 'sub SSL_TXT_kEDH () {"kEDH";}' unless defined(&SSL_TXT_kEDH);
    eval 'sub SSL_TXT_kDHE () {"kDHE";}' unless defined(&SSL_TXT_kDHE);
    eval 'sub SSL_TXT_kECDHr () {"kECDHr";}' unless defined(&SSL_TXT_kECDHr);
    eval 'sub SSL_TXT_kECDHe () {"kECDHe";}' unless defined(&SSL_TXT_kECDHe);
    eval 'sub SSL_TXT_kECDH () {"kECDH";}' unless defined(&SSL_TXT_kECDH);
    eval 'sub SSL_TXT_kEECDH () {"kEECDH";}' unless defined(&SSL_TXT_kEECDH);
    eval 'sub SSL_TXT_kECDHE () {"kECDHE";}' unless defined(&SSL_TXT_kECDHE);
    eval 'sub SSL_TXT_kPSK () {"kPSK";}' unless defined(&SSL_TXT_kPSK);
    eval 'sub SSL_TXT_kRSAPSK () {"kRSAPSK";}' unless defined(&SSL_TXT_kRSAPSK);
    eval 'sub SSL_TXT_kECDHEPSK () {"kECDHEPSK";}' unless defined(&SSL_TXT_kECDHEPSK);
    eval 'sub SSL_TXT_kDHEPSK () {"kDHEPSK";}' unless defined(&SSL_TXT_kDHEPSK);
    eval 'sub SSL_TXT_kGOST () {"kGOST";}' unless defined(&SSL_TXT_kGOST);
    eval 'sub SSL_TXT_kGOST18 () {"kGOST18";}' unless defined(&SSL_TXT_kGOST18);
    eval 'sub SSL_TXT_kSRP () {"kSRP";}' unless defined(&SSL_TXT_kSRP);
    eval 'sub SSL_TXT_aRSA () {"aRSA";}' unless defined(&SSL_TXT_aRSA);
    eval 'sub SSL_TXT_aDSS () {"aDSS";}' unless defined(&SSL_TXT_aDSS);
    eval 'sub SSL_TXT_aDH () {"aDH";}' unless defined(&SSL_TXT_aDH);
    eval 'sub SSL_TXT_aECDH () {"aECDH";}' unless defined(&SSL_TXT_aECDH);
    eval 'sub SSL_TXT_aECDSA () {"aECDSA";}' unless defined(&SSL_TXT_aECDSA);
    eval 'sub SSL_TXT_aPSK () {"aPSK";}' unless defined(&SSL_TXT_aPSK);
    eval 'sub SSL_TXT_aGOST94 () {"aGOST94";}' unless defined(&SSL_TXT_aGOST94);
    eval 'sub SSL_TXT_aGOST01 () {"aGOST01";}' unless defined(&SSL_TXT_aGOST01);
    eval 'sub SSL_TXT_aGOST12 () {"aGOST12";}' unless defined(&SSL_TXT_aGOST12);
    eval 'sub SSL_TXT_aGOST () {"aGOST";}' unless defined(&SSL_TXT_aGOST);
    eval 'sub SSL_TXT_aSRP () {"aSRP";}' unless defined(&SSL_TXT_aSRP);
    eval 'sub SSL_TXT_DSS () {"DSS";}' unless defined(&SSL_TXT_DSS);
    eval 'sub SSL_TXT_DH () {"DH";}' unless defined(&SSL_TXT_DH);
    eval 'sub SSL_TXT_DHE () {"DHE";}' unless defined(&SSL_TXT_DHE);
    eval 'sub SSL_TXT_EDH () {"EDH";}' unless defined(&SSL_TXT_EDH);
    eval 'sub SSL_TXT_ADH () {"ADH";}' unless defined(&SSL_TXT_ADH);
    eval 'sub SSL_TXT_RSA () {"RSA";}' unless defined(&SSL_TXT_RSA);
    eval 'sub SSL_TXT_ECDH () {"ECDH";}' unless defined(&SSL_TXT_ECDH);
    eval 'sub SSL_TXT_EECDH () {"EECDH";}' unless defined(&SSL_TXT_EECDH);
    eval 'sub SSL_TXT_ECDHE () {"ECDHE";}' unless defined(&SSL_TXT_ECDHE);
    eval 'sub SSL_TXT_AECDH () {"AECDH";}' unless defined(&SSL_TXT_AECDH);
    eval 'sub SSL_TXT_ECDSA () {"ECDSA";}' unless defined(&SSL_TXT_ECDSA);
    eval 'sub SSL_TXT_PSK () {"PSK";}' unless defined(&SSL_TXT_PSK);
    eval 'sub SSL_TXT_SRP () {"SRP";}' unless defined(&SSL_TXT_SRP);
    eval 'sub SSL_TXT_DES () {"DES";}' unless defined(&SSL_TXT_DES);
    eval 'sub SSL_TXT_3DES () {"3DES";}' unless defined(&SSL_TXT_3DES);
    eval 'sub SSL_TXT_RC4 () {"RC4";}' unless defined(&SSL_TXT_RC4);
    eval 'sub SSL_TXT_RC2 () {"RC2";}' unless defined(&SSL_TXT_RC2);
    eval 'sub SSL_TXT_IDEA () {"IDEA";}' unless defined(&SSL_TXT_IDEA);
    eval 'sub SSL_TXT_SEED () {"SEED";}' unless defined(&SSL_TXT_SEED);
    eval 'sub SSL_TXT_AES128 () {"AES128";}' unless defined(&SSL_TXT_AES128);
    eval 'sub SSL_TXT_AES256 () {"AES256";}' unless defined(&SSL_TXT_AES256);
    eval 'sub SSL_TXT_AES () {"AES";}' unless defined(&SSL_TXT_AES);
    eval 'sub SSL_TXT_AES_GCM () {"AESGCM";}' unless defined(&SSL_TXT_AES_GCM);
    eval 'sub SSL_TXT_AES_CCM () {"AESCCM";}' unless defined(&SSL_TXT_AES_CCM);
    eval 'sub SSL_TXT_AES_CCM_8 () {"AESCCM8";}' unless defined(&SSL_TXT_AES_CCM_8);
    eval 'sub SSL_TXT_CAMELLIA128 () {"CAMELLIA128";}' unless defined(&SSL_TXT_CAMELLIA128);
    eval 'sub SSL_TXT_CAMELLIA256 () {"CAMELLIA256";}' unless defined(&SSL_TXT_CAMELLIA256);
    eval 'sub SSL_TXT_CAMELLIA () {"CAMELLIA";}' unless defined(&SSL_TXT_CAMELLIA);
    eval 'sub SSL_TXT_CHACHA20 () {"CHACHA20";}' unless defined(&SSL_TXT_CHACHA20);
    eval 'sub SSL_TXT_GOST () {"GOST89";}' unless defined(&SSL_TXT_GOST);
    eval 'sub SSL_TXT_ARIA () {"ARIA";}' unless defined(&SSL_TXT_ARIA);
    eval 'sub SSL_TXT_ARIA_GCM () {"ARIAGCM";}' unless defined(&SSL_TXT_ARIA_GCM);
    eval 'sub SSL_TXT_ARIA128 () {"ARIA128";}' unless defined(&SSL_TXT_ARIA128);
    eval 'sub SSL_TXT_ARIA256 () {"ARIA256";}' unless defined(&SSL_TXT_ARIA256);
    eval 'sub SSL_TXT_GOST2012_GOST8912_GOST8912 () {"GOST2012-GOST8912-GOST8912";}' unless defined(&SSL_TXT_GOST2012_GOST8912_GOST8912);
    eval 'sub SSL_TXT_CBC () {"CBC";}' unless defined(&SSL_TXT_CBC);
    eval 'sub SSL_TXT_MD5 () {"MD5";}' unless defined(&SSL_TXT_MD5);
    eval 'sub SSL_TXT_SHA1 () {"SHA1";}' unless defined(&SSL_TXT_SHA1);
    eval 'sub SSL_TXT_SHA () {"SHA";}' unless defined(&SSL_TXT_SHA);
    eval 'sub SSL_TXT_GOST94 () {"GOST94";}' unless defined(&SSL_TXT_GOST94);
    eval 'sub SSL_TXT_GOST89MAC () {"GOST89MAC";}' unless defined(&SSL_TXT_GOST89MAC);
    eval 'sub SSL_TXT_GOST12 () {"GOST12";}' unless defined(&SSL_TXT_GOST12);
    eval 'sub SSL_TXT_GOST89MAC12 () {"GOST89MAC12";}' unless defined(&SSL_TXT_GOST89MAC12);
    eval 'sub SSL_TXT_SHA256 () {"SHA256";}' unless defined(&SSL_TXT_SHA256);
    eval 'sub SSL_TXT_SHA384 () {"SHA384";}' unless defined(&SSL_TXT_SHA384);
    eval 'sub SSL_TXT_SSLV3 () {"SSLv3";}' unless defined(&SSL_TXT_SSLV3);
    eval 'sub SSL_TXT_TLSV1 () {"TLSv1";}' unless defined(&SSL_TXT_TLSV1);
    eval 'sub SSL_TXT_TLSV1_1 () {"TLSv1.1";}' unless defined(&SSL_TXT_TLSV1_1);
    eval 'sub SSL_TXT_TLSV1_2 () {"TLSv1.2";}' unless defined(&SSL_TXT_TLSV1_2);
    eval 'sub SSL_TXT_ALL () {"ALL";}' unless defined(&SSL_TXT_ALL);
    eval 'sub SSL_TXT_CMPALL () {"COMPLEMENTOFALL";}' unless defined(&SSL_TXT_CMPALL);
    eval 'sub SSL_TXT_CMPDEF () {"COMPLEMENTOFDEFAULT";}' unless defined(&SSL_TXT_CMPDEF);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub SSL_DEFAULT_CIPHER_LIST () {"ALL:!COMPLEMENTOFDEFAULT:!eNULL";}' unless defined(&SSL_DEFAULT_CIPHER_LIST);
	eval 'sub TLS_DEFAULT_CIPHERSUITES () {"TLS_AES_256_GCM_SHA384:" "TLS_CHACHA20_POLY1305_SHA256:" "TLS_AES_128_GCM_SHA256";}' unless defined(&TLS_DEFAULT_CIPHERSUITES);
    }
    eval 'sub SSL_SENT_SHUTDOWN () {1;}' unless defined(&SSL_SENT_SHUTDOWN);
    eval 'sub SSL_RECEIVED_SHUTDOWN () {2;}' unless defined(&SSL_RECEIVED_SHUTDOWN);
    if(defined(&__cplusplus)) {
    }
    if(defined(&__cplusplus)) {
    }
    eval 'sub SSL_FILETYPE_ASN1 () { &X509_FILETYPE_ASN1;}' unless defined(&SSL_FILETYPE_ASN1);
    eval 'sub SSL_FILETYPE_PEM () { &X509_FILETYPE_PEM;}' unless defined(&SSL_FILETYPE_PEM);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_SRTP_PROTECTION_PROFILE_sk_type($sk)));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_num);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_value {
        my($sk, $idx) = @_;
	    eval q((( &SRTP_PROTECTION_PROFILE *) &OPENSSL_sk_value( &ossl_check_const_SRTP_PROTECTION_PROFILE_sk_type($sk), ($idx))));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_value);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &SRTP_PROTECTION_PROFILE) *) &OPENSSL_sk_new( &ossl_check_SRTP_PROTECTION_PROFILE_compfunc_type($cmp))));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_new);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_new_null () {
        eval q((( &STACK_OF( &SRTP_PROTECTION_PROFILE) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_new_null);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &SRTP_PROTECTION_PROFILE) *) &OPENSSL_sk_new_reserve( &ossl_check_SRTP_PROTECTION_PROFILE_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_new_reserve);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_SRTP_PROTECTION_PROFILE_sk_type($sk), ($n)));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_reserve);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_SRTP_PROTECTION_PROFILE_sk_type($sk)));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_free);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_SRTP_PROTECTION_PROFILE_sk_type($sk)));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_zero);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_delete {
        my($sk, $i) = @_;
	    eval q((( &SRTP_PROTECTION_PROFILE *) &OPENSSL_sk_delete( &ossl_check_SRTP_PROTECTION_PROFILE_sk_type($sk), ($i))));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_delete);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &SRTP_PROTECTION_PROFILE *) &OPENSSL_sk_delete_ptr( &ossl_check_SRTP_PROTECTION_PROFILE_sk_type($sk),  &ossl_check_SRTP_PROTECTION_PROFILE_type($ptr))));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_delete_ptr);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_SRTP_PROTECTION_PROFILE_sk_type($sk),  &ossl_check_SRTP_PROTECTION_PROFILE_type($ptr)));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_push);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_SRTP_PROTECTION_PROFILE_sk_type($sk),  &ossl_check_SRTP_PROTECTION_PROFILE_type($ptr)));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_unshift);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_pop {
        my($sk) = @_;
	    eval q((( &SRTP_PROTECTION_PROFILE *) &OPENSSL_sk_pop( &ossl_check_SRTP_PROTECTION_PROFILE_sk_type($sk))));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_pop);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_shift {
        my($sk) = @_;
	    eval q((( &SRTP_PROTECTION_PROFILE *) &OPENSSL_sk_shift( &ossl_check_SRTP_PROTECTION_PROFILE_sk_type($sk))));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_shift);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_SRTP_PROTECTION_PROFILE_sk_type($sk), &ossl_check_SRTP_PROTECTION_PROFILE_freefunc_type($freefunc)));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_pop_free);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_SRTP_PROTECTION_PROFILE_sk_type($sk),  &ossl_check_SRTP_PROTECTION_PROFILE_type($ptr), ($idx)));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_insert);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &SRTP_PROTECTION_PROFILE *) &OPENSSL_sk_set( &ossl_check_SRTP_PROTECTION_PROFILE_sk_type($sk), ($idx),  &ossl_check_SRTP_PROTECTION_PROFILE_type($ptr))));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_set);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_SRTP_PROTECTION_PROFILE_sk_type($sk),  &ossl_check_SRTP_PROTECTION_PROFILE_type($ptr)));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_find);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_SRTP_PROTECTION_PROFILE_sk_type($sk),  &ossl_check_SRTP_PROTECTION_PROFILE_type($ptr)));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_find_ex);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_SRTP_PROTECTION_PROFILE_sk_type($sk),  &ossl_check_SRTP_PROTECTION_PROFILE_type($ptr), $pnum));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_find_all);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_SRTP_PROTECTION_PROFILE_sk_type($sk)));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_sort);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_SRTP_PROTECTION_PROFILE_sk_type($sk)));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_is_sorted);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &SRTP_PROTECTION_PROFILE) *) &OPENSSL_sk_dup( &ossl_check_const_SRTP_PROTECTION_PROFILE_sk_type($sk))));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_dup);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &SRTP_PROTECTION_PROFILE) *) &OPENSSL_sk_deep_copy( &ossl_check_const_SRTP_PROTECTION_PROFILE_sk_type($sk),  &ossl_check_SRTP_PROTECTION_PROFILE_copyfunc_type($copyfunc),  &ossl_check_SRTP_PROTECTION_PROFILE_freefunc_type($freefunc))));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_deep_copy);
    eval 'sub sk_SRTP_PROTECTION_PROFILE_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_SRTP_PROTECTION_PROFILE_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_SRTP_PROTECTION_PROFILE_sk_type($sk),  &ossl_check_SRTP_PROTECTION_PROFILE_compfunc_type($cmp))));
    }' unless defined(&sk_SRTP_PROTECTION_PROFILE_set_cmp_func);
    eval 'sub SSL_EXT_TLS_ONLY () {0x1;}' unless defined(&SSL_EXT_TLS_ONLY);
    eval 'sub SSL_EXT_DTLS_ONLY () {0x2;}' unless defined(&SSL_EXT_DTLS_ONLY);
    eval 'sub SSL_EXT_TLS_IMPLEMENTATION_ONLY () {0x4;}' unless defined(&SSL_EXT_TLS_IMPLEMENTATION_ONLY);
    eval 'sub SSL_EXT_SSL3_ALLOWED () {0x8;}' unless defined(&SSL_EXT_SSL3_ALLOWED);
    eval 'sub SSL_EXT_TLS1_2_AND_BELOW_ONLY () {0x10;}' unless defined(&SSL_EXT_TLS1_2_AND_BELOW_ONLY);
    eval 'sub SSL_EXT_TLS1_3_ONLY () {0x20;}' unless defined(&SSL_EXT_TLS1_3_ONLY);
    eval 'sub SSL_EXT_IGNORE_ON_RESUMPTION () {0x40;}' unless defined(&SSL_EXT_IGNORE_ON_RESUMPTION);
    eval 'sub SSL_EXT_CLIENT_HELLO () {0x80;}' unless defined(&SSL_EXT_CLIENT_HELLO);
    eval 'sub SSL_EXT_TLS1_2_SERVER_HELLO () {0x100;}' unless defined(&SSL_EXT_TLS1_2_SERVER_HELLO);
    eval 'sub SSL_EXT_TLS1_3_SERVER_HELLO () {0x200;}' unless defined(&SSL_EXT_TLS1_3_SERVER_HELLO);
    eval 'sub SSL_EXT_TLS1_3_ENCRYPTED_EXTENSIONS () {0x400;}' unless defined(&SSL_EXT_TLS1_3_ENCRYPTED_EXTENSIONS);
    eval 'sub SSL_EXT_TLS1_3_HELLO_RETRY_REQUEST () {0x800;}' unless defined(&SSL_EXT_TLS1_3_HELLO_RETRY_REQUEST);
    eval 'sub SSL_EXT_TLS1_3_CERTIFICATE () {0x1000;}' unless defined(&SSL_EXT_TLS1_3_CERTIFICATE);
    eval 'sub SSL_EXT_TLS1_3_NEW_SESSION_TICKET () {0x2000;}' unless defined(&SSL_EXT_TLS1_3_NEW_SESSION_TICKET);
    eval 'sub SSL_EXT_TLS1_3_CERTIFICATE_REQUEST () {0x4000;}' unless defined(&SSL_EXT_TLS1_3_CERTIFICATE_REQUEST);
    eval 'sub SSL_EXT_TLS1_3_CERTIFICATE_COMPRESSION () {0x8000;}' unless defined(&SSL_EXT_TLS1_3_CERTIFICATE_COMPRESSION);
    eval 'sub SSL_EXT_TLS1_3_RAW_PUBLIC_KEY () {0x10000;}' unless defined(&SSL_EXT_TLS1_3_RAW_PUBLIC_KEY);
    eval 'sub SSL_OP_BIT {
        my($n) = @_;
	    eval q((( &uint64_t)1<< ( &uint64_t)$n));
    }' unless defined(&SSL_OP_BIT);
    eval 'sub SSL_OP_NO_EXTENDED_MASTER_SECRET () { &SSL_OP_BIT(0);}' unless defined(&SSL_OP_NO_EXTENDED_MASTER_SECRET);
    eval 'sub SSL_OP_CLEANSE_PLAINTEXT () { &SSL_OP_BIT(1);}' unless defined(&SSL_OP_CLEANSE_PLAINTEXT);
    eval 'sub SSL_OP_LEGACY_SERVER_CONNECT () { &SSL_OP_BIT(2);}' unless defined(&SSL_OP_LEGACY_SERVER_CONNECT);
    eval 'sub SSL_OP_ENABLE_KTLS () { &SSL_OP_BIT(3);}' unless defined(&SSL_OP_ENABLE_KTLS);
    eval 'sub SSL_OP_TLSEXT_PADDING () { &SSL_OP_BIT(4);}' unless defined(&SSL_OP_TLSEXT_PADDING);
    eval 'sub SSL_OP_SAFARI_ECDHE_ECDSA_BUG () { &SSL_OP_BIT(6);}' unless defined(&SSL_OP_SAFARI_ECDHE_ECDSA_BUG);
    eval 'sub SSL_OP_IGNORE_UNEXPECTED_EOF () { &SSL_OP_BIT(7);}' unless defined(&SSL_OP_IGNORE_UNEXPECTED_EOF);
    eval 'sub SSL_OP_ALLOW_CLIENT_RENEGOTIATION () { &SSL_OP_BIT(8);}' unless defined(&SSL_OP_ALLOW_CLIENT_RENEGOTIATION);
    eval 'sub SSL_OP_DISABLE_TLSEXT_CA_NAMES () { &SSL_OP_BIT(9);}' unless defined(&SSL_OP_DISABLE_TLSEXT_CA_NAMES);
    eval 'sub SSL_OP_ALLOW_NO_DHE_KEX () { &SSL_OP_BIT(10);}' unless defined(&SSL_OP_ALLOW_NO_DHE_KEX);
    eval 'sub SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS () { &SSL_OP_BIT(11);}' unless defined(&SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS);
    eval 'sub SSL_OP_NO_QUERY_MTU () { &SSL_OP_BIT(12);}' unless defined(&SSL_OP_NO_QUERY_MTU);
    eval 'sub SSL_OP_COOKIE_EXCHANGE () { &SSL_OP_BIT(13);}' unless defined(&SSL_OP_COOKIE_EXCHANGE);
    eval 'sub SSL_OP_NO_TICKET () { &SSL_OP_BIT(14);}' unless defined(&SSL_OP_NO_TICKET);
    unless(defined(&OPENSSL_NO_DTLS1_METHOD)) {
	eval 'sub SSL_OP_CISCO_ANYCONNECT () { &SSL_OP_BIT(15);}' unless defined(&SSL_OP_CISCO_ANYCONNECT);
    }
    eval 'sub SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION () { &SSL_OP_BIT(16);}' unless defined(&SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION);
    eval 'sub SSL_OP_NO_COMPRESSION () { &SSL_OP_BIT(17);}' unless defined(&SSL_OP_NO_COMPRESSION);
    eval 'sub SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION () { &SSL_OP_BIT(18);}' unless defined(&SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION);
    eval 'sub SSL_OP_NO_ENCRYPT_THEN_MAC () { &SSL_OP_BIT(19);}' unless defined(&SSL_OP_NO_ENCRYPT_THEN_MAC);
    eval 'sub SSL_OP_ENABLE_MIDDLEBOX_COMPAT () { &SSL_OP_BIT(20);}' unless defined(&SSL_OP_ENABLE_MIDDLEBOX_COMPAT);
    eval 'sub SSL_OP_PRIORITIZE_CHACHA () { &SSL_OP_BIT(21);}' unless defined(&SSL_OP_PRIORITIZE_CHACHA);
    eval 'sub SSL_OP_CIPHER_SERVER_PREFERENCE () { &SSL_OP_BIT(22);}' unless defined(&SSL_OP_CIPHER_SERVER_PREFERENCE);
    eval 'sub SSL_OP_TLS_ROLLBACK_BUG () { &SSL_OP_BIT(23);}' unless defined(&SSL_OP_TLS_ROLLBACK_BUG);
    eval 'sub SSL_OP_NO_ANTI_REPLAY () { &SSL_OP_BIT(24);}' unless defined(&SSL_OP_NO_ANTI_REPLAY);
    eval 'sub SSL_OP_NO_SSLv3 () { &SSL_OP_BIT(25);}' unless defined(&SSL_OP_NO_SSLv3);
    eval 'sub SSL_OP_NO_TLSv1 () { &SSL_OP_BIT(26);}' unless defined(&SSL_OP_NO_TLSv1);
    eval 'sub SSL_OP_NO_TLSv1_2 () { &SSL_OP_BIT(27);}' unless defined(&SSL_OP_NO_TLSv1_2);
    eval 'sub SSL_OP_NO_TLSv1_1 () { &SSL_OP_BIT(28);}' unless defined(&SSL_OP_NO_TLSv1_1);
    eval 'sub SSL_OP_NO_TLSv1_3 () { &SSL_OP_BIT(29);}' unless defined(&SSL_OP_NO_TLSv1_3);
    eval 'sub SSL_OP_NO_DTLSv1 () { &SSL_OP_BIT(26);}' unless defined(&SSL_OP_NO_DTLSv1);
    eval 'sub SSL_OP_NO_DTLSv1_2 () { &SSL_OP_BIT(27);}' unless defined(&SSL_OP_NO_DTLSv1_2);
    eval 'sub SSL_OP_NO_RENEGOTIATION () { &SSL_OP_BIT(30);}' unless defined(&SSL_OP_NO_RENEGOTIATION);
    eval 'sub SSL_OP_CRYPTOPRO_TLSEXT_BUG () { &SSL_OP_BIT(31);}' unless defined(&SSL_OP_CRYPTOPRO_TLSEXT_BUG);
    eval 'sub SSL_OP_NO_TX_CERTIFICATE_COMPRESSION () { &SSL_OP_BIT(32);}' unless defined(&SSL_OP_NO_TX_CERTIFICATE_COMPRESSION);
    eval 'sub SSL_OP_NO_RX_CERTIFICATE_COMPRESSION () { &SSL_OP_BIT(33);}' unless defined(&SSL_OP_NO_RX_CERTIFICATE_COMPRESSION);
    eval 'sub SSL_OP_ENABLE_KTLS_TX_ZEROCOPY_SENDFILE () { &SSL_OP_BIT(34);}' unless defined(&SSL_OP_ENABLE_KTLS_TX_ZEROCOPY_SENDFILE);
    eval 'sub SSL_OP_PREFER_NO_DHE_KEX () { &SSL_OP_BIT(35);}' unless defined(&SSL_OP_PREFER_NO_DHE_KEX);
    eval 'sub SSL_OP_NO_SSL_MASK () {(  &SSL_OP_NO_SSLv3 |  &SSL_OP_NO_TLSv1 |  &SSL_OP_NO_TLSv1_1 |  &SSL_OP_NO_TLSv1_2 |  &SSL_OP_NO_TLSv1_3 );}' unless defined(&SSL_OP_NO_SSL_MASK);
    eval 'sub SSL_OP_NO_DTLS_MASK () {(  &SSL_OP_NO_DTLSv1 |  &SSL_OP_NO_DTLSv1_2 );}' unless defined(&SSL_OP_NO_DTLS_MASK);
    eval 'sub SSL_OP_ALL () {(  &SSL_OP_CRYPTOPRO_TLSEXT_BUG |  &SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS |  &SSL_OP_TLSEXT_PADDING |  &SSL_OP_SAFARI_ECDHE_ECDSA_BUG );}' unless defined(&SSL_OP_ALL);
    eval 'sub SSL_OP_MICROSOFT_SESS_ID_BUG () {0x;}' unless defined(&SSL_OP_MICROSOFT_SESS_ID_BUG);
    eval 'sub SSL_OP_NETSCAPE_CHALLENGE_BUG () {0x;}' unless defined(&SSL_OP_NETSCAPE_CHALLENGE_BUG);
    eval 'sub SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG () {0x;}' unless defined(&SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG);
    eval 'sub SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG () {0x;}' unless defined(&SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG);
    eval 'sub SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER () {0x;}' unless defined(&SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER);
    eval 'sub SSL_OP_MSIE_SSLV2_RSA_PADDING () {0x;}' unless defined(&SSL_OP_MSIE_SSLV2_RSA_PADDING);
    eval 'sub SSL_OP_SSLEAY_080_CLIENT_DH_BUG () {0x;}' unless defined(&SSL_OP_SSLEAY_080_CLIENT_DH_BUG);
    eval 'sub SSL_OP_TLS_D5_BUG () {0x;}' unless defined(&SSL_OP_TLS_D5_BUG);
    eval 'sub SSL_OP_TLS_BLOCK_PADDING_BUG () {0x;}' unless defined(&SSL_OP_TLS_BLOCK_PADDING_BUG);
    eval 'sub SSL_OP_SINGLE_ECDH_USE () {0x;}' unless defined(&SSL_OP_SINGLE_ECDH_USE);
    eval 'sub SSL_OP_SINGLE_DH_USE () {0x;}' unless defined(&SSL_OP_SINGLE_DH_USE);
    eval 'sub SSL_OP_EPHEMERAL_RSA () {0x;}' unless defined(&SSL_OP_EPHEMERAL_RSA);
    eval 'sub SSL_OP_NO_SSLv2 () {0x;}' unless defined(&SSL_OP_NO_SSLv2);
    eval 'sub SSL_OP_PKCS1_CHECK_1 () {0x;}' unless defined(&SSL_OP_PKCS1_CHECK_1);
    eval 'sub SSL_OP_PKCS1_CHECK_2 () {0x;}' unless defined(&SSL_OP_PKCS1_CHECK_2);
    eval 'sub SSL_OP_NETSCAPE_CA_DN_BUG () {0x;}' unless defined(&SSL_OP_NETSCAPE_CA_DN_BUG);
    eval 'sub SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG () {0x;}' unless defined(&SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG);
    eval 'sub SSL_MODE_ENABLE_PARTIAL_WRITE () {0x1;}' unless defined(&SSL_MODE_ENABLE_PARTIAL_WRITE);
    eval 'sub SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER () {0x2;}' unless defined(&SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER);
    eval 'sub SSL_MODE_AUTO_RETRY () {0x4;}' unless defined(&SSL_MODE_AUTO_RETRY);
    eval 'sub SSL_MODE_NO_AUTO_CHAIN () {0x8;}' unless defined(&SSL_MODE_NO_AUTO_CHAIN);
    eval 'sub SSL_MODE_RELEASE_BUFFERS () {0x10;}' unless defined(&SSL_MODE_RELEASE_BUFFERS);
    eval 'sub SSL_MODE_SEND_CLIENTHELLO_TIME () {0x20;}' unless defined(&SSL_MODE_SEND_CLIENTHELLO_TIME);
    eval 'sub SSL_MODE_SEND_SERVERHELLO_TIME () {0x40;}' unless defined(&SSL_MODE_SEND_SERVERHELLO_TIME);
    eval 'sub SSL_MODE_SEND_FALLBACK_SCSV () {0x80;}' unless defined(&SSL_MODE_SEND_FALLBACK_SCSV);
    eval 'sub SSL_MODE_ASYNC () {0x100;}' unless defined(&SSL_MODE_ASYNC);
    eval 'sub SSL_MODE_DTLS_SCTP_LABEL_LENGTH_BUG () {0x400;}' unless defined(&SSL_MODE_DTLS_SCTP_LABEL_LENGTH_BUG);
    eval 'sub SSL_CERT_FLAG_TLS_STRICT () {0x1;}' unless defined(&SSL_CERT_FLAG_TLS_STRICT);
    eval 'sub SSL_CERT_FLAG_SUITEB_128_LOS_ONLY () {0x10000;}' unless defined(&SSL_CERT_FLAG_SUITEB_128_LOS_ONLY);
    eval 'sub SSL_CERT_FLAG_SUITEB_192_LOS () {0x20000;}' unless defined(&SSL_CERT_FLAG_SUITEB_192_LOS);
    eval 'sub SSL_CERT_FLAG_SUITEB_128_LOS () {0x30000;}' unless defined(&SSL_CERT_FLAG_SUITEB_128_LOS);
    eval 'sub SSL_CERT_FLAG_BROKEN_PROTOCOL () {0x10000000;}' unless defined(&SSL_CERT_FLAG_BROKEN_PROTOCOL);
    eval 'sub SSL_BUILD_CHAIN_FLAG_UNTRUSTED () {0x1;}' unless defined(&SSL_BUILD_CHAIN_FLAG_UNTRUSTED);
    eval 'sub SSL_BUILD_CHAIN_FLAG_NO_ROOT () {0x2;}' unless defined(&SSL_BUILD_CHAIN_FLAG_NO_ROOT);
    eval 'sub SSL_BUILD_CHAIN_FLAG_CHECK () {0x4;}' unless defined(&SSL_BUILD_CHAIN_FLAG_CHECK);
    eval 'sub SSL_BUILD_CHAIN_FLAG_IGNORE_ERROR () {0x8;}' unless defined(&SSL_BUILD_CHAIN_FLAG_IGNORE_ERROR);
    eval 'sub SSL_BUILD_CHAIN_FLAG_CLEAR_ERROR () {0x10;}' unless defined(&SSL_BUILD_CHAIN_FLAG_CLEAR_ERROR);
    eval 'sub CERT_PKEY_VALID () {0x1;}' unless defined(&CERT_PKEY_VALID);
    eval 'sub CERT_PKEY_SIGN () {0x2;}' unless defined(&CERT_PKEY_SIGN);
    eval 'sub CERT_PKEY_EE_SIGNATURE () {0x10;}' unless defined(&CERT_PKEY_EE_SIGNATURE);
    eval 'sub CERT_PKEY_CA_SIGNATURE () {0x20;}' unless defined(&CERT_PKEY_CA_SIGNATURE);
    eval 'sub CERT_PKEY_EE_PARAM () {0x40;}' unless defined(&CERT_PKEY_EE_PARAM);
    eval 'sub CERT_PKEY_CA_PARAM () {0x80;}' unless defined(&CERT_PKEY_CA_PARAM);
    eval 'sub CERT_PKEY_EXPLICIT_SIGN () {0x100;}' unless defined(&CERT_PKEY_EXPLICIT_SIGN);
    eval 'sub CERT_PKEY_ISSUER_NAME () {0x200;}' unless defined(&CERT_PKEY_ISSUER_NAME);
    eval 'sub CERT_PKEY_CERT_TYPE () {0x400;}' unless defined(&CERT_PKEY_CERT_TYPE);
    eval 'sub CERT_PKEY_SUITEB () {0x800;}' unless defined(&CERT_PKEY_SUITEB);
    eval 'sub CERT_PKEY_RPK () {0x1000;}' unless defined(&CERT_PKEY_RPK);
    eval 'sub SSL_CONF_FLAG_CMDLINE () {0x1;}' unless defined(&SSL_CONF_FLAG_CMDLINE);
    eval 'sub SSL_CONF_FLAG_FILE () {0x2;}' unless defined(&SSL_CONF_FLAG_FILE);
    eval 'sub SSL_CONF_FLAG_CLIENT () {0x4;}' unless defined(&SSL_CONF_FLAG_CLIENT);
    eval 'sub SSL_CONF_FLAG_SERVER () {0x8;}' unless defined(&SSL_CONF_FLAG_SERVER);
    eval 'sub SSL_CONF_FLAG_SHOW_ERRORS () {0x10;}' unless defined(&SSL_CONF_FLAG_SHOW_ERRORS);
    eval 'sub SSL_CONF_FLAG_CERTIFICATE () {0x20;}' unless defined(&SSL_CONF_FLAG_CERTIFICATE);
    eval 'sub SSL_CONF_FLAG_REQUIRE_PRIVATE () {0x40;}' unless defined(&SSL_CONF_FLAG_REQUIRE_PRIVATE);
    eval 'sub SSL_CONF_TYPE_UNKNOWN () {0x;}' unless defined(&SSL_CONF_TYPE_UNKNOWN);
    eval 'sub SSL_CONF_TYPE_STRING () {0x1;}' unless defined(&SSL_CONF_TYPE_STRING);
    eval 'sub SSL_CONF_TYPE_FILE () {0x2;}' unless defined(&SSL_CONF_TYPE_FILE);
    eval 'sub SSL_CONF_TYPE_DIR () {0x3;}' unless defined(&SSL_CONF_TYPE_DIR);
    eval 'sub SSL_CONF_TYPE_NONE () {0x4;}' unless defined(&SSL_CONF_TYPE_NONE);
    eval 'sub SSL_CONF_TYPE_STORE () {0x5;}' unless defined(&SSL_CONF_TYPE_STORE);
    eval 'sub SSL_COOKIE_LENGTH () {4096;}' unless defined(&SSL_COOKIE_LENGTH);
    eval 'sub SSL_CTX_set_mode {
        my($ctx,$op) = @_;
	    eval q( &SSL_CTX_ctrl(($ctx), &SSL_CTRL_MODE,($op), &NULL));
    }' unless defined(&SSL_CTX_set_mode);
    eval 'sub SSL_CTX_clear_mode {
        my($ctx,$op) = @_;
	    eval q( &SSL_CTX_ctrl(($ctx), &SSL_CTRL_CLEAR_MODE,($op), &NULL));
    }' unless defined(&SSL_CTX_clear_mode);
    eval 'sub SSL_CTX_get_mode {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl(($ctx), &SSL_CTRL_MODE,0, &NULL));
    }' unless defined(&SSL_CTX_get_mode);
    eval 'sub SSL_clear_mode {
        my($ssl,$op) = @_;
	    eval q( &SSL_ctrl(($ssl), &SSL_CTRL_CLEAR_MODE,($op), &NULL));
    }' unless defined(&SSL_clear_mode);
    eval 'sub SSL_set_mode {
        my($ssl,$op) = @_;
	    eval q( &SSL_ctrl(($ssl), &SSL_CTRL_MODE,($op), &NULL));
    }' unless defined(&SSL_set_mode);
    eval 'sub SSL_get_mode {
        my($ssl) = @_;
	    eval q( &SSL_ctrl(($ssl), &SSL_CTRL_MODE,0, &NULL));
    }' unless defined(&SSL_get_mode);
    eval 'sub SSL_set_mtu {
        my($ssl, $mtu) = @_;
	    eval q( &SSL_ctrl(($ssl), &SSL_CTRL_SET_MTU,($mtu), &NULL));
    }' unless defined(&SSL_set_mtu);
    eval 'sub DTLS_set_link_mtu {
        my($ssl, $mtu) = @_;
	    eval q( &SSL_ctrl(($ssl), &DTLS_CTRL_SET_LINK_MTU,($mtu), &NULL));
    }' unless defined(&DTLS_set_link_mtu);
    eval 'sub DTLS_get_link_min_mtu {
        my($ssl) = @_;
	    eval q( &SSL_ctrl(($ssl), &DTLS_CTRL_GET_LINK_MIN_MTU,0, &NULL));
    }' unless defined(&DTLS_get_link_min_mtu);
    eval 'sub SSL_get_secure_renegotiation_support {
        my($ssl) = @_;
	    eval q( &SSL_ctrl(($ssl),  &SSL_CTRL_GET_RI_SUPPORT, 0,  &NULL));
    }' unless defined(&SSL_get_secure_renegotiation_support);
    eval 'sub SSL_CTX_set_cert_flags {
        my($ctx,$op) = @_;
	    eval q( &SSL_CTX_ctrl(($ctx), &SSL_CTRL_CERT_FLAGS,($op), &NULL));
    }' unless defined(&SSL_CTX_set_cert_flags);
    eval 'sub SSL_set_cert_flags {
        my($s,$op) = @_;
	    eval q( &SSL_ctrl(($s), &SSL_CTRL_CERT_FLAGS,($op), &NULL));
    }' unless defined(&SSL_set_cert_flags);
    eval 'sub SSL_CTX_clear_cert_flags {
        my($ctx,$op) = @_;
	    eval q( &SSL_CTX_ctrl(($ctx), &SSL_CTRL_CLEAR_CERT_FLAGS,($op), &NULL));
    }' unless defined(&SSL_CTX_clear_cert_flags);
    eval 'sub SSL_clear_cert_flags {
        my($s,$op) = @_;
	    eval q( &SSL_ctrl(($s), &SSL_CTRL_CLEAR_CERT_FLAGS,($op), &NULL));
    }' unless defined(&SSL_clear_cert_flags);
    eval 'sub SSL_CTX_set_msg_callback_arg {
        my($ctx, $arg) = @_;
	    eval q( &SSL_CTX_ctrl(($ctx),  &SSL_CTRL_SET_MSG_CALLBACK_ARG, 0, ($arg)));
    }' unless defined(&SSL_CTX_set_msg_callback_arg);
    eval 'sub SSL_set_msg_callback_arg {
        my($ssl, $arg) = @_;
	    eval q( &SSL_ctrl(($ssl),  &SSL_CTRL_SET_MSG_CALLBACK_ARG, 0, ($arg)));
    }' unless defined(&SSL_set_msg_callback_arg);
    eval 'sub SSL_get_extms_support {
        my($s) = @_;
	    eval q( &SSL_ctrl(($s), &SSL_CTRL_GET_EXTMS_SUPPORT,0, &NULL));
    }' unless defined(&SSL_get_extms_support);
    unless(defined(&OPENSSL_NO_SRP)) {
	unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	}
    }
    eval 'sub SSL_MAX_CERT_LIST_DEFAULT () {(1024*100);}' unless defined(&SSL_MAX_CERT_LIST_DEFAULT);
    eval 'sub SSL_SESSION_CACHE_MAX_SIZE_DEFAULT () {(1024*20);}' unless defined(&SSL_SESSION_CACHE_MAX_SIZE_DEFAULT);
    eval 'sub SSL_SESS_CACHE_OFF () {0x;}' unless defined(&SSL_SESS_CACHE_OFF);
    eval 'sub SSL_SESS_CACHE_CLIENT () {0x1;}' unless defined(&SSL_SESS_CACHE_CLIENT);
    eval 'sub SSL_SESS_CACHE_SERVER () {0x2;}' unless defined(&SSL_SESS_CACHE_SERVER);
    eval 'sub SSL_SESS_CACHE_BOTH () {( &SSL_SESS_CACHE_CLIENT| &SSL_SESS_CACHE_SERVER);}' unless defined(&SSL_SESS_CACHE_BOTH);
    eval 'sub SSL_SESS_CACHE_NO_AUTO_CLEAR () {0x80;}' unless defined(&SSL_SESS_CACHE_NO_AUTO_CLEAR);
    eval 'sub SSL_SESS_CACHE_NO_INTERNAL_LOOKUP () {0x100;}' unless defined(&SSL_SESS_CACHE_NO_INTERNAL_LOOKUP);
    eval 'sub SSL_SESS_CACHE_NO_INTERNAL_STORE () {0x200;}' unless defined(&SSL_SESS_CACHE_NO_INTERNAL_STORE);
    eval 'sub SSL_SESS_CACHE_NO_INTERNAL () {( &SSL_SESS_CACHE_NO_INTERNAL_LOOKUP| &SSL_SESS_CACHE_NO_INTERNAL_STORE);}' unless defined(&SSL_SESS_CACHE_NO_INTERNAL);
    eval 'sub SSL_SESS_CACHE_UPDATE_TIME () {0x400;}' unless defined(&SSL_SESS_CACHE_UPDATE_TIME);
    eval 'sub SSL_CTX_sess_number {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SESS_NUMBER,0, &NULL));
    }' unless defined(&SSL_CTX_sess_number);
    eval 'sub SSL_CTX_sess_connect {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SESS_CONNECT,0, &NULL));
    }' unless defined(&SSL_CTX_sess_connect);
    eval 'sub SSL_CTX_sess_connect_good {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SESS_CONNECT_GOOD,0, &NULL));
    }' unless defined(&SSL_CTX_sess_connect_good);
    eval 'sub SSL_CTX_sess_connect_renegotiate {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SESS_CONNECT_RENEGOTIATE,0, &NULL));
    }' unless defined(&SSL_CTX_sess_connect_renegotiate);
    eval 'sub SSL_CTX_sess_accept {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SESS_ACCEPT,0, &NULL));
    }' unless defined(&SSL_CTX_sess_accept);
    eval 'sub SSL_CTX_sess_accept_renegotiate {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SESS_ACCEPT_RENEGOTIATE,0, &NULL));
    }' unless defined(&SSL_CTX_sess_accept_renegotiate);
    eval 'sub SSL_CTX_sess_accept_good {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SESS_ACCEPT_GOOD,0, &NULL));
    }' unless defined(&SSL_CTX_sess_accept_good);
    eval 'sub SSL_CTX_sess_hits {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SESS_HIT,0, &NULL));
    }' unless defined(&SSL_CTX_sess_hits);
    eval 'sub SSL_CTX_sess_cb_hits {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SESS_CB_HIT,0, &NULL));
    }' unless defined(&SSL_CTX_sess_cb_hits);
    eval 'sub SSL_CTX_sess_misses {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SESS_MISSES,0, &NULL));
    }' unless defined(&SSL_CTX_sess_misses);
    eval 'sub SSL_CTX_sess_timeouts {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SESS_TIMEOUTS,0, &NULL));
    }' unless defined(&SSL_CTX_sess_timeouts);
    eval 'sub SSL_CTX_sess_cache_full {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SESS_CACHE_FULL,0, &NULL));
    }' unless defined(&SSL_CTX_sess_cache_full);
    unless(defined(&OPENSSL_NO_ENGINE)) {
    }
    unless(defined(&OPENSSL_NO_NEXTPROTONEG)) {
	eval 'sub SSL_CTX_set_npn_advertised_cb () { &SSL_CTX_set_next_protos_advertised_cb;}' unless defined(&SSL_CTX_set_npn_advertised_cb);
	eval 'sub SSL_CTX_set_npn_select_cb () { &SSL_CTX_set_next_proto_select_cb;}' unless defined(&SSL_CTX_set_npn_select_cb);
	eval 'sub SSL_get0_npn_negotiated () { &SSL_get0_next_proto_negotiated;}' unless defined(&SSL_get0_npn_negotiated);
    }
    eval 'sub OPENSSL_NPN_UNSUPPORTED () {0;}' unless defined(&OPENSSL_NPN_UNSUPPORTED);
    eval 'sub OPENSSL_NPN_NEGOTIATED () {1;}' unless defined(&OPENSSL_NPN_NEGOTIATED);
    eval 'sub OPENSSL_NPN_NO_OVERLAP () {2;}' unless defined(&OPENSSL_NPN_NO_OVERLAP);
    unless(defined(&OPENSSL_NO_PSK)) {
	eval 'sub PSK_MAX_IDENTITY_LEN () {256;}' unless defined(&PSK_MAX_IDENTITY_LEN);
	eval 'sub PSK_MAX_PSK_LEN () {512;}' unless defined(&PSK_MAX_PSK_LEN);
    }
    eval 'sub SSL_NOTHING () {1;}' unless defined(&SSL_NOTHING);
    eval 'sub SSL_WRITING () {2;}' unless defined(&SSL_WRITING);
    eval 'sub SSL_READING () {3;}' unless defined(&SSL_READING);
    eval 'sub SSL_X509_LOOKUP () {4;}' unless defined(&SSL_X509_LOOKUP);
    eval 'sub SSL_ASYNC_PAUSED () {5;}' unless defined(&SSL_ASYNC_PAUSED);
    eval 'sub SSL_ASYNC_NO_JOBS () {6;}' unless defined(&SSL_ASYNC_NO_JOBS);
    eval 'sub SSL_CLIENT_HELLO_CB () {7;}' unless defined(&SSL_CLIENT_HELLO_CB);
    eval 'sub SSL_RETRY_VERIFY () {8;}' unless defined(&SSL_RETRY_VERIFY);
    eval 'sub SSL_want_nothing {
        my($s) = @_;
	    eval q(( &SSL_want($s) ==  &SSL_NOTHING));
    }' unless defined(&SSL_want_nothing);
    eval 'sub SSL_want_read {
        my($s) = @_;
	    eval q(( &SSL_want($s) ==  &SSL_READING));
    }' unless defined(&SSL_want_read);
    eval 'sub SSL_want_write {
        my($s) = @_;
	    eval q(( &SSL_want($s) ==  &SSL_WRITING));
    }' unless defined(&SSL_want_write);
    eval 'sub SSL_want_x509_lookup {
        my($s) = @_;
	    eval q(( &SSL_want($s) ==  &SSL_X509_LOOKUP));
    }' unless defined(&SSL_want_x509_lookup);
    eval 'sub SSL_want_retry_verify {
        my($s) = @_;
	    eval q(( &SSL_want($s) ==  &SSL_RETRY_VERIFY));
    }' unless defined(&SSL_want_retry_verify);
    eval 'sub SSL_want_async {
        my($s) = @_;
	    eval q(( &SSL_want($s) ==  &SSL_ASYNC_PAUSED));
    }' unless defined(&SSL_want_async);
    eval 'sub SSL_want_async_job {
        my($s) = @_;
	    eval q(( &SSL_want($s) ==  &SSL_ASYNC_NO_JOBS));
    }' unless defined(&SSL_want_async_job);
    eval 'sub SSL_want_client_hello_cb {
        my($s) = @_;
	    eval q(( &SSL_want($s) ==  &SSL_CLIENT_HELLO_CB));
    }' unless defined(&SSL_want_client_hello_cb);
    eval 'sub SSL_MAC_FLAG_READ_MAC_STREAM () {1;}' unless defined(&SSL_MAC_FLAG_READ_MAC_STREAM);
    eval 'sub SSL_MAC_FLAG_WRITE_MAC_STREAM () {2;}' unless defined(&SSL_MAC_FLAG_WRITE_MAC_STREAM);
    eval 'sub SSL_MAC_FLAG_READ_MAC_TLSTREE () {4;}' unless defined(&SSL_MAC_FLAG_READ_MAC_TLSTREE);
    eval 'sub SSL_MAC_FLAG_WRITE_MAC_TLSTREE () {8;}' unless defined(&SSL_MAC_FLAG_WRITE_MAC_TLSTREE);
    if(defined(&__cplusplus)) {
    }
    require 'openssl/ssl2.ph';
    require 'openssl/ssl3.ph';
    require 'openssl/tls1.ph';
    require 'openssl/dtls1.ph';
    require 'openssl/srtp.ph';
    require 'openssl/quic.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub sk_SSL_CIPHER_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_SSL_CIPHER_sk_type($sk)));
    }' unless defined(&sk_SSL_CIPHER_num);
    eval 'sub sk_SSL_CIPHER_value {
        my($sk, $idx) = @_;
	    eval q((( &const  &SSL_CIPHER *) &OPENSSL_sk_value( &ossl_check_const_SSL_CIPHER_sk_type($sk), ($idx))));
    }' unless defined(&sk_SSL_CIPHER_value);
    eval 'sub sk_SSL_CIPHER_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &SSL_CIPHER) *) &OPENSSL_sk_new( &ossl_check_SSL_CIPHER_compfunc_type($cmp))));
    }' unless defined(&sk_SSL_CIPHER_new);
    eval 'sub sk_SSL_CIPHER_new_null () {
        eval q((( &STACK_OF( &SSL_CIPHER) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_SSL_CIPHER_new_null);
    eval 'sub sk_SSL_CIPHER_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &SSL_CIPHER) *) &OPENSSL_sk_new_reserve( &ossl_check_SSL_CIPHER_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_SSL_CIPHER_new_reserve);
    eval 'sub sk_SSL_CIPHER_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_SSL_CIPHER_sk_type($sk), ($n)));
    }' unless defined(&sk_SSL_CIPHER_reserve);
    eval 'sub sk_SSL_CIPHER_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_SSL_CIPHER_sk_type($sk)));
    }' unless defined(&sk_SSL_CIPHER_free);
    eval 'sub sk_SSL_CIPHER_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_SSL_CIPHER_sk_type($sk)));
    }' unless defined(&sk_SSL_CIPHER_zero);
    eval 'sub sk_SSL_CIPHER_delete {
        my($sk, $i) = @_;
	    eval q((( &const  &SSL_CIPHER *) &OPENSSL_sk_delete( &ossl_check_SSL_CIPHER_sk_type($sk), ($i))));
    }' unless defined(&sk_SSL_CIPHER_delete);
    eval 'sub sk_SSL_CIPHER_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &const  &SSL_CIPHER *) &OPENSSL_sk_delete_ptr( &ossl_check_SSL_CIPHER_sk_type($sk),  &ossl_check_SSL_CIPHER_type($ptr))));
    }' unless defined(&sk_SSL_CIPHER_delete_ptr);
    eval 'sub sk_SSL_CIPHER_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_SSL_CIPHER_sk_type($sk),  &ossl_check_SSL_CIPHER_type($ptr)));
    }' unless defined(&sk_SSL_CIPHER_push);
    eval 'sub sk_SSL_CIPHER_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_SSL_CIPHER_sk_type($sk),  &ossl_check_SSL_CIPHER_type($ptr)));
    }' unless defined(&sk_SSL_CIPHER_unshift);
    eval 'sub sk_SSL_CIPHER_pop {
        my($sk) = @_;
	    eval q((( &const  &SSL_CIPHER *) &OPENSSL_sk_pop( &ossl_check_SSL_CIPHER_sk_type($sk))));
    }' unless defined(&sk_SSL_CIPHER_pop);
    eval 'sub sk_SSL_CIPHER_shift {
        my($sk) = @_;
	    eval q((( &const  &SSL_CIPHER *) &OPENSSL_sk_shift( &ossl_check_SSL_CIPHER_sk_type($sk))));
    }' unless defined(&sk_SSL_CIPHER_shift);
    eval 'sub sk_SSL_CIPHER_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_SSL_CIPHER_sk_type($sk), &ossl_check_SSL_CIPHER_freefunc_type($freefunc)));
    }' unless defined(&sk_SSL_CIPHER_pop_free);
    eval 'sub sk_SSL_CIPHER_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_SSL_CIPHER_sk_type($sk),  &ossl_check_SSL_CIPHER_type($ptr), ($idx)));
    }' unless defined(&sk_SSL_CIPHER_insert);
    eval 'sub sk_SSL_CIPHER_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &const  &SSL_CIPHER *) &OPENSSL_sk_set( &ossl_check_SSL_CIPHER_sk_type($sk), ($idx),  &ossl_check_SSL_CIPHER_type($ptr))));
    }' unless defined(&sk_SSL_CIPHER_set);
    eval 'sub sk_SSL_CIPHER_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_SSL_CIPHER_sk_type($sk),  &ossl_check_SSL_CIPHER_type($ptr)));
    }' unless defined(&sk_SSL_CIPHER_find);
    eval 'sub sk_SSL_CIPHER_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_SSL_CIPHER_sk_type($sk),  &ossl_check_SSL_CIPHER_type($ptr)));
    }' unless defined(&sk_SSL_CIPHER_find_ex);
    eval 'sub sk_SSL_CIPHER_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_SSL_CIPHER_sk_type($sk),  &ossl_check_SSL_CIPHER_type($ptr), $pnum));
    }' unless defined(&sk_SSL_CIPHER_find_all);
    eval 'sub sk_SSL_CIPHER_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_SSL_CIPHER_sk_type($sk)));
    }' unless defined(&sk_SSL_CIPHER_sort);
    eval 'sub sk_SSL_CIPHER_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_SSL_CIPHER_sk_type($sk)));
    }' unless defined(&sk_SSL_CIPHER_is_sorted);
    eval 'sub sk_SSL_CIPHER_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &SSL_CIPHER) *) &OPENSSL_sk_dup( &ossl_check_const_SSL_CIPHER_sk_type($sk))));
    }' unless defined(&sk_SSL_CIPHER_dup);
    eval 'sub sk_SSL_CIPHER_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &SSL_CIPHER) *) &OPENSSL_sk_deep_copy( &ossl_check_const_SSL_CIPHER_sk_type($sk),  &ossl_check_SSL_CIPHER_copyfunc_type($copyfunc),  &ossl_check_SSL_CIPHER_freefunc_type($freefunc))));
    }' unless defined(&sk_SSL_CIPHER_deep_copy);
    eval 'sub sk_SSL_CIPHER_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_SSL_CIPHER_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_SSL_CIPHER_sk_type($sk),  &ossl_check_SSL_CIPHER_compfunc_type($cmp))));
    }' unless defined(&sk_SSL_CIPHER_set_cmp_func);
    eval 'sub SSL_set_app_data {
        my($s,$arg) = @_;
	    eval q(( &SSL_set_ex_data($s,0,($arg))));
    }' unless defined(&SSL_set_app_data);
    eval 'sub SSL_get_app_data {
        my($s) = @_;
	    eval q(( &SSL_get_ex_data($s,0)));
    }' unless defined(&SSL_get_app_data);
    eval 'sub SSL_SESSION_set_app_data {
        my($s,$a) = @_;
	    eval q(( &SSL_SESSION_set_ex_data($s,0, ($a))));
    }' unless defined(&SSL_SESSION_set_app_data);
    eval 'sub SSL_SESSION_get_app_data {
        my($s) = @_;
	    eval q(( &SSL_SESSION_get_ex_data($s,0)));
    }' unless defined(&SSL_SESSION_get_app_data);
    eval 'sub SSL_CTX_get_app_data {
        my($ctx) = @_;
	    eval q(( &SSL_CTX_get_ex_data($ctx,0)));
    }' unless defined(&SSL_CTX_get_app_data);
    eval 'sub SSL_CTX_set_app_data {
        my($ctx,$arg) = @_;
	    eval q(( &SSL_CTX_set_ex_data($ctx,0, ($arg))));
    }' unless defined(&SSL_CTX_set_app_data);
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
    }
    eval 'sub SSL_KEY_UPDATE_NONE () {-1;}' unless defined(&SSL_KEY_UPDATE_NONE);
    eval 'sub SSL_KEY_UPDATE_NOT_REQUESTED () {0;}' unless defined(&SSL_KEY_UPDATE_NOT_REQUESTED);
    eval 'sub SSL_KEY_UPDATE_REQUESTED () {1;}' unless defined(&SSL_KEY_UPDATE_REQUESTED);
    eval("sub TLS_ST_BEFORE () { 0; }") unless defined(&TLS_ST_BEFORE);
    eval("sub TLS_ST_OK () { 1; }") unless defined(&TLS_ST_OK);
    eval("sub DTLS_ST_CR_HELLO_VERIFY_REQUEST () { 2; }") unless defined(&DTLS_ST_CR_HELLO_VERIFY_REQUEST);
    eval("sub TLS_ST_CR_SRVR_HELLO () { 3; }") unless defined(&TLS_ST_CR_SRVR_HELLO);
    eval("sub TLS_ST_CR_CERT () { 4; }") unless defined(&TLS_ST_CR_CERT);
    eval("sub TLS_ST_CR_COMP_CERT () { 5; }") unless defined(&TLS_ST_CR_COMP_CERT);
    eval("sub TLS_ST_CR_CERT_STATUS () { 6; }") unless defined(&TLS_ST_CR_CERT_STATUS);
    eval("sub TLS_ST_CR_KEY_EXCH () { 7; }") unless defined(&TLS_ST_CR_KEY_EXCH);
    eval("sub TLS_ST_CR_CERT_REQ () { 8; }") unless defined(&TLS_ST_CR_CERT_REQ);
    eval("sub TLS_ST_CR_SRVR_DONE () { 9; }") unless defined(&TLS_ST_CR_SRVR_DONE);
    eval("sub TLS_ST_CR_SESSION_TICKET () { 10; }") unless defined(&TLS_ST_CR_SESSION_TICKET);
    eval("sub TLS_ST_CR_CHANGE () { 11; }") unless defined(&TLS_ST_CR_CHANGE);
    eval("sub TLS_ST_CR_FINISHED () { 12; }") unless defined(&TLS_ST_CR_FINISHED);
    eval("sub TLS_ST_CW_CLNT_HELLO () { 13; }") unless defined(&TLS_ST_CW_CLNT_HELLO);
    eval("sub TLS_ST_CW_CERT () { 14; }") unless defined(&TLS_ST_CW_CERT);
    eval("sub TLS_ST_CW_COMP_CERT () { 15; }") unless defined(&TLS_ST_CW_COMP_CERT);
    eval("sub TLS_ST_CW_KEY_EXCH () { 16; }") unless defined(&TLS_ST_CW_KEY_EXCH);
    eval("sub TLS_ST_CW_CERT_VRFY () { 17; }") unless defined(&TLS_ST_CW_CERT_VRFY);
    eval("sub TLS_ST_CW_CHANGE () { 18; }") unless defined(&TLS_ST_CW_CHANGE);
    eval("sub TLS_ST_CW_NEXT_PROTO () { 19; }") unless defined(&TLS_ST_CW_NEXT_PROTO);
    eval("sub TLS_ST_CW_FINISHED () { 20; }") unless defined(&TLS_ST_CW_FINISHED);
    eval("sub TLS_ST_SW_HELLO_REQ () { 21; }") unless defined(&TLS_ST_SW_HELLO_REQ);
    eval("sub TLS_ST_SR_CLNT_HELLO () { 22; }") unless defined(&TLS_ST_SR_CLNT_HELLO);
    eval("sub DTLS_ST_SW_HELLO_VERIFY_REQUEST () { 23; }") unless defined(&DTLS_ST_SW_HELLO_VERIFY_REQUEST);
    eval("sub TLS_ST_SW_SRVR_HELLO () { 24; }") unless defined(&TLS_ST_SW_SRVR_HELLO);
    eval("sub TLS_ST_SW_CERT () { 25; }") unless defined(&TLS_ST_SW_CERT);
    eval("sub TLS_ST_SW_COMP_CERT () { 26; }") unless defined(&TLS_ST_SW_COMP_CERT);
    eval("sub TLS_ST_SW_KEY_EXCH () { 27; }") unless defined(&TLS_ST_SW_KEY_EXCH);
    eval("sub TLS_ST_SW_CERT_REQ () { 28; }") unless defined(&TLS_ST_SW_CERT_REQ);
    eval("sub TLS_ST_SW_SRVR_DONE () { 29; }") unless defined(&TLS_ST_SW_SRVR_DONE);
    eval("sub TLS_ST_SR_CERT () { 30; }") unless defined(&TLS_ST_SR_CERT);
    eval("sub TLS_ST_SR_COMP_CERT () { 31; }") unless defined(&TLS_ST_SR_COMP_CERT);
    eval("sub TLS_ST_SR_KEY_EXCH () { 32; }") unless defined(&TLS_ST_SR_KEY_EXCH);
    eval("sub TLS_ST_SR_CERT_VRFY () { 33; }") unless defined(&TLS_ST_SR_CERT_VRFY);
    eval("sub TLS_ST_SR_NEXT_PROTO () { 34; }") unless defined(&TLS_ST_SR_NEXT_PROTO);
    eval("sub TLS_ST_SR_CHANGE () { 35; }") unless defined(&TLS_ST_SR_CHANGE);
    eval("sub TLS_ST_SR_FINISHED () { 36; }") unless defined(&TLS_ST_SR_FINISHED);
    eval("sub TLS_ST_SW_SESSION_TICKET () { 37; }") unless defined(&TLS_ST_SW_SESSION_TICKET);
    eval("sub TLS_ST_SW_CERT_STATUS () { 38; }") unless defined(&TLS_ST_SW_CERT_STATUS);
    eval("sub TLS_ST_SW_CHANGE () { 39; }") unless defined(&TLS_ST_SW_CHANGE);
    eval("sub TLS_ST_SW_FINISHED () { 40; }") unless defined(&TLS_ST_SW_FINISHED);
    eval("sub TLS_ST_SW_ENCRYPTED_EXTENSIONS () { 41; }") unless defined(&TLS_ST_SW_ENCRYPTED_EXTENSIONS);
    eval("sub TLS_ST_CR_ENCRYPTED_EXTENSIONS () { 42; }") unless defined(&TLS_ST_CR_ENCRYPTED_EXTENSIONS);
    eval("sub TLS_ST_CR_CERT_VRFY () { 43; }") unless defined(&TLS_ST_CR_CERT_VRFY);
    eval("sub TLS_ST_SW_CERT_VRFY () { 44; }") unless defined(&TLS_ST_SW_CERT_VRFY);
    eval("sub TLS_ST_CR_HELLO_REQ () { 45; }") unless defined(&TLS_ST_CR_HELLO_REQ);
    eval("sub TLS_ST_SW_KEY_UPDATE () { 46; }") unless defined(&TLS_ST_SW_KEY_UPDATE);
    eval("sub TLS_ST_CW_KEY_UPDATE () { 47; }") unless defined(&TLS_ST_CW_KEY_UPDATE);
    eval("sub TLS_ST_SR_KEY_UPDATE () { 48; }") unless defined(&TLS_ST_SR_KEY_UPDATE);
    eval("sub TLS_ST_CR_KEY_UPDATE () { 49; }") unless defined(&TLS_ST_CR_KEY_UPDATE);
    eval("sub TLS_ST_EARLY_DATA () { 50; }") unless defined(&TLS_ST_EARLY_DATA);
    eval("sub TLS_ST_PENDING_EARLY_DATA_END () { 51; }") unless defined(&TLS_ST_PENDING_EARLY_DATA_END);
    eval("sub TLS_ST_CW_END_OF_EARLY_DATA () { 52; }") unless defined(&TLS_ST_CW_END_OF_EARLY_DATA);
    eval("sub TLS_ST_SR_END_OF_EARLY_DATA () { 53; }") unless defined(&TLS_ST_SR_END_OF_EARLY_DATA);
    eval 'sub SSL_ST_CONNECT () {0x1000;}' unless defined(&SSL_ST_CONNECT);
    eval 'sub SSL_ST_ACCEPT () {0x2000;}' unless defined(&SSL_ST_ACCEPT);
    eval 'sub SSL_ST_MASK () {0xfff;}' unless defined(&SSL_ST_MASK);
    eval 'sub SSL_CB_LOOP () {0x1;}' unless defined(&SSL_CB_LOOP);
    eval 'sub SSL_CB_EXIT () {0x2;}' unless defined(&SSL_CB_EXIT);
    eval 'sub SSL_CB_READ () {0x4;}' unless defined(&SSL_CB_READ);
    eval 'sub SSL_CB_WRITE () {0x8;}' unless defined(&SSL_CB_WRITE);
    eval 'sub SSL_CB_ALERT () {0x4000;}' unless defined(&SSL_CB_ALERT);
    eval 'sub SSL_CB_READ_ALERT () {( &SSL_CB_ALERT| &SSL_CB_READ);}' unless defined(&SSL_CB_READ_ALERT);
    eval 'sub SSL_CB_WRITE_ALERT () {( &SSL_CB_ALERT| &SSL_CB_WRITE);}' unless defined(&SSL_CB_WRITE_ALERT);
    eval 'sub SSL_CB_ACCEPT_LOOP () {( &SSL_ST_ACCEPT| &SSL_CB_LOOP);}' unless defined(&SSL_CB_ACCEPT_LOOP);
    eval 'sub SSL_CB_ACCEPT_EXIT () {( &SSL_ST_ACCEPT| &SSL_CB_EXIT);}' unless defined(&SSL_CB_ACCEPT_EXIT);
    eval 'sub SSL_CB_CONNECT_LOOP () {( &SSL_ST_CONNECT| &SSL_CB_LOOP);}' unless defined(&SSL_CB_CONNECT_LOOP);
    eval 'sub SSL_CB_CONNECT_EXIT () {( &SSL_ST_CONNECT| &SSL_CB_EXIT);}' unless defined(&SSL_CB_CONNECT_EXIT);
    eval 'sub SSL_CB_HANDSHAKE_START () {0x10;}' unless defined(&SSL_CB_HANDSHAKE_START);
    eval 'sub SSL_CB_HANDSHAKE_DONE () {0x20;}' unless defined(&SSL_CB_HANDSHAKE_DONE);
    eval 'sub SSL_in_connect_init {
        my($a) = @_;
	    eval q(( &SSL_in_init($a)  && ! &SSL_is_server($a)));
    }' unless defined(&SSL_in_connect_init);
    eval 'sub SSL_in_accept_init {
        my($a) = @_;
	    eval q(( &SSL_in_init($a)  &&  &SSL_is_server($a)));
    }' unless defined(&SSL_in_accept_init);
    eval 'sub SSL_ST_READ_HEADER () {0xf0;}' unless defined(&SSL_ST_READ_HEADER);
    eval 'sub SSL_ST_READ_BODY () {0xf1;}' unless defined(&SSL_ST_READ_BODY);
    eval 'sub SSL_ST_READ_DONE () {0xf2;}' unless defined(&SSL_ST_READ_DONE);
    eval 'sub SSL_VERIFY_NONE () {0x;}' unless defined(&SSL_VERIFY_NONE);
    eval 'sub SSL_VERIFY_PEER () {0x1;}' unless defined(&SSL_VERIFY_PEER);
    eval 'sub SSL_VERIFY_FAIL_IF_NO_PEER_CERT () {0x2;}' unless defined(&SSL_VERIFY_FAIL_IF_NO_PEER_CERT);
    eval 'sub SSL_VERIFY_CLIENT_ONCE () {0x4;}' unless defined(&SSL_VERIFY_CLIENT_ONCE);
    eval 'sub SSL_VERIFY_POST_HANDSHAKE () {0x8;}' unless defined(&SSL_VERIFY_POST_HANDSHAKE);
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub OpenSSL_add_ssl_algorithms () {
	    eval q( &SSL_library_init());
	}' unless defined(&OpenSSL_add_ssl_algorithms);
	eval 'sub SSLeay_add_ssl_algorithms () {
	    eval q( &SSL_library_init());
	}' unless defined(&SSLeay_add_ssl_algorithms);
    }
    eval 'sub SSL_get_cipher {
        my($s) = @_;
	    eval q( &SSL_CIPHER_get_name( &SSL_get_current_cipher($s)));
    }' unless defined(&SSL_get_cipher);
    eval 'sub SSL_get_cipher_bits {
        my($s,$np) = @_;
	    eval q( &SSL_CIPHER_get_bits( &SSL_get_current_cipher($s),$np));
    }' unless defined(&SSL_get_cipher_bits);
    eval 'sub SSL_get_cipher_version {
        my($s) = @_;
	    eval q( &SSL_CIPHER_get_version( &SSL_get_current_cipher($s)));
    }' unless defined(&SSL_get_cipher_version);
    eval 'sub SSL_get_cipher_name {
        my($s) = @_;
	    eval q( &SSL_CIPHER_get_name( &SSL_get_current_cipher($s)));
    }' unless defined(&SSL_get_cipher_name);
    eval 'sub SSL_get_time {
        my($a) = @_;
	    eval q( &SSL_SESSION_get_time($a));
    }' unless defined(&SSL_get_time);
    eval 'sub SSL_set_time {
        my($a,$b) = @_;
	    eval q( &SSL_SESSION_set_time(($a),($b)));
    }' unless defined(&SSL_set_time);
    eval 'sub SSL_get_timeout {
        my($a) = @_;
	    eval q( &SSL_SESSION_get_timeout($a));
    }' unless defined(&SSL_get_timeout);
    eval 'sub SSL_set_timeout {
        my($a,$b) = @_;
	    eval q( &SSL_SESSION_set_timeout(($a),($b)));
    }' unless defined(&SSL_set_timeout);
    eval 'sub d2i_SSL_SESSION_bio {
        my($bp,$s_id) = @_;
	    eval q( &ASN1_d2i_bio_of( &SSL_SESSION, &SSL_SESSION_new, &d2i_SSL_SESSION,$bp,$s_id));
    }' unless defined(&d2i_SSL_SESSION_bio);
    eval 'sub i2d_SSL_SESSION_bio {
        my($bp,$s_id) = @_;
	    eval q( &ASN1_i2d_bio_of( &SSL_SESSION, &i2d_SSL_SESSION,$bp,$s_id));
    }' unless defined(&i2d_SSL_SESSION_bio);
    eval 'sub SSL_AD_REASON_OFFSET () {1000;}' unless defined(&SSL_AD_REASON_OFFSET);
    eval 'sub SSL_AD_CLOSE_NOTIFY () { &SSL3_AD_CLOSE_NOTIFY;}' unless defined(&SSL_AD_CLOSE_NOTIFY);
    eval 'sub SSL_AD_UNEXPECTED_MESSAGE () { &SSL3_AD_UNEXPECTED_MESSAGE;}' unless defined(&SSL_AD_UNEXPECTED_MESSAGE);
    eval 'sub SSL_AD_BAD_RECORD_MAC () { &SSL3_AD_BAD_RECORD_MAC;}' unless defined(&SSL_AD_BAD_RECORD_MAC);
    eval 'sub SSL_AD_DECRYPTION_FAILED () { &TLS1_AD_DECRYPTION_FAILED;}' unless defined(&SSL_AD_DECRYPTION_FAILED);
    eval 'sub SSL_AD_RECORD_OVERFLOW () { &TLS1_AD_RECORD_OVERFLOW;}' unless defined(&SSL_AD_RECORD_OVERFLOW);
    eval 'sub SSL_AD_DECOMPRESSION_FAILURE () { &SSL3_AD_DECOMPRESSION_FAILURE;}' unless defined(&SSL_AD_DECOMPRESSION_FAILURE);
    eval 'sub SSL_AD_HANDSHAKE_FAILURE () { &SSL3_AD_HANDSHAKE_FAILURE;}' unless defined(&SSL_AD_HANDSHAKE_FAILURE);
    eval 'sub SSL_AD_NO_CERTIFICATE () { &SSL3_AD_NO_CERTIFICATE;}' unless defined(&SSL_AD_NO_CERTIFICATE);
    eval 'sub SSL_AD_BAD_CERTIFICATE () { &SSL3_AD_BAD_CERTIFICATE;}' unless defined(&SSL_AD_BAD_CERTIFICATE);
    eval 'sub SSL_AD_UNSUPPORTED_CERTIFICATE () { &SSL3_AD_UNSUPPORTED_CERTIFICATE;}' unless defined(&SSL_AD_UNSUPPORTED_CERTIFICATE);
    eval 'sub SSL_AD_CERTIFICATE_REVOKED () { &SSL3_AD_CERTIFICATE_REVOKED;}' unless defined(&SSL_AD_CERTIFICATE_REVOKED);
    eval 'sub SSL_AD_CERTIFICATE_EXPIRED () { &SSL3_AD_CERTIFICATE_EXPIRED;}' unless defined(&SSL_AD_CERTIFICATE_EXPIRED);
    eval 'sub SSL_AD_CERTIFICATE_UNKNOWN () { &SSL3_AD_CERTIFICATE_UNKNOWN;}' unless defined(&SSL_AD_CERTIFICATE_UNKNOWN);
    eval 'sub SSL_AD_ILLEGAL_PARAMETER () { &SSL3_AD_ILLEGAL_PARAMETER;}' unless defined(&SSL_AD_ILLEGAL_PARAMETER);
    eval 'sub SSL_AD_UNKNOWN_CA () { &TLS1_AD_UNKNOWN_CA;}' unless defined(&SSL_AD_UNKNOWN_CA);
    eval 'sub SSL_AD_ACCESS_DENIED () { &TLS1_AD_ACCESS_DENIED;}' unless defined(&SSL_AD_ACCESS_DENIED);
    eval 'sub SSL_AD_DECODE_ERROR () { &TLS1_AD_DECODE_ERROR;}' unless defined(&SSL_AD_DECODE_ERROR);
    eval 'sub SSL_AD_DECRYPT_ERROR () { &TLS1_AD_DECRYPT_ERROR;}' unless defined(&SSL_AD_DECRYPT_ERROR);
    eval 'sub SSL_AD_EXPORT_RESTRICTION () { &TLS1_AD_EXPORT_RESTRICTION;}' unless defined(&SSL_AD_EXPORT_RESTRICTION);
    eval 'sub SSL_AD_PROTOCOL_VERSION () { &TLS1_AD_PROTOCOL_VERSION;}' unless defined(&SSL_AD_PROTOCOL_VERSION);
    eval 'sub SSL_AD_INSUFFICIENT_SECURITY () { &TLS1_AD_INSUFFICIENT_SECURITY;}' unless defined(&SSL_AD_INSUFFICIENT_SECURITY);
    eval 'sub SSL_AD_INTERNAL_ERROR () { &TLS1_AD_INTERNAL_ERROR;}' unless defined(&SSL_AD_INTERNAL_ERROR);
    eval 'sub SSL_AD_USER_CANCELLED () { &TLS1_AD_USER_CANCELLED;}' unless defined(&SSL_AD_USER_CANCELLED);
    eval 'sub SSL_AD_NO_RENEGOTIATION () { &TLS1_AD_NO_RENEGOTIATION;}' unless defined(&SSL_AD_NO_RENEGOTIATION);
    eval 'sub SSL_AD_MISSING_EXTENSION () { &TLS13_AD_MISSING_EXTENSION;}' unless defined(&SSL_AD_MISSING_EXTENSION);
    eval 'sub SSL_AD_CERTIFICATE_REQUIRED () { &TLS13_AD_CERTIFICATE_REQUIRED;}' unless defined(&SSL_AD_CERTIFICATE_REQUIRED);
    eval 'sub SSL_AD_UNSUPPORTED_EXTENSION () { &TLS1_AD_UNSUPPORTED_EXTENSION;}' unless defined(&SSL_AD_UNSUPPORTED_EXTENSION);
    eval 'sub SSL_AD_CERTIFICATE_UNOBTAINABLE () { &TLS1_AD_CERTIFICATE_UNOBTAINABLE;}' unless defined(&SSL_AD_CERTIFICATE_UNOBTAINABLE);
    eval 'sub SSL_AD_UNRECOGNIZED_NAME () { &TLS1_AD_UNRECOGNIZED_NAME;}' unless defined(&SSL_AD_UNRECOGNIZED_NAME);
    eval 'sub SSL_AD_BAD_CERTIFICATE_STATUS_RESPONSE () { &TLS1_AD_BAD_CERTIFICATE_STATUS_RESPONSE;}' unless defined(&SSL_AD_BAD_CERTIFICATE_STATUS_RESPONSE);
    eval 'sub SSL_AD_BAD_CERTIFICATE_HASH_VALUE () { &TLS1_AD_BAD_CERTIFICATE_HASH_VALUE;}' unless defined(&SSL_AD_BAD_CERTIFICATE_HASH_VALUE);
    eval 'sub SSL_AD_UNKNOWN_PSK_IDENTITY () { &TLS1_AD_UNKNOWN_PSK_IDENTITY;}' unless defined(&SSL_AD_UNKNOWN_PSK_IDENTITY);
    eval 'sub SSL_AD_INAPPROPRIATE_FALLBACK () { &TLS1_AD_INAPPROPRIATE_FALLBACK;}' unless defined(&SSL_AD_INAPPROPRIATE_FALLBACK);
    eval 'sub SSL_AD_NO_APPLICATION_PROTOCOL () { &TLS1_AD_NO_APPLICATION_PROTOCOL;}' unless defined(&SSL_AD_NO_APPLICATION_PROTOCOL);
    eval 'sub SSL_ERROR_NONE () {0;}' unless defined(&SSL_ERROR_NONE);
    eval 'sub SSL_ERROR_SSL () {1;}' unless defined(&SSL_ERROR_SSL);
    eval 'sub SSL_ERROR_WANT_READ () {2;}' unless defined(&SSL_ERROR_WANT_READ);
    eval 'sub SSL_ERROR_WANT_WRITE () {3;}' unless defined(&SSL_ERROR_WANT_WRITE);
    eval 'sub SSL_ERROR_WANT_X509_LOOKUP () {4;}' unless defined(&SSL_ERROR_WANT_X509_LOOKUP);
    eval 'sub SSL_ERROR_SYSCALL () {5;}' unless defined(&SSL_ERROR_SYSCALL);
    eval 'sub SSL_ERROR_ZERO_RETURN () {6;}' unless defined(&SSL_ERROR_ZERO_RETURN);
    eval 'sub SSL_ERROR_WANT_CONNECT () {7;}' unless defined(&SSL_ERROR_WANT_CONNECT);
    eval 'sub SSL_ERROR_WANT_ACCEPT () {8;}' unless defined(&SSL_ERROR_WANT_ACCEPT);
    eval 'sub SSL_ERROR_WANT_ASYNC () {9;}' unless defined(&SSL_ERROR_WANT_ASYNC);
    eval 'sub SSL_ERROR_WANT_ASYNC_JOB () {10;}' unless defined(&SSL_ERROR_WANT_ASYNC_JOB);
    eval 'sub SSL_ERROR_WANT_CLIENT_HELLO_CB () {11;}' unless defined(&SSL_ERROR_WANT_CLIENT_HELLO_CB);
    eval 'sub SSL_ERROR_WANT_RETRY_VERIFY () {12;}' unless defined(&SSL_ERROR_WANT_RETRY_VERIFY);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub SSL_CTRL_SET_TMP_DH () {3;}' unless defined(&SSL_CTRL_SET_TMP_DH);
	eval 'sub SSL_CTRL_SET_TMP_ECDH () {4;}' unless defined(&SSL_CTRL_SET_TMP_ECDH);
	eval 'sub SSL_CTRL_SET_TMP_DH_CB () {6;}' unless defined(&SSL_CTRL_SET_TMP_DH_CB);
    }
    eval 'sub SSL_CTRL_GET_CLIENT_CERT_REQUEST () {9;}' unless defined(&SSL_CTRL_GET_CLIENT_CERT_REQUEST);
    eval 'sub SSL_CTRL_GET_NUM_RENEGOTIATIONS () {10;}' unless defined(&SSL_CTRL_GET_NUM_RENEGOTIATIONS);
    eval 'sub SSL_CTRL_CLEAR_NUM_RENEGOTIATIONS () {11;}' unless defined(&SSL_CTRL_CLEAR_NUM_RENEGOTIATIONS);
    eval 'sub SSL_CTRL_GET_TOTAL_RENEGOTIATIONS () {12;}' unless defined(&SSL_CTRL_GET_TOTAL_RENEGOTIATIONS);
    eval 'sub SSL_CTRL_GET_FLAGS () {13;}' unless defined(&SSL_CTRL_GET_FLAGS);
    eval 'sub SSL_CTRL_EXTRA_CHAIN_CERT () {14;}' unless defined(&SSL_CTRL_EXTRA_CHAIN_CERT);
    eval 'sub SSL_CTRL_SET_MSG_CALLBACK () {15;}' unless defined(&SSL_CTRL_SET_MSG_CALLBACK);
    eval 'sub SSL_CTRL_SET_MSG_CALLBACK_ARG () {16;}' unless defined(&SSL_CTRL_SET_MSG_CALLBACK_ARG);
    eval 'sub SSL_CTRL_SET_MTU () {17;}' unless defined(&SSL_CTRL_SET_MTU);
    eval 'sub SSL_CTRL_SESS_NUMBER () {20;}' unless defined(&SSL_CTRL_SESS_NUMBER);
    eval 'sub SSL_CTRL_SESS_CONNECT () {21;}' unless defined(&SSL_CTRL_SESS_CONNECT);
    eval 'sub SSL_CTRL_SESS_CONNECT_GOOD () {22;}' unless defined(&SSL_CTRL_SESS_CONNECT_GOOD);
    eval 'sub SSL_CTRL_SESS_CONNECT_RENEGOTIATE () {23;}' unless defined(&SSL_CTRL_SESS_CONNECT_RENEGOTIATE);
    eval 'sub SSL_CTRL_SESS_ACCEPT () {24;}' unless defined(&SSL_CTRL_SESS_ACCEPT);
    eval 'sub SSL_CTRL_SESS_ACCEPT_GOOD () {25;}' unless defined(&SSL_CTRL_SESS_ACCEPT_GOOD);
    eval 'sub SSL_CTRL_SESS_ACCEPT_RENEGOTIATE () {26;}' unless defined(&SSL_CTRL_SESS_ACCEPT_RENEGOTIATE);
    eval 'sub SSL_CTRL_SESS_HIT () {27;}' unless defined(&SSL_CTRL_SESS_HIT);
    eval 'sub SSL_CTRL_SESS_CB_HIT () {28;}' unless defined(&SSL_CTRL_SESS_CB_HIT);
    eval 'sub SSL_CTRL_SESS_MISSES () {29;}' unless defined(&SSL_CTRL_SESS_MISSES);
    eval 'sub SSL_CTRL_SESS_TIMEOUTS () {30;}' unless defined(&SSL_CTRL_SESS_TIMEOUTS);
    eval 'sub SSL_CTRL_SESS_CACHE_FULL () {31;}' unless defined(&SSL_CTRL_SESS_CACHE_FULL);
    eval 'sub SSL_CTRL_MODE () {33;}' unless defined(&SSL_CTRL_MODE);
    eval 'sub SSL_CTRL_GET_READ_AHEAD () {40;}' unless defined(&SSL_CTRL_GET_READ_AHEAD);
    eval 'sub SSL_CTRL_SET_READ_AHEAD () {41;}' unless defined(&SSL_CTRL_SET_READ_AHEAD);
    eval 'sub SSL_CTRL_SET_SESS_CACHE_SIZE () {42;}' unless defined(&SSL_CTRL_SET_SESS_CACHE_SIZE);
    eval 'sub SSL_CTRL_GET_SESS_CACHE_SIZE () {43;}' unless defined(&SSL_CTRL_GET_SESS_CACHE_SIZE);
    eval 'sub SSL_CTRL_SET_SESS_CACHE_MODE () {44;}' unless defined(&SSL_CTRL_SET_SESS_CACHE_MODE);
    eval 'sub SSL_CTRL_GET_SESS_CACHE_MODE () {45;}' unless defined(&SSL_CTRL_GET_SESS_CACHE_MODE);
    eval 'sub SSL_CTRL_GET_MAX_CERT_LIST () {50;}' unless defined(&SSL_CTRL_GET_MAX_CERT_LIST);
    eval 'sub SSL_CTRL_SET_MAX_CERT_LIST () {51;}' unless defined(&SSL_CTRL_SET_MAX_CERT_LIST);
    eval 'sub SSL_CTRL_SET_MAX_SEND_FRAGMENT () {52;}' unless defined(&SSL_CTRL_SET_MAX_SEND_FRAGMENT);
    eval 'sub SSL_CTRL_SET_TLSEXT_SERVERNAME_CB () {53;}' unless defined(&SSL_CTRL_SET_TLSEXT_SERVERNAME_CB);
    eval 'sub SSL_CTRL_SET_TLSEXT_SERVERNAME_ARG () {54;}' unless defined(&SSL_CTRL_SET_TLSEXT_SERVERNAME_ARG);
    eval 'sub SSL_CTRL_SET_TLSEXT_HOSTNAME () {55;}' unless defined(&SSL_CTRL_SET_TLSEXT_HOSTNAME);
    eval 'sub SSL_CTRL_SET_TLSEXT_DEBUG_CB () {56;}' unless defined(&SSL_CTRL_SET_TLSEXT_DEBUG_CB);
    eval 'sub SSL_CTRL_SET_TLSEXT_DEBUG_ARG () {57;}' unless defined(&SSL_CTRL_SET_TLSEXT_DEBUG_ARG);
    eval 'sub SSL_CTRL_GET_TLSEXT_TICKET_KEYS () {58;}' unless defined(&SSL_CTRL_GET_TLSEXT_TICKET_KEYS);
    eval 'sub SSL_CTRL_SET_TLSEXT_TICKET_KEYS () {59;}' unless defined(&SSL_CTRL_SET_TLSEXT_TICKET_KEYS);
    eval 'sub SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB () {63;}' unless defined(&SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB);
    eval 'sub SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB_ARG () {64;}' unless defined(&SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB_ARG);
    eval 'sub SSL_CTRL_SET_TLSEXT_STATUS_REQ_TYPE () {65;}' unless defined(&SSL_CTRL_SET_TLSEXT_STATUS_REQ_TYPE);
    eval 'sub SSL_CTRL_GET_TLSEXT_STATUS_REQ_EXTS () {66;}' unless defined(&SSL_CTRL_GET_TLSEXT_STATUS_REQ_EXTS);
    eval 'sub SSL_CTRL_SET_TLSEXT_STATUS_REQ_EXTS () {67;}' unless defined(&SSL_CTRL_SET_TLSEXT_STATUS_REQ_EXTS);
    eval 'sub SSL_CTRL_GET_TLSEXT_STATUS_REQ_IDS () {68;}' unless defined(&SSL_CTRL_GET_TLSEXT_STATUS_REQ_IDS);
    eval 'sub SSL_CTRL_SET_TLSEXT_STATUS_REQ_IDS () {69;}' unless defined(&SSL_CTRL_SET_TLSEXT_STATUS_REQ_IDS);
    eval 'sub SSL_CTRL_GET_TLSEXT_STATUS_REQ_OCSP_RESP () {70;}' unless defined(&SSL_CTRL_GET_TLSEXT_STATUS_REQ_OCSP_RESP);
    eval 'sub SSL_CTRL_SET_TLSEXT_STATUS_REQ_OCSP_RESP () {71;}' unless defined(&SSL_CTRL_SET_TLSEXT_STATUS_REQ_OCSP_RESP);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub SSL_CTRL_SET_TLSEXT_TICKET_KEY_CB () {72;}' unless defined(&SSL_CTRL_SET_TLSEXT_TICKET_KEY_CB);
    }
    eval 'sub SSL_CTRL_SET_TLS_EXT_SRP_USERNAME_CB () {75;}' unless defined(&SSL_CTRL_SET_TLS_EXT_SRP_USERNAME_CB);
    eval 'sub SSL_CTRL_SET_SRP_VERIFY_PARAM_CB () {76;}' unless defined(&SSL_CTRL_SET_SRP_VERIFY_PARAM_CB);
    eval 'sub SSL_CTRL_SET_SRP_GIVE_CLIENT_PWD_CB () {77;}' unless defined(&SSL_CTRL_SET_SRP_GIVE_CLIENT_PWD_CB);
    eval 'sub SSL_CTRL_SET_SRP_ARG () {78;}' unless defined(&SSL_CTRL_SET_SRP_ARG);
    eval 'sub SSL_CTRL_SET_TLS_EXT_SRP_USERNAME () {79;}' unless defined(&SSL_CTRL_SET_TLS_EXT_SRP_USERNAME);
    eval 'sub SSL_CTRL_SET_TLS_EXT_SRP_STRENGTH () {80;}' unless defined(&SSL_CTRL_SET_TLS_EXT_SRP_STRENGTH);
    eval 'sub SSL_CTRL_SET_TLS_EXT_SRP_PASSWORD () {81;}' unless defined(&SSL_CTRL_SET_TLS_EXT_SRP_PASSWORD);
    eval 'sub DTLS_CTRL_GET_TIMEOUT () {73;}' unless defined(&DTLS_CTRL_GET_TIMEOUT);
    eval 'sub DTLS_CTRL_HANDLE_TIMEOUT () {74;}' unless defined(&DTLS_CTRL_HANDLE_TIMEOUT);
    eval 'sub SSL_CTRL_GET_RI_SUPPORT () {76;}' unless defined(&SSL_CTRL_GET_RI_SUPPORT);
    eval 'sub SSL_CTRL_CLEAR_MODE () {78;}' unless defined(&SSL_CTRL_CLEAR_MODE);
    eval 'sub SSL_CTRL_SET_NOT_RESUMABLE_SESS_CB () {79;}' unless defined(&SSL_CTRL_SET_NOT_RESUMABLE_SESS_CB);
    eval 'sub SSL_CTRL_GET_EXTRA_CHAIN_CERTS () {82;}' unless defined(&SSL_CTRL_GET_EXTRA_CHAIN_CERTS);
    eval 'sub SSL_CTRL_CLEAR_EXTRA_CHAIN_CERTS () {83;}' unless defined(&SSL_CTRL_CLEAR_EXTRA_CHAIN_CERTS);
    eval 'sub SSL_CTRL_CHAIN () {88;}' unless defined(&SSL_CTRL_CHAIN);
    eval 'sub SSL_CTRL_CHAIN_CERT () {89;}' unless defined(&SSL_CTRL_CHAIN_CERT);
    eval 'sub SSL_CTRL_GET_GROUPS () {90;}' unless defined(&SSL_CTRL_GET_GROUPS);
    eval 'sub SSL_CTRL_SET_GROUPS () {91;}' unless defined(&SSL_CTRL_SET_GROUPS);
    eval 'sub SSL_CTRL_SET_GROUPS_LIST () {92;}' unless defined(&SSL_CTRL_SET_GROUPS_LIST);
    eval 'sub SSL_CTRL_GET_SHARED_GROUP () {93;}' unless defined(&SSL_CTRL_GET_SHARED_GROUP);
    eval 'sub SSL_CTRL_SET_SIGALGS () {97;}' unless defined(&SSL_CTRL_SET_SIGALGS);
    eval 'sub SSL_CTRL_SET_SIGALGS_LIST () {98;}' unless defined(&SSL_CTRL_SET_SIGALGS_LIST);
    eval 'sub SSL_CTRL_CERT_FLAGS () {99;}' unless defined(&SSL_CTRL_CERT_FLAGS);
    eval 'sub SSL_CTRL_CLEAR_CERT_FLAGS () {100;}' unless defined(&SSL_CTRL_CLEAR_CERT_FLAGS);
    eval 'sub SSL_CTRL_SET_CLIENT_SIGALGS () {101;}' unless defined(&SSL_CTRL_SET_CLIENT_SIGALGS);
    eval 'sub SSL_CTRL_SET_CLIENT_SIGALGS_LIST () {102;}' unless defined(&SSL_CTRL_SET_CLIENT_SIGALGS_LIST);
    eval 'sub SSL_CTRL_GET_CLIENT_CERT_TYPES () {103;}' unless defined(&SSL_CTRL_GET_CLIENT_CERT_TYPES);
    eval 'sub SSL_CTRL_SET_CLIENT_CERT_TYPES () {104;}' unless defined(&SSL_CTRL_SET_CLIENT_CERT_TYPES);
    eval 'sub SSL_CTRL_BUILD_CERT_CHAIN () {105;}' unless defined(&SSL_CTRL_BUILD_CERT_CHAIN);
    eval 'sub SSL_CTRL_SET_VERIFY_CERT_STORE () {106;}' unless defined(&SSL_CTRL_SET_VERIFY_CERT_STORE);
    eval 'sub SSL_CTRL_SET_CHAIN_CERT_STORE () {107;}' unless defined(&SSL_CTRL_SET_CHAIN_CERT_STORE);
    eval 'sub SSL_CTRL_GET_PEER_SIGNATURE_NID () {108;}' unless defined(&SSL_CTRL_GET_PEER_SIGNATURE_NID);
    eval 'sub SSL_CTRL_GET_PEER_TMP_KEY () {109;}' unless defined(&SSL_CTRL_GET_PEER_TMP_KEY);
    eval 'sub SSL_CTRL_GET_RAW_CIPHERLIST () {110;}' unless defined(&SSL_CTRL_GET_RAW_CIPHERLIST);
    eval 'sub SSL_CTRL_GET_EC_POINT_FORMATS () {111;}' unless defined(&SSL_CTRL_GET_EC_POINT_FORMATS);
    eval 'sub SSL_CTRL_GET_CHAIN_CERTS () {115;}' unless defined(&SSL_CTRL_GET_CHAIN_CERTS);
    eval 'sub SSL_CTRL_SELECT_CURRENT_CERT () {116;}' unless defined(&SSL_CTRL_SELECT_CURRENT_CERT);
    eval 'sub SSL_CTRL_SET_CURRENT_CERT () {117;}' unless defined(&SSL_CTRL_SET_CURRENT_CERT);
    eval 'sub SSL_CTRL_SET_DH_AUTO () {118;}' unless defined(&SSL_CTRL_SET_DH_AUTO);
    eval 'sub DTLS_CTRL_SET_LINK_MTU () {120;}' unless defined(&DTLS_CTRL_SET_LINK_MTU);
    eval 'sub DTLS_CTRL_GET_LINK_MIN_MTU () {121;}' unless defined(&DTLS_CTRL_GET_LINK_MIN_MTU);
    eval 'sub SSL_CTRL_GET_EXTMS_SUPPORT () {122;}' unless defined(&SSL_CTRL_GET_EXTMS_SUPPORT);
    eval 'sub SSL_CTRL_SET_MIN_PROTO_VERSION () {123;}' unless defined(&SSL_CTRL_SET_MIN_PROTO_VERSION);
    eval 'sub SSL_CTRL_SET_MAX_PROTO_VERSION () {124;}' unless defined(&SSL_CTRL_SET_MAX_PROTO_VERSION);
    eval 'sub SSL_CTRL_SET_SPLIT_SEND_FRAGMENT () {125;}' unless defined(&SSL_CTRL_SET_SPLIT_SEND_FRAGMENT);
    eval 'sub SSL_CTRL_SET_MAX_PIPELINES () {126;}' unless defined(&SSL_CTRL_SET_MAX_PIPELINES);
    eval 'sub SSL_CTRL_GET_TLSEXT_STATUS_REQ_TYPE () {127;}' unless defined(&SSL_CTRL_GET_TLSEXT_STATUS_REQ_TYPE);
    eval 'sub SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB () {128;}' unless defined(&SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB);
    eval 'sub SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB_ARG () {129;}' unless defined(&SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB_ARG);
    eval 'sub SSL_CTRL_GET_MIN_PROTO_VERSION () {130;}' unless defined(&SSL_CTRL_GET_MIN_PROTO_VERSION);
    eval 'sub SSL_CTRL_GET_MAX_PROTO_VERSION () {131;}' unless defined(&SSL_CTRL_GET_MAX_PROTO_VERSION);
    eval 'sub SSL_CTRL_GET_SIGNATURE_NID () {132;}' unless defined(&SSL_CTRL_GET_SIGNATURE_NID);
    eval 'sub SSL_CTRL_GET_TMP_KEY () {133;}' unless defined(&SSL_CTRL_GET_TMP_KEY);
    eval 'sub SSL_CTRL_GET_NEGOTIATED_GROUP () {134;}' unless defined(&SSL_CTRL_GET_NEGOTIATED_GROUP);
    eval 'sub SSL_CTRL_GET_IANA_GROUPS () {135;}' unless defined(&SSL_CTRL_GET_IANA_GROUPS);
    eval 'sub SSL_CTRL_SET_RETRY_VERIFY () {136;}' unless defined(&SSL_CTRL_SET_RETRY_VERIFY);
    eval 'sub SSL_CTRL_GET_VERIFY_CERT_STORE () {137;}' unless defined(&SSL_CTRL_GET_VERIFY_CERT_STORE);
    eval 'sub SSL_CTRL_GET_CHAIN_CERT_STORE () {138;}' unless defined(&SSL_CTRL_GET_CHAIN_CERT_STORE);
    eval 'sub SSL_CTRL_GET0_IMPLEMENTED_GROUPS () {139;}' unless defined(&SSL_CTRL_GET0_IMPLEMENTED_GROUPS);
    eval 'sub SSL_CTRL_GET_SIGNATURE_NAME () {140;}' unless defined(&SSL_CTRL_GET_SIGNATURE_NAME);
    eval 'sub SSL_CTRL_GET_PEER_SIGNATURE_NAME () {141;}' unless defined(&SSL_CTRL_GET_PEER_SIGNATURE_NAME);
    eval 'sub SSL_CERT_SET_FIRST () {1;}' unless defined(&SSL_CERT_SET_FIRST);
    eval 'sub SSL_CERT_SET_NEXT () {2;}' unless defined(&SSL_CERT_SET_NEXT);
    eval 'sub SSL_CERT_SET_SERVER () {3;}' unless defined(&SSL_CERT_SET_SERVER);
    eval 'sub DTLSv1_get_timeout {
        my($ssl, $arg) = @_;
	    eval q( &SSL_ctrl($ssl, &DTLS_CTRL_GET_TIMEOUT,0, ( &void *)($arg)));
    }' unless defined(&DTLSv1_get_timeout);
    eval 'sub DTLSv1_handle_timeout {
        my($ssl) = @_;
	    eval q( &SSL_ctrl($ssl, &DTLS_CTRL_HANDLE_TIMEOUT,0,  &NULL));
    }' unless defined(&DTLSv1_handle_timeout);
    eval 'sub SSL_num_renegotiations {
        my($ssl) = @_;
	    eval q( &SSL_ctrl(($ssl), &SSL_CTRL_GET_NUM_RENEGOTIATIONS,0, &NULL));
    }' unless defined(&SSL_num_renegotiations);
    eval 'sub SSL_clear_num_renegotiations {
        my($ssl) = @_;
	    eval q( &SSL_ctrl(($ssl), &SSL_CTRL_CLEAR_NUM_RENEGOTIATIONS,0, &NULL));
    }' unless defined(&SSL_clear_num_renegotiations);
    eval 'sub SSL_total_renegotiations {
        my($ssl) = @_;
	    eval q( &SSL_ctrl(($ssl), &SSL_CTRL_GET_TOTAL_RENEGOTIATIONS,0, &NULL));
    }' unless defined(&SSL_total_renegotiations);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub SSL_CTX_set_tmp_dh {
	    my($ctx,$dh) = @_;
    	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_TMP_DH,0,($dh)));
	}' unless defined(&SSL_CTX_set_tmp_dh);
    }
    eval 'sub SSL_CTX_set_dh_auto {
        my($ctx, $onoff) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_DH_AUTO,$onoff, &NULL));
    }' unless defined(&SSL_CTX_set_dh_auto);
    eval 'sub SSL_set_dh_auto {
        my($s, $onoff) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_SET_DH_AUTO,$onoff, &NULL));
    }' unless defined(&SSL_set_dh_auto);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub SSL_set_tmp_dh {
	    my($ssl,$dh) = @_;
    	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_SET_TMP_DH,0,($dh)));
	}' unless defined(&SSL_set_tmp_dh);
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub SSL_CTX_set_tmp_ecdh {
	    my($ctx,$ecdh) = @_;
    	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_TMP_ECDH,0,($ecdh)));
	}' unless defined(&SSL_CTX_set_tmp_ecdh);
	eval 'sub SSL_set_tmp_ecdh {
	    my($ssl,$ecdh) = @_;
    	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_SET_TMP_ECDH,0,($ecdh)));
	}' unless defined(&SSL_set_tmp_ecdh);
    }
    eval 'sub SSL_CTX_add_extra_chain_cert {
        my($ctx,$x509) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_EXTRA_CHAIN_CERT,0,($x509)));
    }' unless defined(&SSL_CTX_add_extra_chain_cert);
    eval 'sub SSL_CTX_get_extra_chain_certs {
        my($ctx,$px509) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_GET_EXTRA_CHAIN_CERTS,0,$px509));
    }' unless defined(&SSL_CTX_get_extra_chain_certs);
    eval 'sub SSL_CTX_get_extra_chain_certs_only {
        my($ctx,$px509) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_GET_EXTRA_CHAIN_CERTS,1,$px509));
    }' unless defined(&SSL_CTX_get_extra_chain_certs_only);
    eval 'sub SSL_CTX_clear_extra_chain_certs {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_CLEAR_EXTRA_CHAIN_CERTS,0, &NULL));
    }' unless defined(&SSL_CTX_clear_extra_chain_certs);
    eval 'sub SSL_CTX_set0_chain {
        my($ctx,$sk) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_CHAIN,0,($sk)));
    }' unless defined(&SSL_CTX_set0_chain);
    eval 'sub SSL_CTX_set1_chain {
        my($ctx,$sk) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_CHAIN,1,($sk)));
    }' unless defined(&SSL_CTX_set1_chain);
    eval 'sub SSL_CTX_add0_chain_cert {
        my($ctx,$x509) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_CHAIN_CERT,0,($x509)));
    }' unless defined(&SSL_CTX_add0_chain_cert);
    eval 'sub SSL_CTX_add1_chain_cert {
        my($ctx,$x509) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_CHAIN_CERT,1,($x509)));
    }' unless defined(&SSL_CTX_add1_chain_cert);
    eval 'sub SSL_CTX_get0_chain_certs {
        my($ctx,$px509) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_GET_CHAIN_CERTS,0,$px509));
    }' unless defined(&SSL_CTX_get0_chain_certs);
    eval 'sub SSL_CTX_clear_chain_certs {
        my($ctx) = @_;
	    eval q( &SSL_CTX_set0_chain($ctx, &NULL));
    }' unless defined(&SSL_CTX_clear_chain_certs);
    eval 'sub SSL_CTX_build_cert_chain {
        my($ctx, $flags) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_BUILD_CERT_CHAIN, $flags,  &NULL));
    }' unless defined(&SSL_CTX_build_cert_chain);
    eval 'sub SSL_CTX_select_current_cert {
        my($ctx,$x509) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SELECT_CURRENT_CERT,0,($x509)));
    }' unless defined(&SSL_CTX_select_current_cert);
    eval 'sub SSL_CTX_set_current_cert {
        my($ctx, $op) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_CURRENT_CERT, $op,  &NULL));
    }' unless defined(&SSL_CTX_set_current_cert);
    eval 'sub SSL_CTX_set0_verify_cert_store {
        my($ctx,$st) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_VERIFY_CERT_STORE,0,($st)));
    }' unless defined(&SSL_CTX_set0_verify_cert_store);
    eval 'sub SSL_CTX_set1_verify_cert_store {
        my($ctx,$st) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_VERIFY_CERT_STORE,1,($st)));
    }' unless defined(&SSL_CTX_set1_verify_cert_store);
    eval 'sub SSL_CTX_get0_verify_cert_store {
        my($ctx,$st) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_GET_VERIFY_CERT_STORE,0,($st)));
    }' unless defined(&SSL_CTX_get0_verify_cert_store);
    eval 'sub SSL_CTX_set0_chain_cert_store {
        my($ctx,$st) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_CHAIN_CERT_STORE,0,($st)));
    }' unless defined(&SSL_CTX_set0_chain_cert_store);
    eval 'sub SSL_CTX_set1_chain_cert_store {
        my($ctx,$st) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_CHAIN_CERT_STORE,1,($st)));
    }' unless defined(&SSL_CTX_set1_chain_cert_store);
    eval 'sub SSL_CTX_get0_chain_cert_store {
        my($ctx,$st) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_GET_CHAIN_CERT_STORE,0,($st)));
    }' unless defined(&SSL_CTX_get0_chain_cert_store);
    eval 'sub SSL_set0_chain {
        my($s,$sk) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_CHAIN,0,($sk)));
    }' unless defined(&SSL_set0_chain);
    eval 'sub SSL_set1_chain {
        my($s,$sk) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_CHAIN,1,($sk)));
    }' unless defined(&SSL_set1_chain);
    eval 'sub SSL_add0_chain_cert {
        my($s,$x509) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_CHAIN_CERT,0,($x509)));
    }' unless defined(&SSL_add0_chain_cert);
    eval 'sub SSL_add1_chain_cert {
        my($s,$x509) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_CHAIN_CERT,1,($x509)));
    }' unless defined(&SSL_add1_chain_cert);
    eval 'sub SSL_get0_chain_certs {
        my($s,$px509) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_GET_CHAIN_CERTS,0,$px509));
    }' unless defined(&SSL_get0_chain_certs);
    eval 'sub SSL_clear_chain_certs {
        my($s) = @_;
	    eval q( &SSL_set0_chain($s, &NULL));
    }' unless defined(&SSL_clear_chain_certs);
    eval 'sub SSL_build_cert_chain {
        my($s, $flags) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_BUILD_CERT_CHAIN, $flags,  &NULL));
    }' unless defined(&SSL_build_cert_chain);
    eval 'sub SSL_select_current_cert {
        my($s,$x509) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_SELECT_CURRENT_CERT,0,($x509)));
    }' unless defined(&SSL_select_current_cert);
    eval 'sub SSL_set_current_cert {
        my($s,$op) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_SET_CURRENT_CERT, $op,  &NULL));
    }' unless defined(&SSL_set_current_cert);
    eval 'sub SSL_set0_verify_cert_store {
        my($s,$st) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_SET_VERIFY_CERT_STORE,0,($st)));
    }' unless defined(&SSL_set0_verify_cert_store);
    eval 'sub SSL_set1_verify_cert_store {
        my($s,$st) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_SET_VERIFY_CERT_STORE,1,($st)));
    }' unless defined(&SSL_set1_verify_cert_store);
    eval 'sub SSL_get0_verify_cert_store {
        my($s,$st) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_GET_VERIFY_CERT_STORE,0,($st)));
    }' unless defined(&SSL_get0_verify_cert_store);
    eval 'sub SSL_set0_chain_cert_store {
        my($s,$st) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_SET_CHAIN_CERT_STORE,0,($st)));
    }' unless defined(&SSL_set0_chain_cert_store);
    eval 'sub SSL_set1_chain_cert_store {
        my($s,$st) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_SET_CHAIN_CERT_STORE,1,($st)));
    }' unless defined(&SSL_set1_chain_cert_store);
    eval 'sub SSL_get0_chain_cert_store {
        my($s,$st) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_GET_CHAIN_CERT_STORE,0,($st)));
    }' unless defined(&SSL_get0_chain_cert_store);
    eval 'sub SSL_get1_groups {
        my($s, $glist) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_GET_GROUPS,0,($glist)));
    }' unless defined(&SSL_get1_groups);
    eval 'sub SSL_get0_iana_groups {
        my($s, $plst) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_GET_IANA_GROUPS,0,( &uint16_t **)($plst)));
    }' unless defined(&SSL_get0_iana_groups);
    eval 'sub SSL_CTX_set1_groups {
        my($ctx, $glist, $glistlen) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_GROUPS,$glistlen,($glist)));
    }' unless defined(&SSL_CTX_set1_groups);
    eval 'sub SSL_CTX_set1_groups_list {
        my($ctx, $s) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_GROUPS_LIST,0,($s)));
    }' unless defined(&SSL_CTX_set1_groups_list);
    eval 'sub SSL_CTX_get0_implemented_groups {
        my($ctx, $all, $out) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_GET0_IMPLEMENTED_GROUPS, $all, ( &STACK_OF( &OPENSSL_CSTRING) *)($out)));
    }' unless defined(&SSL_CTX_get0_implemented_groups);
    eval 'sub SSL_set1_groups {
        my($s, $glist, $glistlen) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_SET_GROUPS,$glistlen,($glist)));
    }' unless defined(&SSL_set1_groups);
    eval 'sub SSL_set1_groups_list {
        my($s, $str) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_SET_GROUPS_LIST,0,($str)));
    }' unless defined(&SSL_set1_groups_list);
    eval 'sub SSL_get_shared_group {
        my($s, $n) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_GET_SHARED_GROUP,$n, &NULL));
    }' unless defined(&SSL_get_shared_group);
    eval 'sub SSL_get_negotiated_group {
        my($s) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_GET_NEGOTIATED_GROUP,0, &NULL));
    }' unless defined(&SSL_get_negotiated_group);
    eval 'sub SSL_CTX_set1_sigalgs {
        my($ctx, $slist, $slistlen) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_SIGALGS,$slistlen,($slist)));
    }' unless defined(&SSL_CTX_set1_sigalgs);
    eval 'sub SSL_CTX_set1_sigalgs_list {
        my($ctx, $s) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_SIGALGS_LIST,0,($s)));
    }' unless defined(&SSL_CTX_set1_sigalgs_list);
    eval 'sub SSL_set1_sigalgs {
        my($s, $slist, $slistlen) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_SET_SIGALGS,$slistlen,($slist)));
    }' unless defined(&SSL_set1_sigalgs);
    eval 'sub SSL_set1_sigalgs_list {
        my($s, $str) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_SET_SIGALGS_LIST,0,($str)));
    }' unless defined(&SSL_set1_sigalgs_list);
    eval 'sub SSL_CTX_set1_client_sigalgs {
        my($ctx, $slist, $slistlen) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_CLIENT_SIGALGS,$slistlen,($slist)));
    }' unless defined(&SSL_CTX_set1_client_sigalgs);
    eval 'sub SSL_CTX_set1_client_sigalgs_list {
        my($ctx, $s) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_CLIENT_SIGALGS_LIST,0,($s)));
    }' unless defined(&SSL_CTX_set1_client_sigalgs_list);
    eval 'sub SSL_set1_client_sigalgs {
        my($s, $slist, $slistlen) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_SET_CLIENT_SIGALGS,$slistlen,($slist)));
    }' unless defined(&SSL_set1_client_sigalgs);
    eval 'sub SSL_set1_client_sigalgs_list {
        my($s, $str) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_SET_CLIENT_SIGALGS_LIST,0,($str)));
    }' unless defined(&SSL_set1_client_sigalgs_list);
    eval 'sub SSL_get0_certificate_types {
        my($s, $clist) = @_;
	    eval q( &SSL_ctrl($s,  &SSL_CTRL_GET_CLIENT_CERT_TYPES, 0, ($clist)));
    }' unless defined(&SSL_get0_certificate_types);
    eval 'sub SSL_CTX_set1_client_certificate_types {
        my($ctx, $clist, $clistlen) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_CLIENT_CERT_TYPES,$clistlen, ($clist)));
    }' unless defined(&SSL_CTX_set1_client_certificate_types);
    eval 'sub SSL_set1_client_certificate_types {
        my($s, $clist, $clistlen) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_SET_CLIENT_CERT_TYPES,$clistlen,($clist)));
    }' unless defined(&SSL_set1_client_certificate_types);
    eval 'sub SSL_get0_signature_name {
        my($s, $str) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_GET_SIGNATURE_NAME,0,(1?($str):( &const \'char\' **) &NULL)));
    }' unless defined(&SSL_get0_signature_name);
    eval 'sub SSL_get_signature_nid {
        my($s, $pn) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_GET_SIGNATURE_NID,0,$pn));
    }' unless defined(&SSL_get_signature_nid);
    eval 'sub SSL_get0_peer_signature_name {
        my($s, $str) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_GET_PEER_SIGNATURE_NAME,0,(1?($str):( &const \'char\' **) &NULL)));
    }' unless defined(&SSL_get0_peer_signature_name);
    eval 'sub SSL_get_peer_signature_nid {
        my($s, $pn) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_GET_PEER_SIGNATURE_NID,0,$pn));
    }' unless defined(&SSL_get_peer_signature_nid);
    eval 'sub SSL_get_peer_tmp_key {
        my($s, $pk) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_GET_PEER_TMP_KEY,0,$pk));
    }' unless defined(&SSL_get_peer_tmp_key);
    eval 'sub SSL_get_tmp_key {
        my($s, $pk) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_GET_TMP_KEY,0,$pk));
    }' unless defined(&SSL_get_tmp_key);
    eval 'sub SSL_get0_raw_cipherlist {
        my($s, $plst) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_GET_RAW_CIPHERLIST,0,$plst));
    }' unless defined(&SSL_get0_raw_cipherlist);
    eval 'sub SSL_get0_ec_point_formats {
        my($s, $plst) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_GET_EC_POINT_FORMATS,0,$plst));
    }' unless defined(&SSL_get0_ec_point_formats);
    eval 'sub SSL_CTX_set_min_proto_version {
        my($ctx, $version) = @_;
	    eval q( &SSL_CTX_ctrl($ctx,  &SSL_CTRL_SET_MIN_PROTO_VERSION, $version,  &NULL));
    }' unless defined(&SSL_CTX_set_min_proto_version);
    eval 'sub SSL_CTX_set_max_proto_version {
        my($ctx, $version) = @_;
	    eval q( &SSL_CTX_ctrl($ctx,  &SSL_CTRL_SET_MAX_PROTO_VERSION, $version,  &NULL));
    }' unless defined(&SSL_CTX_set_max_proto_version);
    eval 'sub SSL_CTX_get_min_proto_version {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx,  &SSL_CTRL_GET_MIN_PROTO_VERSION, 0,  &NULL));
    }' unless defined(&SSL_CTX_get_min_proto_version);
    eval 'sub SSL_CTX_get_max_proto_version {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx,  &SSL_CTRL_GET_MAX_PROTO_VERSION, 0,  &NULL));
    }' unless defined(&SSL_CTX_get_max_proto_version);
    eval 'sub SSL_set_min_proto_version {
        my($s, $version) = @_;
	    eval q( &SSL_ctrl($s,  &SSL_CTRL_SET_MIN_PROTO_VERSION, $version,  &NULL));
    }' unless defined(&SSL_set_min_proto_version);
    eval 'sub SSL_set_max_proto_version {
        my($s, $version) = @_;
	    eval q( &SSL_ctrl($s,  &SSL_CTRL_SET_MAX_PROTO_VERSION, $version,  &NULL));
    }' unless defined(&SSL_set_max_proto_version);
    eval 'sub SSL_get_min_proto_version {
        my($s) = @_;
	    eval q( &SSL_ctrl($s,  &SSL_CTRL_GET_MIN_PROTO_VERSION, 0,  &NULL));
    }' unless defined(&SSL_get_min_proto_version);
    eval 'sub SSL_get_max_proto_version {
        my($s) = @_;
	    eval q( &SSL_ctrl($s,  &SSL_CTRL_GET_MAX_PROTO_VERSION, 0,  &NULL));
    }' unless defined(&SSL_get_max_proto_version);
    eval 'sub SSL_CTRL_GET_SERVER_TMP_KEY () { &SSL_CTRL_GET_PEER_TMP_KEY;}' unless defined(&SSL_CTRL_GET_SERVER_TMP_KEY);
    eval 'sub SSL_get_server_tmp_key {
        my($s, $pk) = @_;
	    eval q( &SSL_get_peer_tmp_key($s, $pk));
    }' unless defined(&SSL_get_server_tmp_key);
    eval 'sub SSL_CTRL_GET_CURVES () { &SSL_CTRL_GET_GROUPS;}' unless defined(&SSL_CTRL_GET_CURVES);
    eval 'sub SSL_CTRL_SET_CURVES () { &SSL_CTRL_SET_GROUPS;}' unless defined(&SSL_CTRL_SET_CURVES);
    eval 'sub SSL_CTRL_SET_CURVES_LIST () { &SSL_CTRL_SET_GROUPS_LIST;}' unless defined(&SSL_CTRL_SET_CURVES_LIST);
    eval 'sub SSL_CTRL_GET_SHARED_CURVE () { &SSL_CTRL_GET_SHARED_GROUP;}' unless defined(&SSL_CTRL_GET_SHARED_CURVE);
    eval 'sub SSL_get1_curves () { &SSL_get1_groups;}' unless defined(&SSL_get1_curves);
    eval 'sub SSL_CTX_set1_curves () { &SSL_CTX_set1_groups;}' unless defined(&SSL_CTX_set1_curves);
    eval 'sub SSL_CTX_set1_curves_list () { &SSL_CTX_set1_groups_list;}' unless defined(&SSL_CTX_set1_curves_list);
    eval 'sub SSL_set1_curves () { &SSL_set1_groups;}' unless defined(&SSL_set1_curves);
    eval 'sub SSL_set1_curves_list () { &SSL_set1_groups_list;}' unless defined(&SSL_set1_curves_list);
    eval 'sub SSL_get_shared_curve () { &SSL_get_shared_group;}' unless defined(&SSL_get_shared_curve);
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub SSL_CTX_need_tmp_RSA {
	    my($ctx) = @_;
    	    eval q(0);
	}' unless defined(&SSL_CTX_need_tmp_RSA);
	eval 'sub SSL_CTX_set_tmp_rsa {
	    my($ctx,$rsa) = @_;
    	    eval q(1);
	}' unless defined(&SSL_CTX_set_tmp_rsa);
	eval 'sub SSL_need_tmp_RSA {
	    my($ssl) = @_;
    	    eval q(0);
	}' unless defined(&SSL_need_tmp_RSA);
	eval 'sub SSL_set_tmp_rsa {
	    my($ssl,$rsa) = @_;
    	    eval q(1);
	}' unless defined(&SSL_set_tmp_rsa);
	eval 'sub SSL_CTX_set_ecdh_auto {
	    my($dummy, $onoff) = @_;
    	    eval q((($onoff) != 0));
	}' unless defined(&SSL_CTX_set_ecdh_auto);
	eval 'sub SSL_set_ecdh_auto {
	    my($dummy, $onoff) = @_;
    	    eval q((($onoff) != 0));
	}' unless defined(&SSL_set_ecdh_auto);
	eval 'sub SSL_CTX_set_tmp_rsa_callback {
	    my($ctx, $cb) = @_;
    	    eval q( &while(0) ($cb)( &NULL, 0, 0));
	}' unless defined(&SSL_CTX_set_tmp_rsa_callback);
	eval 'sub SSL_set_tmp_rsa_callback {
	    my($ssl, $cb) = @_;
    	    eval q( &while(0) ($cb)( &NULL, 0, 0));
	}' unless defined(&SSL_set_tmp_rsa_callback);
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_4)) {
    }
    unless(defined(&OPENSSL_NO_SOCK)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    eval 'sub SSL_SERVERINFOV1 () {1;}' unless defined(&SSL_SERVERINFOV1);
    eval 'sub SSL_SERVERINFOV2 () {2;}' unless defined(&SSL_SERVERINFOV2);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub SSL_load_error_strings () {
	    eval q( &OPENSSL_init_ssl( &OPENSSL_INIT_LOAD_SSL_STRINGS |  &OPENSSL_INIT_LOAD_CRYPTO_STRINGS,  &NULL));
	}' unless defined(&SSL_load_error_strings);
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_4)) {
    }
    unless(defined(&OPENSSL_NO_STDIO)) {
    }
    if(defined(&OPENSSL_X509_H)) {
	unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	    eval 'sub SSL_get_peer_certificate () { &SSL_get1_peer_certificate;}' unless defined(&SSL_get_peer_certificate);
	}
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    unless(defined(&OPENSSL_NO_SRP)) {
	unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	}
    }
    eval 'sub SSL_CLIENT_HELLO_SUCCESS () {1;}' unless defined(&SSL_CLIENT_HELLO_SUCCESS);
    eval 'sub SSL_CLIENT_HELLO_ERROR () {0;}' unless defined(&SSL_CLIENT_HELLO_ERROR);
    eval 'sub SSL_CLIENT_HELLO_RETRY () {(-1);}' unless defined(&SSL_CLIENT_HELLO_RETRY);
    if(defined(&OSSL_ASYNC_FD)) {
    }
    eval 'sub SSL_READ_EARLY_DATA_ERROR () {0;}' unless defined(&SSL_READ_EARLY_DATA_ERROR);
    eval 'sub SSL_READ_EARLY_DATA_SUCCESS () {1;}' unless defined(&SSL_READ_EARLY_DATA_SUCCESS);
    eval 'sub SSL_READ_EARLY_DATA_FINISH () {2;}' unless defined(&SSL_READ_EARLY_DATA_FINISH);
    eval 'sub SSL_WRITE_FLAG_CONCLUDE () {(1 << 0);}' unless defined(&SSL_WRITE_FLAG_CONCLUDE);
    eval 'sub SSL_EARLY_DATA_NOT_SENT () {0;}' unless defined(&SSL_EARLY_DATA_NOT_SENT);
    eval 'sub SSL_EARLY_DATA_REJECTED () {1;}' unless defined(&SSL_EARLY_DATA_REJECTED);
    eval 'sub SSL_EARLY_DATA_ACCEPTED () {2;}' unless defined(&SSL_EARLY_DATA_ACCEPTED);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    unless(defined(&OPENSSL_NO_SSL3_METHOD)) {
	unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	}
    }
    eval 'sub SSLv23_method () { &TLS_method;}' unless defined(&SSLv23_method);
    eval 'sub SSLv23_server_method () { &TLS_server_method;}' unless defined(&SSLv23_server_method);
    eval 'sub SSLv23_client_method () { &TLS_client_method;}' unless defined(&SSLv23_client_method);
    unless(defined(&OPENSSL_NO_TLS1_METHOD)) {
	unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	}
    }
    unless(defined(&OPENSSL_NO_TLS1_1_METHOD)) {
	unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	}
    }
    unless(defined(&OPENSSL_NO_TLS1_2_METHOD)) {
	unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	}
    }
    unless(defined(&OPENSSL_NO_DTLS1_METHOD)) {
	unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	}
    }
    unless(defined(&OPENSSL_NO_DTLS1_2_METHOD)) {
	unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	}
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub SSL_library_init () {
	    eval q( &OPENSSL_init_ssl(0,  &NULL));
	}' unless defined(&SSL_library_init);
    }
    eval 'sub SSL_get0_session () { &SSL_get_session;}' unless defined(&SSL_get0_session);
    eval 'sub SSL_get_ex_new_index {
        my($l, $p, $newf, $dupf, $freef) = @_;
	    eval q( &CRYPTO_get_ex_new_index( &CRYPTO_EX_INDEX_SSL, $l, $p, $newf, $dupf, $freef));
    }' unless defined(&SSL_get_ex_new_index);
    eval 'sub SSL_SESSION_get_ex_new_index {
        my($l, $p, $newf, $dupf, $freef) = @_;
	    eval q( &CRYPTO_get_ex_new_index( &CRYPTO_EX_INDEX_SSL_SESSION, $l, $p, $newf, $dupf, $freef));
    }' unless defined(&SSL_SESSION_get_ex_new_index);
    eval 'sub SSL_CTX_get_ex_new_index {
        my($l, $p, $newf, $dupf, $freef) = @_;
	    eval q( &CRYPTO_get_ex_new_index( &CRYPTO_EX_INDEX_SSL_CTX, $l, $p, $newf, $dupf, $freef));
    }' unless defined(&SSL_CTX_get_ex_new_index);
    eval 'sub SSL_CTX_sess_set_cache_size {
        my($ctx,$t) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_SESS_CACHE_SIZE,$t, &NULL));
    }' unless defined(&SSL_CTX_sess_set_cache_size);
    eval 'sub SSL_CTX_sess_get_cache_size {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_GET_SESS_CACHE_SIZE,0, &NULL));
    }' unless defined(&SSL_CTX_sess_get_cache_size);
    eval 'sub SSL_CTX_set_session_cache_mode {
        my($ctx,$m) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_SESS_CACHE_MODE,$m, &NULL));
    }' unless defined(&SSL_CTX_set_session_cache_mode);
    eval 'sub SSL_CTX_get_session_cache_mode {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_GET_SESS_CACHE_MODE,0, &NULL));
    }' unless defined(&SSL_CTX_get_session_cache_mode);
    eval 'sub SSL_CTX_get_default_read_ahead {
        my($ctx) = @_;
	    eval q( &SSL_CTX_get_read_ahead($ctx));
    }' unless defined(&SSL_CTX_get_default_read_ahead);
    eval 'sub SSL_CTX_set_default_read_ahead {
        my($ctx,$m) = @_;
	    eval q( &SSL_CTX_set_read_ahead($ctx,$m));
    }' unless defined(&SSL_CTX_set_default_read_ahead);
    eval 'sub SSL_CTX_get_read_ahead {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_GET_READ_AHEAD,0, &NULL));
    }' unless defined(&SSL_CTX_get_read_ahead);
    eval 'sub SSL_CTX_set_read_ahead {
        my($ctx,$m) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_READ_AHEAD,$m, &NULL));
    }' unless defined(&SSL_CTX_set_read_ahead);
    eval 'sub SSL_CTX_get_max_cert_list {
        my($ctx) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_GET_MAX_CERT_LIST,0, &NULL));
    }' unless defined(&SSL_CTX_get_max_cert_list);
    eval 'sub SSL_CTX_set_max_cert_list {
        my($ctx,$m) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_MAX_CERT_LIST,$m, &NULL));
    }' unless defined(&SSL_CTX_set_max_cert_list);
    eval 'sub SSL_get_max_cert_list {
        my($ssl) = @_;
	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_GET_MAX_CERT_LIST,0, &NULL));
    }' unless defined(&SSL_get_max_cert_list);
    eval 'sub SSL_set_max_cert_list {
        my($ssl,$m) = @_;
	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_SET_MAX_CERT_LIST,$m, &NULL));
    }' unless defined(&SSL_set_max_cert_list);
    eval 'sub SSL_CTX_set_max_send_fragment {
        my($ctx,$m) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_MAX_SEND_FRAGMENT,$m, &NULL));
    }' unless defined(&SSL_CTX_set_max_send_fragment);
    eval 'sub SSL_set_max_send_fragment {
        my($ssl,$m) = @_;
	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_SET_MAX_SEND_FRAGMENT,$m, &NULL));
    }' unless defined(&SSL_set_max_send_fragment);
    eval 'sub SSL_CTX_set_split_send_fragment {
        my($ctx,$m) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_SPLIT_SEND_FRAGMENT,$m, &NULL));
    }' unless defined(&SSL_CTX_set_split_send_fragment);
    eval 'sub SSL_set_split_send_fragment {
        my($ssl,$m) = @_;
	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_SET_SPLIT_SEND_FRAGMENT,$m, &NULL));
    }' unless defined(&SSL_set_split_send_fragment);
    eval 'sub SSL_CTX_set_max_pipelines {
        my($ctx,$m) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_MAX_PIPELINES,$m, &NULL));
    }' unless defined(&SSL_CTX_set_max_pipelines);
    eval 'sub SSL_set_max_pipelines {
        my($ssl,$m) = @_;
	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_SET_MAX_PIPELINES,$m, &NULL));
    }' unless defined(&SSL_set_max_pipelines);
    eval 'sub SSL_set_retry_verify {
        my($ssl) = @_;
	    eval q(( &SSL_ctrl($ssl, &SSL_CTRL_SET_RETRY_VERIFY,0, &NULL) > 0));
    }' unless defined(&SSL_set_retry_verify);
    unless(defined(&OPENSSL_NO_DH)) {
	unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	}
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub SSL_COMP_free_compression_methods () {
	    eval q( &while(0)  &continue);
	}' unless defined(&SSL_COMP_free_compression_methods);
    }
    eval 'sub SSL_LISTENER_FLAG_NO_VALIDATE () {(1 << 1);}' unless defined(&SSL_LISTENER_FLAG_NO_VALIDATE);
    eval 'sub SSL_ACCEPT_CONNECTION_NO_BLOCK () {(1 << 0);}' unless defined(&SSL_ACCEPT_CONNECTION_NO_BLOCK);
    eval 'sub SSL_DOMAIN_FLAG_SINGLE_THREAD () {(1 << 0);}' unless defined(&SSL_DOMAIN_FLAG_SINGLE_THREAD);
    eval 'sub SSL_DOMAIN_FLAG_MULTI_THREAD () {(1 << 1);}' unless defined(&SSL_DOMAIN_FLAG_MULTI_THREAD);
    eval 'sub SSL_DOMAIN_FLAG_THREAD_ASSISTED () {(1 << 2);}' unless defined(&SSL_DOMAIN_FLAG_THREAD_ASSISTED);
    eval 'sub SSL_DOMAIN_FLAG_BLOCKING () {(1 << 3);}' unless defined(&SSL_DOMAIN_FLAG_BLOCKING);
    eval 'sub SSL_DOMAIN_FLAG_LEGACY_BLOCKING () {(1 << 4);}' unless defined(&SSL_DOMAIN_FLAG_LEGACY_BLOCKING);
    eval 'sub SSL_STREAM_TYPE_NONE () {0;}' unless defined(&SSL_STREAM_TYPE_NONE);
    eval 'sub SSL_STREAM_TYPE_READ () {(1 << 0);}' unless defined(&SSL_STREAM_TYPE_READ);
    eval 'sub SSL_STREAM_TYPE_WRITE () {(1 << 1);}' unless defined(&SSL_STREAM_TYPE_WRITE);
    eval 'sub SSL_STREAM_TYPE_BIDI () {( &SSL_STREAM_TYPE_READ |  &SSL_STREAM_TYPE_WRITE);}' unless defined(&SSL_STREAM_TYPE_BIDI);
    eval 'sub SSL_DEFAULT_STREAM_MODE_NONE () {0;}' unless defined(&SSL_DEFAULT_STREAM_MODE_NONE);
    eval 'sub SSL_DEFAULT_STREAM_MODE_AUTO_BIDI () {1;}' unless defined(&SSL_DEFAULT_STREAM_MODE_AUTO_BIDI);
    eval 'sub SSL_DEFAULT_STREAM_MODE_AUTO_UNI () {2;}' unless defined(&SSL_DEFAULT_STREAM_MODE_AUTO_UNI);
    eval 'sub SSL_STREAM_FLAG_UNI () {(1 << 0);}' unless defined(&SSL_STREAM_FLAG_UNI);
    eval 'sub SSL_STREAM_FLAG_NO_BLOCK () {(1 << 1);}' unless defined(&SSL_STREAM_FLAG_NO_BLOCK);
    eval 'sub SSL_STREAM_FLAG_ADVANCE () {(1 << 2);}' unless defined(&SSL_STREAM_FLAG_ADVANCE);
    eval 'sub SSL_INCOMING_STREAM_POLICY_AUTO () {0;}' unless defined(&SSL_INCOMING_STREAM_POLICY_AUTO);
    eval 'sub SSL_INCOMING_STREAM_POLICY_ACCEPT () {1;}' unless defined(&SSL_INCOMING_STREAM_POLICY_ACCEPT);
    eval 'sub SSL_INCOMING_STREAM_POLICY_REJECT () {2;}' unless defined(&SSL_INCOMING_STREAM_POLICY_REJECT);
    eval 'sub SSL_ACCEPT_STREAM_NO_BLOCK () {(1 << 0);}' unless defined(&SSL_ACCEPT_STREAM_NO_BLOCK);
    unless(defined(&OPENSSL_NO_QUIC)) {
    }
    eval 'sub SSL_SHUTDOWN_FLAG_RAPID () {(1 << 0);}' unless defined(&SSL_SHUTDOWN_FLAG_RAPID);
    eval 'sub SSL_SHUTDOWN_FLAG_NO_STREAM_FLUSH () {(1 << 1);}' unless defined(&SSL_SHUTDOWN_FLAG_NO_STREAM_FLUSH);
    eval 'sub SSL_SHUTDOWN_FLAG_NO_BLOCK () {(1 << 2);}' unless defined(&SSL_SHUTDOWN_FLAG_NO_BLOCK);
    eval 'sub SSL_SHUTDOWN_FLAG_WAIT_PEER () {(1 << 3);}' unless defined(&SSL_SHUTDOWN_FLAG_WAIT_PEER);
    eval 'sub SSL_STREAM_STATE_NONE () {0;}' unless defined(&SSL_STREAM_STATE_NONE);
    eval 'sub SSL_STREAM_STATE_OK () {1;}' unless defined(&SSL_STREAM_STATE_OK);
    eval 'sub SSL_STREAM_STATE_WRONG_DIR () {2;}' unless defined(&SSL_STREAM_STATE_WRONG_DIR);
    eval 'sub SSL_STREAM_STATE_FINISHED () {3;}' unless defined(&SSL_STREAM_STATE_FINISHED);
    eval 'sub SSL_STREAM_STATE_RESET_LOCAL () {4;}' unless defined(&SSL_STREAM_STATE_RESET_LOCAL);
    eval 'sub SSL_STREAM_STATE_RESET_REMOTE () {5;}' unless defined(&SSL_STREAM_STATE_RESET_REMOTE);
    eval 'sub SSL_STREAM_STATE_CONN_CLOSED () {6;}' unless defined(&SSL_STREAM_STATE_CONN_CLOSED);
    eval 'sub SSL_CONN_CLOSE_FLAG_LOCAL () {(1 << 0);}' unless defined(&SSL_CONN_CLOSE_FLAG_LOCAL);
    eval 'sub SSL_CONN_CLOSE_FLAG_TRANSPORT () {(1 << 1);}' unless defined(&SSL_CONN_CLOSE_FLAG_TRANSPORT);
    eval 'sub SSL_VALUE_CLASS_GENERIC () {0;}' unless defined(&SSL_VALUE_CLASS_GENERIC);
    eval 'sub SSL_VALUE_CLASS_FEATURE_REQUEST () {1;}' unless defined(&SSL_VALUE_CLASS_FEATURE_REQUEST);
    eval 'sub SSL_VALUE_CLASS_FEATURE_PEER_REQUEST () {2;}' unless defined(&SSL_VALUE_CLASS_FEATURE_PEER_REQUEST);
    eval 'sub SSL_VALUE_CLASS_FEATURE_NEGOTIATED () {3;}' unless defined(&SSL_VALUE_CLASS_FEATURE_NEGOTIATED);
    eval 'sub SSL_VALUE_NONE () {0;}' unless defined(&SSL_VALUE_NONE);
    eval 'sub SSL_VALUE_QUIC_STREAM_BIDI_LOCAL_AVAIL () {1;}' unless defined(&SSL_VALUE_QUIC_STREAM_BIDI_LOCAL_AVAIL);
    eval 'sub SSL_VALUE_QUIC_STREAM_BIDI_REMOTE_AVAIL () {2;}' unless defined(&SSL_VALUE_QUIC_STREAM_BIDI_REMOTE_AVAIL);
    eval 'sub SSL_VALUE_QUIC_STREAM_UNI_LOCAL_AVAIL () {3;}' unless defined(&SSL_VALUE_QUIC_STREAM_UNI_LOCAL_AVAIL);
    eval 'sub SSL_VALUE_QUIC_STREAM_UNI_REMOTE_AVAIL () {4;}' unless defined(&SSL_VALUE_QUIC_STREAM_UNI_REMOTE_AVAIL);
    eval 'sub SSL_VALUE_QUIC_IDLE_TIMEOUT () {5;}' unless defined(&SSL_VALUE_QUIC_IDLE_TIMEOUT);
    eval 'sub SSL_VALUE_EVENT_HANDLING_MODE () {6;}' unless defined(&SSL_VALUE_EVENT_HANDLING_MODE);
    eval 'sub SSL_VALUE_STREAM_WRITE_BUF_SIZE () {7;}' unless defined(&SSL_VALUE_STREAM_WRITE_BUF_SIZE);
    eval 'sub SSL_VALUE_STREAM_WRITE_BUF_USED () {8;}' unless defined(&SSL_VALUE_STREAM_WRITE_BUF_USED);
    eval 'sub SSL_VALUE_STREAM_WRITE_BUF_AVAIL () {9;}' unless defined(&SSL_VALUE_STREAM_WRITE_BUF_AVAIL);
    eval 'sub SSL_VALUE_EVENT_HANDLING_MODE_INHERIT () {0;}' unless defined(&SSL_VALUE_EVENT_HANDLING_MODE_INHERIT);
    eval 'sub SSL_VALUE_EVENT_HANDLING_MODE_IMPLICIT () {1;}' unless defined(&SSL_VALUE_EVENT_HANDLING_MODE_IMPLICIT);
    eval 'sub SSL_VALUE_EVENT_HANDLING_MODE_EXPLICIT () {2;}' unless defined(&SSL_VALUE_EVENT_HANDLING_MODE_EXPLICIT);
    eval 'sub SSL_get_generic_value_uint {
        my($ssl, $id, $v) = @_;
	    eval q( &SSL_get_value_uint(($ssl),  &SSL_VALUE_CLASS_GENERIC, ($id), ($v)));
    }' unless defined(&SSL_get_generic_value_uint);
    eval 'sub SSL_set_generic_value_uint {
        my($ssl, $id, $v) = @_;
	    eval q( &SSL_set_value_uint(($ssl),  &SSL_VALUE_CLASS_GENERIC, ($id), ($v)));
    }' unless defined(&SSL_set_generic_value_uint);
    eval 'sub SSL_get_feature_request_uint {
        my($ssl, $id, $v) = @_;
	    eval q( &SSL_get_value_uint(($ssl),  &SSL_VALUE_CLASS_FEATURE_REQUEST, ($id), ($v)));
    }' unless defined(&SSL_get_feature_request_uint);
    eval 'sub SSL_set_feature_request_uint {
        my($ssl, $id, $v) = @_;
	    eval q( &SSL_set_value_uint(($ssl),  &SSL_VALUE_CLASS_FEATURE_REQUEST, ($id), ($v)));
    }' unless defined(&SSL_set_feature_request_uint);
    eval 'sub SSL_get_feature_peer_request_uint {
        my($ssl, $id, $v) = @_;
	    eval q( &SSL_get_value_uint(($ssl),  &SSL_VALUE_CLASS_FEATURE_PEER_REQUEST, ($id), ($v)));
    }' unless defined(&SSL_get_feature_peer_request_uint);
    eval 'sub SSL_get_feature_negotiated_uint {
        my($ssl, $id, $v) = @_;
	    eval q( &SSL_get_value_uint(($ssl),  &SSL_VALUE_CLASS_FEATURE_NEGOTIATED, ($id), ($v)));
    }' unless defined(&SSL_get_feature_negotiated_uint);
    eval 'sub SSL_get_quic_stream_bidi_local_avail {
        my($ssl, $value) = @_;
	    eval q( &SSL_get_generic_value_uint(($ssl),  &SSL_VALUE_QUIC_STREAM_BIDI_LOCAL_AVAIL, ($value)));
    }' unless defined(&SSL_get_quic_stream_bidi_local_avail);
    eval 'sub SSL_get_quic_stream_bidi_remote_avail {
        my($ssl, $value) = @_;
	    eval q( &SSL_get_generic_value_uint(($ssl),  &SSL_VALUE_QUIC_STREAM_BIDI_REMOTE_AVAIL, ($value)));
    }' unless defined(&SSL_get_quic_stream_bidi_remote_avail);
    eval 'sub SSL_get_quic_stream_uni_local_avail {
        my($ssl, $value) = @_;
	    eval q( &SSL_get_generic_value_uint(($ssl),  &SSL_VALUE_QUIC_STREAM_UNI_LOCAL_AVAIL, ($value)));
    }' unless defined(&SSL_get_quic_stream_uni_local_avail);
    eval 'sub SSL_get_quic_stream_uni_remote_avail {
        my($ssl, $value) = @_;
	    eval q( &SSL_get_generic_value_uint(($ssl),  &SSL_VALUE_QUIC_STREAM_UNI_REMOTE_AVAIL, ($value)));
    }' unless defined(&SSL_get_quic_stream_uni_remote_avail);
    eval 'sub SSL_get_event_handling_mode {
        my($ssl, $value) = @_;
	    eval q( &SSL_get_generic_value_uint(($ssl),  &SSL_VALUE_EVENT_HANDLING_MODE, ($value)));
    }' unless defined(&SSL_get_event_handling_mode);
    eval 'sub SSL_set_event_handling_mode {
        my($ssl, $value) = @_;
	    eval q( &SSL_set_generic_value_uint(($ssl),  &SSL_VALUE_EVENT_HANDLING_MODE, ($value)));
    }' unless defined(&SSL_set_event_handling_mode);
    eval 'sub SSL_get_stream_write_buf_size {
        my($ssl, $value) = @_;
	    eval q( &SSL_get_generic_value_uint(($ssl),  &SSL_VALUE_STREAM_WRITE_BUF_SIZE, ($value)));
    }' unless defined(&SSL_get_stream_write_buf_size);
    eval 'sub SSL_get_stream_write_buf_used {
        my($ssl, $value) = @_;
	    eval q( &SSL_get_generic_value_uint(($ssl),  &SSL_VALUE_STREAM_WRITE_BUF_USED, ($value)));
    }' unless defined(&SSL_get_stream_write_buf_used);
    eval 'sub SSL_get_stream_write_buf_avail {
        my($ssl, $value) = @_;
	    eval q( &SSL_get_generic_value_uint(($ssl),  &SSL_VALUE_STREAM_WRITE_BUF_AVAIL, ($value)));
    }' unless defined(&SSL_get_stream_write_buf_avail);
    eval 'sub SSL_POLL_EVENT_NONE () {0;}' unless defined(&SSL_POLL_EVENT_NONE);
    eval 'sub SSL_POLL_EVENT_F () {(1 << 0);}' unless defined(&SSL_POLL_EVENT_F);
    eval 'sub SSL_POLL_EVENT_EL () {(1 << 1);}' unless defined(&SSL_POLL_EVENT_EL);
    eval 'sub SSL_POLL_EVENT_EC () {(1 << 2);}' unless defined(&SSL_POLL_EVENT_EC);
    eval 'sub SSL_POLL_EVENT_ECD () {(1 << 3);}' unless defined(&SSL_POLL_EVENT_ECD);
    eval 'sub SSL_POLL_EVENT_ER () {(1 << 4);}' unless defined(&SSL_POLL_EVENT_ER);
    eval 'sub SSL_POLL_EVENT_EW () {(1 << 5);}' unless defined(&SSL_POLL_EVENT_EW);
    eval 'sub SSL_POLL_EVENT_R () {(1 << 6);}' unless defined(&SSL_POLL_EVENT_R);
    eval 'sub SSL_POLL_EVENT_W () {(1 << 7);}' unless defined(&SSL_POLL_EVENT_W);
    eval 'sub SSL_POLL_EVENT_IC () {(1 << 8);}' unless defined(&SSL_POLL_EVENT_IC);
    eval 'sub SSL_POLL_EVENT_ISB () {(1 << 9);}' unless defined(&SSL_POLL_EVENT_ISB);
    eval 'sub SSL_POLL_EVENT_ISU () {(1 << 10);}' unless defined(&SSL_POLL_EVENT_ISU);
    eval 'sub SSL_POLL_EVENT_OSB () {(1 << 11);}' unless defined(&SSL_POLL_EVENT_OSB);
    eval 'sub SSL_POLL_EVENT_OSU () {(1 << 12);}' unless defined(&SSL_POLL_EVENT_OSU);
    eval 'sub SSL_POLL_EVENT_RW () {( &SSL_POLL_EVENT_R |  &SSL_POLL_EVENT_W);}' unless defined(&SSL_POLL_EVENT_RW);
    eval 'sub SSL_POLL_EVENT_RE () {( &SSL_POLL_EVENT_R |  &SSL_POLL_EVENT_ER);}' unless defined(&SSL_POLL_EVENT_RE);
    eval 'sub SSL_POLL_EVENT_WE () {( &SSL_POLL_EVENT_W |  &SSL_POLL_EVENT_EW);}' unless defined(&SSL_POLL_EVENT_WE);
    eval 'sub SSL_POLL_EVENT_RWE () {( &SSL_POLL_EVENT_RE |  &SSL_POLL_EVENT_WE);}' unless defined(&SSL_POLL_EVENT_RWE);
    eval 'sub SSL_POLL_EVENT_E () {( &SSL_POLL_EVENT_EL |  &SSL_POLL_EVENT_EC |  &SSL_POLL_EVENT_ER |  &SSL_POLL_EVENT_EW);}' unless defined(&SSL_POLL_EVENT_E);
    eval 'sub SSL_POLL_EVENT_IS () {( &SSL_POLL_EVENT_ISB |  &SSL_POLL_EVENT_ISU);}' unless defined(&SSL_POLL_EVENT_IS);
    eval 'sub SSL_POLL_EVENT_ISE () {( &SSL_POLL_EVENT_IS |  &SSL_POLL_EVENT_EC);}' unless defined(&SSL_POLL_EVENT_ISE);
    eval 'sub SSL_POLL_EVENT_I () {( &SSL_POLL_EVENT_IS |  &SSL_POLL_EVENT_IC);}' unless defined(&SSL_POLL_EVENT_I);
    eval 'sub SSL_POLL_EVENT_OS () {( &SSL_POLL_EVENT_OSB |  &SSL_POLL_EVENT_OSU);}' unless defined(&SSL_POLL_EVENT_OS);
    eval 'sub SSL_POLL_EVENT_OSE () {( &SSL_POLL_EVENT_OS |  &SSL_POLL_EVENT_EC);}' unless defined(&SSL_POLL_EVENT_OSE);
    eval 'sub SSL_POLL_FLAG_NO_HANDLE_EVENTS () {(1 << 0);}' unless defined(&SSL_POLL_FLAG_NO_HANDLE_EVENTS);
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub SSL_cache_hit {
	    my($s) = @_;
    	    eval q( &SSL_session_reused($s));
	}' unless defined(&SSL_cache_hit);
    }
    unless(defined(&OPENSSL_NO_SSL_TRACE)) {
    }
    unless(defined(&OPENSSL_NO_SOCK)) {
    }
    unless(defined(&OPENSSL_NO_CT)) {
	eval 'sub SSL_disable_ct {
	    my($s) = @_;
    	    eval q((( &void)  &SSL_set_validation_callback(($s),  &NULL,  &NULL)));
	}' unless defined(&SSL_disable_ct);
	eval 'sub SSL_CTX_disable_ct {
	    my($ctx) = @_;
    	    eval q((( &void)  &SSL_CTX_set_validation_callback(($ctx),  &NULL,  &NULL)));
	}' unless defined(&SSL_CTX_disable_ct);
	eval("sub SSL_CT_VALIDATION_PERMISSIVE () { 0; }") unless defined(&SSL_CT_VALIDATION_PERMISSIVE);
	eval("sub SSL_CT_VALIDATION_STRICT () { 1; }") unless defined(&SSL_CT_VALIDATION_STRICT);
    }
    eval 'sub SSL_SECOP_OTHER_TYPE () {0xffff0000;}' unless defined(&SSL_SECOP_OTHER_TYPE);
    eval 'sub SSL_SECOP_OTHER_NONE () {0;}' unless defined(&SSL_SECOP_OTHER_NONE);
    eval 'sub SSL_SECOP_OTHER_CIPHER () {(1<< 16);}' unless defined(&SSL_SECOP_OTHER_CIPHER);
    eval 'sub SSL_SECOP_OTHER_CURVE () {(2<< 16);}' unless defined(&SSL_SECOP_OTHER_CURVE);
    eval 'sub SSL_SECOP_OTHER_DH () {(3<< 16);}' unless defined(&SSL_SECOP_OTHER_DH);
    eval 'sub SSL_SECOP_OTHER_PKEY () {(4<< 16);}' unless defined(&SSL_SECOP_OTHER_PKEY);
    eval 'sub SSL_SECOP_OTHER_SIGALG () {(5<< 16);}' unless defined(&SSL_SECOP_OTHER_SIGALG);
    eval 'sub SSL_SECOP_OTHER_CERT () {(6<< 16);}' unless defined(&SSL_SECOP_OTHER_CERT);
    eval 'sub SSL_SECOP_PEER () {0x1000;}' unless defined(&SSL_SECOP_PEER);
    eval 'sub SSL_SECOP_CIPHER_SUPPORTED () {(1|  &SSL_SECOP_OTHER_CIPHER);}' unless defined(&SSL_SECOP_CIPHER_SUPPORTED);
    eval 'sub SSL_SECOP_CIPHER_SHARED () {(2|  &SSL_SECOP_OTHER_CIPHER);}' unless defined(&SSL_SECOP_CIPHER_SHARED);
    eval 'sub SSL_SECOP_CIPHER_CHECK () {(3|  &SSL_SECOP_OTHER_CIPHER);}' unless defined(&SSL_SECOP_CIPHER_CHECK);
    eval 'sub SSL_SECOP_CURVE_SUPPORTED () {(4|  &SSL_SECOP_OTHER_CURVE);}' unless defined(&SSL_SECOP_CURVE_SUPPORTED);
    eval 'sub SSL_SECOP_CURVE_SHARED () {(5|  &SSL_SECOP_OTHER_CURVE);}' unless defined(&SSL_SECOP_CURVE_SHARED);
    eval 'sub SSL_SECOP_CURVE_CHECK () {(6|  &SSL_SECOP_OTHER_CURVE);}' unless defined(&SSL_SECOP_CURVE_CHECK);
    eval 'sub SSL_SECOP_TMP_DH () {(7|  &SSL_SECOP_OTHER_PKEY);}' unless defined(&SSL_SECOP_TMP_DH);
    eval 'sub SSL_SECOP_VERSION () {(9|  &SSL_SECOP_OTHER_NONE);}' unless defined(&SSL_SECOP_VERSION);
    eval 'sub SSL_SECOP_TICKET () {(10|  &SSL_SECOP_OTHER_NONE);}' unless defined(&SSL_SECOP_TICKET);
    eval 'sub SSL_SECOP_SIGALG_SUPPORTED () {(11|  &SSL_SECOP_OTHER_SIGALG);}' unless defined(&SSL_SECOP_SIGALG_SUPPORTED);
    eval 'sub SSL_SECOP_SIGALG_SHARED () {(12|  &SSL_SECOP_OTHER_SIGALG);}' unless defined(&SSL_SECOP_SIGALG_SHARED);
    eval 'sub SSL_SECOP_SIGALG_CHECK () {(13|  &SSL_SECOP_OTHER_SIGALG);}' unless defined(&SSL_SECOP_SIGALG_CHECK);
    eval 'sub SSL_SECOP_SIGALG_MASK () {(14|  &SSL_SECOP_OTHER_SIGALG);}' unless defined(&SSL_SECOP_SIGALG_MASK);
    eval 'sub SSL_SECOP_COMPRESSION () {(15|  &SSL_SECOP_OTHER_NONE);}' unless defined(&SSL_SECOP_COMPRESSION);
    eval 'sub SSL_SECOP_EE_KEY () {(16|  &SSL_SECOP_OTHER_CERT);}' unless defined(&SSL_SECOP_EE_KEY);
    eval 'sub SSL_SECOP_CA_KEY () {(17|  &SSL_SECOP_OTHER_CERT);}' unless defined(&SSL_SECOP_CA_KEY);
    eval 'sub SSL_SECOP_CA_MD () {(18|  &SSL_SECOP_OTHER_CERT);}' unless defined(&SSL_SECOP_CA_MD);
    eval 'sub SSL_SECOP_PEER_EE_KEY () {( &SSL_SECOP_EE_KEY |  &SSL_SECOP_PEER);}' unless defined(&SSL_SECOP_PEER_EE_KEY);
    eval 'sub SSL_SECOP_PEER_CA_KEY () {( &SSL_SECOP_CA_KEY |  &SSL_SECOP_PEER);}' unless defined(&SSL_SECOP_PEER_CA_KEY);
    eval 'sub SSL_SECOP_PEER_CA_MD () {( &SSL_SECOP_CA_MD |  &SSL_SECOP_PEER);}' unless defined(&SSL_SECOP_PEER_CA_MD);
    eval 'sub OPENSSL_INIT_NO_LOAD_SSL_STRINGS () {0x100000;}' unless defined(&OPENSSL_INIT_NO_LOAD_SSL_STRINGS);
    eval 'sub OPENSSL_INIT_LOAD_SSL_STRINGS () {0x200000;}' unless defined(&OPENSSL_INIT_LOAD_SSL_STRINGS);
    eval 'sub OPENSSL_INIT_SSL_DEFAULT () {( &OPENSSL_INIT_LOAD_SSL_STRINGS |  &OPENSSL_INIT_LOAD_CRYPTO_STRINGS);}' unless defined(&OPENSSL_INIT_SSL_DEFAULT);
    unless(defined(&OPENSSL_NO_UNIT_TEST)) {
    }
    eval 'sub SSL_TICKET_FATAL_ERR_MALLOC () {0;}' unless defined(&SSL_TICKET_FATAL_ERR_MALLOC);
    eval 'sub SSL_TICKET_FATAL_ERR_OTHER () {1;}' unless defined(&SSL_TICKET_FATAL_ERR_OTHER);
    eval 'sub SSL_TICKET_NONE () {2;}' unless defined(&SSL_TICKET_NONE);
    eval 'sub SSL_TICKET_EMPTY () {3;}' unless defined(&SSL_TICKET_EMPTY);
    eval 'sub SSL_TICKET_NO_DECRYPT () {4;}' unless defined(&SSL_TICKET_NO_DECRYPT);
    eval 'sub SSL_TICKET_SUCCESS () {5;}' unless defined(&SSL_TICKET_SUCCESS);
    eval 'sub SSL_TICKET_SUCCESS_RENEW () {6;}' unless defined(&SSL_TICKET_SUCCESS_RENEW);
    eval 'sub SSL_TICKET_RETURN_ABORT () {0;}' unless defined(&SSL_TICKET_RETURN_ABORT);
    eval 'sub SSL_TICKET_RETURN_IGNORE () {1;}' unless defined(&SSL_TICKET_RETURN_IGNORE);
    eval 'sub SSL_TICKET_RETURN_IGNORE_RENEW () {2;}' unless defined(&SSL_TICKET_RETURN_IGNORE_RENEW);
    eval 'sub SSL_TICKET_RETURN_USE () {3;}' unless defined(&SSL_TICKET_RETURN_USE);
    eval 'sub SSL_TICKET_RETURN_USE_RENEW () {4;}' unless defined(&SSL_TICKET_RETURN_USE_RENEW);
    eval 'sub OSSL_RECORD_PROTECTION_LEVEL_NONE () {0;}' unless defined(&OSSL_RECORD_PROTECTION_LEVEL_NONE);
    eval 'sub OSSL_RECORD_PROTECTION_LEVEL_EARLY () {1;}' unless defined(&OSSL_RECORD_PROTECTION_LEVEL_EARLY);
    eval 'sub OSSL_RECORD_PROTECTION_LEVEL_HANDSHAKE () {2;}' unless defined(&OSSL_RECORD_PROTECTION_LEVEL_HANDSHAKE);
    eval 'sub OSSL_RECORD_PROTECTION_LEVEL_APPLICATION () {3;}' unless defined(&OSSL_RECORD_PROTECTION_LEVEL_APPLICATION);
    if(defined(&__cplusplus)) {
    }
}
1;
