# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Type, Optional, cast
from typing_extensions import Literal

import httpx

from ..._types import NOT_GIVEN, Body, Query, Headers, NotGiven
from ..._utils import maybe_transform, async_maybe_transform
from ..._compat import cached_property
from ..._resource import SyncAPIResource, AsyncAPIResource
from ..._response import (
    to_raw_response_wrapper,
    to_streamed_response_wrapper,
    async_to_raw_response_wrapper,
    async_to_streamed_response_wrapper,
)
from ..._wrappers import ResultWrapper
from ...types.dns import dnssec_edit_params
from ..._base_client import make_request_options
from ...types.dns.dnssec import DNSSEC
from ...types.dns.dnssec_delete_response import DNSSECDeleteResponse

__all__ = ["DNSSECResource", "AsyncDNSSECResource"]


class DNSSECResource(SyncAPIResource):
    @cached_property
    def with_raw_response(self) -> DNSSECResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/cloudflare/cloudflare-python#accessing-raw-response-data-eg-headers
        """
        return DNSSECResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> DNSSECResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/cloudflare/cloudflare-python#with_streaming_response
        """
        return DNSSECResourceWithStreamingResponse(self)

    def delete(
        self,
        *,
        zone_id: str,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> str:
        """
        Delete DNSSEC.

        Args:
          zone_id: Identifier.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not zone_id:
            raise ValueError(f"Expected a non-empty value for `zone_id` but received {zone_id!r}")
        return self._delete(
            f"/zones/{zone_id}/dnssec",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                post_parser=ResultWrapper[Optional[DNSSECDeleteResponse]]._unwrapper,
            ),
            cast_to=cast(Type[str], ResultWrapper[str]),
        )

    def edit(
        self,
        *,
        zone_id: str,
        dnssec_multi_signer: bool | NotGiven = NOT_GIVEN,
        dnssec_presigned: bool | NotGiven = NOT_GIVEN,
        dnssec_use_nsec3: bool | NotGiven = NOT_GIVEN,
        status: Literal["active", "disabled"] | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[DNSSEC]:
        """
        Enable or disable DNSSEC.

        Args:
          zone_id: Identifier.

          dnssec_multi_signer: If true, multi-signer DNSSEC is enabled on the zone, allowing multiple providers
              to serve a DNSSEC-signed zone at the same time. This is required for DNSKEY
              records (except those automatically generated by Cloudflare) to be added to the
              zone.

              See
              [Multi-signer DNSSEC](https://developers.cloudflare.com/dns/dnssec/multi-signer-dnssec/)
              for details.

          dnssec_presigned: If true, allows Cloudflare to transfer in a DNSSEC-signed zone including
              signatures from an external provider, without requiring Cloudflare to sign any
              records on the fly.

              Note that this feature has some limitations. See
              [Cloudflare as Secondary](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-secondary/setup/#dnssec)
              for details.

          dnssec_use_nsec3: If true, enables the use of NSEC3 together with DNSSEC on the zone. Combined
              with setting dnssec_presigned to true, this enables the use of NSEC3 records
              when transferring in from an external provider. If dnssec_presigned is instead
              set to false (default), NSEC3 records will be generated and signed at request
              time.

              See
              [DNSSEC with NSEC3](https://developers.cloudflare.com/dns/dnssec/enable-nsec3/)
              for details.

          status: Status of DNSSEC, based on user-desired state and presence of necessary records.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not zone_id:
            raise ValueError(f"Expected a non-empty value for `zone_id` but received {zone_id!r}")
        return self._patch(
            f"/zones/{zone_id}/dnssec",
            body=maybe_transform(
                {
                    "dnssec_multi_signer": dnssec_multi_signer,
                    "dnssec_presigned": dnssec_presigned,
                    "dnssec_use_nsec3": dnssec_use_nsec3,
                    "status": status,
                },
                dnssec_edit_params.DNSSECEditParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                post_parser=ResultWrapper[Optional[DNSSEC]]._unwrapper,
            ),
            cast_to=cast(Type[Optional[DNSSEC]], ResultWrapper[DNSSEC]),
        )

    def get(
        self,
        *,
        zone_id: str,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[DNSSEC]:
        """
        Details about DNSSEC status and configuration.

        Args:
          zone_id: Identifier.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not zone_id:
            raise ValueError(f"Expected a non-empty value for `zone_id` but received {zone_id!r}")
        return self._get(
            f"/zones/{zone_id}/dnssec",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                post_parser=ResultWrapper[Optional[DNSSEC]]._unwrapper,
            ),
            cast_to=cast(Type[Optional[DNSSEC]], ResultWrapper[DNSSEC]),
        )


class AsyncDNSSECResource(AsyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AsyncDNSSECResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/cloudflare/cloudflare-python#accessing-raw-response-data-eg-headers
        """
        return AsyncDNSSECResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncDNSSECResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/cloudflare/cloudflare-python#with_streaming_response
        """
        return AsyncDNSSECResourceWithStreamingResponse(self)

    async def delete(
        self,
        *,
        zone_id: str,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> str:
        """
        Delete DNSSEC.

        Args:
          zone_id: Identifier.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not zone_id:
            raise ValueError(f"Expected a non-empty value for `zone_id` but received {zone_id!r}")
        return await self._delete(
            f"/zones/{zone_id}/dnssec",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                post_parser=ResultWrapper[Optional[DNSSECDeleteResponse]]._unwrapper,
            ),
            cast_to=cast(Type[str], ResultWrapper[str]),
        )

    async def edit(
        self,
        *,
        zone_id: str,
        dnssec_multi_signer: bool | NotGiven = NOT_GIVEN,
        dnssec_presigned: bool | NotGiven = NOT_GIVEN,
        dnssec_use_nsec3: bool | NotGiven = NOT_GIVEN,
        status: Literal["active", "disabled"] | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[DNSSEC]:
        """
        Enable or disable DNSSEC.

        Args:
          zone_id: Identifier.

          dnssec_multi_signer: If true, multi-signer DNSSEC is enabled on the zone, allowing multiple providers
              to serve a DNSSEC-signed zone at the same time. This is required for DNSKEY
              records (except those automatically generated by Cloudflare) to be added to the
              zone.

              See
              [Multi-signer DNSSEC](https://developers.cloudflare.com/dns/dnssec/multi-signer-dnssec/)
              for details.

          dnssec_presigned: If true, allows Cloudflare to transfer in a DNSSEC-signed zone including
              signatures from an external provider, without requiring Cloudflare to sign any
              records on the fly.

              Note that this feature has some limitations. See
              [Cloudflare as Secondary](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-secondary/setup/#dnssec)
              for details.

          dnssec_use_nsec3: If true, enables the use of NSEC3 together with DNSSEC on the zone. Combined
              with setting dnssec_presigned to true, this enables the use of NSEC3 records
              when transferring in from an external provider. If dnssec_presigned is instead
              set to false (default), NSEC3 records will be generated and signed at request
              time.

              See
              [DNSSEC with NSEC3](https://developers.cloudflare.com/dns/dnssec/enable-nsec3/)
              for details.

          status: Status of DNSSEC, based on user-desired state and presence of necessary records.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not zone_id:
            raise ValueError(f"Expected a non-empty value for `zone_id` but received {zone_id!r}")
        return await self._patch(
            f"/zones/{zone_id}/dnssec",
            body=await async_maybe_transform(
                {
                    "dnssec_multi_signer": dnssec_multi_signer,
                    "dnssec_presigned": dnssec_presigned,
                    "dnssec_use_nsec3": dnssec_use_nsec3,
                    "status": status,
                },
                dnssec_edit_params.DNSSECEditParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                post_parser=ResultWrapper[Optional[DNSSEC]]._unwrapper,
            ),
            cast_to=cast(Type[Optional[DNSSEC]], ResultWrapper[DNSSEC]),
        )

    async def get(
        self,
        *,
        zone_id: str,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[DNSSEC]:
        """
        Details about DNSSEC status and configuration.

        Args:
          zone_id: Identifier.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not zone_id:
            raise ValueError(f"Expected a non-empty value for `zone_id` but received {zone_id!r}")
        return await self._get(
            f"/zones/{zone_id}/dnssec",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                post_parser=ResultWrapper[Optional[DNSSEC]]._unwrapper,
            ),
            cast_to=cast(Type[Optional[DNSSEC]], ResultWrapper[DNSSEC]),
        )


class DNSSECResourceWithRawResponse:
    def __init__(self, dnssec: DNSSECResource) -> None:
        self._dnssec = dnssec

        self.delete = to_raw_response_wrapper(
            dnssec.delete,
        )
        self.edit = to_raw_response_wrapper(
            dnssec.edit,
        )
        self.get = to_raw_response_wrapper(
            dnssec.get,
        )


class AsyncDNSSECResourceWithRawResponse:
    def __init__(self, dnssec: AsyncDNSSECResource) -> None:
        self._dnssec = dnssec

        self.delete = async_to_raw_response_wrapper(
            dnssec.delete,
        )
        self.edit = async_to_raw_response_wrapper(
            dnssec.edit,
        )
        self.get = async_to_raw_response_wrapper(
            dnssec.get,
        )


class DNSSECResourceWithStreamingResponse:
    def __init__(self, dnssec: DNSSECResource) -> None:
        self._dnssec = dnssec

        self.delete = to_streamed_response_wrapper(
            dnssec.delete,
        )
        self.edit = to_streamed_response_wrapper(
            dnssec.edit,
        )
        self.get = to_streamed_response_wrapper(
            dnssec.get,
        )


class AsyncDNSSECResourceWithStreamingResponse:
    def __init__(self, dnssec: AsyncDNSSECResource) -> None:
        self._dnssec = dnssec

        self.delete = async_to_streamed_response_wrapper(
            dnssec.delete,
        )
        self.edit = async_to_streamed_response_wrapper(
            dnssec.edit,
        )
        self.get = async_to_streamed_response_wrapper(
            dnssec.get,
        )
