/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporter;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.internal.performanceTests.ProjectInitializationDiagnosticService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.InitProjectActivityJavaShim;
import com.intellij.openapi.ui.playback.PlaybackRunner;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Alarm;
import com.intellij.util.SystemProperties;
import com.jetbrains.performancePlugin.CommandLogger;
import com.jetbrains.performancePlugin.CommandsRunner;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.PlaybackRunnerExtended;
import com.jetbrains.performancePlugin.ProjectLoadedKt;
import com.jetbrains.performancePlugin.commands.OpenProjectCommand;
import com.jetbrains.performancePlugin.commands.TakeScreenshotCommandKt;
import com.jetbrains.performancePlugin.profilers.Profiler;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import io.opentelemetry.context.Context;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0019\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/performancePlugin/ProjectLoaded;", "Lcom/intellij/openapi/startup/InitProjectActivityJavaShim;", "Lcom/intellij/ide/ApplicationInitializedListener;", "()V", "alarm", "Lcom/intellij/util/Alarm;", "execute", "", "asyncScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runActivity", "project", "Lcom/intellij/openapi/project/Project;", "runScriptDuringIndexing", "runScriptWhenInitializedAndIndexed", "Companion", "MyAppLifecycleListener", "intellij.performanceTesting"})
public final class ProjectLoaded
extends InitProjectActivityJavaShim
implements ApplicationInitializedListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Alarm alarm = new Alarm();
    private static final int TIMEOUT = 500;
    @JvmField
    @Nullable
    public static final String TEST_SCRIPT_FILE_PATH = System.getProperty("testscript.filename");
    @NotNull
    private static final String INDEXING_PROFILER_PREFIX = "%%profileIndexing";
    @Nullable
    private static Job screenshotJob;
    private static boolean ourScriptStarted;

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (TEST_SCRIPT_FILE_PATH == null || ourScriptStarted) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ProjectLoadedKt.access$getLOG().info(PerformanceTestingBundle.message("startup.silent", new Object[0]));
            }
            return;
        }
        ourScriptStarted = true;
        if (System.getProperty("ide.performance.screenshot") != null) {
            String string = System.getProperty("ide.performance.screenshot");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"ide.performance.screenshot\")");
            CoroutineScope coroutineScope = project.getCoroutineScope();
            Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"project.coroutineScope");
            ProjectLoaded.Companion.registerScreenshotTaking(string, coroutineScope);
        }
        ProjectLoadedKt.access$getLOG().info("Start Execution");
        PerformanceTestSpan.startSpan();
        Pair profilerSettings = ProjectLoaded.Companion.initializeProfilerSettingsForIndexing();
        if (profilerSettings != null) {
            try {
                Profiler profiler = ProfilersController.getInstance().getCurrentProfilerHandler();
                Object object = profilerSettings.first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"profilerSettings.first");
                String string = (String)object;
                Object object2 = profilerSettings.second;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"profilerSettings.second");
                profiler.startProfiling(string, (List)object2);
            }
            catch (Exception e) {
                System.err.println("Start profile failed: " + e.getMessage());
                ApplicationManagerEx.getApplicationEx().exit(true, true, 1);
            }
        }
        if (OpenProjectCommand.Companion.shouldOpenInSmartMode(project)) {
            this.runScriptWhenInitializedAndIndexed(project);
        } else if (SystemProperties.getBooleanProperty((String)"performance.execute.script.after.scanning", (boolean)false)) {
            this.runScriptDuringIndexing(project);
        } else {
            ProjectLoadedKt.access$runScriptFromFile(project);
        }
    }

    @Nullable
    public Object execute(@NotNull CoroutineScope asyncScope, @NotNull Continuation<? super Unit> $completion) {
        if (ApplicationManagerEx.getApplicationEx().isLightEditMode()) {
            LightEditService.getInstance().getEditorManager().addListener(new LightEditorListener(this){
                final /* synthetic */ ProjectLoaded this$0;
                {
                    this.this$0 = $receiver;
                }

                public void afterSelect(@Nullable LightEditorInfo editorInfo) {
                    StartUpPerformanceReporter.Companion.logStats("LightEditor");
                    Project project = LightEditService.getInstance().getProject();
                    Intrinsics.checkNotNull((Object)project);
                    this.this$0.runActivity(project);
                }
            });
        }
        return Unit.INSTANCE;
    }

    private final void runScriptWhenInitializedAndIndexed(Project project) {
        DumbService dumbService = DumbService.Companion.getInstance(project);
        Runnable runnable = Context.current().wrap(() -> ProjectLoaded.runScriptWhenInitializedAndIndexed$lambda$1(this, project));
        Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"current().wrap(\n      Ru\u2026    }), TIMEOUT)\n      })");
        dumbService.smartInvokeLater(runnable);
    }

    private final void runScriptDuringIndexing(Project project) {
        ApplicationManager.getApplication().executeOnPooledThread(Context.current().wrap(() -> ProjectLoaded.runScriptDuringIndexing$lambda$3(this, project)));
    }

    private static final void runScriptWhenInitializedAndIndexed$lambda$1$lambda$0(Project $project, ProjectLoaded this$0) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (DumbService.Companion.isDumb($project) || !CoreProgressManager.getCurrentIndicators().isEmpty() || !ProjectInitializationDiagnosticService.getInstance((Project)$project).isProjectInitializationAndIndexingFinished()) {
            this$0.runScriptWhenInitializedAndIndexed($project);
        } else {
            ProjectLoadedKt.access$runScriptFromFile($project);
        }
    }

    private static final void runScriptWhenInitializedAndIndexed$lambda$1(ProjectLoaded this$0, Project $project) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        this$0.alarm.addRequest(Context.current().wrap(() -> ProjectLoaded.runScriptWhenInitializedAndIndexed$lambda$1$lambda$0($project, this$0)), 500);
    }

    private static final void runScriptDuringIndexing$lambda$3$lambda$2(Project $project, ProjectLoaded this$0) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        List list = CoreProgressManager.getCurrentIndicators();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCurrentIndicators()");
        List indicators = list;
        boolean indexingInProgress = false;
        for (ProgressIndicator indicator : indicators) {
            String indicatorText = indicator.getText();
            if (indicatorText == null || !StringsKt.contains$default((CharSequence)indicatorText, (CharSequence)"Indexing", (boolean)false, (int)2, null)) continue;
            indexingInProgress = true;
            break;
        }
        if (indexingInProgress) {
            ProjectLoadedKt.access$runScriptFromFile($project);
        } else {
            this$0.runScriptDuringIndexing($project);
        }
    }

    private static final void runScriptDuringIndexing$lambda$3(ProjectLoaded this$0, Project $project) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        this$0.alarm.addRequest(Context.current().wrap(() -> ProjectLoaded.runScriptDuringIndexing$lambda$3$lambda$2($project, this$0)), 500);
    }

    @JvmStatic
    public static final void runScript(@Nullable Project project, @Nullable String script, boolean mustExitOnFailure) {
        Companion.runScript(project, script, mustExitOnFailure);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000eJ\u001c\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0011\u0018\u00010\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0013J$\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/performancePlugin/ProjectLoaded$Companion;", "", "()V", "INDEXING_PROFILER_PREFIX", "", "TEST_SCRIPT_FILE_PATH", "TIMEOUT", "", "ourScriptStarted", "", "screenshotJob", "Lkotlinx/coroutines/Job;", "generifyErrorMessage", "originalMessage", "generifyErrorMessage$intellij_performanceTesting", "initializeProfilerSettingsForIndexing", "Lcom/intellij/openapi/util/Pair;", "", "registerScreenshotTaking", "", "folder", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "reportErrorsFromMessagePool", "runScript", "project", "Lcom/intellij/openapi/project/Project;", "script", "mustExitOnFailure", "intellij.performanceTesting"})
    @SourceDebugExtension(value={"SMAP\nProjectLoaded.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectLoaded.kt\ncom/jetbrains/performancePlugin/ProjectLoaded$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,424:1\n731#2,9:425\n*S KotlinDebug\n*F\n+ 1 ProjectLoaded.kt\ncom/jetbrains/performancePlugin/ProjectLoaded$Companion\n*L\n218#1:425,9\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void registerScreenshotTaking(String folder, CoroutineScope coroutineScope) {
            screenshotJob = BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(folder, null){
                int label;
                final /* synthetic */ String $folder;
                {
                    this.$folder = $folder;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
lbl6:
                            // 2 sources

                            while (true) {
                                this.label = 1;
                                v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl16
                                break;
                            }
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            this.label = 2;
                            v1 = TakeScreenshotCommandKt.takeScreenshotOfAllWindows(this.$folder, (Continuation<? super Unit>)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl24
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl24:
                            // 2 sources

                            ** continue;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        private final Pair<String, List<String>> initializeProfilerSettingsForIndexing() {
            try {
                List list = FileUtil.loadLines((File)ProjectLoadedKt.access$getTestFile());
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"loadLines(getTestFile())");
                List lines = list;
                for (String line : lines) {
                    List list2;
                    Intrinsics.checkNotNullExpressionValue((Object)line, (String)"line");
                    if (!StringsKt.startsWith$default((String)line, (String)ProjectLoaded.INDEXING_PROFILER_PREFIX, (boolean)false, (int)2, null)) continue;
                    String string = line.substring(17);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
                    Regex regex = new Regex("\\s+");
                    int n = 2;
                    List command = regex.split(charSequence, n);
                    String indexingActivity = (String)command.get(0);
                    if (command.size() > 1) {
                        char[] cArray = new char[]{','};
                        List $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)((String)command.get(1)))).toString(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
                        boolean $i$f$dropLastWhile = false;
                        if (!$this$dropLastWhile$iv.isEmpty()) {
                            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                            while (iterator$iv.hasPrevious()) {
                                String it = (String)iterator$iv.previous();
                                boolean bl = false;
                                if (((CharSequence)it).length() == 0) continue;
                                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                                break;
                            }
                        } else {
                            list2 = CollectionsKt.emptyList();
                        }
                    } else {
                        list2 = new ArrayList();
                    }
                    List profilingParameters = list2;
                    return new Pair((Object)indexingActivity, (Object)profilingParameters);
                }
            }
            catch (IOException ignored) {
                System.err.println(PerformanceTestingBundle.message("startup.script.read.error", new Object[0]));
                ApplicationManagerEx.getApplicationEx().exit(true, true, 1);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void reportErrorsFromMessagePool() {
            MessagePool messagePool = MessagePool.getInstance();
            List ideErrors = messagePool.getFatalErrors(false, true);
            for (AbstractMessage message : ideErrors) {
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
                    ProjectLoadedKt.access$reportScriptError(message);
                }
                catch (IOException e) {
                    ProjectLoadedKt.access$getLOG().error((Throwable)e);
                }
                finally {
                    message.setRead(true);
                }
            }
        }

        @NotNull
        public final String generifyErrorMessage$intellij_performanceTesting(@NotNull String originalMessage) {
            Intrinsics.checkNotNullParameter((Object)originalMessage, (String)"originalMessage");
            CharSequence charSequence = originalMessage;
            Regex regex = new Regex("[$@#][A-Za-z0-9-_]+");
            String string = "<ID>";
            charSequence = regex.replace(charSequence, string);
            regex = new Regex("[.]([A-Za-z]+[0-9]|[0-9]+[A-Za-z])[A-Za-z0-9]*");
            string = ".<HASH>";
            charSequence = regex.replace(charSequence, string);
            regex = new Regex("0x[0-9a-fA-F]+");
            string = "<HEX>";
            charSequence = regex.replace(charSequence, string);
            regex = new Regex("[0-9]+");
            string = "<NUM>";
            return regex.replace(charSequence, string);
        }

        @JvmStatic
        public final void runScript(@Nullable Project project, @Nullable String script, boolean mustExitOnFailure) {
            PlaybackRunner.StatusCallback statusCallback = new CommandLogger();
            Project project2 = project;
            Intrinsics.checkNotNull((Object)project2);
            PlaybackRunner playback = new PlaybackRunnerExtended(script, statusCallback, project2);
            CompletableFuture scriptCallback = playback.run();
            CommandsRunner.setActionCallback(scriptCallback);
            Intrinsics.checkNotNullExpressionValue((Object)scriptCallback, (String)"scriptCallback");
            ProjectLoadedKt.access$registerOnFinishRunnables(scriptCallback, mustExitOnFailure);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/performancePlugin/ProjectLoaded$MyAppLifecycleListener;", "Lcom/intellij/ide/AppLifecycleListener;", "()V", "appClosing", "", "appFrameCreated", "commandLineArgs", "", "", "intellij.performanceTesting"})
    public static final class MyAppLifecycleListener
    implements AppLifecycleListener {
        public MyAppLifecycleListener() {
            if (TEST_SCRIPT_FILE_PATH == null) {
                ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
                Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create()");
                throw (Throwable)extensionNotApplicableException;
            }
        }

        public void appFrameCreated(@NotNull List<String> commandLineArgs) {
            Intrinsics.checkNotNullParameter(commandLineArgs, (String)"commandLineArgs");
            MessagePool messagePool = MessagePool.getInstance();
            ProjectLoadedKt.access$getLOG().info("Error watcher has started");
            messagePool.addListener(MyAppLifecycleListener::appFrameCreated$lambda$0);
        }

        public void appClosing() {
            Job job = screenshotJob;
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            PerformanceTestSpan.endSpan();
            Companion.reportErrorsFromMessagePool();
        }

        private static final void appFrameCreated$lambda$0() {
            Companion.reportErrorsFromMessagePool();
        }
    }
}

