/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.lang.IJPerfFileType;
import com.jetbrains.performancePlugin.utils.ScriptRunner;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExecuteScriptDialog
extends DialogWrapper {
    private final Project project;
    private EditorTextField scriptText;
    private JPanel myMainPanel;
    private ComboBox<Scenario> scenarioComboBox;
    private static String lastUsedText = null;
    private final ScriptRunner myScriptRunner;
    private final Action execute;

    public ExecuteScriptDialog(final @NotNull Project project) {
        if (project == null) {
            ExecuteScriptDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.project = project;
        this.$$$setupUI$$$();
        this.myScriptRunner = new ScriptRunner();
        this.execute = this.createExecuteAction();
        this.setTitle(PerformanceTestingBundle.message("executor.title", new Object[0]));
        this.scenarioComboBox.addItem((Object)new Scenario(PerformanceTestingBundle.message("typing.scenario", new Object[0]), ExecuteScriptDialog.generateTestScript(PerformanceScriptType.TYPING)));
        this.scenarioComboBox.addItem((Object)new Scenario(PerformanceTestingBundle.message("formatting.scenario", new Object[0]), ExecuteScriptDialog.generateTestScript(PerformanceScriptType.FORMATTING)));
        this.scenarioComboBox.addItem((Object)new Scenario(PerformanceTestingBundle.message("local.inspection.scenario", new Object[0]), ExecuteScriptDialog.generateTestScript(PerformanceScriptType.INSPECTION)));
        this.scenarioComboBox.setEditable(false);
        this.scenarioComboBox.setSelectedIndex(0);
        this.scenarioComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Scenario item = (Scenario)e.getItem();
                ExecuteScriptDialog.this.scriptText.setText(ExecuteScriptDialog.getCurrentFileCommand(project) + item.getScript());
            }
        });
        this.init();
    }

    private void createUIComponents() {
        this.scriptText = new EditorTextField(this.project, (FileType)IJPerfFileType.INSTANCE);
        this.scriptText.setOneLineMode(false);
        this.scriptText.setText((String)(lastUsedText != null ? lastUsedText : ExecuteScriptDialog.getCurrentFileCommand(this.project) + ExecuteScriptDialog.generateTestScript(PerformanceScriptType.TYPING)));
    }

    private static String getCurrentFileCommand(Project project) {
        VirtualFile[] openFiles;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        Object openFileCommand = "";
        if (fileEditorManager != null && (openFiles = fileEditorManager.getSelectedFiles()).length != 0) {
            openFileCommand = "%openFile " + openFiles[0].getCanonicalPath() + "\n";
        }
        return openFileCommand;
    }

    @NotNull
    @Contract(pure=true)
    private static String generateTestScript(@NotNull PerformanceScriptType scriptType) {
        if (scriptType == null) {
            ExecuteScriptDialog.$$$reportNull$$$0(1);
        }
        return switch (scriptType) {
            default -> throw new IncompatibleClassChangeError();
            case PerformanceScriptType.TYPING -> "%delayType 150|Sample text for typing scenario\n%pressKey ENTER\n%delayType 150|Sample text for typing scenario\n%pressKey ENTER\n%delayType 150|Sample text for typing scenario";
            case PerformanceScriptType.FORMATTING -> "%reformat";
            case PerformanceScriptType.INSPECTION -> "%doLocalInspection\n%doLocalInspection\n%doLocalInspection";
        };
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.execute, this.getCancelAction()};
        if (actionArray == null) {
            ExecuteScriptDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    private Action createExecuteAction() {
        return new DialogWrapper.DialogWrapperAction(PerformanceTestingBundle.message("execute.script.button", new Object[0])){

            protected void doAction(ActionEvent e) {
                lastUsedText = ExecuteScriptDialog.this.scriptText.getText();
                ExecuteScriptDialog.this.doOKAction();
                ExecuteScriptDialog.this.myScriptRunner.doRunScript(ExecuteScriptDialog.this.project, ExecuteScriptDialog.this.scriptText.getText(), null);
            }
        };
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.scriptText;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.scenarioComboBox = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PerformanceTestingBundle", ExecuteScriptDialog.class).getString("select.scenario"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        EditorTextField editorTextField = this.scriptText;
        jBScrollPane.setViewportView((Component)editorTextField);
        jBLabel.setLabelFor((Component)comboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/ui/ExecuteScriptDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/ui/ExecuteScriptDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateTestScript";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    static class Scenario {
        private final String myName;
        private final String myScript;

        Scenario(String name, String script) {
            this.myName = name;
            this.myScript = script;
        }

        public String toString() {
            return this.myName;
        }

        public String getScript() {
            return this.myScript;
        }
    }

    private static enum PerformanceScriptType {
        TYPING,
        FORMATTING,
        INSPECTION;

    }
}

