/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.jcajce.io.CipherOutputStream;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPAEADDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;
import org.bouncycastle.util.Arrays;

public class JcePGPDataEncryptorBuilder
implements PGPDataEncryptorBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private SecureRandom random;
    private boolean withIntegrityPacket;
    private int encAlgorithm;
    private int aeadAlgorithm = -1;
    private int chunkSize;

    public JcePGPDataEncryptorBuilder(int n) {
        this.encAlgorithm = n;
        if (n == 0) {
            throw new IllegalArgumentException("null cipher specified");
        }
    }

    @Override
    public JcePGPDataEncryptorBuilder setWithIntegrityPacket(boolean bl) {
        this.withIntegrityPacket = bl;
        return this;
    }

    @Override
    public JcePGPDataEncryptorBuilder setWithAEAD(int n, int n2) {
        if (this.encAlgorithm != 7 && this.encAlgorithm != 8 && this.encAlgorithm != 9) {
            throw new IllegalStateException("AEAD algorithms can only be used with AES");
        }
        if (n2 < 6) {
            throw new IllegalArgumentException("minimum chunkSize is 6");
        }
        this.aeadAlgorithm = n;
        this.chunkSize = n2 - 6;
        return this;
    }

    public JcePGPDataEncryptorBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePGPDataEncryptorBuilder setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        return this;
    }

    public JcePGPDataEncryptorBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    public int getAlgorithm() {
        return this.encAlgorithm;
    }

    @Override
    public SecureRandom getSecureRandom() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return this.random;
    }

    @Override
    public PGPDataEncryptor build(byte[] byArray) throws PGPException {
        if (this.aeadAlgorithm > 0) {
            return new MyAeadDataEncryptor(byArray);
        }
        return new MyPGPDataEncryptor(byArray);
    }

    private class MyAeadDataEncryptor
    implements PGPAEADDataEncryptor {
        private final Cipher c;
        private final byte[] keyBytes;
        private final byte[] iv;

        MyAeadDataEncryptor(byte[] byArray) throws PGPException {
            this.keyBytes = byArray;
            this.c = JcePGPDataEncryptorBuilder.this.helper.createAEADCipher(JcePGPDataEncryptorBuilder.this.encAlgorithm, JcePGPDataEncryptorBuilder.this.aeadAlgorithm);
            this.iv = new byte[AEADEncDataPacket.getIVLength((byte)JcePGPDataEncryptorBuilder.this.aeadAlgorithm)];
            JcePGPDataEncryptorBuilder.this.getSecureRandom().nextBytes(this.iv);
        }

        @Override
        public OutputStream getOutputStream(OutputStream outputStream) {
            try {
                return new OperatorHelper.PGPAeadOutputStream(outputStream, this.c, JcaJcePGPUtil.makeSymmetricKey(JcePGPDataEncryptorBuilder.this.encAlgorithm, this.keyBytes), JcePGPDataEncryptorBuilder.this.encAlgorithm, JcePGPDataEncryptorBuilder.this.aeadAlgorithm, JcePGPDataEncryptorBuilder.this.chunkSize, this.iv);
            }
            catch (Exception exception) {
                throw new IllegalStateException("unable to process stream: " + exception.getMessage());
            }
        }

        @Override
        public PGPDigestCalculator getIntegrityCalculator() {
            return null;
        }

        @Override
        public int getBlockSize() {
            return this.c.getBlockSize();
        }

        @Override
        public int getAEADAlgorithm() {
            return JcePGPDataEncryptorBuilder.this.aeadAlgorithm;
        }

        @Override
        public int getChunkSize() {
            return JcePGPDataEncryptorBuilder.this.chunkSize;
        }

        @Override
        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }
    }

    private class MyPGPDataEncryptor
    implements PGPDataEncryptor {
        private final Cipher c;

        MyPGPDataEncryptor(byte[] byArray) throws PGPException {
            this.c = JcePGPDataEncryptorBuilder.this.helper.createStreamCipher(JcePGPDataEncryptorBuilder.this.encAlgorithm, JcePGPDataEncryptorBuilder.this.withIntegrityPacket);
            try {
                if (JcePGPDataEncryptorBuilder.this.withIntegrityPacket) {
                    byte[] byArray2 = new byte[this.c.getBlockSize()];
                    this.c.init(1, (Key)JcaJcePGPUtil.makeSymmetricKey(JcePGPDataEncryptorBuilder.this.encAlgorithm, byArray), new IvParameterSpec(byArray2));
                } else {
                    this.c.init(1, JcaJcePGPUtil.makeSymmetricKey(JcePGPDataEncryptorBuilder.this.encAlgorithm, byArray));
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new PGPException("invalid key: " + invalidKeyException.getMessage(), invalidKeyException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new PGPException("imvalid algorithm parameter: " + invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
            }
        }

        @Override
        public OutputStream getOutputStream(OutputStream outputStream) {
            return new CipherOutputStream(outputStream, this.c);
        }

        @Override
        public PGPDigestCalculator getIntegrityCalculator() {
            if (JcePGPDataEncryptorBuilder.this.withIntegrityPacket) {
                return new SHA1PGPDigestCalculator();
            }
            return null;
        }

        @Override
        public int getBlockSize() {
            return this.c.getBlockSize();
        }
    }
}

