/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.MouseWheelUtils;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.InlayOutput;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.InlayTablePage;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.DataFrame;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.DataFrameCSVAdapter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayOutputTable;", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayOutput;", "parent", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "clearAction", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;)V", "inlayTablePage", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayTablePage;", "getParent", "()Lcom/intellij/openapi/Disposable;", "acceptType", "", "type", "", "addData", "data", "clear", "getCollapsedDescription", "saveAs", "scrollToTop", "intellij.notebooks.visualization"})
public final class InlayOutputTable
extends InlayOutput {
    @NotNull
    private final Disposable parent;
    @NotNull
    private final InlayTablePage inlayTablePage;

    public InlayOutputTable(@NotNull Disposable parent, @NotNull Editor editor, @NotNull Function0<Unit> clearAction2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(clearAction2, (String)"clearAction");
        super(parent, editor, clearAction2);
        this.parent = parent;
        this.inlayTablePage = new InlayTablePage();
        this.getToolbarPane().setDataComponent(this.inlayTablePage);
        MouseWheelUtils.INSTANCE.wrapMouseWheelListeners((Component)this.inlayTablePage.getScrollPane(), this.parent);
    }

    @NotNull
    public final Disposable getParent() {
        return this.parent;
    }

    @Override
    public void clear() {
    }

    @Override
    public void addData(@NotNull String data, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        DataFrame dataFrame = DataFrameCSVAdapter.Companion.fromCsvString(data);
        this.inlayTablePage.setDataFrame(dataFrame);
    }

    @Override
    public void scrollToTop() {
    }

    @Override
    @NotNull
    public String getCollapsedDescription() {
        return "Table output";
    }

    @Override
    public void saveAs() {
    }

    @Override
    public boolean acceptType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)"TABLE");
    }
}

