/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.CeProcessCanceledException;
import com.intellij.openapi.progress.ContextKt;
import com.intellij.openapi.progress.CoroutineSuspenderElement;
import com.intellij.openapi.progress.CoroutineSuspenderElementKey;
import com.intellij.openapi.progress.CurrentJobCancellationException;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.JobCanceledException;
import com.intellij.openapi.progress.PceCancellationException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.ProgressReporterKt;
import com.intellij.openapi.progress.RawProgressReporter;
import com.intellij.openapi.progress.RawProgressReporterIndicator;
import com.intellij.openapi.progress.RunBlockingUnderReadActionMarker;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.util.concurrency.BlockingJob;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a\b\u0010\u0003\u001a\u00020\u0004H\u0002\u001a%\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u001a)\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0007\u00a2\u0006\u0002\u0010\f\u001a%\u0010\r\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u001a!\u0010\u000e\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0007\u00a2\u0006\u0002\u0010\u000f\u001a\u0011\u0010\u0010\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011\u001a)\u0010\u0012\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0002\u00a2\u0006\u0002\u0010\f\u001a%\u0010\u0014\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u001aG\u0010\u0015\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0016\u001a\u00020\u00172'\u0010\u0007\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0018\u00a2\u0006\u0002\b\u001cH\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001d\u001a1\u0010\u001e\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0007\u00a2\u0006\u0002\u0010!\u001a\b\u0010\"\u001a\u00020\u000bH\u0007\u001aG\u0010#\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0016\u001a\u00020\u00172'\u0010\u0007\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0018\u00a2\u0006\u0002\b\u001cH\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001d\u001aG\u0010#\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010$\u001a\u00020%2'\u0010\u0007\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0018\u00a2\u0006\u0002\b\u001cH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&\u001a?\u0010#\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062'\u0010\u0007\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0018\u00a2\u0006\u0002\b\u001cH\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'\u001a?\u0010(\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062'\u0010\u0007\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0018\u00a2\u0006\u0002\b\u001cH\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'\u001a%\u0010)\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u001a\f\u0010*\u001a\u00020\u0017*\u00020\u000bH\u0002\u001a\f\u0010+\u001a\u00020%*\u00020\u000bH\u0007\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "assertBackgroundThreadOrWriteAction", "", "blockingContext", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "currentContext", "Lkotlin/coroutines/CoroutineContext;", "(Lkotlin/coroutines/CoroutineContext;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "blockingContextScope", "blockingContextToIndicator", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "checkCancelled", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "contextToIndicator", "ctx", "coroutineToIndicator", "indicatorRunBlockingCancellable", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "jobToIndicator", "job", "Lkotlinx/coroutines/Job;", "(Lkotlinx/coroutines/Job;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "readActionContext", "runBlockingCancellable", "allowOrphan", "", "(ZLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "runBlockingMaybeCancellable", "runUnderIndicator", "createIndicator", "isRunBlockingUnderReadAction", "intellij.platform.core"})
@ApiStatus.Experimental
public final class CoroutinesKt {
    @NotNull
    private static final Logger LOG;

    @Nullable
    public static final Object checkCancelled(@NotNull Continuation<? super Unit> $completion) {
        CoroutineContext ctx = $completion.getContext();
        JobKt.ensureActive(ctx);
        CoroutineSuspenderElement coroutineSuspenderElement = (CoroutineSuspenderElement)ctx.get(CoroutineSuspenderElementKey.INSTANCE);
        if (coroutineSuspenderElement != null) {
            Object object = coroutineSuspenderElement.checkPaused($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    public static final <T> T runBlockingCancellable(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        return CoroutinesKt.runBlockingCancellable(false, action);
    }

    private static final <T> T runBlockingCancellable(boolean allowOrphan, Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action) {
        CoroutinesKt.assertBackgroundThreadOrWriteAction();
        return ContextKt.prepareThreadContext(new Function1<CoroutineContext, T>(allowOrphan, action){
            final /* synthetic */ boolean $allowOrphan;
            final /* synthetic */ Function2<CoroutineScope, Continuation<? super T>, Object> $action;
            {
                this.$allowOrphan = $allowOrphan;
                this.$action = $action;
                super(1);
            }

            public final T invoke(@NotNull CoroutineContext ctx) {
                T t;
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                if (!this.$allowOrphan && ctx.get(Job.Key) == null && !Cancellation.isInNonCancelableSection()) {
                    CoroutinesKt.access$getLOG$p().error(new IllegalStateException("There is no ProgressIndicator or Job in this thread, the current job is not cancellable."));
                }
                try {
                    t = BuildersKt.runBlocking(ctx.plus(CoroutinesKt.readActionContext()), this.$action);
                }
                catch (CancellationException ce) {
                    throw new CeProcessCanceledException(ce);
                }
                return t;
            }
        });
    }

    @ApiStatus.Internal
    @RequiresBackgroundThread(generateAssertion=false)
    public static final <T> T runBlockingMaybeCancellable(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        return CoroutinesKt.runBlockingCancellable(true, action);
    }

    @Deprecated(message="This method is public for compatibility. It is not supposed to be used outside of the platform. Use `runBlockingCancellable` instead.")
    @ApiStatus.Internal
    public static final <T> T indicatorRunBlockingCancellable(@NotNull ProgressIndicator indicator, @NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter(indicator, "indicator");
        Intrinsics.checkNotNullParameter(action, "action");
        CoroutinesKt.assertBackgroundThreadOrWriteAction();
        return ContextKt.prepareIndicatorThreadContext(indicator, new Function1<CoroutineContext, T>(action){
            final /* synthetic */ Function2<CoroutineScope, Continuation<? super T>, Object> $action;
            {
                this.$action = $action;
                super(1);
            }

            public final T invoke(@NotNull CoroutineContext ctx) {
                T t;
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                CoroutineContext context = ctx.plus(new CoroutineName("indicator run blocking"));
                try {
                    t = BuildersKt.runBlocking(context.plus(CoroutinesKt.readActionContext()), this.$action);
                }
                catch (CancellationException ce) {
                    throw new CeProcessCanceledException(ce);
                }
                return t;
            }
        });
    }

    @Nullable
    public static final <T> Object blockingContext(@NotNull Function0<? extends T> action, @NotNull Continuation<? super T> $completion) {
        CoroutineContext coroutineContext = $completion.getContext();
        return CoroutinesKt.blockingContext(coroutineContext, action);
    }

    @Nullable
    public static final <T> Object blockingContextScope(@NotNull Function0<? extends T> action, @NotNull Continuation<? super T> $completion) {
        return CoroutineScopeKt.coroutineScope(new Function2<CoroutineScope, Continuation<? super T>, Object>(action, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Function0<T> $action;
            {
                this.$action = $action;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                        return CoroutinesKt.blockingContext($this$coroutineScope.getCoroutineContext().plus(new BlockingJob(JobKt.getJob($this$coroutineScope.getCoroutineContext()))), this.$action);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super T>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super T> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static final <T> T blockingContext(@NotNull CoroutineContext currentContext, @NotNull Function0<? extends T> action) {
        T t;
        Intrinsics.checkNotNullParameter(currentContext, "currentContext");
        Intrinsics.checkNotNullParameter(action, "action");
        CoroutineContext context = currentContext.minusKey(ContinuationInterceptor.Key);
        AutoCloseable autoCloseable = ThreadContext.installThreadContext$default(context, false, 2, null);
        Throwable throwable = null;
        try {
            T t2;
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            try {
                t2 = action.invoke();
            }
            catch (JobCanceledException e) {
                if (!JobKt.getJob(context).isCancelled()) {
                    throw new IllegalStateException("JobCanceledException must be thrown by ProgressManager.checkCanceled()", e);
                }
                throw new CurrentJobCancellationException(e);
            }
            catch (ProcessCanceledException pce) {
                throw new PceCancellationException(pce);
            }
            t = t2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return t;
    }

    @ApiStatus.Internal
    @Nullable
    public static final <T> Object coroutineToIndicator(@NotNull Function0<? extends T> action, @NotNull Continuation<? super T> $completion) {
        CoroutineContext ctx = $completion.getContext();
        return CoroutinesKt.contextToIndicator(ctx, action);
    }

    @ApiStatus.Internal
    public static final <T> T blockingContextToIndicator(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        CoroutineContext ctx = ThreadContext.currentThreadContext();
        return CoroutinesKt.contextToIndicator(ctx, action);
    }

    private static final <T> T contextToIndicator(CoroutineContext ctx, Function0<? extends T> action) {
        Job job = JobKt.getJob(ctx);
        JobKt.ensureActive(job);
        ProgressIndicator indicator = CoroutinesKt.createIndicator(ctx);
        return CoroutinesKt.jobToIndicator(job, indicator, action);
    }

    private static final ProgressIndicator createIndicator(CoroutineContext $this$createIndicator) {
        ModalityState modalityState = ModalityKt.contextModality($this$createIndicator);
        if (modalityState == null) {
            ModalityState modalityState2 = ModalityState.nonModal();
            modalityState = modalityState2;
            Intrinsics.checkNotNullExpressionValue(modalityState2, "nonModal()");
        }
        ModalityState contextModality = modalityState;
        if (ProgressReporterKt.getProgressReporter($this$createIndicator) != null) {
            LOG.error(new IllegalStateException("Current context has `ProgressReporter`. Please switch to `RawProgressReporter` before switching to indicator. See 'Progress reporting' in `coroutineToIndicator` and/or `blockingContextToIndicator`.\nCurrent context: " + $this$createIndicator));
            return new EmptyProgressIndicator(contextModality);
        }
        RawProgressReporter reporter = ProgressReporterKt.getRawProgressReporter($this$createIndicator);
        return reporter == null ? (ProgressIndicator)new EmptyProgressIndicator(contextModality) : (ProgressIndicator)new RawProgressReporterIndicator(reporter, contextModality);
    }

    @ApiStatus.Internal
    public static final <T> T jobToIndicator(@NotNull Job job, @NotNull ProgressIndicator indicator, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(job, "job");
        Intrinsics.checkNotNullParameter(indicator, "indicator");
        Intrinsics.checkNotNullParameter(action, "action");
        try {
            return (T)ProgressManager.getInstance().runProcess(() -> CoroutinesKt.jobToIndicator$lambda$1(job, indicator, action), indicator);
        }
        catch (ProcessCanceledException e) {
            if (!indicator.isCanceled()) {
                throw e;
            }
            if (!job.isCancelled()) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            throw job.getCancellationException();
        }
    }

    private static final void assertBackgroundThreadOrWriteAction() {
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread() || application.isWriteAccessAllowed() || application.isUnitTestMode()) {
            return;
        }
        LOG.error(new IllegalStateException("This method is forbidden on EDT because it does not pump the event queue. Switch to a BGT, or use com.intellij.openapi.progress.TasksKt.runWithModalProgressBlocking. "));
    }

    @IntellijInternalApi
    @ApiStatus.Internal
    @NotNull
    public static final CoroutineContext readActionContext() {
        return ApplicationManager.getApplication().isReadAccessAllowed() ? (CoroutineContext)RunBlockingUnderReadActionMarker.INSTANCE : (CoroutineContext)EmptyCoroutineContext.INSTANCE;
    }

    @IntellijInternalApi
    @ApiStatus.Internal
    public static final boolean isRunBlockingUnderReadAction(@NotNull CoroutineContext $this$isRunBlockingUnderReadAction) {
        Intrinsics.checkNotNullParameter($this$isRunBlockingUnderReadAction, "<this>");
        return $this$isRunBlockingUnderReadAction.get(RunBlockingUnderReadActionMarker.INSTANCE) != null;
    }

    @Deprecated(message="Method was renamed. Don't use", replaceWith=@ReplaceWith(expression="indicatorRunBlockingCancellable(indicator, action)", imports={}), level=DeprecationLevel.ERROR)
    public static final <T> T runBlockingCancellable(@NotNull ProgressIndicator indicator, @NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter(indicator, "indicator");
        Intrinsics.checkNotNullParameter(action, "action");
        return CoroutinesKt.indicatorRunBlockingCancellable(indicator, action);
    }

    @Deprecated(message="Method was renamed", replaceWith=@ReplaceWith(expression="coroutineToIndicator(action)", imports={}), level=DeprecationLevel.ERROR)
    @Nullable
    public static final <T> Object runUnderIndicator(@NotNull Function0<? extends T> action, @NotNull Continuation<? super T> $completion) {
        return CoroutinesKt.coroutineToIndicator(action, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object jobToIndicator$lambda$1(Job $job, ProgressIndicator $indicator, Function0 $action) {
        Object r;
        Intrinsics.checkNotNullParameter($job, "$job");
        Intrinsics.checkNotNullParameter($indicator, "$indicator");
        Intrinsics.checkNotNullParameter($action, "$action");
        DisposableHandle completionHandle2 = Job.DefaultImpls.invokeOnCompletion$default($job, true, false, new Function1<Throwable, Unit>($indicator){
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.$indicator = $indicator;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                if (it instanceof CancellationException) {
                    this.$indicator.cancel();
                }
            }
        }, 2, null);
        try {
            $indicator.checkCanceled();
            r = $action.invoke();
        }
        finally {
            completionHandle2.dispose();
        }
        return r;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance("#com.intellij.openapi.progress");
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(\"#com.intellij.openapi.progress\")");
        LOG = logger;
    }
}

