/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.client.common.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.client.common.SingleRenderingSurfaceProcessor;
import org.jetbrains.projector.client.common.canvas.Canvas;
import org.jetbrains.projector.client.common.canvas.CanvasFactory;
import org.jetbrains.projector.client.common.canvas.buffering.UnbufferedRenderingSurface;
import org.jetbrains.projector.client.common.misc.ParamsProvider;
import org.jetbrains.projector.client.common.misc.TimeStamp;
import org.jetbrains.projector.common.misc.Do;
import org.jetbrains.projector.common.protocol.data.ImageData;
import org.jetbrains.projector.common.protocol.data.ImageId;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawCommandsEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientRequestImageDataEvent;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010&\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002./B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0015\u001a\u00020\u0016J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J.\u0010\u001a\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u001b\"\u0004\b\u0001\u0010\u001c2\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u0002H\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001c0\b0\u0006H\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020\u0007J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J6\u0010$\u001a\u00020%\"\u0004\b\u0000\u0010\u001b\"\u0004\b\u0001\u0010\u001c2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u0002H\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001c0\b0'2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,H\u0002J\u0016\u0010-\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/projector/client/common/misc/ImageCacher;", "", "canvasFactory", "Lorg/jetbrains/projector/client/common/canvas/CanvasFactory;", "(Lorg/jetbrains/projector/client/common/canvas/CanvasFactory;)V", "cache", "", "Lorg/jetbrains/projector/common/protocol/data/ImageId;", "Lorg/jetbrains/projector/client/common/misc/ImageCacher$LivingEntity;", "Lorg/jetbrains/projector/client/common/canvas/Canvas$ImageSource;", "currentSize", "", "imagesToRequest", "", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "offscreenImages", "", "Lorg/jetbrains/projector/client/common/misc/ImageCacher$OffscreenImage;", "requestedImages", "", "collectGarbage", "", "extractImagesToRequest", "", "Lorg/jetbrains/projector/common/protocol/toServer/ClientRequestImageDataEvent;", "filterDeadEntitiesOutOfMutableMap", "KeyType", "EntityType", "map", "getImageData", "imageId", "getOffscreenProcessor", "Lorg/jetbrains/projector/client/common/SingleRenderingSurfaceProcessor;", "offscreenTarget", "Lorg/jetbrains/projector/common/protocol/toClient/ServerDrawCommandsEvent$Target$Offscreen;", "isAlive", "", "entry", "", "timestamp", "", "putImageAsync", "imageData", "Lorg/jetbrains/projector/common/protocol/data/ImageData;", "putImageData", "LivingEntity", "OffscreenImage", "projector-client-common"})
public final class ImageCacher {
    @NotNull
    private final CanvasFactory canvasFactory;
    private int currentSize;
    @NotNull
    private final Map<ImageId, LivingEntity<Canvas.ImageSource>> cache;
    @NotNull
    private final Map<ImageId, LivingEntity> requestedImages;
    @NotNull
    private final Set<ImageId> imagesToRequest;
    @NotNull
    private final Map<Long, OffscreenImage> offscreenImages;
    @NotNull
    private final Logger logger;

    public ImageCacher(@NotNull CanvasFactory canvasFactory) {
        Intrinsics.checkNotNullParameter((Object)canvasFactory, (String)"canvasFactory");
        this.canvasFactory = canvasFactory;
        this.cache = new LinkedHashMap();
        this.requestedImages = new LinkedHashMap();
        this.imagesToRequest = new LinkedHashSet();
        this.offscreenImages = new LinkedHashMap();
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(ImageCacher.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        this.logger = LoggerKt.Logger((String)string);
    }

    public final void collectGarbage() {
        if (this.currentSize > ParamsProvider.INSTANCE.getIMAGE_CACHE_SIZE_CHARS()) {
            this.filterDeadEntitiesOutOfMutableMap(this.cache);
        }
        this.filterDeadEntitiesOutOfMutableMap(this.requestedImages);
    }

    public final void putImageData(@NotNull ImageId imageId, @NotNull ImageData imageData) {
        Intrinsics.checkNotNullParameter((Object)imageId, (String)"imageId");
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        Map<ImageId, LivingEntity> map = this.requestedImages;
        LivingEntity<Object> livingEntity = new LivingEntity<Object>(TimeStamp.INSTANCE.getCurrent(), 0, null);
        map.put(imageId, livingEntity);
        this.putImageAsync(imageId, imageData);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Canvas.ImageSource getImageData(@NotNull ImageId imageId) {
        Canvas.ImageSource imageSource;
        Intrinsics.checkNotNullParameter((Object)imageId, (String)"imageId");
        ImageId imageId2 = imageId;
        if (imageId2 instanceof ImageId.PVolatileImageId) {
            OffscreenImage offscreenImage = this.offscreenImages.get(((ImageId.PVolatileImageId)imageId).getId());
            imageSource = offscreenImage == null ? null : offscreenImage.getOffscreenCanvas();
        } else if (imageId2 instanceof ImageId.BufferedImageId) {
            Canvas.ImageSource imageData;
            LivingEntity<Canvas.ImageSource> livingEntity;
            Canvas.ImageSource imageSource2;
            LivingEntity<Canvas.ImageSource> livingEntity2 = this.cache.get(imageId);
            if (livingEntity2 == null) {
                imageSource2 = null;
            } else {
                LivingEntity<Canvas.ImageSource> livingEntity3;
                LivingEntity<Canvas.ImageSource> $this$getImageData_u24lambda_u2d0 = livingEntity3 = livingEntity2;
                boolean bl = false;
                $this$getImageData_u24lambda_u2d0.setLastUsageTimestamp(TimeStamp.INSTANCE.getCurrent());
                livingEntity = livingEntity3;
                imageSource2 = imageData = livingEntity.getData();
            }
            if (imageData == null) {
                if (!this.requestedImages.containsKey(imageId)) {
                    this.imagesToRequest.add(imageId);
                    Map<ImageId, LivingEntity> map = this.requestedImages;
                    livingEntity = new LivingEntity<Object>(TimeStamp.INSTANCE.getCurrent(), 0, null);
                    map.put(imageId, livingEntity);
                }
                imageSource = null;
            } else {
                void var3_7;
                imageSource = var3_7;
            }
        } else if (imageId2 instanceof ImageId.Unknown) {
            Logger.DefaultImpls.info$default((Logger)this.logger, null, (Function0)((Function0)new Function0<String>(imageId){
                final /* synthetic */ ImageId $imageId;
                {
                    this.$imageId = $imageId;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Can't draw unknown image: " + this.$imageId;
                }
            }), (int)1, null);
            imageSource = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return imageSource;
    }

    @NotNull
    public final SingleRenderingSurfaceProcessor getOffscreenProcessor(@NotNull ServerDrawCommandsEvent.Target.Offscreen offscreenTarget) {
        Intrinsics.checkNotNullParameter((Object)offscreenTarget, (String)"offscreenTarget");
        OffscreenImage image = this.offscreenImages.get(offscreenTarget.getPVolatileImageId());
        if (image == null || image.getWidth() != offscreenTarget.getWidth() || image.getHeight() != offscreenTarget.getHeight()) {
            Canvas canvas;
            Canvas $this$getOffscreenProcessor_u24lambda_u2d1 = canvas = this.canvasFactory.create();
            boolean bl = false;
            $this$getOffscreenProcessor_u24lambda_u2d1.setWidth(offscreenTarget.getWidth());
            $this$getOffscreenProcessor_u24lambda_u2d1.setHeight(offscreenTarget.getHeight());
            Canvas offScreenCanvas = canvas;
            UnbufferedRenderingSurface offScreenRenderingSurface = new UnbufferedRenderingSurface(offScreenCanvas);
            SingleRenderingSurfaceProcessor offScreenCommandProcessor = new SingleRenderingSurfaceProcessor(offScreenRenderingSurface, this);
            this.offscreenImages.put(offscreenTarget.getPVolatileImageId(), new OffscreenImage(offscreenTarget.getWidth(), offscreenTarget.getHeight(), offScreenCommandProcessor, offScreenCanvas.getImageSource()));
            return offScreenCommandProcessor;
        }
        return image.getSingleRenderingSurfaceProcessor();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ClientRequestImageDataEvent> extractImagesToRequest() {
        List list;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.imagesToRequest;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ImageId imageId = (ImageId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ClientRequestImageDataEvent((ImageId)p0));
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        this.imagesToRequest.clear();
        return list;
    }

    private final void putImageAsync(ImageId imageId, ImageData imageData) {
        int n;
        ImageData imageData2 = imageData;
        if (imageData2 instanceof ImageData.PngBase64) {
            n = ((ImageData.PngBase64)imageData).getPngBase64().length();
        } else if (imageData2 instanceof ImageData.Empty) {
            n = 0;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int size = n;
        imageData2 = Do.INSTANCE;
        ImageData imageData3 = imageData;
        if (imageData3 instanceof ImageData.PngBase64) {
            this.canvasFactory.createImageSource(((ImageData.PngBase64)imageData).getPngBase64(), (Function1<? super Canvas.ImageSource, Unit>)((Function1)new Function1<Canvas.ImageSource, Unit>(this, imageId, size){
                final /* synthetic */ ImageCacher this$0;
                final /* synthetic */ ImageId $imageId;
                final /* synthetic */ int $size;
                {
                    this.this$0 = $receiver;
                    this.$imageId = $imageId;
                    this.$size = $size;
                    super(1, Intrinsics.Kotlin.class, "onLoad", "putImageAsync$onLoad(Lorg/jetbrains/projector/client/common/misc/ImageCacher;Lorg/jetbrains/projector/common/protocol/data/ImageId;ILorg/jetbrains/projector/client/common/canvas/Canvas$ImageSource;)V", 0);
                }

                public final void invoke(@NotNull Canvas.ImageSource p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ImageCacher.access$putImageAsync$onLoad(this.this$0, this.$imageId, this.$size, p0);
                }
            }));
        } else if (imageData3 instanceof ImageData.Empty) {
            Logger.DefaultImpls.info$default((Logger)this.logger, null, (Function0)((Function0)new Function0<String>(imageId){
                final /* synthetic */ ImageId $imageId;
                {
                    this.$imageId = $imageId;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Empty image received for " + this.$imageId;
                }
            }), (int)1, null);
            this.canvasFactory.createEmptyImageSource((Function1<? super Canvas.ImageSource, Unit>)((Function1)new Function1<Canvas.ImageSource, Unit>(this, imageId, size){
                final /* synthetic */ ImageCacher this$0;
                final /* synthetic */ ImageId $imageId;
                final /* synthetic */ int $size;
                {
                    this.this$0 = $receiver;
                    this.$imageId = $imageId;
                    this.$size = $size;
                    super(1, Intrinsics.Kotlin.class, "onLoad", "putImageAsync$onLoad(Lorg/jetbrains/projector/client/common/misc/ImageCacher;Lorg/jetbrains/projector/common/protocol/data/ImageId;ILorg/jetbrains/projector/client/common/canvas/Canvas$ImageSource;)V", 0);
                }

                public final void invoke(@NotNull Canvas.ImageSource p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ImageCacher.access$putImageAsync$onLoad(this.this$0, this.$imageId, this.$size, p0);
                }
            }));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        imageData3 = Unit.INSTANCE;
        boolean $i$f$exhaustive = false;
    }

    private final <KeyType, EntityType> boolean isAlive(Map.Entry<? extends KeyType, ? extends LivingEntity<? extends EntityType>> entry, double timestamp) {
        return entry.getValue().getLastUsageTimestamp() + ParamsProvider.INSTANCE.getIMAGE_TTL() > timestamp;
    }

    private final <KeyType, EntityType> void filterDeadEntitiesOutOfMutableMap(Map<KeyType, LivingEntity<EntityType>> map) {
        double timestamp = TimeStamp.INSTANCE.getCurrent();
        Iterator<Map.Entry<KeyType, LivingEntity<EntityType>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<KeyType, LivingEntity<EntityType>> next = iterator.next();
            if (this.isAlive(next, timestamp)) continue;
            iterator.remove();
            this.currentSize -= next.getValue().getSize();
        }
    }

    private static final void putImageAsync$onLoad(ImageCacher this$0, ImageId $imageId, int size, Canvas.ImageSource image) {
        Map<ImageId, LivingEntity<Canvas.ImageSource>> map = this$0.cache;
        LivingEntity<Canvas.ImageSource> livingEntity = new LivingEntity<Canvas.ImageSource>(TimeStamp.INSTANCE.getCurrent(), size, image);
        map.put($imageId, livingEntity);
        this$0.currentSize += size;
    }

    public static final /* synthetic */ void access$putImageAsync$onLoad(ImageCacher this$0, ImageId $imageId, int size, Canvas.ImageSource image) {
        ImageCacher.putImageAsync$onLoad(this$0, $imageId, size, image);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\u000e\u0010\u0014\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ2\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/projector/client/common/misc/ImageCacher$LivingEntity;", "EntityType", "", "lastUsageTimestamp", "", "size", "", "data", "(DILjava/lang/Object;)V", "getData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getLastUsageTimestamp", "()D", "setLastUsageTimestamp", "(D)V", "getSize", "()I", "component1", "component2", "component3", "copy", "(DILjava/lang/Object;)Lorg/jetbrains/projector/client/common/misc/ImageCacher$LivingEntity;", "equals", "", "other", "hashCode", "toString", "", "projector-client-common"})
    private static final class LivingEntity<EntityType> {
        private double lastUsageTimestamp;
        private final int size;
        private final EntityType data;

        public LivingEntity(double lastUsageTimestamp, int size, EntityType data) {
            this.lastUsageTimestamp = lastUsageTimestamp;
            this.size = size;
            this.data = data;
        }

        public final double getLastUsageTimestamp() {
            return this.lastUsageTimestamp;
        }

        public final void setLastUsageTimestamp(double d) {
            this.lastUsageTimestamp = d;
        }

        public final int getSize() {
            return this.size;
        }

        public final EntityType getData() {
            return this.data;
        }

        public final double component1() {
            return this.lastUsageTimestamp;
        }

        public final int component2() {
            return this.size;
        }

        public final EntityType component3() {
            return this.data;
        }

        @NotNull
        public final LivingEntity<EntityType> copy(double lastUsageTimestamp, int size, EntityType data) {
            return new LivingEntity<EntityType>(lastUsageTimestamp, size, data);
        }

        public static /* synthetic */ LivingEntity copy$default(LivingEntity livingEntity, double d, int n, Object object, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                d = livingEntity.lastUsageTimestamp;
            }
            if ((n2 & 2) != 0) {
                n = livingEntity.size;
            }
            if ((n2 & 4) != 0) {
                object = livingEntity.data;
            }
            return livingEntity.copy(d, n, object);
        }

        @NotNull
        public String toString() {
            return "LivingEntity(lastUsageTimestamp=" + this.lastUsageTimestamp + ", size=" + this.size + ", data=" + this.data + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.lastUsageTimestamp);
            result = result * 31 + Integer.hashCode(this.size);
            result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LivingEntity)) {
                return false;
            }
            LivingEntity livingEntity = (LivingEntity)other;
            if (!Intrinsics.areEqual((Object)this.lastUsageTimestamp, (Object)livingEntity.lastUsageTimestamp)) {
                return false;
            }
            if (this.size != livingEntity.size) {
                return false;
            }
            return Intrinsics.areEqual(this.data, livingEntity.data);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/projector/client/common/misc/ImageCacher$OffscreenImage;", "", "width", "", "height", "singleRenderingSurfaceProcessor", "Lorg/jetbrains/projector/client/common/SingleRenderingSurfaceProcessor;", "offscreenCanvas", "Lorg/jetbrains/projector/client/common/canvas/Canvas$ImageSource;", "(IILorg/jetbrains/projector/client/common/SingleRenderingSurfaceProcessor;Lorg/jetbrains/projector/client/common/canvas/Canvas$ImageSource;)V", "getHeight", "()I", "getOffscreenCanvas", "()Lorg/jetbrains/projector/client/common/canvas/Canvas$ImageSource;", "getSingleRenderingSurfaceProcessor", "()Lorg/jetbrains/projector/client/common/SingleRenderingSurfaceProcessor;", "getWidth", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "projector-client-common"})
    private static final class OffscreenImage {
        private final int width;
        private final int height;
        @NotNull
        private final SingleRenderingSurfaceProcessor singleRenderingSurfaceProcessor;
        @NotNull
        private final Canvas.ImageSource offscreenCanvas;

        public OffscreenImage(int width, int height, @NotNull SingleRenderingSurfaceProcessor singleRenderingSurfaceProcessor, @NotNull Canvas.ImageSource offscreenCanvas) {
            Intrinsics.checkNotNullParameter((Object)singleRenderingSurfaceProcessor, (String)"singleRenderingSurfaceProcessor");
            Intrinsics.checkNotNullParameter((Object)offscreenCanvas, (String)"offscreenCanvas");
            this.width = width;
            this.height = height;
            this.singleRenderingSurfaceProcessor = singleRenderingSurfaceProcessor;
            this.offscreenCanvas = offscreenCanvas;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @NotNull
        public final SingleRenderingSurfaceProcessor getSingleRenderingSurfaceProcessor() {
            return this.singleRenderingSurfaceProcessor;
        }

        @NotNull
        public final Canvas.ImageSource getOffscreenCanvas() {
            return this.offscreenCanvas;
        }

        public final int component1() {
            return this.width;
        }

        public final int component2() {
            return this.height;
        }

        @NotNull
        public final SingleRenderingSurfaceProcessor component3() {
            return this.singleRenderingSurfaceProcessor;
        }

        @NotNull
        public final Canvas.ImageSource component4() {
            return this.offscreenCanvas;
        }

        @NotNull
        public final OffscreenImage copy(int width, int height, @NotNull SingleRenderingSurfaceProcessor singleRenderingSurfaceProcessor, @NotNull Canvas.ImageSource offscreenCanvas) {
            Intrinsics.checkNotNullParameter((Object)singleRenderingSurfaceProcessor, (String)"singleRenderingSurfaceProcessor");
            Intrinsics.checkNotNullParameter((Object)offscreenCanvas, (String)"offscreenCanvas");
            return new OffscreenImage(width, height, singleRenderingSurfaceProcessor, offscreenCanvas);
        }

        public static /* synthetic */ OffscreenImage copy$default(OffscreenImage offscreenImage, int n, int n2, SingleRenderingSurfaceProcessor singleRenderingSurfaceProcessor, Canvas.ImageSource imageSource, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = offscreenImage.width;
            }
            if ((n3 & 2) != 0) {
                n2 = offscreenImage.height;
            }
            if ((n3 & 4) != 0) {
                singleRenderingSurfaceProcessor = offscreenImage.singleRenderingSurfaceProcessor;
            }
            if ((n3 & 8) != 0) {
                imageSource = offscreenImage.offscreenCanvas;
            }
            return offscreenImage.copy(n, n2, singleRenderingSurfaceProcessor, imageSource);
        }

        @NotNull
        public String toString() {
            return "OffscreenImage(width=" + this.width + ", height=" + this.height + ", singleRenderingSurfaceProcessor=" + this.singleRenderingSurfaceProcessor + ", offscreenCanvas=" + this.offscreenCanvas + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.width);
            result = result * 31 + Integer.hashCode(this.height);
            result = result * 31 + this.singleRenderingSurfaceProcessor.hashCode();
            result = result * 31 + this.offscreenCanvas.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OffscreenImage)) {
                return false;
            }
            OffscreenImage offscreenImage = (OffscreenImage)other;
            if (this.width != offscreenImage.width) {
                return false;
            }
            if (this.height != offscreenImage.height) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.singleRenderingSurfaceProcessor, (Object)offscreenImage.singleRenderingSurfaceProcessor)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.offscreenCanvas, (Object)offscreenImage.offscreenCanvas);
        }
    }
}

