/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateAction;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.branch.GitBranchPair;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.UpdateMethod;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdateEnvironment;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J(\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00050\b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgit4idea/update/GitUpdateExecutionProcess;", "", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "updateConfig", "", "Lgit4idea/branch/GitBranchPair;", "updateMethod", "Lgit4idea/config/UpdateMethod;", "shouldSetAsUpstream", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Ljava/util/Map;Lgit4idea/config/UpdateMethod;Z)V", "execute", "", "getVcsRoots", "Lcom/intellij/openapi/vcs/AbstractVcs;", "Lcom/intellij/openapi/vcs/FilePath;", "UpdateExecution", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitUpdateExecutionProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitUpdateExecutionProcess.kt\ngit4idea/update/GitUpdateExecutionProcess\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n29#2,3:85\n26#3:88\n1179#4,2:89\n1253#4,4:91\n*S KotlinDebug\n*F\n+ 1 GitUpdateExecutionProcess.kt\ngit4idea/update/GitUpdateExecutionProcess\n*L\n34#1:85,3\n41#1:88\n48#1:89,2\n48#1:91,4\n*E\n"})
public final class GitUpdateExecutionProcess {
    @NotNull
    private final Project project;
    @NotNull
    private final Collection<GitRepository> repositories;
    @NotNull
    private final Map<GitRepository, GitBranchPair> updateConfig;
    @NotNull
    private final UpdateMethod updateMethod;
    private final boolean shouldSetAsUpstream;

    public GitUpdateExecutionProcess(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories2, @NotNull Map<GitRepository, GitBranchPair> updateConfig, @NotNull UpdateMethod updateMethod, boolean shouldSetAsUpstream) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter(updateConfig, (String)"updateConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)updateMethod), (String)"updateMethod");
        this.project = project;
        this.repositories = repositories2;
        this.updateConfig = updateConfig;
        this.updateMethod = updateMethod;
        this.shouldSetAsUpstream = shouldSetAsUpstream;
    }

    public /* synthetic */ GitUpdateExecutionProcess(Project project, Collection collection, Map map2, UpdateMethod updateMethod, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(project, collection, map2, updateMethod, bl);
    }

    public final void execute() {
        if (this.updateConfig.isEmpty()) {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<VcsNotifier> serviceClass$iv = VcsNotifier.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            ((VcsNotifier)object).notifyMinorWarning("git.update.nothing.to.update", "", GitBundle.message("update.process.nothing.to.update", new Object[0]));
            return;
        }
        Map<AbstractVcs, Collection<FilePath>> vcsToRoots = this.getVcsRoots(this.repositories);
        boolean $i$f$emptyArray = false;
        FilePath[] roots = (FilePath[])UtilKt.toArray((Collection)CollectionsKt.flatten((Iterable)vcsToRoots.values()), (Object[])new FilePath[0]);
        ProgressManager.getInstance().run((Task)new UpdateExecution(this.project, vcsToRoots, roots, this.updateConfig, this.updateMethod, this.shouldSetAsUpstream));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<AbstractVcs, Collection<FilePath>> getVcsRoots(Collection<? extends GitRepository> repositories2) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = repositories2;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            GitRepository repo = (GitRepository)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)((Object)repo.getVcs()), (Object)CollectionsKt.listOf((Object)VcsUtil.getFilePath((VirtualFile)repo.getRoot())));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J:\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dH\u0014J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\rH\u0002R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lgit4idea/update/GitUpdateExecutionProcess$UpdateExecution;", "Lcom/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Updater;", "project", "Lcom/intellij/openapi/project/Project;", "vcsToRoots", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "", "Lcom/intellij/openapi/vcs/FilePath;", "roots", "", "updateConfig", "Lgit4idea/repo/GitRepository;", "Lgit4idea/branch/GitBranchPair;", "updateMethod", "Lgit4idea/config/UpdateMethod;", "shouldSetAsUpstream", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;[Lcom/intellij/openapi/vcs/FilePath;Ljava/util/Map;Lgit4idea/config/UpdateMethod;Z)V", "[Lcom/intellij/openapi/vcs/FilePath;", "performUpdate", "Lcom/intellij/openapi/vcs/update/UpdateSession;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "updateEnvironment", "Lcom/intellij/openapi/vcs/update/UpdateEnvironment;", "files", "", "refContext", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/openapi/vcs/update/SequentialUpdatesContext;", "setBranchUpstream", "", "repository", "branchConfig", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitUpdateExecutionProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitUpdateExecutionProcess.kt\ngit4idea/update/GitUpdateExecutionProcess$UpdateExecution\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,84:1\n215#2,2:85\n*S KotlinDebug\n*F\n+ 1 GitUpdateExecutionProcess.kt\ngit4idea/update/GitUpdateExecutionProcess$UpdateExecution\n*L\n64#1:85,2\n*E\n"})
    public static final class UpdateExecution
    extends AbstractCommonUpdateAction.Updater {
        @NotNull
        private final FilePath[] roots;
        @NotNull
        private final Map<GitRepository, GitBranchPair> updateConfig;
        @NotNull
        private final UpdateMethod updateMethod;
        private final boolean shouldSetAsUpstream;

        public UpdateExecution(@NotNull Project project, @NotNull Map<AbstractVcs, ? extends Collection<? extends FilePath>> vcsToRoots, @NotNull FilePath[] roots, @NotNull Map<GitRepository, GitBranchPair> updateConfig, @NotNull UpdateMethod updateMethod, boolean shouldSetAsUpstream) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(vcsToRoots, (String)"vcsToRoots");
            Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
            Intrinsics.checkNotNullParameter(updateConfig, (String)"updateConfig");
            Intrinsics.checkNotNullParameter((Object)((Object)updateMethod), (String)"updateMethod");
            super(project, roots, vcsToRoots, ActionInfo.UPDATE, GitBundle.message("progress.title.update", new Object[0]));
            this.roots = roots;
            this.updateConfig = updateConfig;
            this.updateMethod = updateMethod;
            this.shouldSetAsUpstream = shouldSetAsUpstream;
        }

        public /* synthetic */ UpdateExecution(Project project, Map map2, FilePath[] filePathArray, Map map3, UpdateMethod updateMethod, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                bl = false;
            }
            this(project, map2, filePathArray, map3, updateMethod, bl);
        }

        @NotNull
        protected UpdateSession performUpdate(@NotNull ProgressIndicator progressIndicator, @Nullable UpdateEnvironment updateEnvironment, @Nullable Collection<FilePath> files, @Nullable Ref<SequentialUpdatesContext> refContext) {
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            if (this.shouldSetAsUpstream) {
                Map<GitRepository, GitBranchPair> $this$forEach$iv = this.updateConfig;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<GitRepository, GitBranchPair>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<GitRepository, GitBranchPair> element$iv;
                    Map.Entry<GitRepository, GitBranchPair> entry = element$iv = iterator.next();
                    boolean bl = false;
                    GitRepository repository = entry.getKey();
                    GitBranchPair branchPair = entry.getValue();
                    this.setBranchUpstream(repository, branchPair);
                }
            }
            UpdateSession updateSession = GitUpdateEnvironment.performUpdate(this.getProject(), this.roots, this.myUpdatedFiles, progressIndicator, this.updateMethod, this.updateConfig);
            Intrinsics.checkNotNullExpressionValue((Object)updateSession, (String)"performUpdate(project, r\u2026dateMethod, updateConfig)");
            return updateSession;
        }

        private final void setBranchUpstream(GitRepository repository, GitBranchPair branchConfig) {
            GitLineHandler handler = new GitLineHandler(this.getProject(), repository.getRoot(), GitCommand.BRANCH);
            GitLocalBranch local = branchConfig.component1();
            GitBranch remote = branchConfig.component2();
            String[] stringArray = new String[]{"--set-upstream-to", remote.getName(), local.getName()};
            handler.addParameters(stringArray);
            GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
            Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"getInstance().runCommand(handler)");
            GitCommandResult result2 = gitCommandResult;
            if (!result2.success()) {
                VcsNotifier.getInstance((Project)this.getProject()).notifyError("git.branch.set.upstream.failed", GitBundle.message("update.process.error.notification.title", new Object[0]), result2.getErrorOutputAsHtmlString(), true);
            }
        }
    }
}

