/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.auth;

import circlet.workspaces.Workspace;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.space.components.SpaceWorkspaceComponent;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.settings.SpaceServerSettings;
import com.intellij.space.settings.SpaceSettings;
import com.intellij.space.settings.SpaceSettingsPanel;
import com.intellij.space.utils.UtilitiesKt;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeSource;
import libraries.coroutines.extra.LifetimeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0012\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0006\u0010\b\u001a\u00020\u0004J\f\u0010\t\u001a\u00020\u0004*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/space/auth/SpaceAuthNotifier;", "", "()V", "authFailed", "", "loginToSavedServer", "project", "Lcom/intellij/openapi/project/Project;", "permissionsChanged", "expireOnLogin", "Lcom/intellij/notification/Notification;", "intellij.space"})
@SourceDebugExtension(value={"SMAP\nSpaceAuthNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceAuthNotifier.kt\ncom/intellij/space/auth/SpaceAuthNotifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class SpaceAuthNotifier {
    @NotNull
    public static final SpaceAuthNotifier INSTANCE = new SpaceAuthNotifier();

    private SpaceAuthNotifier() {
    }

    public final void authFailed() {
        Supplier<String> supplier = SpaceBundle.messagePointer("auth.notification.failed.login.again.action", new Object[0]);
        DumbAwareAction tryAgainAction2 = new DumbAwareAction(supplier){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SpaceAuthNotifier.access$loginToSavedServer(SpaceAuthNotifier.INSTANCE, e.getProject());
            }
        };
        String string2 = SpaceBundle.message("auth.notification.failed.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"auth.notification.failed.message\")");
        Notification notification = UtilitiesKt.notify(string2, false, CollectionsKt.listOf((Object)tryAgainAction2));
        this.expireOnLogin(notification);
    }

    public final void permissionsChanged() {
        Supplier<String> supplier = SpaceBundle.messagePointer("auth.notification.permissions.updated.check.permissions.action", new Object[0]);
        DumbAwareAction checkPermissionsAction2 = new DumbAwareAction(supplier){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SpaceAuthNotifier.access$loginToSavedServer(SpaceAuthNotifier.INSTANCE, e.getProject());
            }
        };
        Notification notification = new Notification("space.other", SpaceBundle.message("auth.notification.permissions.updated.title", new Object[0]), SpaceBundle.message("auth.notification.permissions.updated.message", new Object[0]), NotificationType.WARNING).addAction((AnAction)checkPermissionsAction2);
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"Notification(\n      Spac\u2026n(checkPermissionsAction)");
        Notification notification2 = notification;
        this.expireOnLogin(notification2);
        notification2.notify(null);
    }

    private final void expireOnLogin(Notification $this$expireOnLogin) {
        LifetimeSource lifetime = LifetimeUtilsKt.nested(SpaceWorkspaceComponent.Companion.getInstance().getLifetime());
        SpaceWorkspaceComponent.Companion.getInstance().getWorkspace().forEach(lifetime, (Function1<Workspace, Unit>)((Function1)new Function1<Workspace, Unit>($this$expireOnLogin, lifetime){
            final /* synthetic */ Notification $this_expireOnLogin;
            final /* synthetic */ LifetimeSource $lifetime;
            {
                this.$this_expireOnLogin = $receiver;
                this.$lifetime = $lifetime;
                super(1);
            }

            public final void invoke(@Nullable Workspace it) {
                if (it != null) {
                    this.$this_expireOnLogin.expire();
                    this.$lifetime.terminate();
                }
            }
        }));
    }

    private final void loginToSavedServer(Project project2) {
        SpaceWorkspaceComponent.FocusOnLoginPolicy focusOnLoginPolicy;
        SpaceServerSettings serverSettings2 = SpaceSettings.Companion.getInstance().getServerSettings();
        String savedServer = serverSettings2.getServer();
        if (StringsKt.isBlank((CharSequence)savedServer)) {
            SpaceSettingsPanel.Companion.openSettings(project2);
            return;
        }
        Lifetime spaceLifetime2 = SpaceWorkspaceComponent.Companion.getInstance().getLifetime();
        Project project3 = project2;
        if (project3 != null) {
            Project it = project3;
            boolean bl = false;
            focusOnLoginPolicy = new SpaceWorkspaceComponent.FocusOnLoginPolicy.FocusProjectFrame(it);
        } else {
            focusOnLoginPolicy = SpaceWorkspaceComponent.FocusOnLoginPolicy.DontFocus.INSTANCE;
        }
        SpaceWorkspaceComponent.FocusOnLoginPolicy focusOnLoginPolicy2 = focusOnLoginPolicy;
        SpaceWorkspaceComponent.Companion.getInstance().signInManually(savedServer, spaceLifetime2, focusOnLoginPolicy2);
    }

    public static final /* synthetic */ void access$loginToSavedServer(SpaceAuthNotifier $this, Project project2) {
        $this.loginToSavedServer(project2);
    }
}

