/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.changes;

import circlet.client.api.CodeViewServiceKt;
import circlet.client.api.GitCommitChange;
import circlet.client.api.GitCommitChangeType;
import circlet.client.api.GitFile;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.LocalFilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.space.vcs.SpaceRepoInfo;
import com.intellij.space.vcs.changes.SpaceChange;
import com.intellij.vcsUtil.VcsUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0003\u001a\u00020\u0001*\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\rH\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"filePath", "Lcom/intellij/openapi/vcs/FilePath;", "Lcom/intellij/space/vcs/changes/SpaceChange;", "getFilePath", "(Lcom/intellij/space/vcs/changes/SpaceChange;)Lcom/intellij/openapi/vcs/FilePath;", "spaceFilePath", "", "getSpaceFilePath", "(Lcom/intellij/space/vcs/changes/SpaceChange;)Ljava/lang/String;", "Lcirclet/client/api/GitFile;", "spaceRepoInfo", "Lcom/intellij/space/vcs/SpaceRepoInfo;", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "Lcirclet/client/api/GitCommitChange;", "toGitCommitChangeType", "Lcirclet/client/api/GitCommitChangeType;", "intellij.space.vcs"})
public final class SpaceChangeKt {
    @NotNull
    public static final FilePath getFilePath(@NotNull SpaceChange $this$filePath) {
        Intrinsics.checkNotNullParameter((Object)$this$filePath, (String)"<this>");
        FilePath filePath = $this$filePath.getNewFilePath();
        if (filePath == null) {
            FilePath filePath2 = $this$filePath.getOldFilePath();
            filePath = filePath2;
            Intrinsics.checkNotNull((Object)filePath2);
        }
        return filePath;
    }

    @NotNull
    public static final String getSpaceFilePath(@NotNull SpaceChange $this$spaceFilePath) {
        Intrinsics.checkNotNullParameter((Object)$this$spaceFilePath, (String)"<this>");
        GitFile gitFile = $this$spaceFilePath.getGitCommitChange().getNew();
        if (gitFile == null) {
            gitFile = $this$spaceFilePath.getGitCommitChange().getOld();
        }
        Intrinsics.checkNotNull((Object)gitFile);
        return gitFile.getPath();
    }

    private static final FilePath getFilePath(GitFile $this$getFilePath, SpaceRepoInfo spaceRepoInfo) {
        char[] cArray = new char[]{'/', '\\'};
        String path2 = StringsKt.trimStart((String)$this$getFilePath.getPath(), (char[])cArray);
        if (spaceRepoInfo == null) {
            return (FilePath)new LocalFilePath(path2, CodeViewServiceKt.isDirectory($this$getFilePath));
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)spaceRepoInfo.getRepository().getRoot(), (String)path2);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(spaceRepoInfo.repository.root, path)");
        return filePath;
    }

    private static final FileStatus getFileStatus(GitCommitChange $this$getFileStatus) {
        FileStatus fileStatus;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$getFileStatus.getChangeType().ordinal()]) {
            case 1: {
                FileStatus fileStatus2 = FileStatus.ADDED;
                fileStatus = fileStatus2;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus2, (String)"ADDED");
                break;
            }
            case 2: {
                FileStatus fileStatus3 = FileStatus.DELETED;
                fileStatus = fileStatus3;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus3, (String)"DELETED");
                break;
            }
            case 3: {
                FileStatus fileStatus4 = FileStatus.MODIFIED;
                fileStatus = fileStatus4;
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus4, (String)"MODIFIED");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fileStatus;
    }

    @NotNull
    public static final GitCommitChangeType toGitCommitChangeType(@NotNull FileStatus $this$toGitCommitChangeType) {
        Intrinsics.checkNotNullParameter((Object)$this$toGitCommitChangeType, (String)"<this>");
        FileStatus fileStatus = $this$toGitCommitChangeType;
        return Intrinsics.areEqual((Object)fileStatus, (Object)FileStatus.DELETED) ? GitCommitChangeType.DELETED : (Intrinsics.areEqual((Object)fileStatus, (Object)FileStatus.ADDED) ? GitCommitChangeType.ADDED : GitCommitChangeType.MODIFIED);
    }

    public static final /* synthetic */ FileStatus access$getFileStatus(GitCommitChange $receiver) {
        return SpaceChangeKt.getFileStatus($receiver);
    }

    public static final /* synthetic */ FilePath access$getFilePath(GitFile $receiver, SpaceRepoInfo spaceRepoInfo) {
        return SpaceChangeKt.getFilePath($receiver, spaceRepoInfo);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GitCommitChangeType.values().length];
            try {
                nArray[GitCommitChangeType.ADDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitCommitChangeType.DELETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitCommitChangeType.MODIFIED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

