/*
 * Decompiled with CFR 0.152.
 */
package libraries.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.nio.channels.Channel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.io.CountingStream;
import libraries.io.DataSizeKt;
import libraries.io.DirectoryInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0016\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\b\b\u0002\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0012H\u0007J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u0012H\u0007J\u001f\u0010(\u001a\u00020\u00172\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0*\"\u00020+\u00a2\u0006\u0002\u0010,J\"\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u00020/2\b\b\u0002\u00101\u001a\u00020#J\"\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00062\b\b\u0002\u00100\u001a\u00020/2\b\b\u0002\u00101\u001a\u00020#J\u000e\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u0012J\u0016\u00104\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012J\u0006\u00105\u001a\u00020\u001eJ\u0006\u00106\u001a\u00020+J\u000e\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020\u0004J1\u00109\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00122\u0006\u0010:\u001a\u00020;2\u0012\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020=0*\"\u00020=H\u0007\u00a2\u0006\u0002\u0010>R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Llibraries/io/FileUtil;", "", "()V", "B_POSTFIX", "", "GB", "", "GB_POSTFIX", "KB", "KB_POSTFIX", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "MB", "MB_POSTFIX", "TB", "TB_POSTFIX", "child", "Ljava/io/File;", "root", "parts", "", "close", "", "c", "Ljava/io/Closeable;", "copy", "from", "to", "countingStream", "Ljava/io/InputStream;", "stream", "counter", "Ljava/util/concurrent/atomic/AtomicLong;", "delete", "", "file", "directorySize", "Llibraries/io/DirectoryInfo;", "repositoryPath", "flushAndCatch", "streams", "", "Ljava/io/OutputStream;", "([Ljava/io/OutputStream;)V", "formatFileSize", "fileSize", "", "maxFractionDigits", "withWhitespace", "mkdirs", "path", "move", "nullInputStream", "nullOutputStream", "parseFileSize", "fileSizeStr", "writeAndFlush", "data", "", "options", "Ljava/nio/file/OpenOption;", "(Ljava/io/File;[B[Ljava/nio/file/OpenOption;)V", "libraries-io"})
@SourceDebugExtension(value={"SMAP\nFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtil.kt\nlibraries/io/FileUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,289:1\n1789#2,3:290\n37#3,2:293\n13579#4,2:295\n*S KotlinDebug\n*F\n+ 1 FileUtil.kt\nlibraries/io/FileUtil\n*L\n45#1:290,3\n186#1:293,2\n140#1:295,2\n*E\n"})
public final class FileUtil {
    @NotNull
    public static final FileUtil INSTANCE = new FileUtil();
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);
    public static final long KB = 1000L;
    public static final long MB = 1000000L;
    public static final long GB = 1000000000L;
    public static final long TB = 1000000000000L;
    @NotNull
    public static final String B_POSTFIX = "B";
    @NotNull
    public static final String KB_POSTFIX = "KB";
    @NotNull
    public static final String MB_POSTFIX = "MB";
    @NotNull
    public static final String GB_POSTFIX = "GB";
    @NotNull
    public static final String TB_POSTFIX = "TB";

    private FileUtil() {
    }

    public final void close(@Nullable Closeable c) {
        try {
            Closeable closeable = c;
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final File child(@NotNull File root2, @NotNull List<String> parts) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        Iterable $this$fold$iv = parts;
        boolean $i$f$fold = false;
        File accumulator$iv = root2;
        for (Object element$iv : $this$fold$iv) {
            void b;
            String string2 = (String)element$iv;
            File a = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new File(a, (String)b);
        }
        return accumulator$iv;
    }

    public final void mkdirs(@NotNull File path2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        path2.mkdirs();
        if (!path2.isDirectory()) {
            if (path2.isFile()) {
                throw new IOException("Failed to create directory (target is a file) at " + path2);
            }
            throw new IOException("Failed to create directory at " + path2);
        }
    }

    @JvmStatic
    public static final boolean delete(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        File[] files2 = file2.listFiles();
        if (files2 != null) {
            for (File child : files2) {
                Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                if (FileUtil.delete(child)) continue;
                return false;
            }
        }
        for (int i = 0; i < 10; ++i) {
            if (file2.delete() || !file2.exists()) {
                return true;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    public final long parseFileSize(@NotNull String fileSizeStr) throws NumberFormatException {
        Intrinsics.checkNotNullParameter((Object)fileSizeStr, (String)"fileSizeStr");
        return DataSizeKt.parseDataSize(fileSizeStr);
    }

    @NotNull
    public final String formatFileSize(int fileSize, int maxFractionDigits, boolean withWhitespace) {
        return this.formatFileSize((long)fileSize, maxFractionDigits, withWhitespace);
    }

    public static /* synthetic */ String formatFileSize$default(FileUtil fileUtil, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 2;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        return fileUtil.formatFileSize(n, n2, bl);
    }

    @NotNull
    public final String formatFileSize(long fileSize, int maxFractionDigits, boolean withWhitespace) {
        String whitespace;
        DecimalFormat f = new DecimalFormat();
        DecimalFormatSymbols custom = new DecimalFormatSymbols();
        custom.setDecimalSeparator('.');
        f.setDecimalFormatSymbols(custom);
        f.setRoundingMode(RoundingMode.FLOOR);
        f.setMaximumFractionDigits(maxFractionDigits);
        String string2 = whitespace = withWhitespace ? " " : "";
        if (fileSize >= 1000000000000L) {
            return f.format((double)fileSize / (double)1000000000000L) + whitespace + TB_POSTFIX;
        }
        if (fileSize >= 1000000000L) {
            return f.format((double)fileSize / (double)1000000000L) + whitespace + GB_POSTFIX;
        }
        if (fileSize >= 1000000L) {
            return f.format((double)fileSize / (double)1000000L) + whitespace + MB_POSTFIX;
        }
        return fileSize >= 1000L ? f.format((double)fileSize / (double)1000L) + whitespace + KB_POSTFIX : fileSize + whitespace + B_POSTFIX;
    }

    public static /* synthetic */ String formatFileSize$default(FileUtil fileUtil, long l, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return fileUtil.formatFileSize(l, n, bl);
    }

    @JvmStatic
    @Nullable
    public static final DirectoryInfo directorySize(@NotNull File repositoryPath) {
        Intrinsics.checkNotNullParameter((Object)repositoryPath, (String)"repositoryPath");
        if (repositoryPath.isFile()) {
            return new DirectoryInfo(Math.max(0L, repositoryPath.length()), 1);
        }
        if (!repositoryPath.isDirectory()) {
            return null;
        }
        try {
            AtomicLong size2 = new AtomicLong(0L);
            AtomicInteger files2 = new AtomicInteger(0);
            FileUtil.directorySize$visit(files2, size2, repositoryPath);
            return new DirectoryInfo(size2.get(), files2.get());
        }
        catch (Throwable e) {
            LOG.warn("Failed to list files. " + e.getMessage(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void writeAndFlush(@NotNull File file2, @NotNull byte[] data2, OpenOption ... options2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        File parent = file2.getParentFile();
        if (parent != null) {
            INSTANCE.mkdirs(parent);
        }
        HashSet<StandardOpenOption> effectiveOptions = new HashSet<StandardOpenOption>();
        if (options2.length == 0) {
            effectiveOptions.add(StandardOpenOption.WRITE);
            effectiveOptions.add(StandardOpenOption.CREATE);
            effectiveOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
        } else {
            CollectionsKt.addAll((Collection)effectiveOptions, (Object[])options2);
        }
        effectiveOptions.add(StandardOpenOption.SYNC);
        Collection $this$toTypedArray$iv = effectiveOptions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object object = thisCollection$iv.toArray(new OpenOption[0]);
        object = Files.newOutputStream(file2.toPath(), Arrays.copyOf(object, ((OpenOption[])object).length));
        Throwable throwable = null;
        try {
            OutputStream out = (OutputStream)object;
            boolean bl = false;
            out.write(data2);
            out.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public final void move(@NotNull File from, @NotNull File to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE, LinkOption.NOFOLLOW_LINKS};
        Files.move(from.toPath(), to.toPath(), copyOptionArray);
    }

    public final void copy(@NotNull File from, @NotNull File to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, LinkOption.NOFOLLOW_LINKS};
        Files.copy(from.toPath(), to.toPath(), copyOptionArray);
    }

    public final void flushAndCatch(OutputStream ... streams) {
        Intrinsics.checkNotNullParameter((Object)streams, (String)"streams");
        for (OutputStream stream : streams) {
            if (stream instanceof Channel && !((Channel)((Object)stream)).isOpen()) continue;
            try {
                stream.flush();
            }
            catch (Throwable t) {
                LOG.info("Failed to flush stream. " + t.getMessage(), t);
            }
        }
    }

    @NotNull
    public final InputStream countingStream(@NotNull InputStream stream, @NotNull AtomicLong counter2) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)counter2, (String)"counter");
        return (InputStream)((Object)new CountingStream(stream, counter2){
            final /* synthetic */ InputStream $stream;
            final /* synthetic */ AtomicLong $counter;
            {
                this.$stream = $stream;
                this.$counter = $counter;
            }

            public int read() throws IOException {
                int read2 = this.$stream.read();
                if (read2 >= 0) {
                    this.$counter.addAndGet(1L);
                }
                return read2;
            }

            public int read(@NotNull byte[] b, int off2, int len) throws IOException {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                int read2 = this.$stream.read(b, off2, len);
                if (read2 >= 0) {
                    this.$counter.addAndGet(read2);
                }
                return read2;
            }

            public void close() throws IOException {
                this.$stream.close();
            }

            public int available() throws IOException {
                return this.$stream.available();
            }

            public long skip(long n) throws IOException {
                long skip2 = this.$stream.skip(n);
                if (skip2 >= 0L) {
                    this.$counter.addAndGet(skip2);
                }
                return skip2;
            }

            public long getTransferredBytes() {
                return this.$counter.get();
            }
        });
    }

    public static /* synthetic */ InputStream countingStream$default(FileUtil fileUtil, InputStream inputStream, AtomicLong atomicLong, int n, Object object) {
        if ((n & 2) != 0) {
            atomicLong = new AtomicLong(0L);
        }
        return fileUtil.countingStream(inputStream, atomicLong);
    }

    @NotNull
    public final OutputStream nullOutputStream() {
        return new OutputStream(){

            public void write(int b) throws IOException {
            }

            public void write(@NotNull byte[] b, int off2, int len) throws IOException {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            }
        };
    }

    @NotNull
    public final InputStream nullInputStream() {
        return new InputStream(){

            public int read() throws IOException {
                return -1;
            }
        };
    }

    private static final void directorySize$visit(AtomicInteger files2, AtomicLong size2, File root2) {
        block2: {
            File[] fileArray = root2.listFiles();
            if (fileArray == null) break block2;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File child = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (child.isFile()) {
                    files2.incrementAndGet();
                    size2.addAndGet(Files.size(child.toPath()));
                    continue;
                }
                if (!child.isDirectory()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                FileUtil.directorySize$visit(files2, size2, child);
            }
        }
    }
}

