/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.core.settings.IvyVariableContainerImpl;
import org.apache.ivy.util.Message;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Property;

class IvyAntVariableContainer
extends IvyVariableContainerImpl
implements IvyVariableContainer {
    private Map<String, String> overwrittenProperties = new HashMap<String, String>();
    private Project project;

    public IvyAntVariableContainer(Project project2) {
        this.project = project2;
    }

    @Override
    public String getVariable(String name2) {
        String r = this.overwrittenProperties.get(name2);
        if (r == null) {
            r = this.project.getProperty(name2);
        }
        if (r == null) {
            r = super.getVariable(name2);
        }
        return r;
    }

    @Override
    public void setVariable(String varName, String value2, boolean overwrite) {
        if (overwrite) {
            Message.debug("setting '" + varName + "' to '" + value2 + "'");
            this.overwrittenProperties.put(varName, this.substitute(value2));
        } else {
            super.setVariable(varName, value2, overwrite);
        }
    }

    public void updateProject(String id2) {
        HashMap<String, String> r = new HashMap<String, String>(super.getVariables());
        r.putAll(this.overwrittenProperties);
        for (Map.Entry entry : r.entrySet()) {
            this.setPropertyIfNotSet((String)entry.getKey(), (String)entry.getValue());
            if (id2 == null) continue;
            this.setPropertyIfNotSet((String)entry.getKey() + "." + id2, (String)entry.getValue());
        }
        if (this.getEnvironmentPrefix() != null) {
            Property propTask = new Property();
            propTask.setProject(this.project);
            propTask.setEnvironment(this.getEnvironmentPrefix());
            propTask.init();
            propTask.execute();
        }
    }

    private void setPropertyIfNotSet(String property2, String value2) {
        if (this.project.getProperty(property2) == null) {
            this.project.setProperty(property2, value2);
        }
    }

    @Override
    public Object clone() {
        IvyAntVariableContainer result2 = (IvyAntVariableContainer)super.clone();
        result2.overwrittenProperties = (HashMap)((HashMap)this.overwrittenProperties).clone();
        return result2;
    }
}

