/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import kotlin.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.basics.DebugKt;
import libraries.basics.DevEnv;
import libraries.collections.Collections;
import libraries.collections.MutableSetLike;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeSource;
import libraries.coroutines.extra.LifetimeUtilsKt;
import libraries.klogging.BaseLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.CellTracker;
import runtime.reactive.CellTrackerKt;
import runtime.reactive.ComputedExpression;
import runtime.reactive.ComputedKt;
import runtime.reactive.DependenciesState;
import runtime.reactive.DevTool;
import runtime.reactive.Property;
import runtime.reactive.PropertyLiveKt;
import runtime.reactive.ReactionsKt;
import runtime.reactive.TransactionalReactionsScheduler;
import runtime.reactive.XTrackableLifetimed;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B&\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u0007H\u0002J \u0010\u000e\u001a\u0014\u0012\f\u0012\n\u0012\u0002\b\u00030\u0010j\u0002`\u00110\u000fj\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\rJ\u0006\u0010\u0014\u001a\u00020\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u00020\u00072\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00072\u000e\u0010\u001b\u001a\n\u0012\u0002\b\u00030\u0010j\u0002`\u0011H\u0002J\u0006\u0010\u001c\u001a\u00020\u0007J*\u0010\u001d\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00032\u0018\u0010\u001e\u001a\u0014\u0012\f\u0012\n\u0012\u0002\b\u00030\u0010j\u0002`\u00110\u000fj\u0002`\u0012H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lruntime/reactive/Effect;", "", "parentLifetime", "Llibraries/coroutines/extra/Lifetime;", "expression", "Lkotlin/Function1;", "Lruntime/reactive/XTrackableLifetimed;", "", "Lkotlin/ExtensionFunctionType;", "(Llibraries/coroutines/extra/Lifetime;Lkotlin/jvm/functions/Function1;)V", "dependenciesState", "Lruntime/reactive/DependenciesState;", "executionLifetime", "Llibraries/coroutines/extra/LifetimeSource;", "execute", "Llibraries/collections/MutableSetLike;", "Lruntime/reactive/Property;", "Lruntime/reactive/CellTrackerDependency;", "Lruntime/reactive/CellTrackerDependencies;", "lifetime", "invalidate", "isNeedToBeReexecuted", "", "markAsPossiblyStale", "dependency", "Lruntime/reactive/ComputedExpression;", "markAsStale", "cause", "run", "trackDependencies", "dependencies", "platform-ui"})
@SourceDebugExtension(value={"SMAP\nReactions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Reactions.kt\nruntime/reactive/Effect\n+ 2 DebugCommon.kt\nlibraries/basics/DebugCommonKt\n+ 3 Debug.kt\nlibraries/basics/DebugKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,298:1\n29#2,3:299\n29#2,3:302\n29#2,3:307\n17#3:305\n1#4:306\n*S KotlinDebug\n*F\n+ 1 Reactions.kt\nruntime/reactive/Effect\n*L\n142#1:299,3\n176#1:302,3\n211#1:307,3\n193#1:305\n*E\n"})
public final class Effect {
    @NotNull
    private final Lifetime parentLifetime;
    @NotNull
    private final Function1<XTrackableLifetimed, Unit> expression;
    @Nullable
    private LifetimeSource executionLifetime;
    @NotNull
    private DependenciesState dependenciesState;

    public Effect(@NotNull Lifetime parentLifetime, @NotNull Function1<? super XTrackableLifetimed, Unit> expression2) {
        Intrinsics.checkNotNullParameter((Object)parentLifetime, (String)"parentLifetime");
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        this.parentLifetime = parentLifetime;
        this.expression = expression2;
        boolean $i$f$ifDevEnv = false;
        if (DebugKt.getIS_DEV_ENV()) {
            DevEnv $this$_init__u24lambda_u240 = DevEnv.INSTANCE;
            boolean bl = false;
            DevTool devTool = CellTrackerKt.getDevTool($this$_init__u24lambda_u240);
            if (devTool != null) {
                devTool.onCreateEffect(this.parentLifetime, this);
            }
        }
        this.dependenciesState = DependenciesState.NotTracked.INSTANCE;
    }

    @NotNull
    public final MutableSetLike<Property<?>> execute(@NotNull LifetimeSource lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        MutableSetLike<Property<?>> dependencies = Collections.INSTANCE.fastSet();
        CellTracker.INSTANCE.frameAccess((Function1)new Function1<Property<?>, Unit>(dependencies){

            public final void invoke(@NotNull Property<?> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((MutableSetLike)this.receiver).add(p0);
            }
        }, (Function0)new Function0<Unit>(this, lifetime){
            final /* synthetic */ Effect this$0;
            final /* synthetic */ LifetimeSource $lifetime;
            {
                this.this$0 = $receiver;
                this.$lifetime = $lifetime;
                super(0);
            }

            public final void invoke() {
                try {
                    Effect.access$getExpression$p(this.this$0).invoke((Object)PropertyLiveKt.XTrackableLifetimed(this.$lifetime));
                }
                catch (Throwable e) {
                    BaseLogger.DefaultImpls.error$default(ReactionsKt.access$getLog$p(), e, null, 2, null);
                }
            }
        });
        return dependencies;
    }

    private final void markAsPossiblyStale(ComputedExpression<?> dependency) {
        ReactionsKt.markAsPossiblyStale(dependency, this.dependenciesState, (Function1<? super DependenciesState.Tracked.PossiblyStale, Unit>)((Function1)new Function1<DependenciesState.Tracked.PossiblyStale, Unit>(this){
            final /* synthetic */ Effect this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DependenciesState.Tracked.PossiblyStale it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Effect.access$setDependenciesState$p(this.this$0, it);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ Effect this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                TransactionalReactionsScheduler.INSTANCE.schedule(this.this$0);
            }
        }));
    }

    private final void markAsStale(Property<?> cause) {
        ReactionsKt.markAsStale(this.dependenciesState, (Function1<? super DependenciesState.Tracked.Stale, Unit>)((Function1)new Function1<DependenciesState.Tracked.Stale, Unit>(this){
            final /* synthetic */ Effect this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DependenciesState.Tracked.Stale it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Effect.access$setDependenciesState$p(this.this$0, it);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ Effect this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                TransactionalReactionsScheduler.INSTANCE.schedule(this.this$0);
            }
        }));
    }

    private final void trackDependencies(Lifetime executionLifetime, MutableSetLike<Property<?>> dependencies) {
        if (!executionLifetime.isTerminated()) {
            boolean $i$f$ifDevEnv = false;
            if (DebugKt.getIS_DEV_ENV()) {
                DevEnv $this$trackDependencies_u24lambda_u241 = DevEnv.INSTANCE;
                boolean bl = false;
                DevTool devTool = CellTrackerKt.getDevTool($this$trackDependencies_u24lambda_u241);
                if (devTool != null) {
                    devTool.onTrackDependenciesEffect(this, dependencies);
                }
            }
            LifetimeSource trackingLifetime = LifetimeUtilsKt.nested(executionLifetime);
            this.dependenciesState = DependenciesState.Tracked.UpToDate.INSTANCE;
            Effect $this$getDbgName$iv = this;
            boolean $i$f$getDbgName = false;
            ComputedKt.trackDependencies(trackingLifetime, dependencies, (Function1)new Function1<ComputedExpression<?>, Unit>(this){
                final /* synthetic */ Effect this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ComputedExpression<?> dependency) {
                    Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
                    Effect.access$markAsPossiblyStale(this.this$0, dependency);
                }
            }, (Function1)new Function1<Property<?>, Unit>(this){
                final /* synthetic */ Effect this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Property<?> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    Effect effect2 = this.this$0;
                    boolean $i$f$ifDevEnv = false;
                    if (DebugKt.getIS_DEV_ENV()) {
                        DevEnv $this$invoke_u24lambda_u240 = DevEnv.INSTANCE;
                        boolean bl = false;
                        DevTool devTool = CellTrackerKt.getDevTool($this$invoke_u24lambda_u240);
                        if (devTool != null) {
                            devTool.onReexecuteEffect(effect2, it);
                        }
                    }
                    Effect.access$markAsStale(this.this$0, it);
                }
            }, null);
        } else {
            this.dependenciesState = DependenciesState.NotTracked.INSTANCE;
        }
    }

    public final void invalidate() {
        if (this.parentLifetime.isTerminated()) {
            return;
        }
        boolean needsToBeReexecuted = this.isNeedToBeReexecuted();
        if (needsToBeReexecuted) {
            this.execute();
        } else {
            this.dependenciesState = DependenciesState.Tracked.UpToDate.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isNeedToBeReexecuted() {
        void var3_3;
        block2: {
            Pair<Boolean, ComputedExpression<?>> pair = ReactionsKt.isNeedToBeReexecuted(this.parentLifetime, (Function0<? extends DependenciesState>)((Function0)new Function0<DependenciesState>(this){
                final /* synthetic */ Effect this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final DependenciesState invoke() {
                    return Effect.access$getDependenciesState$p(this.this$0);
                }
            }));
            boolean bl = false;
            boolean result2 = (Boolean)pair.component1();
            ComputedExpression cause = (ComputedExpression)pair.component2();
            boolean $i$f$ifDevEnv = false;
            if (!DebugKt.getIS_DEV_ENV()) break block2;
            DevEnv $this$isNeedToBeReexecuted_u24lambda_u244_u24lambda_u243 = DevEnv.INSTANCE;
            boolean bl2 = false;
            if (cause != null) {
                DevTool devTool = CellTrackerKt.getDevTool($this$isNeedToBeReexecuted_u24lambda_u244_u24lambda_u243);
                if (devTool != null) {
                    devTool.onReexecuteEffect(this, cause);
                }
            }
        }
        return (boolean)var3_3;
    }

    private final void execute() {
        LifetimeSource executionLifetime;
        if (this.parentLifetime.isTerminated()) {
            return;
        }
        LifetimeSource lifetimeSource = this.executionLifetime;
        if (lifetimeSource != null) {
            lifetimeSource.terminate();
        }
        this.executionLifetime = executionLifetime = LifetimeUtilsKt.nested(this.parentLifetime);
        MutableSetLike<Property<?>> dependencies = this.execute(executionLifetime);
        this.trackDependencies(executionLifetime, dependencies);
    }

    public final void run() {
        if (this.parentLifetime.isTerminated()) {
            this.dependenciesState = DependenciesState.NotTracked.INSTANCE;
            return;
        }
        this.parentLifetime.add((Function)new Function0<Unit>(this){
            final /* synthetic */ Effect this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Effect.access$setDependenciesState$p(this.this$0, DependenciesState.NotTracked.INSTANCE);
            }
        });
        this.execute();
    }

    public static final /* synthetic */ Function1 access$getExpression$p(Effect $this) {
        return $this.expression;
    }

    public static final /* synthetic */ void access$setDependenciesState$p(Effect $this, DependenciesState dependenciesState) {
        $this.dependenciesState = dependenciesState;
    }

    public static final /* synthetic */ void access$markAsPossiblyStale(Effect $this, ComputedExpression dependency) {
        $this.markAsPossiblyStale(dependency);
    }

    public static final /* synthetic */ void access$markAsStale(Effect $this, Property cause) {
        $this.markAsStale(cause);
    }

    public static final /* synthetic */ DependenciesState access$getDependenciesState$p(Effect $this) {
        return $this.dependenciesState;
    }
}

