/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.ec4j.core.ResourceProperties;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigIndentStatusBarUIContributor;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/editorconfig/configmanagement/EditorConfigIndentOptionsProvider;", "Lcom/intellij/psi/codeStyle/FileIndentOptionsProvider;", "()V", "getIndentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getIndentStatusBarUiContributor", "Lcom/intellij/psi/codeStyle/IndentStatusBarUIContributor;", "indentOptions", "Companion", "intellij.editorconfig"})
public final class EditorConfigIndentOptionsProvider
extends FileIndentOptionsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String indentSizeKey = "indent_size";
    @NotNull
    private static final String continuationSizeKey = "continuation_indent_size";
    @NotNull
    public static final String tabWidthKey = "tab_width";
    @NotNull
    public static final String indentStyleKey = "indent_style";

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull Project project, @NotNull CodeStyleSettings settings, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (Utils.INSTANCE.isFullIntellijSettingsSupport()) {
            return null;
        }
        if (project.isDisposed() || !Utils.isEnabled(settings)) {
            return null;
        }
        ResourceProperties properties = SettingsProviderComponent.Companion.getInstance(project).getProperties(file);
        return EditorConfigIndentOptionsProvider.Companion.applyCodeStyleSettings(project, properties, file, settings);
    }

    @NotNull
    public IndentStatusBarUIContributor getIndentStatusBarUiContributor(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        Intrinsics.checkNotNullParameter((Object)indentOptions, (String)"indentOptions");
        return new EditorConfigIndentStatusBarUIContributor(indentOptions);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002JB\u0010\u0016\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J \u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\tH\u0002J\u0018\u0010!\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/editorconfig/configmanagement/EditorConfigIndentOptionsProvider$Companion;", "", "()V", "continuationSizeKey", "", "indentSizeKey", "indentStyleKey", "tabWidthKey", "applyCodeStyleSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "project", "Lcom/intellij/openapi/project/Project;", "properties", "Lorg/ec4j/core/ResourceProperties;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "applyContinuationIndentSize", "", "indentOptions", "continuationIndentSize", "applyIndentOptions", "indentSize", "tabWidth", "indentStyle", "filePath", "applyIndentSize", "applyIndentStyle", "applyTabWidth", "calculateContinuationIndentSize", "calculateIndentSize", "options", "calculateTabWidth", "intellij.editorconfig"})
    @SourceDebugExtension(value={"SMAP\nEditorConfigIndentOptionsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigIndentOptionsProvider.kt\norg/editorconfig/configmanagement/EditorConfigIndentOptionsProvider$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final CommonCodeStyleSettings.IndentOptions applyCodeStyleSettings(Project project, ResourceProperties properties, VirtualFile file, CodeStyleSettings settings) {
            String indentSize = Utils.INSTANCE.configValueForKey(properties, EditorConfigIndentOptionsProvider.indentSizeKey);
            String continuationIndentSize = Utils.INSTANCE.configValueForKey(properties, EditorConfigIndentOptionsProvider.continuationSizeKey);
            String tabWidth = Utils.INSTANCE.configValueForKey(properties, EditorConfigIndentOptionsProvider.tabWidthKey);
            String indentStyle = Utils.INSTANCE.configValueForKey(properties, EditorConfigIndentOptionsProvider.indentStyleKey);
            Object object = settings.getIndentOptions(file.getFileType()).clone();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.psi.codeStyle.CommonCodeStyleSettings.IndentOptions");
            CommonCodeStyleSettings.IndentOptions indentOptions = (CommonCodeStyleSettings.IndentOptions)object;
            if (this.applyIndentOptions(project, indentOptions, indentSize, continuationIndentSize, tabWidth, indentStyle, file.getCanonicalPath())) {
                indentOptions.setOverrideLanguageOptions(true);
                return indentOptions;
            }
            return null;
        }

        private final boolean applyIndentOptions(Project project, CommonCodeStyleSettings.IndentOptions indentOptions, String indentSize, String continuationIndentSize, String tabWidth, String indentStyle, String filePath) {
            boolean changed = false;
            String calculatedIndentSize = this.calculateIndentSize(tabWidth, indentSize, indentOptions);
            String calculatedContinuationSize = this.calculateContinuationIndentSize(calculatedIndentSize, continuationIndentSize);
            String calculatedTabWidth = this.calculateTabWidth(tabWidth, indentSize);
            if (!(((CharSequence)calculatedIndentSize).length() == 0)) {
                if (this.applyIndentSize(indentOptions, calculatedIndentSize)) {
                    changed = true;
                } else {
                    Utils.INSTANCE.invalidConfigMessage(project, calculatedIndentSize, EditorConfigIndentOptionsProvider.indentSizeKey, filePath);
                }
            }
            if (!(((CharSequence)calculatedContinuationSize).length() == 0)) {
                if (this.applyContinuationIndentSize(indentOptions, calculatedContinuationSize)) {
                    changed = true;
                } else {
                    Utils.INSTANCE.invalidConfigMessage(project, calculatedIndentSize, EditorConfigIndentOptionsProvider.indentSizeKey, filePath);
                }
            }
            if (!(((CharSequence)calculatedTabWidth).length() == 0)) {
                if (this.applyTabWidth(indentOptions, calculatedTabWidth)) {
                    changed = true;
                } else {
                    Utils.INSTANCE.invalidConfigMessage(project, calculatedTabWidth, EditorConfigIndentOptionsProvider.tabWidthKey, filePath);
                }
            }
            if (!(((CharSequence)indentStyle).length() == 0)) {
                if (this.applyIndentStyle(indentOptions, indentStyle)) {
                    changed = true;
                } else {
                    Utils.INSTANCE.invalidConfigMessage(project, indentStyle, EditorConfigIndentOptionsProvider.indentStyleKey, filePath);
                }
            }
            return changed;
        }

        private final String calculateIndentSize(String tabWidth, String indentSize, CommonCodeStyleSettings.IndentOptions options) {
            String string;
            if (Intrinsics.areEqual((Object)indentSize, (Object)"tab")) {
                CharSequence charSequence;
                CharSequence charSequence2 = tabWidth;
                if (charSequence2.length() == 0) {
                    boolean bl = false;
                    charSequence = String.valueOf(options.TAB_SIZE);
                } else {
                    charSequence = charSequence2;
                }
                string = (String)charSequence;
            } else {
                string = indentSize;
            }
            return string;
        }

        private final String calculateContinuationIndentSize(String indentSize, String continuationIndentSize) {
            CharSequence charSequence;
            CharSequence charSequence2 = continuationIndentSize;
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = indentSize;
            } else {
                charSequence = charSequence2;
            }
            return (String)charSequence;
        }

        private final String calculateTabWidth(String tabWidth, String indentSize) {
            return ((CharSequence)tabWidth).length() == 0 && Intrinsics.areEqual((Object)indentSize, (Object)"tab") ? "" : (((CharSequence)tabWidth).length() == 0 ? indentSize : tabWidth);
        }

        private final boolean applyIndentSize(CommonCodeStyleSettings.IndentOptions indentOptions, String indentSize) {
            boolean bl;
            Integer n = StringsKt.toIntOrNull((String)indentSize);
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                indentOptions.INDENT_SIZE = it;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        private final boolean applyContinuationIndentSize(CommonCodeStyleSettings.IndentOptions indentOptions, String continuationIndentSize) {
            boolean bl;
            Integer n = StringsKt.toIntOrNull((String)continuationIndentSize);
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                indentOptions.CONTINUATION_INDENT_SIZE = it;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        private final boolean applyTabWidth(CommonCodeStyleSettings.IndentOptions indentOptions, String tabWidth) {
            boolean bl;
            Integer n = StringsKt.toIntOrNull((String)tabWidth);
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                indentOptions.TAB_SIZE = it;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        private final boolean applyIndentStyle(CommonCodeStyleSettings.IndentOptions indentOptions, String indentStyle) {
            if (Intrinsics.areEqual((Object)indentStyle, (Object)"tab") || Intrinsics.areEqual((Object)indentStyle, (Object)"space")) {
                indentOptions.USE_TAB_CHARACTER = Intrinsics.areEqual((Object)indentStyle, (Object)"tab");
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

