/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.internal.DumpLookupElementWeights;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class EditorTestFixture {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final VirtualFile myFile;
    private boolean myEmptyLookup;

    public EditorTestFixture(@NotNull Project project2, @NotNull Editor editor, @NotNull VirtualFile file2) {
        if (project2 == null) {
            EditorTestFixture.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            EditorTestFixture.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            EditorTestFixture.$$$reportNull$$$0(2);
        }
        this.myProject = project2;
        this.myEditor = editor;
        this.myFile = file2;
    }

    public void type(char c) {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            EditorActionManager.getInstance();
            if (c == '\b') {
                this.performEditorAction("EditorBackSpace");
                return;
            }
            if (c == '\n') {
                if (this.performEditorAction("EditorChooseLookupItem")) {
                    return;
                }
                if (this.performEditorAction("NextTemplateVariable")) {
                    return;
                }
                this.performEditorAction("EditorEnter");
                return;
            }
            if (c == '\t') {
                if (this.performEditorAction("EditorChooseLookupItemReplace")) {
                    return;
                }
                if (this.performEditorAction("ExpandLiveTemplateByTab")) {
                    return;
                }
                if (this.performEditorAction("NextTemplateVariable")) {
                    return;
                }
                if (this.performEditorAction("EditorTab")) {
                    return;
                }
            }
            if (c == '\r' && this.performEditorAction("EditorChooseLookupItemCompleteStatement")) {
                return;
            }
            ActionManagerEx.getInstanceEx().fireBeforeEditorTyping(c, this.getEditorDataContext());
            TypedAction.getInstance().actionPerformed(this.myEditor, c, this.getEditorDataContext());
            ActionManagerEx.getInstanceEx().fireAfterEditorTyping(c, this.getEditorDataContext());
        });
    }

    public void type(@NotNull String s) {
        if (s == null) {
            EditorTestFixture.$$$reportNull$$$0(3);
        }
        for (int i = 0; i < s.length(); ++i) {
            this.type(s.charAt(i));
        }
    }

    public boolean performEditorAction(@NotNull String actionId) {
        AnActionEvent event;
        if (actionId == null) {
            EditorTestFixture.$$$reportNull$$$0(4);
        }
        DataContext dataContext = this.getEditorDataContext();
        ActionManagerEx managerEx = ActionManagerEx.getInstanceEx();
        AnAction action = managerEx.getAction(actionId);
        if (!ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)(event = new AnActionEvent(null, dataContext, "unknown", new Presentation(), (ActionManager)managerEx, 0)), (boolean)false)) {
            return false;
        }
        ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action, (AnActionEvent)event);
        return true;
    }

    @NotNull
    private DataContext getEditorDataContext() {
        DataContext dataContext = ((EditorEx)this.myEditor).getDataContext();
        if (dataContext == null) {
            EditorTestFixture.$$$reportNull$$$0(5);
        }
        return dataContext;
    }

    public PsiFile getFile() {
        return (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.myProject).findFile(this.myFile));
    }

    @NotNull
    public List<HighlightInfo> doHighlighting() {
        List<HighlightInfo> list = this.doHighlighting(false, false);
        if (list == null) {
            EditorTestFixture.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<HighlightInfo> doHighlighting(boolean myAllowDirt, boolean readEditorMarkupModel) {
        EdtTestUtil.runInEdtAndWait(() -> PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments());
        PsiFile file2 = this.getFile();
        Editor editor = this.myEditor;
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file2 = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
        }
        Assert.assertNotNull((Object)file2);
        List<HighlightInfo> list = CodeInsightTestFixtureImpl.instantiateAndRun(file2, editor, ArrayUtilRt.EMPTY_INT_ARRAY, myAllowDirt, readEditorMarkupModel);
        if (list == null) {
            EditorTestFixture.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    protected Editor getCompletionEditor() {
        Editor editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)this.myEditor, (PsiFile)this.getFile());
        if (editor == null) {
            EditorTestFixture.$$$reportNull$$$0(8);
        }
        return editor;
    }

    public LookupImpl getLookup() {
        return (LookupImpl)LookupManager.getActiveLookup((Editor)this.myEditor);
    }

    public LookupElement[] complete(@NotNull CompletionType type) {
        if (type == null) {
            EditorTestFixture.$$$reportNull$$$0(9);
        }
        return this.complete(type, 1);
    }

    public LookupElement[] completeBasic() {
        return this.complete(CompletionType.BASIC);
    }

    public LookupElement[] complete(@NotNull CompletionType type, int invocationCount) {
        if (type == null) {
            EditorTestFixture.$$$reportNull$$$0(10);
        }
        this.myEmptyLookup = false;
        ApplicationManager.getApplication().invokeAndWait(() -> CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            CodeCompletionHandlerBase handler = new CodeCompletionHandlerBase(type){

                protected void completionFinished(CompletionProgressIndicator indicator, boolean hasModifiers) {
                    EditorTestFixture.this.myEmptyLookup = indicator.getLookup().getItems().isEmpty();
                    super.completionFinished(indicator, hasModifiers);
                }
            };
            Editor editor = this.getCompletionEditor();
            Assert.assertNotNull((Object)editor);
            handler.invokeCompletion(this.myProject, editor, invocationCount);
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        }, null, null, this.myEditor.getDocument()));
        return this.getLookupElements();
    }

    public LookupElement @Nullable [] getLookupElements() {
        LookupImpl lookup = this.getLookup();
        if (lookup == null) {
            return this.myEmptyLookup ? LookupElement.EMPTY_ARRAY : null;
        }
        List list = lookup.getItems();
        return list.toArray(LookupElement.EMPTY_ARRAY);
    }

    public List<String> getLookupElementStrings() {
        Object[] elements = this.getLookupElements();
        if (elements == null) {
            return null;
        }
        return ContainerUtil.map((Object[])elements, LookupElement::getLookupString);
    }

    @NotNull
    public final List<LookupElement> completeBasicAllCarets(@Nullable Character charToTypeAfterCompletion) {
        CaretModel caretModel = this.myEditor.getCaretModel();
        List carets = caretModel.getAllCarets();
        ArrayList<Integer> originalOffsets = new ArrayList<Integer>(carets.size());
        for (Caret caret : carets) {
            originalOffsets.add(caret.getOffset());
        }
        caretModel.removeSecondaryCarets();
        Collections.reverse(originalOffsets);
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
        Iterator iterator = originalOffsets.iterator();
        while (iterator.hasNext()) {
            int originalOffset = (Integer)iterator.next();
            caretModel.moveToOffset(originalOffset);
            LookupElement[] lookupElements = this.completeBasic();
            if (charToTypeAfterCompletion != null) {
                this.type(charToTypeAfterCompletion.charValue());
            }
            if (lookupElements == null) continue;
            result2.addAll(Arrays.asList(lookupElements));
        }
        ArrayList<LookupElement> arrayList = result2;
        if (arrayList == null) {
            EditorTestFixture.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public void assertPreferredCompletionItems(int selected, String ... expected) {
        if (expected == null) {
            EditorTestFixture.$$$reportNull$$$0(12);
        }
        LookupImpl lookup = this.getLookup();
        Assert.assertNotNull((String)"No lookup is shown", (Object)lookup);
        JList list = lookup.getList();
        List<String> strings = this.getLookupElementStrings();
        Assert.assertNotNull(strings);
        List actual = ContainerUtil.getFirstItems(strings, (int)expected.length);
        if (!actual.equals(Arrays.asList(expected))) {
            UsefulTestCase.assertOrderedEquals(DumpLookupElementWeights.getLookupElementWeights((LookupImpl)lookup, (boolean)false), expected);
        }
        if (selected != list.getSelectedIndex()) {
            DumpLookupElementWeights.getLookupElementWeights((LookupImpl)lookup, (boolean)false).forEach(System.out::println);
        }
        Assert.assertEquals((long)selected, (long)list.getSelectedIndex());
    }

    public void finishLookup(char completionChar) {
        Runnable command = () -> {
            LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)this.myEditor);
            Assert.assertNotNull((Object)lookup);
            lookup.finishLookup(completionChar);
        };
        CommandProcessor.getInstance().executeCommand(this.myProject, command, null, null, this.myEditor.getDocument());
    }

    public PsiElement getElementAtCaret() {
        int findTargetFlags;
        Editor editor = this.getCompletionEditor();
        PsiElement element = TargetElementUtil.findTargetElement((Editor)editor, (int)(findTargetFlags = 3));
        if (element == null && editor instanceof EditorWindow) {
            element = TargetElementUtil.findTargetElement((Editor)((EditorWindow)editor).getDelegate(), (int)findTargetFlags);
        }
        if (element == null) {
            Assert.fail((String)("element not found in file " + this.myFile.getName() + " at caret position offset " + this.myEditor.getCaretModel().getOffset() + ", psi structure:\n" + DebugUtil.psiToString((PsiElement)this.getFile(), (boolean)false, (boolean)true)));
        }
        return element;
    }

    public <T extends PsiElement> T findElementByText(@NotNull String text, @NotNull Class<T> elementClass) {
        if (text == null) {
            EditorTestFixture.$$$reportNull$$$0(13);
        }
        if (elementClass == null) {
            EditorTestFixture.$$$reportNull$$$0(14);
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.getFile());
        Assert.assertNotNull((Object)document);
        int pos = document.getText().indexOf(text);
        Assert.assertTrue((String)text, (pos >= 0 ? 1 : 0) != 0);
        return (T)PsiTreeUtil.getParentOfType((PsiElement)this.getFile().findElementAt(pos), elementClass);
    }

    @NotNull
    public List<IntentionAction> getAllQuickFixes() {
        List<HighlightInfo> infos = this.doHighlighting();
        ArrayList<IntentionAction> actions = new ArrayList<IntentionAction>();
        for (HighlightInfo info : infos) {
            info.findRegisteredQuickFix((descriptor, range) -> {
                actions.add(descriptor.getAction());
                return null;
            });
        }
        ArrayList<IntentionAction> arrayList = actions;
        if (arrayList == null) {
            EditorTestFixture.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public List<Crumb> getBreadcrumbsAtCaret() {
        FileBreadcrumbsCollector breadcrumbsCollector = FileBreadcrumbsCollector.findBreadcrumbsCollector((Project)this.myProject, (VirtualFile)this.myFile);
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)breadcrumbsCollector.computeCrumbs(this.myFile, this.myEditor.getDocument(), this.myEditor.getCaretModel().getOffset(), Boolean.valueOf(true)));
        if (arrayList == null) {
            EditorTestFixture.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            EditorTestFixture.$$$reportNull$$$0(17);
        }
        return editor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 11, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/EditorTestFixture";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/EditorTestFixture";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorDataContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doHighlighting";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "completeBasicAllCarets";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllQuickFixes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreadcrumbsAtCaret";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performEditorAction";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "complete";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "assertPreferredCompletionItems";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findElementByText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 11, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

