/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.lexer.Compat;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J:\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rR\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rR\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0016"}, d2={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "()V", "getAlignmentInfo", "", "Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "populateRow", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "cellName", "alignmentInfo", "rowNumber", "", "processNode", "Alignment", "Companion", "markdown"})
public final class TablesGeneratingProvider
implements GeneratingProvider {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Alignment DEFAULT_ALIGNMENT;
    @NotNull
    private static final Regex SPLIT_REGEX;

    @Override
    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Compat compat = Compat.INSTANCE;
        boolean condition$iv = Intrinsics.areEqual((Object)node.getType(), (Object)GFMElementTypes.TABLE);
        boolean $i$f$assert = false;
        if (!condition$iv) {
            String string;
            String string2 = string = "";
            throw new MarkdownParsingException(string2);
        }
        List<Alignment> alignmentInfo = this.getAlignmentInfo(text, node);
        int rowsPopulated = 0;
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "table", new CharSequence[0], false, 8, null);
        for (ASTNode child : node.getChildren()) {
            if (Intrinsics.areEqual((Object)child.getType(), (Object)GFMElementTypes.HEADER)) {
                visitor.consumeHtml("<thead>");
                this.populateRow(visitor, child, "th", alignmentInfo, -1);
                visitor.consumeHtml("</thead>");
                continue;
            }
            if (!Intrinsics.areEqual((Object)child.getType(), (Object)GFMElementTypes.ROW)) continue;
            if (rowsPopulated == 0) {
                visitor.consumeHtml("<tbody>");
            }
            int n = rowsPopulated;
            rowsPopulated = n + 1;
            this.populateRow(visitor, child, "td", alignmentInfo, rowsPopulated);
        }
        if (rowsPopulated > 0) {
            visitor.consumeHtml("</tbody>");
        }
        visitor.consumeTagClose("table");
    }

    /*
     * WARNING - void declaration
     */
    private final void populateRow(HtmlGenerator.HtmlGeneratingVisitor visitor, ASTNode node, String cellName, List<? extends Alignment> alignmentInfo, int rowNumber) {
        int n;
        void $this$filterTo$iv$iv;
        String parityAttribute = rowNumber > 0 && rowNumber % 2 == 0 ? "class=\"intellij-row-even\"" : null;
        CharSequence[] charSequenceArray = new CharSequence[]{parityAttribute};
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "tr", charSequenceArray, false, 8, null);
        Iterable $this$filter$iv = node.getChildren();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)GFMTokenTypes.CELL)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (IndexedValue child : CollectionsKt.withIndex((Iterable)((List)destination$iv$iv))) {
            if (child.getIndex() >= alignmentInfo.size()) {
                throw new IllegalStateException("Too many cells in a row! Should check parser.");
            }
            Alignment alignment = alignmentInfo.get(child.getIndex());
            String alignmentAttribute = alignment.isDefault() ? null : "align=\"" + alignment.getHtmlName() + '\"';
            CharSequence[] charSequenceArray2 = new CharSequence[]{alignmentAttribute};
            HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, (ASTNode)child.getValue(), cellName, charSequenceArray2, false, 8, null);
            visitor.visitNode((ASTNode)child.getValue());
            visitor.consumeTagClose(cellName);
        }
        Iterable $this$count$iv = node.getChildren();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)GFMTokenTypes.CELL)) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n3 = n;
        int n4 = alignmentInfo.size() - 1;
        if (n3 <= n4) {
            int i;
            do {
                i = n3++;
                visitor.consumeHtml("<td></td>");
            } while (i != n4);
        }
        visitor.consumeTagClose("tr");
    }

    private final List<Alignment> getAlignmentInfo(String text, ASTNode node) {
        ASTNode aSTNode = ASTUtilKt.findChildOfType(node, GFMTokenTypes.TABLE_SEPARATOR);
        if (aSTNode == null) {
            throw new IllegalStateException("Could not find table separator");
        }
        ASTNode separatorRow = aSTNode;
        ArrayList<Alignment> result = new ArrayList<Alignment>();
        int n = 0;
        List cells = Regex.split$default((Regex)SPLIT_REGEX, (CharSequence)ASTUtilKt.getTextInNode(separatorRow, text), (int)0, (int)2, null);
        int n2 = cells.size() + -1;
        if (n <= n2) {
            do {
                int i;
                String cell;
                if (StringsKt.isBlank((CharSequence)(cell = (String)cells.get(i = n++)))) {
                    boolean bl = 1 <= i ? i <= CollectionsKt.getLastIndex((List)cells) - 1 : false;
                    if (!bl) continue;
                }
                String string = cell;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String trimmed = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                boolean starts = StringsKt.startsWith$default((CharSequence)trimmed, (char)':', (boolean)false, (int)2, null);
                boolean ends = StringsKt.endsWith$default((CharSequence)trimmed, (char)':', (boolean)false, (int)2, null);
                result.add(starts && ends ? Alignment.CENTER : (starts ? Alignment.LEFT : (ends ? Alignment.RIGHT : DEFAULT_ALIGNMENT)));
            } while (n <= n2);
        }
        return result;
    }

    static {
        Alignment alignment;
        block2: {
            Alignment alignment2;
            Companion = new Companion(null);
            Alignment[] alignmentArray = Alignment.values();
            boolean bl = false;
            Alignment[] alignmentArray2 = alignmentArray;
            boolean bl2 = false;
            Alignment[] alignmentArray3 = alignmentArray2;
            int n = alignmentArray3.length;
            for (int i = 0; i < n; ++i) {
                Alignment alignment3;
                Alignment it = alignment3 = alignmentArray3[i];
                boolean bl3 = false;
                if (!it.isDefault()) continue;
                alignment2 = alignment3;
                break block2;
            }
            alignment2 = alignment = null;
        }
        if (alignment == null) {
            throw new IllegalStateException("Must me default alignment");
        }
        DEFAULT_ALIGNMENT = alignment;
        SPLIT_REGEX = new Regex("\\|");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "", "htmlName", "", "isDefault", "", "(Ljava/lang/String;ILjava/lang/String;Z)V", "getHtmlName", "()Ljava/lang/String;", "()Z", "LEFT", "CENTER", "RIGHT", "markdown"})
    public static final class Alignment
    extends Enum<Alignment> {
        @NotNull
        private final String htmlName;
        private final boolean isDefault;
        public static final /* enum */ Alignment LEFT = new Alignment("left", true);
        public static final /* enum */ Alignment CENTER = new Alignment("center", false);
        public static final /* enum */ Alignment RIGHT = new Alignment("right", false);
        private static final /* synthetic */ Alignment[] $VALUES;

        private Alignment(String htmlName, boolean isDefault) {
            this.htmlName = htmlName;
            this.isDefault = isDefault;
        }

        @NotNull
        public final String getHtmlName() {
            return this.htmlName;
        }

        public final boolean isDefault() {
            return this.isDefault;
        }

        public static Alignment[] values() {
            return (Alignment[])$VALUES.clone();
        }

        public static Alignment valueOf(String value) {
            return Enum.valueOf(Alignment.class, value);
        }

        static {
            $VALUES = alignmentArray = new Alignment[]{Alignment.LEFT, Alignment.CENTER, Alignment.RIGHT};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Companion;", "", "()V", "DEFAULT_ALIGNMENT", "Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "getDEFAULT_ALIGNMENT", "()Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "SPLIT_REGEX", "Lkotlin/text/Regex;", "getSPLIT_REGEX", "()Lkotlin/text/Regex;", "markdown"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Alignment getDEFAULT_ALIGNMENT() {
            return DEFAULT_ALIGNMENT;
        }

        @NotNull
        public final Regex getSPLIT_REGEX() {
            return SPLIT_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

