/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.CollectionFactory;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.ShellStartupOptionsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u001a*\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0014\b\u0002\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001H\u0007\u001a*\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bH\u0007\u00a8\u0006\u000b"}, d2={"createEnvVariablesMap", "", "", "content", "shellStartupOptions", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions;", "workingDirectory", "modifier", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions$Builder;", "", "intellij.terminal"})
public final class ShellStartupOptionsKt {
    @JvmOverloads
    @NotNull
    public static final ShellStartupOptions shellStartupOptions(@Nullable String workingDirectory, @Nullable Function1<? super ShellStartupOptions.Builder, Unit> modifier) {
        ShellStartupOptions.Builder builder = new ShellStartupOptions.Builder().workingDirectory(workingDirectory);
        Function1 function1 = modifier;
        if (function1 == null) {
            function1 = shellStartupOptions.1.INSTANCE;
        }
        return builder.modify(function1).build();
    }

    public static /* synthetic */ ShellStartupOptions shellStartupOptions$default(String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return ShellStartupOptionsKt.shellStartupOptions(string, (Function1<? super ShellStartupOptions.Builder, Unit>)function1);
    }

    @JvmOverloads
    @NotNull
    public static final Map<String, String> createEnvVariablesMap(@NotNull Map<String, String> content) {
        Map map;
        Intrinsics.checkNotNullParameter(content, (String)"content");
        if (SystemInfo.isWindows) {
            Map map2 = CollectionFactory.createCaseInsensitiveStringMap(content);
            map = map2;
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createCaseInsensitiveStringMap(content)");
        } else {
            map = new HashMap<String, String>(content);
        }
        return map;
    }

    public static /* synthetic */ Map createEnvVariablesMap$default(Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        return ShellStartupOptionsKt.createEnvVariablesMap(map);
    }

    @JvmOverloads
    @NotNull
    public static final ShellStartupOptions shellStartupOptions(@Nullable String workingDirectory) {
        return ShellStartupOptionsKt.shellStartupOptions$default(workingDirectory, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final Map<String, String> createEnvVariablesMap() {
        return ShellStartupOptionsKt.createEnvVariablesMap$default(null, 1, null);
    }
}

