/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.ConversionRunner;
import com.intellij.impl.ConversionServiceImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0002\u001a\u00020\u00032\u0010\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getProviderId", "", "supplier", "Ljava/util/function/Supplier;", "Lcom/intellij/conversion/ConverterProvider;", "id", "isConversionNeeded", "", "Lcom/intellij/conversion/impl/ConversionRunner;", "context", "Lcom/intellij/conversion/impl/ConversionContextImpl;", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nConversionServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversionServiceImpl.kt\ncom/intellij/impl/ConversionServiceImplKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,242:1\n10#2:243\n*S KotlinDebug\n*F\n+ 1 ConversionServiceImpl.kt\ncom/intellij/impl/ConversionServiceImplKt\n*L\n181#1:243\n*E\n"})
public final class ConversionServiceImplKt {
    @NotNull
    private static final Logger LOG;

    private static final List<ConversionRunner> isConversionNeeded(ConversionContextImpl context) {
        try {
            Object2LongMap object2LongMap = context.getProjectFileTimestamps();
            Intrinsics.checkNotNullExpressionValue((Object)object2LongMap, (String)"context.projectFileTimestamps");
            Object2LongMap oldMap = object2LongMap;
            boolean changed2 = false;
            if (oldMap.isEmpty()) {
                LOG.debug("conversion will be performed because no information about project files");
            } else {
                Object2LongMap object2LongMap2 = context.getAllProjectFiles();
                Intrinsics.checkNotNullExpressionValue((Object)object2LongMap2, (String)"context.allProjectFiles");
                Object2LongMap newMap = object2LongMap2;
                LOG.debug("Checking project files");
                ObjectIterator iterator = Object2LongMaps.fastIterator((Object2LongMap)newMap);
                while (iterator.hasNext()) {
                    Object2LongMap.Entry entry2 = (Object2LongMap.Entry)iterator.next();
                    String path2 = (String)entry2.getKey();
                    long oldValue = oldMap.getLong((Object)path2);
                    long newValue = entry2.getLongValue();
                    if (newValue == oldValue) continue;
                    LOG.info("conversion will be performed because at least " + path2 + " is changed (oldLastModified=" + oldValue + ", newLastModified=" + newValue + ")");
                    changed2 = true;
                    break;
                }
            }
            Set performedConversionIds = null;
            if (changed2) {
                performedConversionIds = SetsKt.emptySet();
            } else {
                Set set = context.getAppliedConverters();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"context.appliedConverters");
                performedConversionIds = set;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Project files are up to date. Applied converters: " + performedConversionIds);
                }
            }
            ArrayList<ConversionRunner> runners = new ArrayList<ConversionRunner>();
            ExtensionPoint extensionPoint = ConverterProvider.EP_NAME.getPoint();
            Intrinsics.checkNotNull((Object)extensionPoint, (String)"null cannot be cast to non-null type com.intellij.openapi.extensions.impl.ExtensionPointImpl<com.intellij.conversion.ConverterProvider>");
            ExtensionPointImpl point = (ExtensionPointImpl)extensionPoint;
            point.processIdentifiableImplementations((arg_0, arg_1) -> ConversionServiceImplKt.isConversionNeeded$lambda$0((Function2)new Function2<Supplier<? extends ConverterProvider>, String, Unit>((Set<String>)performedConversionIds, context, runners){
                final /* synthetic */ Set<String> $performedConversionIds;
                final /* synthetic */ ConversionContextImpl $context;
                final /* synthetic */ ArrayList<ConversionRunner> $runners;
                {
                    this.$performedConversionIds = $performedConversionIds;
                    this.$context = $context;
                    this.$runners = $runners;
                    super(2);
                }

                public final void invoke(@NotNull Supplier<? extends ConverterProvider> supplier2, @Nullable String id) {
                    ConversionRunner runner;
                    ConverterProvider provider;
                    Intrinsics.checkNotNullParameter(supplier2, (String)"supplier");
                    String providerId = ConversionServiceImplKt.access$getProviderId(supplier2, id);
                    if (!this.$performedConversionIds.contains(providerId) && (provider = supplier2.get()) != null && (runner = new ConversionRunner(providerId, provider, this.$context)).isConversionNeeded()) {
                        this.$runners.add(runner);
                    }
                }
            }, arg_0, arg_1));
            return runners;
        }
        catch (CannotConvertException e) {
            LOG.info("Cannot check whether conversion of project files is needed or not, conversion won't be performed", (Throwable)e);
            return CollectionsKt.emptyList();
        }
    }

    private static final String getProviderId(Supplier<? extends ConverterProvider> supplier2, String id) {
        String string2 = id;
        if (string2 == null) {
            ConverterProvider converterProvider = supplier2.get();
            Intrinsics.checkNotNull((Object)converterProvider);
            String string3 = converterProvider.getDeprecatedId();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"supplier.get()!!.deprecatedId");
        }
        return string2;
    }

    private static final void isConversionNeeded$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ List access$isConversionNeeded(ConversionContextImpl context) {
        return ConversionServiceImplKt.isConversionNeeded(context);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ String access$getProviderId(Supplier supplier2, String id) {
        return ConversionServiceImplKt.getProviderId(supplier2, id);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ConversionServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }
}

