/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.CurrentRevisionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsCurrentRevisionProxy
implements ByteBackedContentRevision {
    @NotNull
    private final DiffProvider myDiffProvider;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsKey myVcsKey;

    @Nullable
    public static VcsCurrentRevisionProxy create(@NotNull VirtualFile file, @NotNull Project project2) {
        DiffProvider diffProvider;
        AbstractVcs vcs;
        if (file == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(1);
        }
        if ((vcs = ProjectLevelVcsManager.getInstance(project2).getVcsFor(file)) != null && (diffProvider = vcs.getDiffProvider()) != null) {
            return new VcsCurrentRevisionProxy(diffProvider, file, project2, vcs.getKeyInstanceMethod());
        }
        return null;
    }

    private VcsCurrentRevisionProxy(@NotNull DiffProvider diffProvider, @NotNull VirtualFile file, @NotNull Project project2, @NotNull VcsKey vcsKey) {
        if (diffProvider == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(2);
        }
        if (file == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(4);
        }
        if (vcsKey == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(5);
        }
        this.myDiffProvider = diffProvider;
        this.myFile = file;
        this.myProject = project2;
        this.myVcsKey = vcsKey;
    }

    @Override
    @Nullable
    public String getContent() throws VcsException {
        return ContentRevisionCache.getAsString(this.getContentAsBytes(), this.getFile(), this.myFile.getCharset());
    }

    @Override
    public byte @Nullable [] getContentAsBytes() throws VcsException {
        return (byte[])this.getVcsRevision().second;
    }

    @Override
    @NotNull
    public FilePath getFile() {
        FilePath filePath = VcsUtil.getFilePath(this.myFile);
        if (filePath == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(6);
        }
        return filePath;
    }

    @Override
    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber;
        try {
            vcsRevisionNumber = (VcsRevisionNumber)this.getVcsRevision().first;
        }
        catch (VcsException ex) {
            VcsRevisionNumber vcsRevisionNumber2 = VcsRevisionNumber.NULL;
            if (vcsRevisionNumber2 == null) {
                VcsCurrentRevisionProxy.$$$reportNull$$$0(8);
            }
            return vcsRevisionNumber2;
        }
        if (vcsRevisionNumber == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(7);
        }
        return vcsRevisionNumber;
    }

    @NotNull
    private Pair<VcsRevisionNumber, byte[]> getVcsRevision() throws VcsException {
        Pair<VcsRevisionNumber, byte[]> pair;
        try {
            pair = ContentRevisionCache.getOrLoadCurrentAsBytes(this.myProject, this.getFile(), this.myVcsKey, new CurrentRevisionProvider(){

                @Override
                public VcsRevisionNumber getCurrentRevision() throws VcsException {
                    return VcsCurrentRevisionProxy.this.getCurrentRevisionNumber();
                }

                @Override
                public Pair<VcsRevisionNumber, byte[]> get() throws VcsException {
                    return VcsCurrentRevisionProxy.this.loadContent();
                }
            });
        }
        catch (IOException e) {
            throw new VcsException(e);
        }
        if (pair == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(9);
        }
        return pair;
    }

    @NotNull
    private VcsRevisionNumber getCurrentRevisionNumber() throws VcsException {
        VcsRevisionNumber currentRevision = this.myDiffProvider.getCurrentRevision(this.myFile);
        if (currentRevision == null) {
            throw new VcsException(VcsBundle.message("changes.error.failed.to.fetch.current.revision", new Object[0]));
        }
        VcsRevisionNumber vcsRevisionNumber = currentRevision;
        if (vcsRevisionNumber == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(10);
        }
        return vcsRevisionNumber;
    }

    @NotNull
    private Pair<VcsRevisionNumber, byte[]> loadContent() throws VcsException {
        byte[] bytes;
        VcsRevisionNumber currentRevision = this.getCurrentRevisionNumber();
        ContentRevision contentRevision = this.myDiffProvider.createFileContent(currentRevision, this.myFile);
        if (contentRevision == null) {
            throw new VcsException(VcsBundle.message("changes.error.failed.to.create.content.for.current.revision", new Object[0]));
        }
        if (contentRevision instanceof ByteBackedContentRevision) {
            bytes = ((ByteBackedContentRevision)contentRevision).getContentAsBytes();
        } else {
            String content = contentRevision.getContent();
            if (content == null) {
                throw new VcsException(VcsBundle.message("changes.error.can.t.get.revision.content", new Object[0]));
            }
            bytes = content.getBytes(this.myFile.getCharset());
        }
        Pair pair = Pair.create((Object)currentRevision, (Object)bytes);
        if (pair == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(11);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsKey";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsRevision";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentRevisionNumber";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string2);
        };
    }
}

