/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.util.treeView.FileNameComparator;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.HierarchicalFilePathComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public final class ChangesComparator {
    private static final Comparator<VirtualFile> VIRTUAL_FILE_FLAT = new VirtualFileComparator(true);
    private static final Comparator<VirtualFile> VIRTUAL_FILE_TREE = new VirtualFileComparator(false);
    private static final Comparator<Change> CHANGE_FLAT = new ChangeComparator(true);
    private static final Comparator<Change> CHANGE_TREE = new ChangeComparator(false);
    private static final Comparator<FilePath> FILE_PATH_FLAT = new FilePathComparator(true);
    private static final Comparator<FilePath> FILE_PATH_TREE = new FilePathComparator(false);

    @NotNull
    public static Comparator<Change> getInstance(boolean flattened) {
        Comparator<Change> comparator2 = flattened ? CHANGE_FLAT : CHANGE_TREE;
        if (comparator2 == null) {
            ChangesComparator.$$$reportNull$$$0(0);
        }
        return comparator2;
    }

    @NotNull
    public static Comparator<VirtualFile> getVirtualFileComparator(boolean flattened) {
        Comparator<VirtualFile> comparator2 = flattened ? VIRTUAL_FILE_FLAT : VIRTUAL_FILE_TREE;
        if (comparator2 == null) {
            ChangesComparator.$$$reportNull$$$0(1);
        }
        return comparator2;
    }

    @NotNull
    public static Comparator<FilePath> getFilePathComparator(boolean flattened) {
        Comparator<FilePath> comparator2 = flattened ? FILE_PATH_FLAT : FILE_PATH_TREE;
        if (comparator2 == null) {
            ChangesComparator.$$$reportNull$$$0(2);
        }
        return comparator2;
    }

    private static int comparePaths(@NotNull FilePath filePath1, @NotNull FilePath filePath2, boolean flattened) {
        int delta;
        if (filePath1 == null) {
            ChangesComparator.$$$reportNull$$$0(3);
        }
        if (filePath2 == null) {
            ChangesComparator.$$$reportNull$$$0(4);
        }
        if (flattened && (delta = FileNameComparator.INSTANCE.compare(filePath1.getName(), filePath2.getName())) != 0) {
            return delta;
        }
        return HierarchicalFilePathComparator.NATURAL.compare(filePath1, filePath2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesComparator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFileComparator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathComparator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesComparator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "comparePaths";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 3, 4 -> new IllegalArgumentException(string2);
        };
    }

    private static class VirtualFileComparator
    implements Comparator<VirtualFile> {
        private final boolean myFlattened;

        VirtualFileComparator(boolean flattened) {
            this.myFlattened = flattened;
        }

        @Override
        public int compare(VirtualFile o1, VirtualFile o2) {
            return ChangesComparator.comparePaths(VcsUtil.getFilePath(o1), VcsUtil.getFilePath(o2), this.myFlattened);
        }
    }

    private static class ChangeComparator
    implements Comparator<Change> {
        private final boolean myFlattened;

        ChangeComparator(boolean flattened) {
            this.myFlattened = flattened;
        }

        @Override
        public int compare(Change o1, Change o2) {
            int delta = ChangesComparator.comparePaths(ChangesUtil.getFilePath(o1), ChangesUtil.getFilePath(o2), this.myFlattened);
            if (delta != 0) {
                return delta;
            }
            if (o1 instanceof ChangeListChange || o2 instanceof ChangeListChange) {
                if (o1 instanceof ChangeListChange && o2 instanceof ChangeListChange) {
                    String changeList1 = ((ChangeListChange)o1).getChangeListName();
                    String changeList2 = ((ChangeListChange)o2).getChangeListName();
                    return changeList1.compareToIgnoreCase(changeList2);
                }
                return o1 instanceof ChangeListChange ? 1 : -1;
            }
            return 0;
        }
    }

    private static class FilePathComparator
    implements Comparator<FilePath> {
        private final boolean myFlattened;

        FilePathComparator(boolean flattened) {
            this.myFlattened = flattened;
        }

        @Override
        public int compare(FilePath o1, FilePath o2) {
            return ChangesComparator.comparePaths(o1, o2, this.myFlattened);
        }
    }
}

