/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.ui.BasicDomElementComponent;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.CompositeCommittable;
import com.intellij.util.xml.ui.DomUIControl;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.List;

public class DomUINavigationProvider
extends DomElementNavigationProvider {
    public static String DOM_UI_NAVIGATION_PROVIDER_NAME = "DOM_UI_NAVIGATION_PROVIDER_NAME";
    private final CompositeCommittable myComponent;

    public DomUINavigationProvider(CompositeCommittable component2) {
        this.myComponent = component2;
    }

    @Override
    public String getProviderName() {
        return DOM_UI_NAVIGATION_PROVIDER_NAME;
    }

    @Override
    public void navigate(DomElement domElement, boolean requestFocus) {
        DomUIControl domUIControl = DomUINavigationProvider.findDomControl(this.myComponent, domElement);
        if (domUIControl != null) {
            domUIControl.navigate(domElement);
        }
    }

    @Override
    public boolean canNavigate(DomElement domElement) {
        return DomUINavigationProvider.findDomControl(this.myComponent, domElement) != null;
    }

    public static DomElement findDomElement(BasicDomElementComponent compositCommitable) {
        DomElement domElement;
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (component2 != null && (domElement = DomUINavigationProvider.findDomElement(compositCommitable, component2)) != null) {
            return domElement;
        }
        return compositCommitable.getDomElement();
    }

    public static DomElement findDomElement(CompositeCommittable compositCommitable, Component component2) {
        List<Committable> list = compositCommitable.getChildren();
        for (Committable committable : list) {
            DomElement element;
            if (committable instanceof DomUIControl) {
                DomUIControl uiControl = (DomUIControl)committable;
                if (!uiControl.getComponent().isAncestorOf(component2)) continue;
                return uiControl.getDomElement();
            }
            if (!(committable instanceof CompositeCommittable) || (element = DomUINavigationProvider.findDomElement((CompositeCommittable)committable, component2)) == null) continue;
            return element;
        }
        return null;
    }

    public static DomUIControl findDomControl(CompositeCommittable compositCommitable, DomElement domElement) {
        List<Committable> list = compositCommitable.getChildren();
        for (Committable committable : list) {
            DomUIControl control;
            if (committable instanceof DomUIControl) {
                if (!((DomUIControl)committable).canNavigate(domElement)) continue;
                return (DomUIControl)committable;
            }
            if (!(committable instanceof CompositeCommittable) || (control = DomUINavigationProvider.findDomControl((CompositeCommittable)committable, domElement)) == null) continue;
            return control;
        }
        return null;
    }
}

