/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.linearBek;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.collapsing.EdgeStorageWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearBekGraph
implements LinearGraph {
    @NotNull
    protected final LinearGraph myGraph;
    @NotNull
    protected final EdgeStorageWrapper myHiddenEdges;
    @NotNull
    protected final EdgeStorageWrapper myDottedEdges;

    public LinearBekGraph(@NotNull LinearGraph graph) {
        if (graph == null) {
            LinearBekGraph.$$$reportNull$$$0(0);
        }
        this.myGraph = graph;
        this.myHiddenEdges = EdgeStorageWrapper.createSimpleEdgeStorage();
        this.myDottedEdges = EdgeStorageWrapper.createSimpleEdgeStorage();
    }

    @Override
    public int nodesCount() {
        return this.myGraph.nodesCount();
    }

    @Override
    @NotNull
    public List<GraphEdge> getAdjacentEdges(int nodeIndex, @NotNull EdgeFilter filter2) {
        if (filter2 == null) {
            LinearBekGraph.$$$reportNull$$$0(1);
        }
        ArrayList<GraphEdge> result2 = new ArrayList<GraphEdge>();
        result2.addAll(this.myDottedEdges.getAdjacentEdges(nodeIndex, filter2));
        result2.addAll(this.myGraph.getAdjacentEdges(nodeIndex, filter2));
        result2.removeAll(this.myHiddenEdges.getAdjacentEdges(nodeIndex, filter2));
        ArrayList<GraphEdge> arrayList = result2;
        if (arrayList == null) {
            LinearBekGraph.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public GraphNode getGraphNode(int nodeIndex) {
        GraphNode graphNode = this.myGraph.getGraphNode(nodeIndex);
        if (graphNode == null) {
            LinearBekGraph.$$$reportNull$$$0(3);
        }
        return graphNode;
    }

    @Override
    public int getNodeId(int nodeIndex) {
        return this.myGraph.getNodeId(nodeIndex);
    }

    @Override
    @Nullable
    public Integer getNodeIndex(int nodeId) {
        return this.myGraph.getNodeIndex(nodeId);
    }

    public Collection<GraphEdge> expandEdge(@NotNull GraphEdge edge) {
        if (edge == null) {
            LinearBekGraph.$$$reportNull$$$0(4);
        }
        HashSet<GraphEdge> result2 = new HashSet<GraphEdge>();
        assert (edge.getType() == GraphEdgeType.DOTTED);
        this.myDottedEdges.removeEdge(edge);
        Integer tail = edge.getUpNodeIndex();
        Integer firstChild = edge.getDownNodeIndex();
        assert (tail != null) : "Collapsed from to an unloaded node";
        assert (firstChild != null) : "Collapsed edge to an unloaded node";
        List<GraphEdge> downDottedEdges = this.myHiddenEdges.getAdjacentEdges(tail, EdgeFilter.NORMAL_DOWN);
        List<GraphEdge> upDottedEdges = this.myHiddenEdges.getAdjacentEdges(firstChild, EdgeFilter.NORMAL_UP);
        for (GraphEdge e : ContainerUtil.concat(downDottedEdges, upDottedEdges)) {
            this.myHiddenEdges.removeEdge(e);
            if (e.getType() == GraphEdgeType.DOTTED) {
                result2.addAll(this.expandEdge(e));
                continue;
            }
            result2.add(e);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/linearBek/LinearBekGraph";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/linearBek/LinearBekGraph";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjacentEdges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAdjacentEdges";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "expandEdge";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }

    public static class WorkingLinearBekGraph
    extends LinearBekGraph {
        private final LinearBekGraph myLinearGraph;

        public WorkingLinearBekGraph(@NotNull LinearBekGraph graph) {
            if (graph == null) {
                WorkingLinearBekGraph.$$$reportNull$$$0(0);
            }
            super(graph.myGraph);
            this.myLinearGraph = graph;
        }

        public Collection<GraphEdge> getAddedEdges() {
            Set<GraphEdge> result2 = this.myDottedEdges.getEdges();
            result2.removeAll(ContainerUtil.filter(this.myHiddenEdges.getEdges(), graphEdge -> graphEdge.getType() == GraphEdgeType.DOTTED));
            result2.removeAll(this.myLinearGraph.myDottedEdges.getEdges());
            return result2;
        }

        public Collection<GraphEdge> getRemovedEdges() {
            HashSet<GraphEdge> result2 = new HashSet<GraphEdge>();
            Set<GraphEdge> hidden = this.myHiddenEdges.getEdges();
            result2.addAll(ContainerUtil.filter(hidden, graphEdge -> graphEdge.getType() != GraphEdgeType.DOTTED));
            result2.addAll(ContainerUtil.intersection(hidden, this.myLinearGraph.myDottedEdges.getEdges()));
            result2.removeAll(this.myLinearGraph.myHiddenEdges.getEdges());
            return result2;
        }

        public void applyChanges() {
            this.myLinearGraph.myDottedEdges.removeAll();
            this.myLinearGraph.myHiddenEdges.removeAll();
            for (GraphEdge e : this.myDottedEdges.getEdges()) {
                this.myLinearGraph.myDottedEdges.createEdge(e);
            }
            for (GraphEdge e : this.myHiddenEdges.getEdges()) {
                this.myLinearGraph.myHiddenEdges.createEdge(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/linearBek/LinearBekGraph$WorkingLinearBekGraph", "<init>"));
        }
    }
}

