/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.util.containers.Stack;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.utils.GraphUtilKt;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import com.intellij.vcs.log.history.FileHistoryData;
import com.intellij.vcs.log.history.FileHistoryRefinerKt;
import com.intellij.vcs.log.history.MaybeDeletedFilePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ&\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00062\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0016H\u0002JB\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J(\u0010 \u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J4\u0010#\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0$\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060%0\u00192\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\fJ \u0010(\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryRefiner;", "", "visibleLinearGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "permanentGraphInfo", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "", "historyData", "Lcom/intellij/vcs/log/history/FileHistoryData;", "(Lcom/intellij/vcs/log/graph/api/LinearGraph;Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;Lcom/intellij/vcs/log/history/FileHistoryData;)V", "pathsForCommits", "Ljava/util/HashMap;", "Lcom/intellij/vcs/log/history/MaybeDeletedFilePath;", "permanentCommitsInfo", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentCommitsInfo;", "permanentLinearGraph", "Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;", "visibilityBuffer", "Lcom/intellij/vcs/log/graph/utils/impl/BitSetFlags;", "findPathWithoutConflict", "nodeId", "pathGetter", "Lkotlin/Function1;", "getNextNodes", "", "Lkotlin/Pair;", "graph", "visited", "currentNode", "currentPath", "down", "", "getPath", "previousNode", "previousPath", "refine", "", "", "row", "startPath", "walk", "", "startNode", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistoryRefiner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryRefiner.kt\ncom/intellij/vcs/log/history/FileHistoryRefiner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1855#2,2:158\n819#2:161\n847#2,2:162\n1549#2:164\n1620#2,3:165\n1#3:160\n*S KotlinDebug\n*F\n+ 1 FileHistoryRefiner.kt\ncom/intellij/vcs/log/history/FileHistoryRefiner\n*L\n34#1:158,2\n133#1:161\n133#1:162,2\n133#1:164\n133#1:165,3\n*E\n"})
public final class FileHistoryRefiner {
    @NotNull
    private final LinearGraph visibleLinearGraph;
    @NotNull
    private final FileHistoryData historyData;
    @NotNull
    private final PermanentCommitsInfo<Integer> permanentCommitsInfo;
    @NotNull
    private final LiteLinearGraph permanentLinearGraph;
    @NotNull
    private final BitSetFlags visibilityBuffer;
    @NotNull
    private final HashMap<Integer, MaybeDeletedFilePath> pathsForCommits;

    public FileHistoryRefiner(@NotNull LinearGraph visibleLinearGraph, @NotNull PermanentGraphInfo<Integer> permanentGraphInfo, @NotNull FileHistoryData historyData) {
        Intrinsics.checkNotNullParameter((Object)visibleLinearGraph, (String)"visibleLinearGraph");
        Intrinsics.checkNotNullParameter(permanentGraphInfo, (String)"permanentGraphInfo");
        Intrinsics.checkNotNullParameter((Object)historyData, (String)"historyData");
        this.visibleLinearGraph = visibleLinearGraph;
        this.historyData = historyData;
        PermanentCommitsInfo<Integer> permanentCommitsInfo = permanentGraphInfo.getPermanentCommitsInfo();
        Intrinsics.checkNotNullExpressionValue(permanentCommitsInfo, (String)"permanentGraphInfo.permanentCommitsInfo");
        this.permanentCommitsInfo = permanentCommitsInfo;
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph(permanentGraphInfo.getLinearGraph());
        Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"asLiteLinearGraph(permanentGraphInfo.linearGraph)");
        this.permanentLinearGraph = liteLinearGraph;
        this.visibilityBuffer = new BitSetFlags(this.permanentLinearGraph.nodesCount());
        this.pathsForCommits = new HashMap();
    }

    @NotNull
    public final Pair<Map<Integer, MaybeDeletedFilePath>, Set<Integer>> refine(int row2, @NotNull MaybeDeletedFilePath startPath) {
        Intrinsics.checkNotNullParameter((Object)startPath, (String)"startPath");
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph(this.visibleLinearGraph);
        Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"asLiteLinearGraph(visibleLinearGraph)");
        this.walk(liteLinearGraph, row2, startPath);
        HashSet<Integer> excluded = new HashSet<Integer>();
        for (Map.Entry entry2 : ((Map)this.pathsForCommits).entrySet()) {
            MaybeDeletedFilePath path2;
            int commit2 = ((Number)entry2.getKey()).intValue();
            if (this.historyData.affects(commit2, path2 = (MaybeDeletedFilePath)entry2.getValue(), true)) continue;
            excluded.add(commit2);
        }
        Iterable $this$forEach$iv = excluded;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            this.pathsForCommits.remove(it);
        }
        return new Pair(this.pathsForCommits, excluded);
    }

    private final void walk(LiteLinearGraph graph, int startNode, MaybeDeletedFilePath startPath) {
        Pair pair;
        if (startNode < 0 || startNode >= graph.nodesCount()) {
            return;
        }
        BitSetFlags visited = new BitSetFlags(graph.nodesCount(), false);
        Pair $this$walk_u24lambda_u241 = pair = new LinkedList();
        boolean bl = false;
        $this$walk_u24lambda_u241.add(new Pair((Object)startNode, (Object)startPath));
        Queue starts = (Queue)pair;
        while (!((Collection)starts).isEmpty()) {
            pair = (Pair)starts.poll();
            int nextStart = ((Number)pair.component1()).intValue();
            MaybeDeletedFilePath nextStartPath = (MaybeDeletedFilePath)pair.component2();
            if (visited.get(nextStart)) continue;
            Pair[] pairArray = new Pair[]{new Pair((Object)nextStart, (Object)nextStartPath)};
            Stack stack = new Stack((Object[])pairArray);
            block1: while (!stack.empty()) {
                MaybeDeletedFilePath nextPath;
                int nextNode;
                pairArray = (Pair[])stack.peek();
                int currentNode = ((Number)pairArray.component1()).intValue();
                MaybeDeletedFilePath currentPath = (MaybeDeletedFilePath)pairArray.component2();
                boolean down = FileHistoryRefinerKt.access$isDown(stack);
                if (!visited.get(currentNode)) {
                    visited.set(currentNode, true);
                    Iterator<Pair<Integer, MaybeDeletedFilePath>> iterator = this.pathsForCommits;
                    Integer n = this.permanentCommitsInfo.getCommitId(this.visibleLinearGraph.getNodeId(currentNode));
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"permanentCommitsInfo.get\u2026h.getNodeId(currentNode))");
                    iterator.put(n, currentPath);
                }
                for (Pair<Integer, MaybeDeletedFilePath> pair2 : this.getNextNodes(graph, visited, currentNode, currentPath, down)) {
                    nextNode = ((Number)pair2.component1()).intValue();
                    nextPath = (MaybeDeletedFilePath)pair2.component2();
                    if (!currentPath.getDeleted() && nextPath.getDeleted()) {
                        starts.add(new Pair((Object)nextNode, (Object)nextPath));
                        continue;
                    }
                    stack.push((Object)new Pair((Object)nextNode, (Object)nextPath));
                    continue block1;
                }
                for (Pair<Integer, MaybeDeletedFilePath> pair2 : this.getNextNodes(graph, visited, currentNode, currentPath, !down)) {
                    nextNode = ((Number)pair2.component1()).intValue();
                    nextPath = (MaybeDeletedFilePath)pair2.component2();
                    if (!currentPath.getDeleted() && nextPath.getDeleted()) {
                        starts.add(new Pair((Object)nextNode, (Object)nextPath));
                        continue;
                    }
                    stack.push((Object)new Pair((Object)nextNode, (Object)nextPath));
                    continue block1;
                }
                stack.pop();
            }
        }
    }

    private final MaybeDeletedFilePath getPath(int currentNode, int previousNode, MaybeDeletedFilePath previousPath, boolean down) {
        if (previousNode == -1) {
            return previousPath;
        }
        int previousNodeId = this.visibleLinearGraph.getNodeId(previousNode);
        int currentNodeId = this.visibleLinearGraph.getNodeId(currentNode);
        if (down) {
            Integer n = this.permanentCommitsInfo.getCommitId(previousNodeId);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"permanentCommitsInfo.getCommitId(previousNodeId)");
            int previousCommit = ((Number)n).intValue();
            Function1 pathGetter2 = (Function1)new Function1<Integer, MaybeDeletedFilePath>(this, previousCommit, previousPath){
                final /* synthetic */ FileHistoryRefiner this$0;
                final /* synthetic */ int $previousCommit;
                final /* synthetic */ MaybeDeletedFilePath $previousPath;
                {
                    this.this$0 = $receiver;
                    this.$previousCommit = $previousCommit;
                    this.$previousPath = $previousPath;
                    super(1);
                }

                @NotNull
                public final MaybeDeletedFilePath invoke(int parentIndex) {
                    FileHistoryData fileHistoryData = FileHistoryRefiner.access$getHistoryData$p(this.this$0);
                    CommitId CommitId2 = FileHistoryRefiner.access$getPermanentCommitsInfo$p(this.this$0).getCommitId(parentIndex);
                    Intrinsics.checkNotNullExpressionValue(CommitId2, (String)"permanentCommitsInfo.getCommitId(parentIndex)");
                    return fileHistoryData.getPathInParentRevision(this.$previousCommit, ((Number)CommitId2).intValue(), this.$previousPath);
                }
            };
            MaybeDeletedFilePath path2 = this.findPathWithoutConflict(previousNodeId, (Function1<? super Integer, MaybeDeletedFilePath>)pathGetter2);
            MaybeDeletedFilePath maybeDeletedFilePath = path2;
            if (maybeDeletedFilePath == null) {
                maybeDeletedFilePath = (MaybeDeletedFilePath)pathGetter2.invoke((Object)GraphUtilKt.getCorrespondingParent(this.permanentLinearGraph, previousNodeId, currentNodeId, this.visibilityBuffer));
            }
            return maybeDeletedFilePath;
        }
        Integer n = this.permanentCommitsInfo.getCommitId(currentNodeId);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"permanentCommitsInfo.getCommitId(currentNodeId)");
        int currentCommit = ((Number)n).intValue();
        Function1 pathGetter3 = (Function1)new Function1<Integer, MaybeDeletedFilePath>(this, currentCommit, previousPath){
            final /* synthetic */ FileHistoryRefiner this$0;
            final /* synthetic */ int $currentCommit;
            final /* synthetic */ MaybeDeletedFilePath $previousPath;
            {
                this.this$0 = $receiver;
                this.$currentCommit = $currentCommit;
                this.$previousPath = $previousPath;
                super(1);
            }

            @NotNull
            public final MaybeDeletedFilePath invoke(int parentIndex) {
                FileHistoryData fileHistoryData = FileHistoryRefiner.access$getHistoryData$p(this.this$0);
                CommitId CommitId2 = FileHistoryRefiner.access$getPermanentCommitsInfo$p(this.this$0).getCommitId(parentIndex);
                Intrinsics.checkNotNullExpressionValue(CommitId2, (String)"permanentCommitsInfo.getCommitId(parentIndex)");
                return fileHistoryData.getPathInChildRevision(this.$currentCommit, ((Number)CommitId2).intValue(), this.$previousPath);
            }
        };
        MaybeDeletedFilePath path3 = this.findPathWithoutConflict(currentNodeId, (Function1<? super Integer, MaybeDeletedFilePath>)pathGetter3);
        MaybeDeletedFilePath maybeDeletedFilePath = path3;
        if (maybeDeletedFilePath == null) {
            maybeDeletedFilePath = (MaybeDeletedFilePath)pathGetter3.invoke((Object)GraphUtilKt.getCorrespondingParent(this.permanentLinearGraph, currentNodeId, previousNodeId, this.visibilityBuffer));
        }
        return maybeDeletedFilePath;
    }

    private final MaybeDeletedFilePath findPathWithoutConflict(int nodeId, Function1<? super Integer, MaybeDeletedFilePath> pathGetter2) {
        Object v2;
        MaybeDeletedFilePath path2;
        block3: {
            List<Integer> list = this.permanentLinearGraph.getNodes(nodeId, LiteLinearGraph.NodeFilter.DOWN);
            Intrinsics.checkNotNullExpressionValue(list, (String)"permanentLinearGraph.get\u2026earGraph.NodeFilter.DOWN)");
            List<Integer> parents = list;
            Object object = CollectionsKt.first(parents);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parents.first()");
            path2 = (MaybeDeletedFilePath)pathGetter2.invoke(object);
            if (parents.size() == 1) {
                return path2;
            }
            Iterable iterable = parents.subList(1, parents.size());
            for (Object t : iterable) {
                Integer it = (Integer)t;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!(!Intrinsics.areEqual((Object)pathGetter2.invoke((Object)it), (Object)path2))) continue;
                v2 = t;
                break block3;
            }
            v2 = null;
        }
        if (v2 != null) {
            return null;
        }
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Integer, MaybeDeletedFilePath>> getNextNodes(LiteLinearGraph graph, BitSetFlags visited, int currentNode, MaybeDeletedFilePath currentPath, boolean down) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterNotTo$iv$iv;
        List<Integer> list = graph.getNodes(currentNode, down ? LiteLinearGraph.NodeFilter.DOWN : LiteLinearGraph.NodeFilter.UP);
        Intrinsics.checkNotNullExpressionValue(list, (String)"graph.getNodes(currentNo\u2026inearGraph.NodeFilter.UP)");
        List<Integer> nextNodes = list;
        Iterable $this$filterNot$iv = nextNodes;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            int p0 = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (visited.get(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void node;
            Integer p0 = (Integer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
            collection.add(new Pair((Object)node, (Object)this.getPath(node.intValue(), currentNode, currentPath, down)));
        }
        List nodesWithPaths = (List)destination$iv$iv;
        return CollectionsKt.sortedWith((Iterable)nodesWithPaths, (Comparator)new Comparator(currentPath){
            final /* synthetic */ MaybeDeletedFilePath $currentPath$inlined;
            {
                this.$currentPath$inlined = maybeDeletedFilePath;
            }

            public final int compare(T a, T b) {
                Pair pair = (Pair)a;
                boolean bl = false;
                MaybeDeletedFilePath path2 = (MaybeDeletedFilePath)pair.component2();
                pair = (Pair)b;
                Comparable comparable = Intrinsics.areEqual((Object)path2, (Object)this.$currentPath$inlined) ? (Comparable)Integer.valueOf(-1) : (path2.getDeleted() ? (Comparable)Integer.valueOf(1) : (Comparable)Integer.valueOf(0));
                bl = false;
                path2 = (MaybeDeletedFilePath)pair.component2();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(Intrinsics.areEqual((Object)path2, (Object)this.$currentPath$inlined) ? (Comparable)Integer.valueOf(-1) : (path2.getDeleted() ? (Comparable)Integer.valueOf(1) : (Comparable)Integer.valueOf(0))));
            }
        });
    }

    public static final /* synthetic */ FileHistoryData access$getHistoryData$p(FileHistoryRefiner $this) {
        return $this.historyData;
    }

    public static final /* synthetic */ PermanentCommitsInfo access$getPermanentCommitsInfo$p(FileHistoryRefiner $this) {
        return $this.permanentCommitsInfo;
    }
}

