/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd.regex.test;

import com.thaiopensource.datatype.xsd.regex.Regex;
import com.thaiopensource.datatype.xsd.regex.RegexEngine;
import com.thaiopensource.datatype.xsd.regex.RegexSyntaxException;
import com.thaiopensource.util.Service;
import com.thaiopensource.util.Utf16;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;

public class CategoryTest {
    private static final String categories = "LMNPZSC";
    private static final String subCategories = "LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn";
    private final Regex[] categoryPosRegexes = new Regex["LMNPZSC".length()];
    private final Regex[] categoryNegRegexes = new Regex["LMNPZSC".length()];
    private final Regex[] subCategoryPosRegexes = new Regex["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];
    private final Regex[] subCategoryNegRegexes = new Regex["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];
    int nFail = 0;
    static /* synthetic */ Class class$com$thaiopensource$datatype$xsd$regex$test$CategoryTest;
    static /* synthetic */ Class class$com$thaiopensource$datatype$xsd$regex$RegexEngine;

    public static void main(String[] stringArray) throws IOException, RegexSyntaxException {
        RegexEngine regexEngine;
        if (stringArray.length != 2) {
            System.err.println("usage: " + (class$com$thaiopensource$datatype$xsd$regex$test$CategoryTest == null ? (class$com$thaiopensource$datatype$xsd$regex$test$CategoryTest = CategoryTest.class$("com.thaiopensource.datatype.xsd.regex.test.CategoryTest")) : class$com$thaiopensource$datatype$xsd$regex$test$CategoryTest).getName() + " engineClass UnicodeData");
            System.exit(2);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(stringArray[1])));
        Enumeration enumeration = new Service(class$com$thaiopensource$datatype$xsd$regex$RegexEngine == null ? (class$com$thaiopensource$datatype$xsd$regex$RegexEngine = CategoryTest.class$("com.thaiopensource.datatype.xsd.regex.RegexEngine")) : class$com$thaiopensource$datatype$xsd$regex$RegexEngine).getProviders();
        do {
            if (enumeration.hasMoreElements()) continue;
            System.err.println("couldn't find regex engine");
            System.exit(2);
        } while (!(regexEngine = (RegexEngine)enumeration.nextElement()).getClass().getName().equals(stringArray[0]));
        int n = new CategoryTest(regexEngine).testAll(bufferedReader);
        System.err.println(n + " tests failed");
        System.exit(n > 0 ? 1 : 0);
    }

    CategoryTest(RegexEngine regexEngine) throws RegexSyntaxException {
        int n = 0;
        int n2 = categories.length();
        while (n < n2) {
            String string2 = categories.substring(n, n + 1);
            this.categoryPosRegexes[n] = regexEngine.compile("\\p{" + string2 + "}");
            this.categoryNegRegexes[n] = regexEngine.compile("\\P{" + string2 + "}");
            ++n;
        }
        int n3 = 0;
        int n4 = subCategories.length();
        while (n3 < n4) {
            String string3 = subCategories.substring(n3, n3 + 2);
            this.subCategoryPosRegexes[n3 / 2] = regexEngine.compile("\\p{" + string3 + "}");
            this.subCategoryNegRegexes[n3 / 2] = regexEngine.compile("\\P{" + string3 + "}");
            n3 += 2;
        }
    }

    int testAll(BufferedReader bufferedReader) throws IOException {
        String string2;
        int n = -1;
        while ((string2 = bufferedReader.readLine()) != null) {
            int n2 = string2.indexOf(59);
            if (n2 < 0) continue;
            int n3 = Integer.parseInt(string2.substring(0, n2), 16);
            int n4 = string2.indexOf(59, n2 + 1);
            String string3 = string2.substring(n2, n4);
            String string4 = string2.substring(n4 + 1, n4 + 3);
            if (n + 1 != n3) {
                String string5 = string3.endsWith(", Last>") ? string4 : "Cn";
                int n5 = n + 1;
                while (n5 < n3) {
                    this.test(n5, string5);
                    ++n5;
                }
            }
            this.test(n3, string4);
            n = n3;
        }
        ++n;
        while (n < 0x110000) {
            this.test(n, "Cn");
            ++n;
        }
        return this.nFail;
    }

    void test(int n, String string2) {
        if (!CategoryTest.isXmlChar(n)) {
            return;
        }
        if (subCategories.indexOf(string2) < 0) {
            System.err.println("Missing category: " + string2);
            System.exit(2);
        }
        int n2 = 0;
        int n3 = categories.length();
        while (n2 < n3) {
            this.check(n, this.categoryPosRegexes[n2], this.categoryNegRegexes[n2], string2.charAt(0) == categories.charAt(n2), categories.substring(n2, n2 + 1));
            ++n2;
        }
        int n4 = 0;
        int n5 = subCategories.length();
        while (n4 < n5) {
            this.check(n, this.subCategoryPosRegexes[n4 / 2], this.subCategoryNegRegexes[n4 / 2], string2.equals(subCategories.substring(n4, n4 + 2)), subCategories.substring(n4, n4 + 2));
            n4 += 2;
        }
    }

    void check(int n, Regex regex, Regex regex2, boolean bl, String string2) {
        String string3 = n > 65535 ? new String(new char[]{Utf16.surrogate1(n), Utf16.surrogate2(n)}) : new String(new char[]{(char)n});
        if (regex.matches(string3) != bl) {
            this.fail(n, string2);
        }
        if (regex2.matches(string3) != !bl) {
            this.fail(n, "-" + string2);
        }
    }

    void fail(int n, String string2) {
        ++this.nFail;
        System.err.println("Failed: " + Integer.toHexString(n) + "/" + string2);
    }

    static boolean isXmlChar(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 13: {
                return true;
            }
            case 65534: 
            case 65535: {
                return false;
            }
        }
        if (n < 32) {
            return false;
        }
        return n < 55296 || n >= 57344;
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

