/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.inspection.fix;

import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.codeInspection.ModuleProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.externalSystem.DependencyModifierService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.PackageCheckerBundle;
import org.jetbrains.security.fus.PackageCheckerUsageStat;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/security/inspection/fix/DeclarePackageFix;", "Lcom/intellij/codeInspection/QuickFix;", "Lcom/intellij/codeInspection/ModuleProblemDescriptor;", "packageToDeclare", "Lorg/jetbrains/security/package/Package;", "(Lorg/jetbrains/security/package/Package;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "getFamilyName", "", "intellij.packageChecker"})
public final class DeclarePackageFix
implements QuickFix<ModuleProblemDescriptor> {
    @NotNull
    private final Package packageToDeclare;

    public DeclarePackageFix(@NotNull Package packageToDeclare) {
        Intrinsics.checkNotNullParameter((Object)packageToDeclare, (String)"packageToDeclare");
        this.packageToDeclare = packageToDeclare;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.packageToDeclare.getHumanReadableCoordinates()};
        String string = PackageCheckerBundle.message("declare.package.quickfix", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"declare.package\u2026humanReadableCoordinates)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ModuleProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PackageCheckerUsageStat.fixGlobal.log(project);
        DependencyModifierService instance = DependencyModifierService.Companion.getInstance(project);
        Module module = descriptor.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"descriptor.module");
        Module module2 = module;
        instance.addDependency(module2, new UnifiedDependency(this.packageToDeclare.getNamespace(), this.packageToDeclare.getName(), this.packageToDeclare.getVersion().getValue(), null, 8, null));
    }
}

