/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLFileBasedIndexUtil;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;

public class YAMLUtil {
    public static final FileBasedIndex.InputFilter YAML_INPUT_FILTER = YAMLFileBasedIndexUtil.YAML_INPUT_FILTER;
    private static final TokenSet BLANK_LINE_ELEMENTS = TokenSet.andNot((TokenSet)YAMLElementTypes.BLANK_ELEMENTS, (TokenSet)YAMLElementTypes.EOL_ELEMENTS);

    @NotNull
    public static String getConfigFullName(@NotNull YAMLPsiElement target) {
        if (target == null) {
            YAMLUtil.$$$reportNull$$$0(0);
        }
        String string = StringUtil.join(YAMLUtil.getConfigFullNameParts(target), (String)".");
        if (string == null) {
            YAMLUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static List<String> getConfigFullNameParts(@NotNull YAMLPsiElement target) {
        if (target == null) {
            YAMLUtil.$$$reportNull$$$0(2);
        }
        SmartList result = new SmartList();
        YAMLPsiElement element = target;
        while (element != null) {
            Object elementIndexSuffix = "";
            if (element instanceof YAMLSequenceItem) {
                elementIndexSuffix = "[" + ((YAMLSequenceItem)element).getItemIndex() + "]";
                element = PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class);
            }
            if (element instanceof YAMLKeyValue) {
                String keyText = ((YAMLKeyValue)element).getKeyText();
                result.add((Object)(keyText + (String)elementIndexSuffix));
            }
            element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{YAMLKeyValue.class, YAMLSequenceItem.class});
        }
        List list = ContainerUtil.reverse((List)result);
        if (list == null) {
            YAMLUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static Collection<YAMLKeyValue> getTopLevelKeys(YAMLFile file) {
        YAMLValue topLevelValue = file.getDocuments().get(0).getTopLevelValue();
        if (topLevelValue instanceof YAMLMapping) {
            Collection<YAMLKeyValue> collection = ((YAMLMapping)topLevelValue).getKeyValues();
            if (collection == null) {
                YAMLUtil.$$$reportNull$$$0(4);
            }
            return collection;
        }
        List<YAMLKeyValue> list = Collections.emptyList();
        if (list == null) {
            YAMLUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public static YAMLKeyValue getQualifiedKeyInFile(YAMLFile file, List<String> key) {
        return YAMLUtil.getQualifiedKeyInDocument(file.getDocuments().get(0), key);
    }

    @Nullable
    public static YAMLKeyValue getQualifiedKeyInDocument(@NotNull YAMLDocument document, @NotNull List<String> key) {
        if (document == null) {
            YAMLUtil.$$$reportNull$$$0(6);
        }
        if (key == null) {
            YAMLUtil.$$$reportNull$$$0(7);
        }
        assert (key.size() != 0);
        YAMLMapping mapping = (YAMLMapping)ObjectUtils.tryCast((Object)document.getTopLevelValue(), YAMLMapping.class);
        for (int i = 0; i < key.size(); ++i) {
            if (mapping == null) {
                return null;
            }
            YAMLKeyValue keyValue = mapping.getKeyValueByKey(String.join((CharSequence)".", key.subList(i, key.size())));
            if (keyValue != null) {
                return keyValue;
            }
            keyValue = mapping.getKeyValueByKey(key.get(i));
            if (keyValue == null || i + 1 == key.size()) {
                return keyValue;
            }
            mapping = (YAMLMapping)ObjectUtils.tryCast((Object)keyValue.getValue(), YAMLMapping.class);
        }
        throw new IllegalStateException("Should have returned from the loop");
    }

    @Nullable
    public static YAMLKeyValue getQualifiedKeyInFile(YAMLFile file, String ... key) {
        return YAMLUtil.getQualifiedKeyInFile(file, Arrays.asList(key));
    }

    @Nullable
    public static YAMLKeyValue findKeyInProbablyMapping(@Nullable YAMLValue node, @NotNull String keyText) {
        if (keyText == null) {
            YAMLUtil.$$$reportNull$$$0(8);
        }
        if (!(node instanceof YAMLMapping)) {
            return null;
        }
        return ((YAMLMapping)node).getKeyValueByKey(keyText);
    }

    @Nullable
    public static Pair<PsiElement, String> getValue(YAMLFile file, String ... key) {
        YAMLKeyValue record = YAMLUtil.getQualifiedKeyInFile(file, key);
        if (record != null) {
            YAMLValue psiValue = record.getValue();
            return Pair.create((Object)psiValue, (Object)record.getValueText());
        }
        return null;
    }

    public YAMLKeyValue createI18nRecord(YAMLFile file, String key, String text) {
        return YAMLUtil.createI18nRecord(file, key.split("\\."), text);
    }

    @Nullable
    public static YAMLKeyValue createI18nRecord(YAMLFile file, String[] key, String text) {
        int i;
        YAMLDocument root = file.getDocuments().get(0);
        assert (root != null);
        assert (key.length > 0);
        YAMLMapping rootMapping = (YAMLMapping)PsiTreeUtil.findChildOfType((PsiElement)root, YAMLMapping.class);
        if (rootMapping == null) {
            YAMLFile yamlFile = YAMLElementGenerator.getInstance(file.getProject()).createDummyYamlWithText(key[0] + ":");
            YAMLMapping mapping = (YAMLMapping)yamlFile.getDocuments().get(0).getTopLevelValue();
            assert (mapping != null);
            rootMapping = (YAMLMapping)root.add((PsiElement)mapping);
        }
        YAMLMapping current = rootMapping;
        int keyLength = key.length;
        for (i = 0; i < keyLength; ++i) {
            YAMLMapping nextMapping;
            YAMLKeyValue existingRec = current.getKeyValueByKey(key[i]);
            if (existingRec != null && (nextMapping = (YAMLMapping)ObjectUtils.tryCast((Object)existingRec.getValue(), YAMLMapping.class)) != null) {
                current = nextMapping;
                continue;
            }
            Object indent = StringUtil.repeatSymbol((char)' ', (int)YAMLUtil.getIndentInThisLine((PsiElement)current));
            StringBuilder builder = new StringBuilder();
            builder.append("---");
            for (int j = i; j < keyLength; ++j) {
                builder.append("\n").append((String)indent);
                builder.append(key[j]).append(":");
                indent = (String)indent + "  ";
            }
            builder.append(" ").append(text);
            YAMLFile fileWithKey = YAMLElementGenerator.getInstance(file.getProject()).createDummyYamlWithText(builder.toString());
            YAMLMapping dummyMapping = (YAMLMapping)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)fileWithKey.getDocuments().get(0)), YAMLMapping.class);
            assert (dummyMapping != null && dummyMapping.getKeyValues().size() == 1);
            YAMLKeyValue dummyKeyValue = dummyMapping.getKeyValues().iterator().next();
            current.putKeyValue(dummyKeyValue);
            if (!(dummyKeyValue.getValue() instanceof YAMLMapping)) {
                return dummyKeyValue;
            }
            current = (YAMLMapping)dummyKeyValue.getValue();
        }
        StringBuilder builder = new StringBuilder();
        int top = Math.min(i + 1, keyLength);
        for (int j = 0; j < top; ++j) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(key[j]);
        }
        throw new IncorrectOperationException(YAMLBundle.message("new.name.conflicts.with", builder.toString()));
    }

    public static PsiElement rename(YAMLKeyValue element, String newName) {
        if (newName.equals(element.getName())) {
            throw new IncorrectOperationException(YAMLBundle.message("rename.same.name", new Object[0]));
        }
        YAMLKeyValue topKeyValue = YAMLElementGenerator.getInstance(element.getProject()).createYamlKeyValue(newName, "Foo");
        PsiElement key = element.getKey();
        if (key == null || topKeyValue.getKey() == null) {
            throw new IllegalStateException();
        }
        key.replace(topKeyValue.getKey());
        return element;
    }

    public static int getIndentInThisLine(@NotNull PsiElement elementInLine) {
        if (elementInLine == null) {
            YAMLUtil.$$$reportNull$$$0(9);
        }
        PsiElement currentElement = elementInLine;
        while (currentElement != null) {
            IElementType type = currentElement.getNode().getElementType();
            if (type == YAMLTokenTypes.EOL) {
                return 0;
            }
            if (type == YAMLTokenTypes.INDENT) {
                return currentElement.getTextLength();
            }
            currentElement = PsiTreeUtil.prevLeaf((PsiElement)currentElement);
        }
        return 0;
    }

    public static int getIndentToThisElement(@NotNull PsiElement element) {
        if (element == null) {
            YAMLUtil.$$$reportNull$$$0(10);
        }
        if (element instanceof YAMLBlockMappingImpl) {
            try {
                element = ((YAMLBlockMappingImpl)element).getFirstKeyValue();
            }
            catch (IllegalStateException e) {
                if (!e.getMessage().equals("YAML map without any key-value")) {
                    throw e;
                }
                Logger.getInstance(YAMLUtil.class).warn("YAML map without any key-value");
            }
        }
        int offset = element.getTextOffset();
        PsiElement currentElement = element;
        while (currentElement != null) {
            IElementType type = currentElement.getNode().getElementType();
            if (YAMLElementTypes.EOL_ELEMENTS.contains(type)) {
                return offset - currentElement.getTextOffset() - currentElement.getTextLength();
            }
            currentElement = PsiTreeUtil.prevLeaf((PsiElement)currentElement);
        }
        return offset;
    }

    public static boolean psiAreAtTheSameLine(@NotNull PsiElement psi1, @NotNull PsiElement psi2) {
        if (psi1 == null) {
            YAMLUtil.$$$reportNull$$$0(11);
        }
        if (psi2 == null) {
            YAMLUtil.$$$reportNull$$$0(12);
        }
        PsiElement leaf = YAMLUtil.firstLeaf(psi1);
        PsiElement lastLeaf = YAMLUtil.firstLeaf(psi2);
        while (leaf != null) {
            if (PsiUtilCore.getElementType((PsiElement)leaf) == YAMLTokenTypes.EOL) {
                return false;
            }
            if (leaf == lastLeaf) {
                return true;
            }
            leaf = PsiTreeUtil.nextLeaf((PsiElement)leaf);
        }
        return false;
    }

    @Nullable
    private static PsiElement firstLeaf(PsiElement psi1) {
        LeafElement leaf = TreeUtil.findFirstLeaf((ASTNode)psi1.getNode());
        if (leaf != null) {
            return leaf.getPsi();
        }
        return null;
    }

    public static void deleteSurroundingWhitespace(@NotNull PsiElement element) {
        if (element == null) {
            YAMLUtil.$$$reportNull$$$0(13);
        }
        if (element.getNextSibling() != null) {
            YAMLUtil.deleteElementsOfType(() -> ((PsiElement)element).getNextSibling(), BLANK_LINE_ELEMENTS);
            YAMLUtil.deleteElementsOfType(() -> ((PsiElement)element).getNextSibling(), YAMLElementTypes.SPACE_ELEMENTS);
        } else {
            YAMLUtil.deleteElementsOfType(() -> ((PsiElement)element).getPrevSibling(), YAMLElementTypes.SPACE_ELEMENTS);
        }
    }

    private static void deleteElementsOfType(@NotNull Supplier<? extends PsiElement> element, @NotNull TokenSet types) {
        if (element == null) {
            YAMLUtil.$$$reportNull$$$0(14);
        }
        if (types == null) {
            YAMLUtil.$$$reportNull$$$0(15);
        }
        while (element.get() != null && types.contains(PsiUtilCore.getElementType((PsiElement)element.get()))) {
            element.get().delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/YAMLUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementInLine";
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi1";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi2";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/YAMLUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFullName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFullNameParts";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFullName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFullNameParts";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedKeyInDocument";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findKeyInProbablyMapping";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIndentInThisLine";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIndentToThisElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "psiAreAtTheSameLine";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deleteSurroundingWhitespace";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "deleteElementsOfType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

