/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.BufferedInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.bundles.TextMateBundleReader;
import org.jetbrains.plugins.textmate.bundles.VSCBundleReader;
import org.jetbrains.plugins.textmate.bundles.VSCodeExtension;
import org.jetbrains.plugins.textmate.plist.JsonPlistReader;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a-\u0010\u0000\u001a\u0004\u0018\u00010\u00012#\u0010\u0002\u001a\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003*\n\u0010\t\"\u00020\u00042\u00020\u0004\u00a8\u0006\n"}, d2={"readVSCBundle", "Lorg/jetbrains/plugins/textmate/bundles/TextMateBundleReader;", "resourceLoader", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "relativePath", "Ljava/io/InputStream;", "VSCodeExtensionLanguageId", "intellij.textmate.core"})
public final class VSCBundleReaderKt {
    @Nullable
    public static final TextMateBundleReader readVSCBundle(@NotNull Function1<? super String, ? extends InputStream> resourceLoader) {
        VSCBundleReader vSCBundleReader;
        Intrinsics.checkNotNullParameter(resourceLoader, (String)"resourceLoader");
        InputStream inputStream = (InputStream)resourceLoader.invoke((Object)"package.json");
        if (inputStream != null) {
            InputStream inputStream2 = inputStream;
            int n = 8192;
            BufferedInputStream packageJsonStream = inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n);
            boolean bl = false;
            ObjectMapper objectMapper = JsonPlistReader.createJsonReader();
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"createJsonReader()");
            ObjectMapper jsonReader2 = ExtensionsKt.registerKotlinModule((ObjectMapper)objectMapper);
            VSCodeExtension extension = (VSCodeExtension)jsonReader2.readValue((InputStream)packageJsonStream, VSCodeExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)extension, (String)"extension");
            vSCBundleReader = new VSCBundleReader(extension, resourceLoader);
        } else {
            vSCBundleReader = null;
        }
        return vSCBundleReader;
    }
}

