/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.editor.BaseQuoteHandler;

public class PyTripleQuoteBackspaceDelegate
extends BackspaceHandlerDelegate {
    private boolean isTripleQuote;

    public void beforeCharDeleted(char c, PsiFile file, Editor editor2) {
        this.isTripleQuote = false;
        if (c == '\"' || c == '\'' && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            boolean mayBeTripleQuote;
            QuoteHandler quoteHandler = TypedHandler.getQuoteHandler((PsiFile)file, (Editor)editor2);
            if (!(quoteHandler instanceof BaseQuoteHandler)) {
                return;
            }
            int offset = editor2.getCaretModel().getCurrentCaret().getOffset();
            CharSequence text = editor2.getDocument().getCharsSequence();
            boolean bl = mayBeTripleQuote = offset >= 3 && offset + 2 < text.length();
            if (mayBeTripleQuote) {
                int quoteOffset = offset - 1;
                HighlighterIterator iterator = editor2.getHighlighter().createIterator(quoteOffset);
                boolean hasTripleQuoteAfter = offset + 2 < text.length() && text.charAt(offset) == c && text.charAt(offset + 1) == c && text.charAt(offset + 2) == c;
                this.isTripleQuote = quoteHandler.isOpeningQuote(iterator, quoteOffset) && hasTripleQuoteAfter;
            }
        }
    }

    public boolean charDeleted(char c, PsiFile file, Editor editor2) {
        if (this.isTripleQuote) {
            int offset = editor2.getCaretModel().getCurrentCaret().getOffset();
            editor2.getDocument().deleteString(offset - 2, offset + 3);
            return true;
        }
        return false;
    }
}

