/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyVariableViewSettings {
    public static void showWarningMessage(@Nullable XCompositeNode node) {
        if (node == null) {
            return;
        }
        final PyDebuggerSettings debuggerSettings = PyDebuggerSettings.getInstance();
        if (debuggerSettings.getValuesPolicy() == PyDebugValue.ValuesPolicy.ON_DEMAND) {
            return;
        }
        node.setMessage(PyBundle.message("debugger.variables.view.warning.message", new Object[0]), AllIcons.General.BalloonWarning, SimpleTextAttributes.REGULAR_ATTRIBUTES, new XDebuggerTreeNodeHyperlink(PyBundle.message("debugger.variables.view.switch.to.loading.on.demand", new Object[0])){
            private boolean linkClicked;
            {
                super(arg0);
                this.linkClicked = false;
            }

            public void onClick(MouseEvent event) {
                debuggerSettings.setValuesPolicy(PyDebugValue.ValuesPolicy.ON_DEMAND);
                this.linkClicked = true;
            }

            @NotNull
            public String getLinkText() {
                if (this.linkClicked) {
                    return "";
                }
                String string = PyBundle.message("debugger.variables.view.switch.to.loading.on.demand", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyVariableViewSettings$1", "getLinkText"));
            }
        });
    }

    public static class PolicyAction
    extends ToggleAction {
        @NotNull
        private final PyDebugValue.ValuesPolicy myPolicy;
        @NotNull
        private final VariablesPolicyGroup myActionGroup;
        private volatile boolean isEnabled;

        public PolicyAction(@NotNull @Nls String text, @NotNull @Nls String description, @NotNull PyDebugValue.ValuesPolicy policy, @NotNull VariablesPolicyGroup actionGroup) {
            if (text == null) {
                PolicyAction.$$$reportNull$$$0(0);
            }
            if (description == null) {
                PolicyAction.$$$reportNull$$$0(1);
            }
            if (policy == null) {
                PolicyAction.$$$reportNull$$$0(2);
            }
            if (actionGroup == null) {
                PolicyAction.$$$reportNull$$$0(3);
            }
            super(text, description, null);
            this.myPolicy = policy;
            this.myActionGroup = actionGroup;
            this.isEnabled = PyDebuggerSettings.getInstance().getValuesPolicy() == policy;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                PolicyAction.$$$reportNull$$$0(4);
            }
            super.update(e);
            this.myActionGroup.updatePolicyActions();
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(true);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                PolicyAction.$$$reportNull$$$0(5);
            }
            return actionUpdateThread;
        }

        @NotNull
        public PyDebugValue.ValuesPolicy getPolicy() {
            PyDebugValue.ValuesPolicy valuesPolicy = this.myPolicy;
            if (valuesPolicy == null) {
                PolicyAction.$$$reportNull$$$0(6);
            }
            return valuesPolicy;
        }

        public void setEnabled(boolean enabled) {
            this.isEnabled = enabled;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                PolicyAction.$$$reportNull$$$0(7);
            }
            return this.isEnabled;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean hide) {
            if (e == null) {
                PolicyAction.$$$reportNull$$$0(8);
            }
            this.isEnabled = hide;
            if (hide) {
                PyDebuggerSettings.getInstance().setValuesPolicy(this.myPolicy);
                this.myActionGroup.notifyValuesPolicyUpdated();
            }
            this.myActionGroup.updatePolicyActions();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionGroup";
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/PyVariableViewSettings$PolicyAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/PyVariableViewSettings$PolicyAction";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPolicy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    public static class VariablesPolicyGroup
    extends DefaultActionGroup {
        @NotNull
        private final List<PolicyAction> myValuesPolicyActions = new ArrayList<PolicyAction>();
        private final List<ValuesPolicyListener> myValuesPolicyListeners = new ArrayList<ValuesPolicyListener>();

        public VariablesPolicyGroup() {
            super(PyBundle.message("debugger.variables.loading.policy", new Object[0]), true);
            this.myValuesPolicyActions.add(new PolicyAction(PyBundle.message("debugger.variables.loading.synchronously.text", new Object[0]), PyBundle.message("debugger.variables.loading.synchronously.description", new Object[0]), PyDebugValue.ValuesPolicy.SYNC, this));
            this.myValuesPolicyActions.add(new PolicyAction(PyBundle.message("debugger.variables.loading.asynchronously.text", new Object[0]), PyBundle.message("debugger.variables.loading.asynchronously.description", new Object[0]), PyDebugValue.ValuesPolicy.ASYNC, this));
            this.myValuesPolicyActions.add(new PolicyAction(PyBundle.message("debugger.variables.loading.on.demand.text", new Object[0]), PyBundle.message("debugger.variables.loading.on.demand.description", new Object[0]), PyDebugValue.ValuesPolicy.ON_DEMAND, this));
            for (AnAction anAction : this.myValuesPolicyActions) {
                this.add(anAction);
            }
        }

        public void updatePolicyActions() {
            PyDebugValue.ValuesPolicy currentValuesPolicy = PyDebuggerSettings.getInstance().getValuesPolicy();
            for (PolicyAction action : this.myValuesPolicyActions) {
                action.setEnabled(currentValuesPolicy == action.getPolicy());
            }
        }

        private void notifyValuesPolicyUpdated() {
            for (ValuesPolicyListener listener2 : this.myValuesPolicyListeners) {
                listener2.valuesPolicyUpdated();
            }
        }

        public void addValuesPolicyListener(@NotNull ValuesPolicyListener listener2) {
            if (listener2 == null) {
                VariablesPolicyGroup.$$$reportNull$$$0(0);
            }
            this.myValuesPolicyListeners.add(listener2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/python/debugger/PyVariableViewSettings$VariablesPolicyGroup", "addValuesPolicyListener"));
        }

        public static interface ValuesPolicyListener {
            public void valuesPolicyUpdated();
        }
    }

    public static class SimplifiedView
    extends ToggleAction {
        private final PyDebugProcess myProcess;
        private volatile boolean mySimplifiedView = PyDebuggerSettings.getInstance().isSimplifiedView();

        public SimplifiedView(@Nullable PyDebugProcess debugProcess) {
            super(PyBundle.message("debugger.simplified.view.text", new Object[0]), PyBundle.message("debugger.simplified.view.description", new Object[0]), null);
            this.myProcess = debugProcess;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SimplifiedView.$$$reportNull$$$0(0);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(true);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SimplifiedView.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SimplifiedView.$$$reportNull$$$0(2);
            }
            return this.mySimplifiedView;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean hide) {
            if (e == null) {
                SimplifiedView.$$$reportNull$$$0(3);
            }
            this.mySimplifiedView = hide;
            PyDebuggerSettings.getInstance().setSimplifiedView(hide);
            if (this.myProcess != null) {
                this.myProcess.getSession().rebuildViews();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/PyVariableViewSettings$SimplifiedView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/PyVariableViewSettings$SimplifiedView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

