# encoding: utf-8
# copyright: 2015, Dominik Richter
# license: MPLv2

module SSLShake # rubocop:disable Metrics/ModuleLength
  CIPHERS = {
    '010080' => 'SSL_CK_RC4_128_WITH_MD5',
    '020080' => 'SSL_CK_RC4_128_EXPORT40_WITH_MD5',
    '030080' => 'SSL_CK_RC2_128_CBC_WITH_MD5',
    '040080' => 'SSL_CK_RC2_128_CBC_EXPORT40_WITH_MD5',
    '050080' => 'SSL_CK_IDEA_128_CBC_WITH_MD5',
    '060040' => 'SSL_CK_DES_64_CBC_WITH_MD5',
    '0700C0' => 'SSL_CK_DES_192_EDE3_CBC_WITH_MD5',
    '080080' => 'SSL_CK_RC4_64_WITH_MD5',
    '0000' => 'TLS_NULL_WITH_NULL_NULL',
    '0001' => 'TLS_RSA_WITH_NULL_MD5',
    '0002' => 'TLS_RSA_WITH_NULL_SHA',
    '0003' => 'TLS_RSA_EXPORT_WITH_RC4_40_MD5',
    '0004' => 'TLS_RSA_WITH_RC4_128_MD5',
    '0005' => 'TLS_RSA_WITH_RC4_128_SHA',
    '0006' => 'TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5',
    '0007' => 'TLS_RSA_WITH_IDEA_CBC_SHA',
    '0008' => 'TLS_RSA_EXPORT_WITH_DES40_CBC_SHA',
    '0009' => 'TLS_RSA_WITH_DES_CBC_SHA',
    '000A' => 'TLS_RSA_WITH_3DES_EDE_CBC_SHA',
    '000B' => 'TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA',
    '000C' => 'TLS_DH_DSS_WITH_DES_CBC_SHA',
    '000D' => 'TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA',
    '000E' => 'TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA',
    '000F' => 'TLS_DH_RSA_WITH_DES_CBC_SHA',
    '0010' => 'TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA',
    '0011' => 'TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA',
    '0012' => 'TLS_DHE_DSS_WITH_DES_CBC_SHA',
    '0013' => 'TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA',
    '0014' => 'TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA',
    '0015' => 'TLS_DHE_RSA_WITH_DES_CBC_SHA',
    '0016' => 'TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA',
    '0017' => 'TLS_DH_anon_EXPORT_WITH_RC4_40_MD5',
    '0018' => 'TLS_DH_anon_WITH_RC4_128_MD5',
    '0019' => 'TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA',
    '001A' => 'TLS_DH_anon_WITH_DES_CBC_SHA',
    '001B' => 'TLS_DH_anon_WITH_3DES_EDE_CBC_SHA',
    '001E' => 'TLS_KRB5_WITH_DES_CBC_SHA',
    '001F' => 'TLS_KRB5_WITH_3DES_EDE_CBC_SHA',
    '0020' => 'TLS_KRB5_WITH_RC4_128_SHA',
    '0021' => 'TLS_KRB5_WITH_IDEA_CBC_SHA',
    '0022' => 'TLS_KRB5_WITH_DES_CBC_MD5',
    '0023' => 'TLS_KRB5_WITH_3DES_EDE_CBC_MD5',
    '0024' => 'TLS_KRB5_WITH_RC4_128_MD5',
    '0025' => 'TLS_KRB5_WITH_IDEA_CBC_MD5',
    '0026' => 'TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA',
    '0027' => 'TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA',
    '0028' => 'TLS_KRB5_EXPORT_WITH_RC4_40_SHA',
    '0029' => 'TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5',
    '002A' => 'TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5',
    '002B' => 'TLS_KRB5_EXPORT_WITH_RC4_40_MD5',
    '002C' => 'TLS_PSK_WITH_NULL_SHA',
    '002D' => 'TLS_DHE_PSK_WITH_NULL_SHA',
    '002E' => 'TLS_RSA_PSK_WITH_NULL_SHA',
    '002F' => 'TLS_RSA_WITH_AES_128_CBC_SHA',
    '0030' => 'TLS_DH_DSS_WITH_AES_128_CBC_SHA',
    '0031' => 'TLS_DH_RSA_WITH_AES_128_CBC_SHA',
    '0032' => 'TLS_DHE_DSS_WITH_AES_128_CBC_SHA',
    '0033' => 'TLS_DHE_RSA_WITH_AES_128_CBC_SHA',
    '0034' => 'TLS_DH_anon_WITH_AES_128_CBC_SHA',
    '0035' => 'TLS_RSA_WITH_AES_256_CBC_SHA',
    '0036' => 'TLS_DH_DSS_WITH_AES_256_CBC_SHA',
    '0037' => 'TLS_DH_RSA_WITH_AES_256_CBC_SHA',
    '0038' => 'TLS_DHE_DSS_WITH_AES_256_CBC_SHA',
    '0039' => 'TLS_DHE_RSA_WITH_AES_256_CBC_SHA',
    '003A' => 'TLS_DH_anon_WITH_AES_256_CBC_SHA',
    '003B' => 'TLS_RSA_WITH_NULL_SHA256',
    '003C' => 'TLS_RSA_WITH_AES_128_CBC_SHA256',
    '003D' => 'TLS_RSA_WITH_AES_256_CBC_SHA256',
    '003E' => 'TLS_DH_DSS_WITH_AES_128_CBC_SHA256',
    '003F' => 'TLS_DH_RSA_WITH_AES_128_CBC_SHA256',
    '0040' => 'TLS_DHE_DSS_WITH_AES_128_CBC_SHA256',
    '0041' => 'TLS_RSA_WITH_CAMELLIA_128_CBC_SHA',
    '0042' => 'TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA',
    '0043' => 'TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA',
    '0044' => 'TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA',
    '0045' => 'TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA',
    '0046' => 'TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA',
    '0060' => 'TLS_RSA_EXPORT1024_WITH_RC4_56_MD5',
    '0061' => 'TLS_RSA_EXPORT1024_WITH_RC2_56_MD5',
    '0062' => 'TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA',
    '0063' => 'TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA',
    '0064' => 'TLS_RSA_EXPORT1024_WITH_RC4_56_SHA',
    '0065' => 'TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA',
    '0066' => 'TLS_DHE_DSS_WITH_RC4_128_SHA',
    '0067' => 'TLS_DHE_RSA_WITH_AES_128_CBC_SHA256',
    '0068' => 'TLS_DH_DSS_WITH_AES_256_CBC_SHA256',
    '0069' => 'TLS_DH_RSA_WITH_AES_256_CBC_SHA256',
    '006A' => 'TLS_DHE_DSS_WITH_AES_256_CBC_SHA256',
    '006B' => 'TLS_DHE_RSA_WITH_AES_256_CBC_SHA256',
    '006C' => 'TLS_DH_anon_WITH_AES_128_CBC_SHA256',
    '006D' => 'TLS_DH_anon_WITH_AES_256_CBC_SHA256',
    '0080' => 'TLS_GOSTR341094_WITH_28147_CNT_IMIT',
    '0081' => 'TLS_GOSTR341001_WITH_28147_CNT_IMIT',
    '0082' => 'TLS_GOSTR341094_WITH_NULL_GOSTR3411',
    '0083' => 'TLS_GOSTR341001_WITH_NULL_GOSTR3411',
    '0084' => 'TLS_RSA_WITH_CAMELLIA_256_CBC_SHA',
    '0085' => 'TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA',
    '0086' => 'TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA',
    '0087' => 'TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA',
    '0088' => 'TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA',
    '0089' => 'TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA',
    '008A' => 'TLS_PSK_WITH_RC4_128_SHA',
    '008B' => 'TLS_PSK_WITH_3DES_EDE_CBC_SHA',
    '008C' => 'TLS_PSK_WITH_AES_128_CBC_SHA',
    '008D' => 'TLS_PSK_WITH_AES_256_CBC_SHA',
    '008E' => 'TLS_DHE_PSK_WITH_RC4_128_SHA',
    '008F' => 'TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA',
    '0090' => 'TLS_DHE_PSK_WITH_AES_128_CBC_SHA',
    '0091' => 'TLS_DHE_PSK_WITH_AES_256_CBC_SHA',
    '0092' => 'TLS_RSA_PSK_WITH_RC4_128_SHA',
    '0093' => 'TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA',
    '0094' => 'TLS_RSA_PSK_WITH_AES_128_CBC_SHA',
    '0095' => 'TLS_RSA_PSK_WITH_AES_256_CBC_SHA',
    '0096' => 'TLS_RSA_WITH_SEED_CBC_SHA',
    '0097' => 'TLS_DH_DSS_WITH_SEED_CBC_SHA',
    '0098' => 'TLS_DH_RSA_WITH_SEED_CBC_SHA',
    '0099' => 'TLS_DHE_DSS_WITH_SEED_CBC_SHA',
    '009A' => 'TLS_DHE_RSA_WITH_SEED_CBC_SHA',
    '009B' => 'TLS_DH_anon_WITH_SEED_CBC_SHA',
    '009C' => 'TLS_RSA_WITH_AES_128_GCM_SHA256',
    '009D' => 'TLS_RSA_WITH_AES_256_GCM_SHA384',
    '009E' => 'TLS_DHE_RSA_WITH_AES_128_GCM_SHA256',
    '009F' => 'TLS_DHE_RSA_WITH_AES_256_GCM_SHA384',
    '00A0' => 'TLS_DH_RSA_WITH_AES_128_GCM_SHA256',
    '00A1' => 'TLS_DH_RSA_WITH_AES_256_GCM_SHA384',
    '00A2' => 'TLS_DHE_DSS_WITH_AES_128_GCM_SHA256',
    '00A3' => 'TLS_DHE_DSS_WITH_AES_256_GCM_SHA384',
    '00A4' => 'TLS_DH_DSS_WITH_AES_128_GCM_SHA256',
    '00A5' => 'TLS_DH_DSS_WITH_AES_256_GCM_SHA384',
    '00A6' => 'TLS_DH_anon_WITH_AES_128_GCM_SHA256',
    '00A7' => 'TLS_DH_anon_WITH_AES_256_GCM_SHA384',
    '00A8' => 'TLS_PSK_WITH_AES_128_GCM_SHA256',
    '00A9' => 'TLS_PSK_WITH_AES_256_GCM_SHA384',
    '00AA' => 'TLS_DHE_PSK_WITH_AES_128_GCM_SHA256',
    '00AB' => 'TLS_DHE_PSK_WITH_AES_256_GCM_SHA384',
    '00AC' => 'TLS_RSA_PSK_WITH_AES_128_GCM_SHA256',
    '00AD' => 'TLS_RSA_PSK_WITH_AES_256_GCM_SHA384',
    '00AE' => 'TLS_PSK_WITH_AES_128_CBC_SHA256',
    '00AF' => 'TLS_PSK_WITH_AES_256_CBC_SHA384',
    '00B0' => 'TLS_PSK_WITH_NULL_SHA256',
    '00B1' => 'TLS_PSK_WITH_NULL_SHA384',
    '00B2' => 'TLS_DHE_PSK_WITH_AES_128_CBC_SHA256',
    '00B3' => 'TLS_DHE_PSK_WITH_AES_256_CBC_SHA384',
    '00B4' => 'TLS_DHE_PSK_WITH_NULL_SHA256',
    '00B5' => 'TLS_DHE_PSK_WITH_NULL_SHA384',
    '00B6' => 'TLS_RSA_PSK_WITH_AES_128_CBC_SHA256',
    '00B7' => 'TLS_RSA_PSK_WITH_AES_256_CBC_SHA384',
    '00B8' => 'TLS_RSA_PSK_WITH_NULL_SHA256',
    '00B9' => 'TLS_RSA_PSK_WITH_NULL_SHA384',
    '00BA' => 'TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256',
    '00BB' => 'TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256',
    '00BC' => 'TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256',
    '00BD' => 'TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256',
    '00BE' => 'TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256',
    '00BF' => 'TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256',
    '00C0' => 'TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256',
    '00C1' => 'TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256',
    '00C2' => 'TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256',
    '00C3' => 'TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256',
    '00C4' => 'TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256',
    '00C5' => 'TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256',
    '00FF' => 'TLS_EMPTY_RENEGOTIATION_INFO_SCSV',
    # See https://tools.ietf.org/html/rfc8446#appendix-B.4
    "1301" => "TLS_AES_128_GCM_SHA256",
    "1302" => "TLS_AES_256_GCM_SHA384",
    "1303" => "TLS_CHACHA20_POLY1305_SHA256",
    "1304" => "TLS_AES_128_CCM_SHA256",
    "1305" => "TLS_AES_128_CCM_8_SHA256",
    'C001' => 'TLS_ECDH_ECDSA_WITH_NULL_SHA',
    'C002' => 'TLS_ECDH_ECDSA_WITH_RC4_128_SHA',
    'C003' => 'TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA',
    'C004' => 'TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA',
    'C005' => 'TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA',
    'C006' => 'TLS_ECDHE_ECDSA_WITH_NULL_SHA',
    'C007' => 'TLS_ECDHE_ECDSA_WITH_RC4_128_SHA',
    'C008' => 'TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA',
    'C009' => 'TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA',
    'C00A' => 'TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA',
    'C00B' => 'TLS_ECDH_RSA_WITH_NULL_SHA',
    'C00C' => 'TLS_ECDH_RSA_WITH_RC4_128_SHA',
    'C00D' => 'TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA',
    'C00E' => 'TLS_ECDH_RSA_WITH_AES_128_CBC_SHA',
    'C00F' => 'TLS_ECDH_RSA_WITH_AES_256_CBC_SHA',
    'C010' => 'TLS_ECDHE_RSA_WITH_NULL_SHA',
    'C011' => 'TLS_ECDHE_RSA_WITH_RC4_128_SHA',
    'C012' => 'TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA',
    'C013' => 'TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA',
    'C014' => 'TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA',
    'C015' => 'TLS_ECDH_anon_WITH_NULL_SHA',
    'C016' => 'TLS_ECDH_anon_WITH_RC4_128_SHA',
    'C017' => 'TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA',
    'C018' => 'TLS_ECDH_anon_WITH_AES_128_CBC_SHA',
    'C019' => 'TLS_ECDH_anon_WITH_AES_256_CBC_SHA',
    'C01A' => 'TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA',
    'C01B' => 'TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA',
    'C01C' => 'TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA',
    'C01D' => 'TLS_SRP_SHA_WITH_AES_128_CBC_SHA',
    'C01E' => 'TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA',
    'C01F' => 'TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA',
    'C020' => 'TLS_SRP_SHA_WITH_AES_256_CBC_SHA',
    'C021' => 'TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA',
    'C022' => 'TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA',
    'C023' => 'TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256',
    'C024' => 'TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384',
    'C025' => 'TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256',
    'C026' => 'TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384',
    'C027' => 'TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256',
    'C028' => 'TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384',
    'C029' => 'TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256',
    'C02A' => 'TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384',
    'C02B' => 'TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256',
    'C02C' => 'TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384',
    'C02D' => 'TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256',
    'C02E' => 'TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384',
    'C02F' => 'TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256',
    'C030' => 'TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384',
    'C031' => 'TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256',
    'C032' => 'TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384',
    'C033' => 'TLS_ECDHE_PSK_WITH_RC4_128_SHA',
    'C034' => 'TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA',
    'C035' => 'TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA',
    'C036' => 'TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA',
    'C037' => 'TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256',
    'C038' => 'TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384',
    'C039' => 'TLS_ECDHE_PSK_WITH_NULL_SHA',
    'C03A' => 'TLS_ECDHE_PSK_WITH_NULL_SHA256',
    'C03B' => 'TLS_ECDHE_PSK_WITH_NULL_SHA384',
    'C03C' => 'TLS_RSA_WITH_ARIA_128_CBC_SHA256',
    'C03D' => 'TLS_RSA_WITH_ARIA_256_CBC_SHA384',
    'C03E' => 'TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256',
    'C03F' => 'TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384',
    'C040' => 'TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256',
    'C041' => 'TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384',
    'C042' => 'TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256',
    'C043' => 'TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384',
    'C044' => 'TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256',
    'C045' => 'TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384',
    'C046' => 'TLS_DH_anon_WITH_ARIA_128_CBC_SHA256',
    'C047' => 'TLS_DH_anon_WITH_ARIA_256_CBC_SHA384',
    'C048' => 'TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256',
    'C049' => 'TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384',
    'C04A' => 'TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256',
    'C04B' => 'TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384',
    'C04C' => 'TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256',
    'C04D' => 'TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384',
    'C04E' => 'TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256',
    'C04F' => 'TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384',
    'C050' => 'TLS_RSA_WITH_ARIA_128_GCM_SHA256',
    'C051' => 'TLS_RSA_WITH_ARIA_256_GCM_SHA384',
    'C052' => 'TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256',
    'C053' => 'TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384',
    'C054' => 'TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256',
    'C055' => 'TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384',
    'C056' => 'TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256',
    'C057' => 'TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384',
    'C058' => 'TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256',
    'C059' => 'TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384',
    'C05A' => 'TLS_DH_anon_WITH_ARIA_128_GCM_SHA256',
    'C05B' => 'TLS_DH_anon_WITH_ARIA_256_GCM_SHA384',
    'C05C' => 'TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256',
    'C05D' => 'TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384',
    'C05E' => 'TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256',
    'C05F' => 'TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384',
    'C060' => 'TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256',
    'C061' => 'TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384',
    'C062' => 'TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256',
    'C063' => 'TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384',
    'C064' => 'TLS_PSK_WITH_ARIA_128_CBC_SHA256',
    'C065' => 'TLS_PSK_WITH_ARIA_256_CBC_SHA384',
    'C066' => 'TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256',
    'C067' => 'TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384',
    'C068' => 'TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256',
    'C069' => 'TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384',
    'C06A' => 'TLS_PSK_WITH_ARIA_128_GCM_SHA256',
    'C06B' => 'TLS_PSK_WITH_ARIA_256_GCM_SHA384',
    'C06C' => 'TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256',
    'C06D' => 'TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384',
    'C06E' => 'TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256',
    'C06F' => 'TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384',
    'C070' => 'TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256',
    'C071' => 'TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384',
    'C072' => 'TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256',
    'C073' => 'TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384',
    'C074' => 'TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256',
    'C075' => 'TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384',
    'C076' => 'TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256',
    'C077' => 'TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384',
    'C078' => 'TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256',
    'C079' => 'TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384',
    'C07A' => 'TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256',
    'C07B' => 'TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384',
    'C07C' => 'TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256',
    'C07D' => 'TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384',
    'C07E' => 'TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256',
    'C07F' => 'TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384',
    'C080' => 'TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256',
    'C081' => 'TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384',
    'C082' => 'TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256',
    'C083' => 'TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384',
    'C084' => 'TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256',
    'C085' => 'TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384',
    'C086' => 'TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256',
    'C087' => 'TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384',
    'C088' => 'TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256',
    'C089' => 'TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384',
    'C08A' => 'TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256',
    'C08B' => 'TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384',
    'C08C' => 'TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256',
    'C08D' => 'TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384',
    'C08E' => 'TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256',
    'C08F' => 'TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384',
    'C090' => 'TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256',
    'C091' => 'TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384',
    'C092' => 'TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256',
    'C093' => 'TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384',
    'C094' => 'TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256',
    'C095' => 'TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384',
    'C096' => 'TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256',
    'C097' => 'TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384',
    'C098' => 'TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256',
    'C099' => 'TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384',
    'C09A' => 'TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256',
    'C09B' => 'TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384',
    'C09C' => 'TLS_RSA_WITH_AES_128_CCM',
    'C09D' => 'TLS_RSA_WITH_AES_256_CCM',
    'C09E' => 'TLS_DHE_RSA_WITH_AES_128_CCM',
    'C09F' => 'TLS_DHE_RSA_WITH_AES_256_CCM',
    'C0A0' => 'TLS_RSA_WITH_AES_128_CCM_8',
    'C0A1' => 'TLS_RSA_WITH_AES_256_CCM_8',
    'C0A2' => 'TLS_DHE_RSA_WITH_AES_128_CCM_8',
    'C0A3' => 'TLS_DHE_RSA_WITH_AES_256_CCM_8',
    'C0A4' => 'TLS_PSK_WITH_AES_128_CCM',
    'C0A5' => 'TLS_PSK_WITH_AES_256_CCM',
    'C0A6' => 'TLS_DHE_PSK_WITH_AES_128_CCM',
    'C0A7' => 'TLS_DHE_PSK_WITH_AES_256_CCM',
    'C0A8' => 'TLS_PSK_WITH_AES_128_CCM_8',
    'C0A9' => 'TLS_PSK_WITH_AES_256_CCM_8',
    'C0AA' => 'TLS_PSK_DHE_WITH_AES_128_CCM_8',
    'C0AB' => 'TLS_PSK_DHE_WITH_AES_256_CCM_8',
    'C0AC' => 'TLS_ECDHE_ECDSA_WITH_AES_128_CCM',
    'C0AD' => 'TLS_ECDHE_ECDSA_WITH_AES_256_CCM',
    'C0AE' => 'TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8',
    'C0AF' => 'TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8',
    'CCA8' => 'TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305',
    'CCA9' => 'TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305',
    'CCAA' => 'TLS_DHE_RSA_WITH_CHACHA20_POLY1305',
    'CCAB' => 'TLS_PSK_WITH_CHACHA20_POLY1305',
    'CCAC' => 'TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305',
    'CCAD' => 'TLS_DHE_PSK_WITH_CHACHA20_POLY1305',
    'CCAE' => 'TLS_RSA_PSK_WITH_CHACHA20_POLY1305',
    'CC13' => 'OLD_TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256',
    'CC14' => 'OLD_TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256',
    'CC15' => 'OLD_TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256',
    'FEFE' => 'SSL_RSA_FIPS_WITH_DES_CBC_SHA',
    'FEFF' => 'SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA',
    'FFE0' => 'SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA',
    'FFE1' => 'SSL_RSA_FIPS_WITH_DES_CBC_SHA'
  }.invert.freeze
end
