/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.gem.dependency;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.gem.dependency.DummyGemInfo;
import com.intellij.diagram.gem.dependency.GemDependencyDiagramProvider;
import com.intellij.diagram.gem.dependency.GemDependencyNode;
import com.intellij.diagram.gem.dependency.GemDependencyRelationShip;
import com.intellij.diagram.gem.dependency.GemDependencyUmlEdge;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.GemEnvironment;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public class GemDependencyDataModel
extends DiagramDataModel<GemInfo> {
    private final Module myModule;
    private final Set<GemInfo> myGems;
    private final Set<DiagramNode<GemInfo>> myGemNodes;
    private final Set<DiagramNode<GemInfo>> myDependentGemNodes;
    private final Set<DiagramNode<GemInfo>> myNodes;
    private final Collection<DiagramEdge<GemInfo>> myEdges;

    public GemDependencyDataModel(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            GemDependencyDataModel.$$$reportNull$$$0(0);
        }
        if (module == null) {
            GemDependencyDataModel.$$$reportNull$$$0(1);
        }
        super(project, GemDependencyDiagramProvider.getInstance());
        this.myGems = new HashSet();
        this.myGemNodes = new HashSet();
        this.myDependentGemNodes = new HashSet();
        this.myNodes = new HashSet();
        this.myEdges = new HashSet();
        this.myModule = module;
    }

    @NotNull
    public Collection<? extends DiagramNode<GemInfo>> getNodes() {
        Set<DiagramNode<GemInfo>> set = this.myNodes;
        if (set == null) {
            GemDependencyDataModel.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Collection<? extends DiagramEdge<GemInfo>> getEdges() {
        Collection<DiagramEdge<GemInfo>> collection = this.myEdges;
        if (collection == null) {
            GemDependencyDataModel.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public String getNodeName(DiagramNode<GemInfo> node) {
        String name = node.getTooltip();
        String string = name != null ? name : "";
        if (string == null) {
            GemDependencyDataModel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public DiagramNode<GemInfo> addElement(GemInfo element) {
        return null;
    }

    public void refreshDataModel() {
        this.init();
        for (GemInfo gemInfo : this.myGems) {
            if (gemInfo == null) continue;
            this.myGemNodes.add((DiagramNode<GemInfo>)new GemDependencyNode(gemInfo));
        }
        this.myNodes.addAll(this.myGemNodes);
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(this.myModule);
        GemDependencyNode defaultNode = new GemDependencyNode(new DummyGemInfo(this.myModule.getName(), sdk, this.myModule));
        this.myNodes.add((DiagramNode<GemInfo>)defaultNode);
        Set environments = BundlerUtil.getGemEnvironments((Module)this.myModule);
        if (!environments.isEmpty()) {
            for (GemEnvironment environment : environments) {
                GemDependencyNode envNode = new GemDependencyNode(new DummyGemInfo(environment.getName(), sdk, this.myModule));
                this.myNodes.add((DiagramNode<GemInfo>)envNode);
                this.fillEdges(defaultNode, environment, envNode);
            }
        } else {
            this.fillEdges(defaultNode);
        }
    }

    private void fillEdges(GemDependencyNode defaultNode) {
        for (DiagramNode<GemInfo> node : this.myGemNodes) {
            GemInfo gem = (GemInfo)node.getIdentifyingElement();
            for (GemDependency dep : gem.getDependencies()) {
                DiagramNode<GemInfo> dependentNode = this.findNodeByGem(GemSearchUtil.findGem(this.myGems, (GemDependency)dep));
                if (dependentNode == null) continue;
                this.myDependentGemNodes.add(dependentNode);
                GemDependencyUmlEdge edge = new GemDependencyUmlEdge(node, dependentNode, new GemDependencyRelationShip(""));
                this.myEdges.add((DiagramEdge<GemInfo>)edge);
            }
        }
        for (DiagramNode<GemInfo> node : this.myGemNodes) {
            if (this.myDependentGemNodes.contains(node)) continue;
            GemDependencyUmlEdge defaultEdge = new GemDependencyUmlEdge((DiagramNode<GemInfo>)defaultNode, node, new GemDependencyRelationShip(""));
            this.myEdges.add((DiagramEdge<GemInfo>)defaultEdge);
        }
    }

    private void fillEdges(GemDependencyNode defaultNode, GemEnvironment environment, GemDependencyNode envNode) {
        for (DiagramNode<GemInfo> node : this.myGemNodes) {
            String gemName;
            GemInfo gem = (GemInfo)node.getIdentifyingElement();
            for (GemDependency dep : gem.getDependencies()) {
                DiagramNode<GemInfo> dependentNode = this.findNodeByGem(GemSearchUtil.findGem(this.myGems, (GemDependency)dep));
                if (dependentNode == null) continue;
                GemDependencyUmlEdge edge = new GemDependencyUmlEdge(node, dependentNode, new GemDependencyRelationShip(""));
                this.myEdges.add((DiagramEdge<GemInfo>)edge);
            }
            List environmentGems = environment.getGems();
            if (environmentGems.contains(gemName = gem.getName())) {
                GemDependencyUmlEdge envEdge = new GemDependencyUmlEdge((DiagramNode<GemInfo>)envNode, node, new GemDependencyRelationShip(""));
                this.myEdges.add((DiagramEdge<GemInfo>)envEdge);
                continue;
            }
            GemDependencyUmlEdge defaultEdge = new GemDependencyUmlEdge((DiagramNode<GemInfo>)defaultNode, node, new GemDependencyRelationShip(""));
            this.myEdges.add((DiagramEdge<GemInfo>)defaultEdge);
        }
    }

    private void init() {
        this.cleanUp();
        this.myGems.addAll(GemManager.getAllGems((Module)this.myModule));
    }

    private void cleanUp() {
        this.myGems.clear();
        this.myNodes.clear();
        this.myEdges.clear();
        this.myGemNodes.clear();
        this.myDependentGemNodes.clear();
    }

    public void removeNode(DiagramNode<GemInfo> node) {
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            GemDependencyDataModel.$$$reportNull$$$0(5);
        }
        return psiModificationTracker;
    }

    public void dispose() {
    }

    @Nullable
    private DiagramNode<GemInfo> findNodeByGem(@Nullable GemInfo gem) {
        if (gem == null) {
            return null;
        }
        for (DiagramNode<GemInfo> node : this.myGemNodes) {
            if (!((GemInfo)node.getIdentifyingElement()).equals((Object)gem)) continue;
            return node;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/gem/dependency/GemDependencyDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/gem/dependency/GemDependencyDataModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

