/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeBase;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.openapi.util.Key;
import gnu.trove.THashMap;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramEdgeBase<T>
implements DiagramEdge<T> {
    private final THashMap myUserData;
    protected final DiagramNode<T> mySource;
    protected final DiagramNode<T> myTarget;
    protected final DiagramRelationshipInfo myRelationship;
    private final String myDebugInfo;
    private Object mySourceAnchor;
    private Object myTargetAnchor;
    private Color myAnchorColor;

    public DiagramEdgeBase(@NotNull DiagramNode<T> source, @NotNull DiagramNode<T> target, @NotNull DiagramRelationshipInfo relationship) {
        if (source == null) {
            DiagramEdgeBase.$$$reportNull$$$0(0);
        }
        if (target == null) {
            DiagramEdgeBase.$$$reportNull$$$0(1);
        }
        if (relationship == null) {
            DiagramEdgeBase.$$$reportNull$$$0(2);
        }
        this.myUserData = new THashMap();
        this.mySourceAnchor = null;
        this.myTargetAnchor = null;
        this.myAnchorColor = null;
        this.mySource = source;
        this.myTarget = target;
        this.myRelationship = relationship;
        if (source instanceof DiagramNodeBase && target instanceof DiagramNodeBase) {
            String fqn1 = source instanceof DiagramNoteNode ? "Note" : ((DiagramNodeBase)source).getFQN();
            String fqn2 = target instanceof DiagramNoteNode ? "Note" : ((DiagramNodeBase)target).getFQN();
            this.myDebugInfo = fqn1 + " -> " + fqn2 + " (" + this.myRelationship + ")";
        } else {
            this.myDebugInfo = this.toString();
        }
    }

    @Override
    public DiagramNode<T> getSource() {
        return this.mySource;
    }

    @Override
    public DiagramNode<T> getTarget() {
        return this.myTarget;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    @NotNull
    public T getIdentifyingElement() {
        T t = this.getSource().getIdentifyingElement();
        if (t == null) {
            DiagramEdgeBase.$$$reportNull$$$0(3);
        }
        return t;
    }

    @Override
    @NotNull
    public DiagramRelationshipInfo getRelationship() {
        DiagramRelationshipInfo diagramRelationshipInfo = this.myRelationship;
        if (diagramRelationshipInfo == null) {
            DiagramEdgeBase.$$$reportNull$$$0(4);
        }
        return diagramRelationshipInfo;
    }

    public <Type> Type getUserData(@NotNull Key<Type> key) {
        if (key == null) {
            DiagramEdgeBase.$$$reportNull$$$0(5);
        }
        return (Type)this.myUserData.get(key);
    }

    public <Type> void putUserData(@NotNull Key<Type> key, @Nullable Type value) {
        if (key == null) {
            DiagramEdgeBase.$$$reportNull$$$0(6);
        }
        this.myUserData.put(key, value);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            DiagramEdge e = (DiagramEdge)obj;
            DiagramNode source = e.getSource();
            DiagramNode target = e.getTarget();
            DiagramRelationshipInfo relationship = e.getRelationship();
            return source != null && source.equals(this.getSource()) && target != null && target.equals(this.getTarget()) && relationship.equals(this.getRelationship());
        }
        return false;
    }

    public int hashCode() {
        return 961 * this.getSource().hashCode() + 31 * this.getTarget().hashCode() + this.getRelationship().hashCode();
    }

    public String toString() {
        return this.myDebugInfo;
    }

    @Override
    public Object getSourceAnchor() {
        return this.mySourceAnchor;
    }

    public void setSourceAnchor(Object sourceAnchor) {
        this.mySourceAnchor = sourceAnchor;
    }

    @Override
    public Object getTargetAnchor() {
        return this.myTargetAnchor;
    }

    public void setTargetAnchor(Object targetAnchor) {
        this.myTargetAnchor = targetAnchor;
    }

    @Override
    public Color getAnchorColor() {
        return this.myAnchorColor;
    }

    public void setAnchorColor(Color anchorColor) {
        this.myAnchorColor = anchorColor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationship";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/DiagramEdgeBase";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/DiagramEdgeBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifyingElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelationship";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

