/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.integration;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSAnnotationError {
    public static final String ERROR_CATEGORY = "error";
    public static final String WARNING_CATEGORY = "warning";
    public static final String INFO_CATEGORY = "info";
    public static final String HIDE_CATEGORY = "hide";

    public int getLine();

    public int getColumn();

    @Nullable
    public String getAbsoluteFilePath();

    @NotNull
    public String getDescription();

    @NotNull
    default public HighlightSeverity getSeverity() {
        String category = this.getCategory();
        if (category == null) {
            HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
            if (highlightSeverity == null) {
                JSAnnotationError.$$$reportNull$$$0(0);
            }
            return highlightSeverity;
        }
        switch (category) {
            case "error": {
                HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
                if (highlightSeverity == null) {
                    JSAnnotationError.$$$reportNull$$$0(1);
                }
                return highlightSeverity;
            }
            case "warning": {
                HighlightSeverity highlightSeverity = HighlightSeverity.WARNING;
                if (highlightSeverity == null) {
                    JSAnnotationError.$$$reportNull$$$0(2);
                }
                return highlightSeverity;
            }
            case "info": 
            case "hide": {
                HighlightSeverity highlightSeverity = HighlightSeverity.INFORMATION;
                if (highlightSeverity == null) {
                    JSAnnotationError.$$$reportNull$$$0(3);
                }
                return highlightSeverity;
            }
        }
        HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
        if (highlightSeverity == null) {
            JSAnnotationError.$$$reportNull$$$0(4);
        }
        return highlightSeverity;
    }

    @Nullable
    default public String getTooltipText() {
        return null;
    }

    @Nullable
    default public String getCategory() {
        return ERROR_CATEGORY;
    }

    @Nullable
    default public ProblemHighlightType getHighlightType() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/integration/JSAnnotationError", "getSeverity"));
    }
}

