/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.presentable.Capitalization;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.HighlightingUtils;
import com.intellij.lang.javascript.refactoring.JSRefactoringSettings;
import com.intellij.lang.javascript.refactoring.inline.JSFunctionInliner;
import com.intellij.lang.javascript.refactoring.inline.JSVarOrFieldInliner;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.GenericInlineHandler;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInlineHandler
extends InlineActionHandler {
    private final boolean mySuppressDialog;

    public JSInlineHandler(boolean suppressDialog) {
        this.mySuppressDialog = suppressDialog;
    }

    public JSInlineHandler() {
        this(false);
    }

    public boolean isEnabledForLanguage(Language l) {
        return l.isKindOf((Language)JavascriptLanguage.INSTANCE);
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof JSElement;
    }

    public void inlineElement(Project project, Editor editor, PsiElement originalElement) {
        PsiReference invocationReference = editor != null ? TargetElementUtil.findReference((Editor)editor) : null;
        PsiElement elementToInline = JSInlineHandler.adjustElementToInline(originalElement);
        Settings settings = this.prepareInlineElement(elementToInline, editor, invocationReference);
        if (settings == null) {
            return;
        }
        Inliner inliner = this.createInliner(settings, elementToInline);
        if (inliner == null) {
            return;
        }
        Collection<PsiReference> allReferences = settings.isOnlyOneReferenceToInline() ? Collections.singleton(invocationReference) : settings.getUsages();
        MultiMap conflicts = new MultiMap();
        for (PsiReference reference : allReferences) {
            inliner.checkConflicts(reference, (MultiMap<PsiElement, String>)conflicts);
        }
        if (!JSRefactoringUtil.showConflictsDialog(project, (MultiMap<PsiElement, String>)conflicts)) {
            return;
        }
        List toCheckForReadonly = ContainerUtil.mapNotNull(allReferences, PsiReference::getElement);
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, (Collection)toCheckForReadonly, (boolean)true)) {
            return;
        }
        String elementName = elementToInline instanceof PsiNamedElement ? ((PsiNamedElement)elementToInline).getName() : "element";
        WriteCommandAction.runWriteCommandAction((Project)project, (String)RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{elementName}), null, () -> {
            Object[] references = GenericInlineHandler.sortDepthFirstRightLeftOrder((Collection)allReferences);
            HashSet<PsiFile> filesToOptimizeImports = new HashSet<PsiFile>();
            for (UsageInfo usage : ContainerUtil.map((Object[])references, UsageInfo::new)) {
                PsiElement replacement = inliner.inlineUsage(usage);
                if (replacement == null) continue;
                filesToOptimizeImports.add(replacement.getContainingFile());
            }
            for (PsiFile file2 : filesToOptimizeImports) {
                ES6CreateImportUtil.optimizeImports((PsiElement)file2);
            }
            if (!settings.isOnlyOneReferenceToInline()) {
                inliner.removeDefinition(elementToInline);
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    @NotNull
    private static PsiElement adjustElementToInline(@NotNull PsiElement element) {
        PsiElement resolved;
        JSExpression value;
        if (element == null) {
            JSInlineHandler.$$$reportNull$$$0(0);
        }
        if (element instanceof ES6Property && ((ES6Property)element).isShorthanded() && (value = ((ES6Property)element).getValue()) instanceof JSReferenceExpression && (resolved = ((JSReferenceExpression)value).resolve()) instanceof JSVariable) {
            PsiElement psiElement = resolved;
            if (psiElement == null) {
                JSInlineHandler.$$$reportNull$$$0(1);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JSInlineHandler.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @Nullable
    protected final Settings prepareInlineElement(@NotNull PsiElement element, Editor editor, @Nullable PsiReference invocationReference) {
        NotNullLazyValue<Collection<PsiReference>> elementUsages;
        Settings settings;
        if (element == null) {
            JSInlineHandler.$$$reportNull$$$0(3);
        }
        if ((settings = this.getSettingsForElement(element, editor, invocationReference, elementUsages = JSInlineHandler.getDeferredUsagesForElement(element))) == null) {
            return null;
        }
        int occurenceCount = ((Collection)elementUsages.getValue()).size();
        if (occurenceCount == 0) {
            JSInlineHandler.showErrorHint(element, editor, JSBundle.message((String)"javascript.inline.element.is.not.used", (Object[])new Object[]{new JSNamedElementPresenter(element, Capitalization.UpperCase).describeWithShortName()}));
            return null;
        }
        if (ContainerUtil.find((Iterable)((Iterable)elementUsages.getValue()), reference -> reference.getElement() instanceof JSXmlLiteralExpression) != null) {
            JSInlineHandler.showErrorHint(element, editor, JSBundle.message((String)"javascript.refactoring.cannot.inline.jsx.usage", (Object[])new Object[0]));
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return settings;
        }
        if (editor != null) {
            ArrayList<PsiReference> referencesToHighlightFromCurrentEditor = new ArrayList<PsiReference>();
            VirtualFile file2 = JSInlineHandler.getPhysicalFileOfEditor(editor);
            for (PsiReference ref : (Collection)elementUsages.getValue()) {
                if (!Comparing.equal((Object)file2, (Object)JSInlineHandler.getVirtualFile(ref.getElement().getContainingFile()))) continue;
                referencesToHighlightFromCurrentEditor.add(ref);
            }
            settings.highlightUsages(editor, referencesToHighlightFromCurrentEditor);
        }
        if (this.mySuppressDialog) {
            return settings;
        }
        JSNamedElementPresenter presenter = new JSNamedElementPresenter(element, Capitalization.EachWordUpperCase);
        String inlineTitle = JSBundle.message((String)"inline.0.dialog.title", (Object[])new Object[]{presenter.describeElementKind()});
        String inlineAllMessage = "Inline " + presenter.describeWithShortName() + (!settings.isOnlyOneReferenceToInline() ? "?" : "") + " (" + occurenceCount + " occurrence" + (occurenceCount > 1 ? "s" : "") + ")";
        String kind = new JSNamedElementPresenter(element).describeElementKind();
        JSInlineOptionsDialog dialog = new JSInlineOptionsDialog(element, inlineTitle, inlineAllMessage + (element.isWritable() ? " and remove the " + kind : ""), "Inline this usage and keep the " + kind, presenter.describeWithShortName(), settings.isInvokedOnReference());
        if (!dialog.showAndGet()) {
            return null;
        }
        settings.setOneRefToInline(dialog.isInlineThisOnly());
        return settings;
    }

    @Nullable
    protected Settings getSettingsForElement(@NotNull PsiElement element, Editor editor, @Nullable PsiReference invocationReference, NotNullLazyValue<Collection<PsiReference>> elementUsages) {
        if (element == null) {
            JSInlineHandler.$$$reportNull$$$0(4);
        }
        if (element instanceof JSClass && invocationReference != null && invocationReference.getElement() instanceof JSReferenceExpression && invocationReference.getElement().getParent() instanceof JSCallExpression) {
            JSFunctionInliner.inlineFunctionProblem(JSBundle.message((String)"javascript.refactoring.cannot.inline.constructor", (Object[])new Object[0]), editor, element.getProject());
            return null;
        }
        boolean invokedOnReference = invocationReference != null && (!(invocationReference instanceof JSReferenceExpression) || !JSResolveUtil.isSelfReference((PsiElement)((JSReferenceExpression)invocationReference)));
        JSFunction function = JSPsiImplUtils.getPossibleFunction(element);
        if (function != null) {
            return JSFunctionInliner.handleFunction(element, function, editor, invokedOnReference, elementUsages);
        }
        if (element instanceof JSVariable) {
            return JSVarOrFieldInliner.handleVariable((JSVariable)element, editor, invocationReference, elementUsages, invokedOnReference);
        }
        return null;
    }

    @NotNull
    private static NotNullLazyValue<Collection<PsiReference>> getDeferredUsagesForElement(final @NotNull PsiElement element) {
        if (element == null) {
            JSInlineHandler.$$$reportNull$$$0(5);
        }
        NotNullLazyValue<Collection<PsiReference>> notNullLazyValue = new NotNullLazyValue<Collection<PsiReference>>(){

            @NotNull
            protected Collection<PsiReference> compute() {
                ArrayList<PsiReference> referenceCollection = new ArrayList<PsiReference>();
                boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                    if (element == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    SearchScope useScope = (SearchScope)ReadAction.compute(() -> {
                        if (element == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return element.getUseScope();
                    });
                    ReferencesSearch.search((PsiElement)element, (SearchScope)useScope).forEach(psiReference -> {
                        if (element == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (psiReference.getElement().getParent() != element && JSInlineHandler.isInlinableReference(psiReference)) {
                            referenceCollection.add((PsiReference)psiReference);
                        }
                        return true;
                    });
                }, JSBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), true, element.getProject());
                if (!completed) {
                    throw new ProcessCanceledException();
                }
                ArrayList<PsiReference> arrayList = referenceCollection;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "compute";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$compute$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$null$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$null$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (notNullLazyValue == null) {
            JSInlineHandler.$$$reportNull$$$0(6);
        }
        return notNullLazyValue;
    }

    static void showErrorHint(@NotNull PsiElement element, @Nullable Editor editor, @NotNull String message) {
        if (element == null) {
            JSInlineHandler.$$$reportNull$$$0(7);
        }
        if (message == null) {
            JSInlineHandler.$$$reportNull$$$0(8);
        }
        CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)message, (String)"Inline", null);
    }

    public static boolean isInlinableReference(PsiReference psiReference) {
        return !(psiReference instanceof JSTextReference) || !psiReference.isSoft();
    }

    static VirtualFile getPhysicalFileOfEditor(Editor editor) {
        PsiFile psifile = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument());
        return JSInlineHandler.getVirtualFile(psifile);
    }

    static VirtualFile getVirtualFile(PsiFile psifile) {
        VirtualFile file2 = psifile.getVirtualFile();
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        return file2;
    }

    @Nullable
    protected Inliner createInliner(@NotNull Settings settings, @NotNull PsiElement elementToInline) {
        JSFunction function;
        if (settings == null) {
            JSInlineHandler.$$$reportNull$$$0(9);
        }
        if (elementToInline == null) {
            JSInlineHandler.$$$reportNull$$$0(10);
        }
        if ((function = JSPsiImplUtils.getPossibleFunction(elementToInline)) != null) {
            return new JSFunctionInliner(elementToInline, function);
        }
        if (elementToInline instanceof JSVariable) {
            return new JSVarOrFieldInliner((JSVariable)elementToInline, (JSVarOrFieldInliner.MySettings)settings);
        }
        return null;
    }

    static void addThisReference(PsiElement node, PsiElement qualifier, PsiElement psiElement, int funOffset, Set<? super RangeMarker> thisRefs, Document document) {
        if ((psiElement instanceof JSFunction || psiElement instanceof JSVariable) && JSResolveUtil.findParent(psiElement) instanceof JSClass) {
            if (JSResolveUtil.isConstructorFunction(psiElement)) {
                return;
            }
            JSInlineHandler.doAddThisReference(node, qualifier, funOffset, thisRefs, document);
        }
    }

    static void doAddThisReference(PsiElement node, PsiElement qualifier, int funOffset, Set<? super RangeMarker> thisRefs, Document document) {
        TextRange range;
        if (qualifier != null) {
            range = qualifier.getTextRange().shiftRight(funOffset);
        } else {
            int offset = node.getTextRange().getStartOffset() + funOffset;
            range = new TextRange(offset, offset);
        }
        thisRefs.add((RangeMarker)document.createRangeMarker(range));
    }

    static void checkES6ModuleConflicts(@NotNull ES6ReferenceExpressionsInfo info, @NotNull JSQualifiedNamedElement toReport, @Nullable PsiElement usageModule, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (info == null) {
            JSInlineHandler.$$$reportNull$$$0(11);
        }
        if (toReport == null) {
            JSInlineHandler.$$$reportNull$$$0(12);
        }
        if (conflicts == null) {
            JSInlineHandler.$$$reportNull$$$0(13);
        }
        if (usageModule == ES6PsiUtil.findExternalModule((PsiElement)toReport)) {
            return;
        }
        ES6ReferenceExpressionsInfo.addValidations(info, (JSPsiElementBase)toReport, (Condition<? super PsiElement>)((Condition)t -> t instanceof JSParameter), conflicts);
    }

    static void deleteElementWithReformat(@NotNull PsiElement element) {
        if (element == null) {
            JSInlineHandler.$$$reportNull$$$0(14);
        }
        FormatFixer.Mode mode = FormatFixer.Mode.InSpecifiedRangeMakeFormatterWorkAndLeaveWsBeforeAndAfterIntact;
        FormatFixer fixer = FormatFixer.create(element, mode);
        element.delete();
        fixer.fixFormat();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToInline";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReport";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustElementToInline";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeferredUsagesForElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustElementToInline";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareInlineElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsForElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDeferredUsagesForElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createInliner";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkES6ModuleConflicts";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deleteElementWithReformat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface Inliner {
        public void checkConflicts(@NotNull PsiReference var1, @NotNull MultiMap<PsiElement, String> var2);

        @Nullable
        public PsiElement inlineUsage(@NotNull UsageInfo var1);

        default public void removeDefinition(@NotNull PsiElement element) {
            if (element == null) {
                Inliner.$$$reportNull$$$0(0);
            }
            JSInlineHandler.deleteElementWithReformat(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler$Inliner", "removeDefinition"));
        }
    }

    private static class JSInlineOptionsDialog
    extends InlineOptionsDialog {
        private final String myInlineAllText;
        private final String myInlineThisText;
        private final String myNameLabelText;

        protected JSInlineOptionsDialog(PsiElement element, String title, String inlineAllText, String inlineThisText, String nameLabelText, boolean isInvokedOnReference) {
            super(element.getProject(), true, element);
            this.myInlineAllText = inlineAllText;
            this.myInlineThisText = inlineThisText;
            this.myNameLabelText = nameLabelText;
            this.myInvokedOnReference = isInvokedOnReference;
            this.setTitle(title);
            this.init();
        }

        protected String getNameLabelText() {
            return this.myNameLabelText;
        }

        protected String getBorderTitle() {
            return "Inline";
        }

        protected String getInlineAllText() {
            return this.myInlineAllText;
        }

        protected String getInlineThisText() {
            return this.myInlineThisText;
        }

        protected boolean isInlineThis() {
            return JSRefactoringSettings.getInstance().INLINE_THIS;
        }

        protected void doAction() {
            JSRefactoringSettings settings = JSRefactoringSettings.getInstance();
            if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
                settings.INLINE_THIS = this.isInlineThisOnly();
            }
            this.close(0);
        }

        protected boolean hasHelpAction() {
            return false;
        }

        protected boolean hasPreviewButton() {
            return false;
        }
    }

    protected static class Settings {
        final List<RangeMarker> myHighlightedMarkers = new ArrayList<RangeMarker>();
        @Nullable
        final Editor editor;
        private final NotNullLazyValue<Collection<PsiReference>> myDeferredUsages;
        private boolean myOneRefToInline;
        private final boolean myInvokedOnReference;
        private final PsiFile myFile;

        public Settings(PsiElement elementToSearchForReferences, NotNullLazyValue<Collection<PsiReference>> deferredUsages, boolean invokedOnReference, @Nullable Editor editor) {
            this.myDeferredUsages = deferredUsages;
            this.myInvokedOnReference = invokedOnReference;
            this.myOneRefToInline = invokedOnReference;
            this.myFile = elementToSearchForReferences.getContainingFile();
            this.editor = editor != null ? InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)this.myFile) : null;
        }

        public void addRangeHighlighterForPsiElement(PsiElement element) {
            if (this.editor != null && element.getContainingFile() == this.myFile) {
                this.myHighlightedMarkers.add(this.editor.getDocument().createRangeMarker(element.getTextRange()));
            }
        }

        public boolean isOnlyOneReferenceToInline() {
            return this.myOneRefToInline;
        }

        public void setOneRefToInline(boolean oneRefToInline) {
            this.myOneRefToInline = oneRefToInline;
        }

        public void highlightUsages(Editor editor, Collection<PsiReference> refs) {
            ArrayList<PsiElement> refsToHighlight = new ArrayList<PsiElement>();
            for (PsiReference ref : refs) {
                refsToHighlight.add(ref.getElement());
            }
            Project project = editor.getProject();
            HighlightingUtils.doHighlightOccurences(project, editor, new HighlightingUtils.PsiElementsOccurrenceInfoSource(PsiUtilCore.toPsiElementArray(refsToHighlight)), false);
            HighlightingUtils.informThatHighlightingCanbeRemoved(project);
        }

        @NotNull
        public Collection<PsiReference> getUsages() {
            Collection collection = (Collection)this.myDeferredUsages.getValue();
            if (collection == null) {
                Settings.$$$reportNull$$$0(0);
            }
            return collection;
        }

        public boolean isInvokedOnReference() {
            return this.myInvokedOnReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler$Settings", "getUsages"));
        }
    }
}

