/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Set;

public class LocalPathsSet {
    private final Set<String> mySet = ContainerUtil.newHashSet();

    public LocalPathsSet(Collection<String> paths) {
        for (String path : paths) {
            this.mySet.add(LocalPathsSet.convert(path));
        }
    }

    private static String convert(String value) {
        return (SystemInfo.isFileSystemCaseSensitive ? value : value.toLowerCase()).replace("\\", "/");
    }

    public boolean contains(File file) {
        String modified = LocalPathsSet.convert(file.getAbsolutePath());
        return this.mySet.contains(modified);
    }
}

