/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.SingletonFamily;
import com.intellij.database.util.DbImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelUtil {
    public static final Comparator<? super BasicElement> DISPLAY_ORDER_COMPARATOR = (e1, e2) -> {
        String s1 = e1.getDisplayOrder();
        String s2 = e2.getDisplayOrder();
        return s1.compareTo(s2);
    };
    public static final Comparator<? super BasicArrangedElement> POSITIONS_COMPARATOR = (e1, e2) -> {
        short p2;
        short p1 = e1.getPosition();
        return p1 < (p2 = e2.getPosition()) ? -1 : (p1 > p2 ? 1 : 0);
    };

    @Nullable
    public static String nameOf(@Nullable BasicNamedElement element2) {
        return element2 != null ? element2.getRealName() : null;
    }

    public static String calculateSybProcedureIdentity(short pos) {
        return Short.toString(pos);
    }

    public static String calculateRoutineIdentity(@Nullable String name, @NotNull Iterable<? extends DasArgument> args2) {
        if (args2 == null) {
            ModelUtil.$$$reportNull$$$0(0);
        }
        return ModelUtil.calculateRoutineIdentityByType(name, (Iterable<DataType>)JBIterable.from(args2).filterMap(a -> a.getArgumentDirection().isIn() ? a.getDataType() : null));
    }

    public static String calculateRoutineIdentityByType(@Nullable String name, @NotNull Iterable<DataType> types) {
        if (types == null) {
            ModelUtil.$$$reportNull$$$0(1);
        }
        StringBuilder b2 = new StringBuilder();
        b2.append(name);
        boolean w = false;
        b2.append('(');
        for (DataType a : types) {
            if (w) {
                b2.append(',');
            }
            b2.append(a.getSpecification());
            w = true;
        }
        b2.append(')');
        return b2.toString();
    }

    @NotNull
    public static String calculateOverloadableIdentity(@NotNull BasicOverloadable o, boolean includingSurrogate) {
        String name;
        if (o == null) {
            ModelUtil.$$$reportNull$$$0(2);
        }
        if (o instanceof DasPositioned && DbImplUtil.getDbms(o) == Dbms.SYBASE) {
            String string = ModelUtil.calculateSybProcedureIdentity(((DasPositioned)o).getPosition());
            if (string == null) {
                ModelUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        BasicNamedElement ne = (BasicNamedElement)ObjectUtils.tryCast((Object)o, BasicNamedElement.class);
        String string = ne == null ? "" : (name = includingSurrogate ? ne.getRealName() : ne.getNaturalName());
        if (o instanceof BasicRoutine) {
            String string2 = ModelUtil.calculateRoutineIdentity(name, ((BasicRoutine)((Object)o)).getArguments());
            if (string2 == null) {
                ModelUtil.$$$reportNull$$$0(4);
            }
            return string2;
        }
        if (o instanceof DasOperator) {
            String string3 = ModelUtil.calculateRoutineIdentityByType(name, ((DasOperator)o).getArgumentTypes());
            if (string3 == null) {
                ModelUtil.$$$reportNull$$$0(5);
            }
            return string3;
        }
        String string4 = String.valueOf(name);
        if (string4 == null) {
            ModelUtil.$$$reportNull$$$0(6);
        }
        return string4;
    }

    @Nullable
    public static BasicElement findObject(@NotNull Family<?> target, @NotNull BasicElement child) {
        BasicElement res2;
        if (target == null) {
            ModelUtil.$$$reportNull$$$0(7);
        }
        if (child == null) {
            ModelUtil.$$$reportNull$$$0(8);
        }
        if (target instanceof SingletonFamily) {
            return ((SingletonFamily)target).get();
        }
        if (child instanceof BasicOverloadable) {
            String identity = child.identity();
            return target.find(x -> x.identity().equals(identity));
        }
        String name = child.getName();
        boolean surrogate = ModelUtil.isSurrogate(child);
        if (!surrogate) {
            res2 = target.find(x -> x.getName().equals(name));
        } else {
            String id = child.identity(false);
            res2 = target.find(x -> ModelUtil.isSurrogate(x) && x.identity(false).equals(id));
        }
        return res2;
    }

    private static boolean isSurrogate(@NotNull BasicElement child) {
        if (child == null) {
            ModelUtil.$$$reportNull$$$0(9);
        }
        return child instanceof BasicModNamedElement && ((BasicModNamedElement)child).isNameSurrogate() || child.getName().isEmpty() && (child instanceof BasicConstraint || child instanceof BasicLikeColumn || child instanceof BasicArgument);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ModelUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ModelUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateOverloadableIdentity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateRoutineIdentity";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateRoutineIdentityByType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calculateOverloadableIdentity";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findObject";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSurrogate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

