/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ruby.performanceTesting;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.sampullara.cli.Argument;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolScopeUtil;
import org.jetbrains.ruby.performanceTesting.RubyAbstractCommand;

public class GetAncestors
extends RubyAbstractCommand<Options> {
    public static final String PREFIX = "%rubyGetAncestors";

    public GetAncestors(@NotNull Project project, @NotNull String text, int line) {
        if (project == null) {
            GetAncestors.$$$reportNull$$$0(0);
        }
        if (text == null) {
            GetAncestors.$$$reportNull$$$0(1);
        }
        super(project, text, line, PREFIX, new Options(), false);
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper(this.getProject());
        ReadAction.run(() -> this.lambda$_execute$0(context, (ActionCallback)actionCallback));
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$_execute$0(PlaybackContext context, ActionCallback actionCallback) throws RuntimeException {
        try {
            Options options = (Options)this.getOptions();
            Symbol symbol = SymbolUtil.findConstantByFQN((Project)this.getProject(), (String)options.fqn);
            if (symbol == null) {
                context.error("fqn not found", this.getLine());
                return;
            }
            if (options.clearCache) {
                this.clearCaches();
            }
            long time = System.currentTimeMillis();
            List ancestors = SymbolScopeUtil.getAncestorsCaching((Symbol)symbol, null);
            context.message(String.format("Got %d for %s with %dms", ancestors.size(), options.fqn, System.currentTimeMillis() - time), this.getLine());
        }
        finally {
            actionCallback.setDone();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/ruby/performanceTesting/GetAncestors";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Options {
        @Argument
        public String fqn;
        @Argument
        public boolean clearCache;
    }
}

