/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.Map;
import org.sablecc.sablecc.IntegerCast;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.StringCast;
import org.sablecc.sablecc.TypedHashMap;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAlt;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.AProd;
import org.sablecc.sablecc.node.ATokenSpecifier;

public class ComputeSimpleTermPosition
extends DepthFirstAdapter {
    String currentAlt;
    String currentProd;
    boolean processingParsedAlt;
    private ResolveIds ids;
    private int counter;
    public final Map positionsMap = new TypedHashMap(StringCast.instance, StringCast.instance);
    public final Map elems_position = new TypedHashMap(StringCast.instance, IntegerCast.instance);

    public ComputeSimpleTermPosition(ResolveIds ids) {
        this.ids = ids;
    }

    @Override
    public void inAProd(AProd node) {
        this.currentProd = ResolveIds.name(node.getId().getText());
        this.ids.names.put(node, this.currentProd);
    }

    @Override
    public void inAAlt(AAlt node) {
        this.counter = 0;
        this.processingParsedAlt = true;
        this.currentAlt = node.getAltName() != null ? "A" + ResolveIds.name(node.getAltName().getText()) + this.currentProd : "A" + this.currentProd;
        this.ids.names.put(node, this.currentAlt);
    }

    @Override
    public void inAElem(AElem node) {
        if (this.processingParsedAlt) {
            String currentElemName = node.getElemName() != null ? this.currentAlt + "." + node.getElemName().getText() : this.currentAlt + "." + node.getId().getText();
            this.elems_position.put(currentElemName, new Integer(++this.counter));
        }
        if (node.getSpecifier() != null && node.getSpecifier() instanceof ATokenSpecifier) {
            return;
        }
        String elemType = (String)this.ids.elemTypes.get(node);
        if (this.processingParsedAlt && elemType.startsWith("P")) {
            String elemName = node.getElemName() != null ? node.getElemName().getText() : node.getId().getText();
            this.positionsMap.put(this.currentAlt + "." + elemName, elemType);
        }
    }

    @Override
    public void outAAlt(AAlt node) {
        this.processingParsedAlt = false;
    }
}

