/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class UTF_16Encoder
extends CharsetEncoder {
    static final int BIG_ENDIAN = 0;
    static final int LITTLE_ENDIAN = 1;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private final ByteOrder byteOrder;
    private final boolean useByteOrderMark;
    private boolean needsByteOrderMark;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        CoderResult coderResult;
        int inPos;
        block12: {
            CoderResult coderResult2;
            block16: {
                CoderResult coderResult3;
                block15: {
                    CoderResult coderResult4;
                    block14: {
                        CoderResult coderResult5;
                        ByteOrder originalBO = out.order();
                        out.order(this.byteOrder);
                        if (this.needsByteOrderMark) {
                            if (out.remaining() < 2) {
                                out.order(originalBO);
                                return CoderResult.OVERFLOW;
                            }
                            out.putChar('\ufeff');
                            this.needsByteOrderMark = false;
                        }
                        inPos = in.position();
                        try {
                            while (true) {
                                if (!in.hasRemaining()) {
                                    out.order(originalBO);
                                    coderResult = CoderResult.UNDERFLOW;
                                    break block12;
                                }
                                char c = in.get();
                                if ('\ud800' <= c && c <= '\udfff') {
                                    if (c > '\udbff') {
                                        coderResult5 = CoderResult.malformedForLength(1);
                                        Object var6_12 = null;
                                        break;
                                    }
                                    if (in.remaining() < 1) {
                                        coderResult4 = CoderResult.UNDERFLOW;
                                        break block14;
                                    }
                                    char d = in.get();
                                    if (d < '\udc00' || d > '\udfff') {
                                        coderResult3 = CoderResult.malformedForLength(1);
                                        break block15;
                                    } else {
                                        out.putChar(c);
                                        out.putChar(d);
                                        inPos += 2;
                                        continue;
                                    }
                                }
                                if (out.remaining() < 2) {
                                    out.order(originalBO);
                                    coderResult2 = CoderResult.OVERFLOW;
                                    break block16;
                                }
                                out.putChar(c);
                                ++inPos;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var6_17 = null;
                            in.position(inPos);
                            throw throwable;
                        }
                        in.position(inPos);
                        return coderResult5;
                    }
                    Object var6_13 = null;
                    in.position(inPos);
                    return coderResult4;
                }
                Object var6_14 = null;
                in.position(inPos);
                return coderResult3;
            }
            Object var6_15 = null;
            in.position(inPos);
            return coderResult2;
        }
        Object var6_16 = null;
        in.position(inPos);
        return coderResult;
    }

    protected final void implReset() {
        this.needsByteOrderMark = this.useByteOrderMark;
    }

    UTF_16Encoder(Charset cs, int byteOrder, boolean useByteOrderMark) {
        byte[] byArray;
        float f = useByteOrderMark ? (float)4 : 2.0f;
        if (byteOrder == 0) {
            byte[] byArray2 = new byte[2];
            byArray2[0] = -1;
            byArray = byArray2;
            byArray2[1] = -3;
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = -3;
            byArray = byArray3;
            byArray3[1] = -1;
        }
        super(cs, 2.0f, f, byArray);
        this.byteOrder = byteOrder == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.useByteOrderMark = useByteOrderMark;
        this.needsByteOrderMark = useByteOrderMark;
    }
}

