/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.velocity;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;

public abstract class VelocityEngineUtils {
    private static final Log logger = LogFactory.getLog((Class)VelocityEngineUtils.class);

    public static void mergeTemplate(VelocityEngine velocityEngine, String templateLocation, Map model, Writer writer) throws VelocityException {
        try {
            VelocityContext velocityContext = new VelocityContext(model);
            velocityEngine.mergeTemplate(templateLocation, (Context)velocityContext, writer);
        }
        catch (VelocityException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"Why does VelocityEngine throw a generic checked exception, after all?", (Throwable)ex);
            throw new VelocityException(ex.toString());
        }
    }

    public static void mergeTemplate(VelocityEngine velocityEngine, String templateLocation, String encoding, Map model, Writer writer) throws VelocityException {
        try {
            VelocityContext velocityContext = new VelocityContext(model);
            velocityEngine.mergeTemplate(templateLocation, encoding, (Context)velocityContext, writer);
        }
        catch (VelocityException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"Why does VelocityEngine throw a generic checked exception, after all?", (Throwable)ex);
            throw new VelocityException(ex.toString());
        }
    }

    public static String mergeTemplateIntoString(VelocityEngine velocityEngine, String templateLocation, Map model) throws VelocityException {
        StringWriter result = new StringWriter();
        VelocityEngineUtils.mergeTemplate(velocityEngine, templateLocation, model, result);
        return result.toString();
    }

    public static String mergeTemplateIntoString(VelocityEngine velocityEngine, String templateLocation, String encoding, Map model) throws VelocityException {
        StringWriter result = new StringWriter();
        VelocityEngineUtils.mergeTemplate(velocityEngine, templateLocation, encoding, model, result);
        return result.toString();
    }
}

