/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoRectangle;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk3.GdkEventFocus;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    long buttonHandle;
    long entryHandle;
    long textRenderer;
    long cellHandle;
    long popupHandle;
    long menuHandle;
    long buttonBoxHandle;
    long cellBoxHandle;
    long arrowHandle;
    int lastEventTime;
    int visibleCount = 10;
    long imContext;
    long gdkEventKey = 0L;
    int fixStart = -1;
    int fixEnd = -1;
    String[] items = new String[0];
    int indexSelected;
    GdkRGBA background;
    GdkRGBA buttonBackground;
    String cssButtonBackground;
    String cssButtonForeground = " ";
    long buttonProvider;
    long comboProvider;
    boolean firstDraw = true;
    boolean unselected = true;
    boolean fitModelToggled = false;
    public static final int LIMIT = 65535;
    private boolean delayedEnableWrap = false;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.add(string, this.items.length);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > index || index > this.items.length) {
            this.error(6);
        }
        String[] newItems = new String[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        newItems[index] = string;
        System.arraycopy(this.items, index, newItems, index + 1, this.items.length - index);
        this.items = newItems;
        this.gtk_combo_box_insert(string, index);
        if ((this.style & 0x4000000) != 0 && this.popupHandle != 0L) {
            GTK3.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
        }
    }

    private void gtk_combo_box_insert(String string, int index) {
        byte[] buffer = Converter.wcsToMbcs(string, true);
        if (this.handle != 0L) {
            this.gtk_combo_box_toggle_wrap(false);
            GTK.gtk_combo_box_text_insert(this.handle, index, null, buffer);
            this.gtk_combo_box_toggle_wrap(true);
        }
    }

    private void gtk_combo_box_toggle_wrap(boolean wrap) {
        if (this.handle == 0L || GTK.GTK4) {
            return;
        }
        if (!wrap) {
            if (GTK3.gtk_combo_box_get_wrap_width(this.handle) == 1) {
                GTK3.gtk_combo_box_set_wrap_width(this.handle, 0);
            }
        } else {
            if (this.delayedEnableWrap) {
                return;
            }
            this.delayedEnableWrap = true;
            this.display.asyncExec(() -> {
                if (!this.isDisposed() && this.handle != 0L) {
                    GTK3.gtk_combo_box_set_wrap_width(this.handle, 1);
                    this.delayedEnableWrap = false;
                }
            });
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(listener));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Combo.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            int position = GTK.gtk_editable_get_position(this.entryHandle);
            GTK.gtk_editable_select_region(this.entryHandle, position, position);
        }
    }

    void clearText() {
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        if ((this.style & 8) != 0) {
            int index = GTK.gtk_combo_box_get_active(this.handle);
            if (index != -1) {
                long modelHandle = GTK.gtk_combo_box_get_model(this.handle);
                long[] ptr = new long[1];
                long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
                GTK.gtk_tree_model_iter_nth_child(modelHandle, iter, 0L, index);
                GTK.gtk_tree_model_get(modelHandle, iter, 0, ptr, -1);
                OS.g_free(iter);
                if (ptr[0] != 0L && C.strlen(ptr[0]) > 0) {
                    this.postEvent(24);
                }
                OS.g_free(ptr[0]);
            }
        } else if (GTK.GTK4) {
            long bufferHandle = GTK4.gtk_entry_get_buffer(this.entryHandle);
            GTK.gtk_entry_buffer_delete_text(bufferHandle, 0, -1);
        } else {
            GTK3.gtk_entry_set_text(this.entryHandle, new byte[1]);
        }
        GTK.gtk_combo_box_set_active(this.handle, -1);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        return this.computeNativeSize(this.handle, wHint, hHint, changed);
    }

    @Override
    Point computeNativeSize(long h, int wHint, int hHint, boolean changed) {
        if (this.fitModelToggled) {
            GTK.gtk_cell_view_set_fit_model(this.cellHandle, true);
        }
        int[] xpad = new int[1];
        if (this.textRenderer != 0L) {
            GTK.gtk_cell_renderer_get_padding(this.textRenderer, xpad, null);
        }
        Point nativeSize = super.computeNativeSize(h, wHint, hHint, changed);
        nativeSize.x += xpad[0] * 2;
        if ((this.style & 8) != 0 && !GTK.GTK4 && GTK.GTK_VERSION >= OS.VERSION(3, 22, 0)) {
            GtkBorder buttonPadding = new GtkBorder();
            long context = GTK.gtk_widget_get_style_context(this.buttonHandle);
            int stateFlag = GTK.gtk_widget_get_state_flags(this.buttonHandle);
            this.gtk_style_context_get_padding(context, stateFlag, buttonPadding);
            nativeSize.x += buttonPadding.left + buttonPadding.right;
        }
        if (this.fitModelToggled) {
            GTK.gtk_cell_view_set_fit_model(this.cellHandle, false);
        }
        return nativeSize;
    }

    public void copy() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            if (GTK.GTK4) {
                long textHandle = GTK4.gtk_widget_get_first_child(this.entryHandle);
                GTK4.gtk_widget_activate_action(textHandle, OS.action_copy_clipboard, null);
            } else {
                GTK3.gtk_editable_copy_clipboard(this.entryHandle);
            }
        }
    }

    @Override
    void createHandle(int index) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if (!GTK.GTK4) {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
        }
        long oldList = GTK.gtk_window_list_toplevels();
        if ((this.style & 8) != 0) {
            this.handle = GTK.gtk_combo_box_text_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            long l = this.cellHandle = GTK.GTK4 ? GTK4.gtk_combo_box_get_child(this.handle) : GTK3.gtk_bin_get_child(this.handle);
            if (this.cellHandle == 0L) {
                this.error(2);
            }
            this.gtk_combo_box_toggle_wrap(true);
        } else {
            this.handle = GTK.gtk_combo_box_text_new_with_entry();
            if (this.handle == 0L) {
                this.error(2);
            }
            long l = this.entryHandle = GTK.GTK4 ? GTK4.gtk_combo_box_get_child(this.handle) : GTK3.gtk_bin_get_child(this.handle);
            if (this.entryHandle == 0L) {
                this.error(2);
            }
            if (DISABLE_EMOJI && GTK.GTK_VERSION >= OS.VERSION(3, 22, 20)) {
                GTK.gtk_entry_set_input_hints(this.entryHandle, 1024);
            }
            this.imContext = OS.imContextLast();
        }
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
        } else {
            this.popupHandle = this.findPopupHandle(oldList);
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
        }
        this.textRenderer = GTK.gtk_cell_renderer_text_new();
        if (this.textRenderer == 0L) {
            this.error(2);
        }
        GTK.gtk_cell_layout_clear(this.handle);
        GTK.gtk_cell_layout_pack_start(this.handle, this.textRenderer, true);
        GTK.gtk_cell_layout_set_attributes(this.handle, this.textRenderer, OS.text, 0, 0L);
        this.menuHandle = this.findMenuHandle();
        if (this.menuHandle != 0L) {
            OS.g_object_ref(this.menuHandle);
        }
        this.buttonHandle = this.findButtonHandle();
        if (this.buttonHandle != 0L) {
            OS.g_object_ref(this.buttonHandle);
        }
        if (this.buttonBoxHandle != 0L) {
            OS.g_object_ref(this.buttonBoxHandle);
        }
        if (this.cellHandle != 0L) {
            this.cellBoxHandle = GTK.gtk_widget_get_parent(this.cellHandle);
        }
        if (this.cellBoxHandle != 0L) {
            OS.g_object_ref(this.cellBoxHandle);
        }
        if ((this.style & 8) != 0 && this.buttonHandle != 0L) {
            GTK.gtk_widget_set_receives_default(this.buttonHandle, false);
        }
        if ((this.style & 8) != 0 && this.cellBoxHandle != 0L) {
            this.arrowHandle = this.findArrowHandle();
        }
        this.setFontDescription(this.defaultFont().handle);
    }

    public void cut() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            if (GTK.GTK4) {
                long textHandle = GTK4.gtk_widget_get_first_child(this.entryHandle);
                GTK4.gtk_widget_activate_action(textHandle, OS.action_cut_clipboard, null);
            } else {
                GTK3.gtk_editable_cut_clipboard(this.entryHandle);
            }
        }
    }

    @Override
    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handle;
    }

    GdkRGBA defaultButtonBackground() {
        return this.display.getSystemColor((int)22).handle;
    }

    @Override
    void deregister() {
        long imContext;
        super.deregister();
        if (this.buttonHandle != 0L) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.entryHandle != 0L) {
            this.display.removeWidget(this.entryHandle);
        }
        if (this.popupHandle != 0L) {
            this.display.removeWidget(this.popupHandle);
        }
        if (this.menuHandle != 0L) {
            this.display.removeWidget(this.menuHandle);
        }
        if ((imContext = this.imContext()) != 0L) {
            this.display.removeWidget(imContext);
        }
    }

    @Override
    boolean filterKey(long event) {
        int time = GDK.gdk_event_get_time(event);
        if (time != this.lastEventTime) {
            this.lastEventTime = time;
            long imContext = this.imContext();
            if (imContext != 0L) {
                if (GTK.GTK4) {
                    return GTK4.gtk_im_context_filter_keypress(imContext, event);
                }
                return GTK3.gtk_im_context_filter_keypress(imContext, event);
            }
        }
        this.gdkEventKey = event;
        return false;
    }

    long findPopupHandle(long oldList) {
        long result = 0L;
        long currentList = GTK.gtk_window_list_toplevels();
        long oldFromList = oldList;
        long newFromList = OS.g_list_last(currentList);
        while (newFromList != 0L) {
            long newToplevel = OS.g_list_data(newFromList);
            boolean isFound = false;
            oldFromList = oldList;
            while (oldFromList != 0L) {
                long oldToplevel = OS.g_list_data(oldFromList);
                if (newToplevel == oldToplevel) {
                    isFound = true;
                    break;
                }
                oldFromList = OS.g_list_next(oldFromList);
            }
            if (!isFound) {
                result = newToplevel;
                break;
            }
            newFromList = OS.g_list_previous(newFromList);
        }
        OS.g_list_free(oldList);
        OS.g_list_free(currentList);
        return result;
    }

    @Override
    Point resizeCalculationsGTK3(long widget, int width, int height) {
        return new Point(width, height);
    }

    long findButtonHandle() {
        long result = 0L;
        if (GTK.GTK4) {
            long child = GTK4.gtk_widget_get_first_child(this.handle);
            while (child != 0L) {
                if (GTK.GTK_IS_BOX(child)) {
                    this.buttonBoxHandle = child;
                    break;
                }
                child = GTK4.gtk_widget_get_next_sibling(child);
            }
            child = GTK4.gtk_widget_get_first_child(this.buttonBoxHandle);
            while (child != 0L) {
                if (GTK.GTK_IS_BUTTON(child)) {
                    result = child;
                    break;
                }
                child = GTK4.gtk_widget_get_next_sibling(child);
            }
        } else {
            long widget;
            long list;
            long childHandle = this.handle;
            GTK3.gtk_container_forall(this.handle, this.display.allChildrenProc, 0L);
            if (this.display.allChildren != 0L) {
                list = this.display.allChildren;
                while (list != 0L) {
                    widget = OS.g_list_data(list);
                    if (widget != 0L) {
                        childHandle = widget;
                        break;
                    }
                    list = OS.g_list_next(list);
                }
                OS.g_list_free(this.display.allChildren);
                this.display.allChildren = 0L;
            }
            this.buttonBoxHandle = childHandle;
            GTK3.gtk_container_forall(childHandle, this.display.allChildrenProc, 0L);
            if (this.display.allChildren != 0L) {
                list = this.display.allChildren;
                while (list != 0L) {
                    widget = OS.g_list_data(list);
                    if (GTK.GTK_IS_BUTTON(widget)) {
                        result = widget;
                        break;
                    }
                    list = OS.g_list_next(list);
                }
                OS.g_list_free(this.display.allChildren);
                this.display.allChildren = 0L;
            }
        }
        return result;
    }

    long findArrowHandle() {
        long result = 0L;
        if (this.cellBoxHandle != 0L) {
            if (GTK.GTK4) {
                long child = GTK4.gtk_widget_get_first_child(this.cellBoxHandle);
                while (child != 0L) {
                    String name = this.display.gtk_widget_get_name(child);
                    if (name != null && name.equals("GtkBuiltinIcon")) {
                        result = child;
                        break;
                    }
                    child = GTK4.gtk_widget_get_next_sibling(child);
                }
            } else {
                GTK3.gtk_container_forall(this.cellBoxHandle, this.display.allChildrenProc, 0L);
                if (this.display.allChildren != 0L) {
                    long list = this.display.allChildren;
                    while (list != 0L) {
                        long widget = OS.g_list_data(list);
                        String name = this.display.gtk_widget_get_name(widget);
                        if (name != null && name.contains("GtkIcon")) {
                            result = widget;
                        }
                        list = OS.g_list_next(list);
                    }
                    OS.g_list_free(this.display.allChildren);
                    this.display.allChildren = 0L;
                }
            }
        }
        return result;
    }

    long findMenuHandle() {
        long result = 0L;
        if (this.popupHandle != 0L) {
            GTK3.gtk_container_forall(this.popupHandle, this.display.allChildrenProc, 0L);
            if (this.display.allChildren != 0L) {
                long list = this.display.allChildren;
                while (list != 0L) {
                    long widget = OS.g_list_data(list);
                    String name = this.display.gtk_widget_get_name(widget);
                    if (name != null && name.contains("gtk-combobox-popup-menu")) {
                        result = widget;
                        break;
                    }
                    list = OS.g_list_next(list);
                }
                OS.g_list_free(this.display.allChildren);
                this.display.allChildren = 0L;
            }
        }
        return result;
    }

    @Override
    void fixModal(long group, long modalGroup) {
        if (this.popupHandle != 0L) {
            if (group != 0L) {
                GTK.gtk_window_group_add_window(group, this.popupHandle);
            } else if (modalGroup != 0L) {
                GTK.gtk_window_group_remove_window(modalGroup, this.popupHandle);
            }
        }
    }

    void fixIM() {
        long imContext;
        if (this.gdkEventKey != 0L && this.gdkEventKey != -1L && (imContext = this.imContext()) != 0L) {
            if (GTK.GTK4) {
                GTK4.gtk_im_context_filter_keypress(imContext, this.gdkEventKey);
            } else {
                GTK3.gtk_im_context_filter_keypress(imContext, this.gdkEventKey);
            }
            this.gdkEventKey = -1L;
            return;
        }
        this.gdkEventKey = 0L;
    }

    @Override
    long fontHandle() {
        if (this.entryHandle != 0L) {
            return this.entryHandle;
        }
        return super.fontHandle();
    }

    @Override
    long focusHandle() {
        if (this.entryHandle != 0L) {
            return this.entryHandle;
        }
        return super.focusHandle();
    }

    @Override
    boolean hasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        return this.entryHandle != 0L && GTK.gtk_widget_has_focus(this.entryHandle);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.changed, this.display.getClosure(6), true);
        if (this.entryHandle != 0L) {
            OS.g_signal_connect_closure(this.entryHandle, OS.changed, this.display.getClosure(6), true);
            OS.g_signal_connect_closure(this.entryHandle, OS.insert_text, this.display.getClosure(26), false);
            OS.g_signal_connect_closure(this.entryHandle, OS.delete_text, this.display.getClosure(13), false);
            OS.g_signal_connect_closure(this.entryHandle, OS.activate, this.display.getClosure(1), false);
            if (!GTK.GTK4) {
                OS.g_signal_connect_closure(this.entryHandle, OS.populate_popup, this.display.getClosure(37), false);
            }
        }
        this.hookEvents(new long[]{this.buttonHandle, this.entryHandle, this.menuHandle});
        long imContext = this.imContext();
        if (imContext != 0L) {
            OS.g_signal_connect_closure(imContext, OS.commit, this.display.getClosure(9), false);
            int id = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
            int blockMask = 17;
            OS.g_signal_handlers_block_matched(imContext, blockMask, id, 0, 0L, 0L, this.entryHandle);
        }
    }

    void hookEvents(long[] handles) {
        for (int i = 0; i < handles.length; ++i) {
            long eventHandle = handles[i];
            if (eventHandle == 0L) continue;
            if (GTK.GTK4) {
                long motionController = GTK4.gtk_event_controller_motion_new();
                GTK4.gtk_widget_add_controller(eventHandle, motionController);
                OS.g_signal_connect(motionController, OS.motion, this.display.enterMotionProc, 97L);
                OS.g_signal_connect(motionController, OS.motion, this.display.enterMotionProc, 98L);
                long gestureController = GTK4.gtk_gesture_click_new();
                GTK4.gtk_widget_add_controller(eventHandle, gestureController);
                OS.g_signal_connect(gestureController, OS.pressed, this.display.gesturePressReleaseProc, 100L);
                OS.g_signal_connect(gestureController, OS.released, this.display.gesturePressReleaseProc, 101L);
                continue;
            }
            int eventMask = 772;
            GTK3.gtk_widget_add_events(eventHandle, eventMask);
            OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[33], 0, this.display.getClosure(33), false);
            OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[33], 0, this.display.getClosure(34), true);
            OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[2], 0, this.display.getClosure(2), false);
            OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[4], 0, this.display.getClosure(4), false);
            OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[2], 0, this.display.getClosure(3), true);
            OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[4], 0, this.display.getClosure(5), true);
            if (eventHandle != this.focusHandle()) {
                OS.g_signal_connect_closure_by_id(eventHandle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
            }
            if (OS.G_OBJECT_TYPE(eventHandle) != GTK3.GTK_TYPE_MENU()) continue;
            OS.g_signal_connect_closure(eventHandle, OS.selection_done, this.display.getClosure(68), true);
        }
    }

    long imContext() {
        if (this.imContext != 0L) {
            return this.imContext;
        }
        return 0L;
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            return;
        }
        if (GTK.gtk_combo_box_get_active(this.handle) == index) {
            this.clearText();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.clearText();
    }

    @Override
    boolean dragDetect(int x, int y, boolean filter, boolean dragOnTimeout, boolean[] consume) {
        if (filter && this.entryHandle != 0L) {
            int[] index = new int[1];
            int[] trailing = new int[1];
            long layout = GTK3.gtk_entry_get_layout(this.entryHandle);
            OS.pango_layout_xy_to_index(layout, x * 1024, y * 1024, index, trailing);
            long ptr = OS.pango_layout_get_text(layout);
            int position = (int)OS.g_utf8_pointer_to_offset(ptr, ptr + (long)index[0]) + trailing[0];
            int[] start = new int[1];
            int[] end = new int[1];
            GTK.gtk_editable_get_selection_bounds(this.entryHandle, start, end);
            if (start[0] <= position && position < end[0] && super.dragDetect(x, y, filter, dragOnTimeout, consume)) {
                if (consume != null) {
                    consume[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(x, y, filter, dragOnTimeout, consume);
    }

    @Override
    long enterExitHandle() {
        return this.fixedHandle;
    }

    @Override
    long eventWindow() {
        if ((this.style & 8) != 0) {
            GTK.gtk_widget_realize(this.handle);
            return this.gtk_widget_get_window(this.handle);
        }
        GTK.gtk_widget_realize(this.entryHandle);
        long window = this.gtk_widget_get_window(this.entryHandle);
        long children = GDK.gdk_window_get_children(window);
        if (children != 0L) {
            long childrenIterator = children;
            do {
                window = OS.g_list_data(childrenIterator);
            } while ((childrenIterator = OS.g_list_next(childrenIterator)) != 0L);
        }
        OS.g_list_free(children);
        return window;
    }

    @Override
    long eventSurface() {
        return this.paintSurface();
    }

    public Point getCaretLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getCaretLocationInPixels());
    }

    Point getCaretLocationInPixels() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return new Point(0, 0);
        }
        int index = GTK.gtk_editable_get_position(this.entryHandle);
        index = GTK3.gtk_entry_text_index_to_layout_index(this.entryHandle, index);
        int[] offset_x = new int[1];
        int[] offset_y = new int[1];
        GTK3.gtk_entry_get_layout_offsets(this.entryHandle, offset_x, offset_y);
        long layout = GTK3.gtk_entry_get_layout(this.entryHandle);
        PangoRectangle pos = new PangoRectangle();
        OS.pango_layout_index_to_pos(layout, index, pos);
        Point thickness = this.getThickness(this.entryHandle);
        int x = offset_x[0] + OS.PANGO_PIXELS(pos.x) - this.getBorderWidthInPixels() - thickness.x;
        int y = offset_y[0] + OS.PANGO_PIXELS(pos.y) - thickness.y;
        return new Point(x, y);
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return 0;
        }
        long ptr = GTK3.gtk_entry_get_text(this.entryHandle);
        return (int)OS.g_utf8_offset_to_utf16_offset(ptr, GTK.gtk_editable_get_position(this.entryHandle));
    }

    @Override
    GdkRGBA getContextBackgroundGdkRGBA() {
        if (this.background != null && (this.state & 0x2000) != 0) {
            return this.background;
        }
        return this.defaultBackground();
    }

    public String getItem(int index) {
        this.checkWidget();
        if (0 > index || index >= this.items.length) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        long fontDesc = this.getFontDescription();
        int result = this.fontHeight(fontDesc, this.handle);
        OS.pango_font_description_free(fontDesc);
        return result;
    }

    public String[] getItems() {
        this.checkWidget();
        String[] result = new String[this.items.length];
        System.arraycopy(this.items, 0, result, 0, this.items.length);
        return result;
    }

    public boolean getListVisible() {
        this.checkWidget();
        return this.popupHandle != 0L && GTK.gtk_widget_get_visible(this.popupHandle);
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    @Override
    public int getOrientation() {
        return super.getOrientation();
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            int length = 0;
            int index = GTK.gtk_combo_box_get_active(this.handle);
            if (index != -1) {
                length = this.getItem(index).length();
            }
            return new Point(0, length);
        }
        int[] start = new int[1];
        int[] end = new int[1];
        if (this.entryHandle != 0L) {
            GTK.gtk_editable_get_selection_bounds(this.entryHandle, start, end);
            long ptr = GTK3.gtk_entry_get_text(this.entryHandle);
            start[0] = (int)OS.g_utf8_offset_to_utf16_offset(ptr, start[0]);
            end[0] = (int)OS.g_utf8_offset_to_utf16_offset(ptr, end[0]);
        }
        return new Point(start[0], end[0]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return GTK.gtk_combo_box_get_active(this.handle);
    }

    public String getText() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            long str = 0L;
            if (GTK.GTK4) {
                long bufferHandle = GTK4.gtk_entry_get_buffer(this.entryHandle);
                str = GTK.gtk_entry_buffer_get_text(bufferHandle);
            } else {
                str = GTK3.gtk_entry_get_text(this.entryHandle);
            }
            if (str == 0L) {
                return "";
            }
            int length = C.strlen(str);
            byte[] buffer = new byte[length];
            C.memmove(buffer, str, (long)length);
            return new String(Converter.mbcsToWcs(buffer));
        }
        int index = GTK.gtk_combo_box_get_active(this.handle);
        return index != -1 ? this.getItem(index) : "";
    }

    String getText(int start, int stop) {
        return this.getText().substring(start, stop - 1);
    }

    public int getTextHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getTextHeightInPixels());
    }

    int getTextHeightInPixels() {
        this.checkWidget();
        GtkRequisition requisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(this.handle, requisition);
        return requisition.height;
    }

    public int getTextLimit() {
        this.checkWidget();
        int limit = this.entryHandle != 0L ? GTK.gtk_entry_get_max_length(this.entryHandle) : 0;
        return limit == 0 ? LIMIT : limit;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    @Override
    long gtk_activate(long widget) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        int[] eventButton = new int[1];
        if (GTK.GTK4) {
            eventButton[0] = GDK.gdk_button_event_get_button(event);
        } else {
            GDK.gdk_event_get_button(event, eventButton);
        }
        int eventType = GDK.gdk_event_get_event_type(event);
        if (eventType == 4 && eventButton[0] == 1) {
            return this.gtk_button_press_event(widget, event, false);
        }
        return super.gtk_button_press_event(widget, event);
    }

    @Override
    long gtk_changed(long widget) {
        long eventPtr;
        if (widget == this.handle) {
            int index;
            this.unselected = false;
            if (this.entryHandle == 0L) {
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return 0L;
                }
            }
            if ((index = GTK.gtk_combo_box_get_active(this.handle)) != -1) {
                this.sendSelectionEvent(13);
            }
            this.indexSelected = -1;
            return 0L;
        }
        boolean keyPress = false;
        long l = eventPtr = GTK.GTK4 ? 0L : GTK3.gtk_get_current_event();
        if (eventPtr != 0L) {
            int eventType = GDK.gdk_event_get_event_type(eventPtr);
            eventType = Combo.fixGdkEventTypeValues(eventType);
            switch (eventType) {
                case 8: {
                    keyPress = true;
                }
            }
            this.gdk_event_free(eventPtr);
        }
        if (keyPress) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        return 0L;
    }

    @Override
    long gtk_commit(long imContext, long text) {
        if (text == 0L) {
            return 0L;
        }
        if (!GTK.gtk_editable_get_editable(this.entryHandle)) {
            return 0L;
        }
        int length = C.strlen(text);
        if (length == 0) {
            return 0L;
        }
        byte[] buffer = new byte[length];
        C.memmove(buffer, text, (long)length);
        char[] chars = Converter.mbcsToWcs(buffer);
        char[] newChars = this.sendIMKeyEvent(1, 0L, chars);
        if (newChars == null) {
            return 0L;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(imContext, 16, 0, 0, 0L, 0L, 9L);
        int id = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
        int mask = 17;
        OS.g_signal_handlers_unblock_matched(imContext, mask, id, 0, 0L, 0L, this.entryHandle);
        if (newChars == chars) {
            OS.g_signal_emit_by_name(imContext, OS.commit, text);
        } else {
            buffer = Converter.wcsToMbcs(newChars, true);
            OS.g_signal_emit_by_name(imContext, OS.commit, buffer);
        }
        OS.g_signal_handlers_unblock_matched(imContext, 16, 0, 0, 0L, 0L, 9L);
        OS.g_signal_handlers_block_matched(imContext, mask, id, 0, 0L, 0L, this.entryHandle);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            GTK.gtk_editable_set_position(this.entryHandle, this.fixStart);
            GTK.gtk_editable_select_region(this.entryHandle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0L;
    }

    @Override
    long gtk_delete_text(long widget, long start_pos, long end_pos) {
        int end;
        int start;
        String newText;
        long ptr;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        if (GTK.GTK4) {
            long bufferPtr = GTK4.gtk_entry_get_buffer(this.entryHandle);
            ptr = GTK.gtk_entry_buffer_get_text(bufferPtr);
        } else {
            ptr = GTK3.gtk_entry_get_text(this.entryHandle);
        }
        if (end_pos == -1L) {
            end_pos = OS.g_utf8_strlen(ptr, -1L);
        }
        if ((newText = this.verifyText("", start = (int)OS.g_utf8_offset_to_utf16_offset(ptr, start_pos), end = (int)OS.g_utf8_offset_to_utf16_offset(ptr, end_pos))) == null) {
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.delete_text);
        } else if (newText.length() > 0) {
            int[] pos = new int[]{(int)end_pos};
            byte[] buffer = Converter.wcsToMbcs(newText, false);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
            GTK.gtk_editable_insert_text(this.entryHandle, buffer, buffer.length, pos);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_editable_set_position(this.entryHandle, pos[0]);
        }
        return 0L;
    }

    @Override
    void adjustChildClipping(long widget) {
        if (widget == this.cellHandle && (this.style & 8) != 0 && !this.unselected) {
            if (GTK.GTK4) {
                super.adjustChildClipping(widget);
                return;
            }
            if (!this.fitModelToggled) {
                GTK.gtk_cell_view_set_fit_model(this.cellHandle, false);
                this.fitModelToggled = true;
            }
            GtkAllocation iconAllocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(this.arrowHandle, iconAllocation);
            GtkAllocation cellViewAllocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(this.cellHandle, cellViewAllocation);
            cellViewAllocation.width = iconAllocation.x - iconAllocation.width;
            GTK3.gtk_widget_set_clip(widget, cellViewAllocation);
            return;
        }
        super.adjustChildClipping(widget);
    }

    @Override
    long gtk_draw(long widget, long cairo) {
        long parentHandle = GTK.gtk_widget_get_parent(this.fixedHandle);
        if (parentHandle != 0L) {
            if (this.parent.fixClipHandle == 0L) {
                this.parent.fixClipHandle = parentHandle;
            }
            if (this.firstDraw) {
                if ((this.style & 8) != 0) {
                    long[] array = new long[]{this.fixedHandle, this.handle, this.buttonBoxHandle, this.buttonHandle, this.cellBoxHandle, this.cellHandle};
                    this.parent.fixClipMap.put(this, array);
                } else {
                    long[] array = new long[]{this.fixedHandle, this.handle, this.entryHandle, this.buttonBoxHandle, this.buttonHandle};
                    this.parent.fixClipMap.put(this, array);
                }
                this.firstDraw = false;
                GTK.gtk_widget_queue_draw(parentHandle);
            }
        }
        return super.gtk_draw(widget, cairo);
    }

    @Override
    long gtk_event_after(long widget, long gdkEvent) {
        int eventType = GDK.gdk_event_get_event_type(gdkEvent);
        eventType = Combo.fixGdkEventTypeValues(eventType);
        switch (eventType) {
            case 4: {
                int[] eventButton = new int[1];
                int[] eventState = new int[1];
                if (GTK.GTK4) {
                    eventButton[0] = GDK.gdk_button_event_get_button(gdkEvent);
                    eventState[0] = GDK.gdk_event_get_modifier_state(gdkEvent);
                } else {
                    GDK.gdk_event_get_button(gdkEvent, eventButton);
                    GDK.gdk_event_get_state(gdkEvent, eventState);
                }
                int eventTime = GDK.gdk_event_get_time(gdkEvent);
                double[] eventRX = new double[1];
                double[] eventRY = new double[1];
                GDK.gdk_event_get_root_coords(gdkEvent, eventRX, eventRY);
                if (eventButton[0] != 1) break;
                if (!this.sendMouseEvent(3, eventButton[0], this.display.clickCount, 0, false, eventTime, eventRX[0], eventRY[0], false, eventState[0])) {
                    return 1L;
                }
                if ((this.style & 8) != 0 || widget != this.buttonHandle) break;
                GTK.gtk_widget_grab_focus(this.entryHandle);
                break;
            }
            case 12: {
                if ((this.style & 8) != 0) break;
                boolean[] focusIn = new boolean[1];
                if (GTK.GTK4) {
                    focusIn[0] = GDK.gdk_focus_event_get_in(gdkEvent);
                } else {
                    GdkEventFocus gdkEventFocus = new GdkEventFocus();
                    GTK3.memmove(gdkEventFocus, gdkEvent, (long)GdkEventFocus.sizeof);
                    boolean bl = focusIn[0] = gdkEventFocus.in != 0;
                }
                if (focusIn[0]) {
                    GTK.gtk_widget_set_focus_on_click(this.handle, false);
                    break;
                }
                GTK.gtk_widget_set_focus_on_click(this.handle, true);
            }
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    @Override
    long gtk_focus_out_event(long widget, long event) {
        this.fixIM();
        return super.gtk_focus_out_event(widget, event);
    }

    @Override
    long gtk_insert_text(long widget, long new_text, long new_text_length, long position) {
        int start;
        String newText;
        long ptr;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        if (new_text == 0L || new_text_length == 0L) {
            return 0L;
        }
        byte[] buffer = new byte[(int)new_text_length];
        C.memmove(buffer, new_text, (long)buffer.length);
        String oldText = new String(Converter.mbcsToWcs(buffer));
        int[] pos = new int[1];
        C.memmove(pos, position, 4L);
        if (GTK.GTK4) {
            long bufferPtr = GTK4.gtk_entry_get_buffer(this.entryHandle);
            ptr = GTK.gtk_entry_buffer_get_text(bufferPtr);
        } else {
            ptr = GTK3.gtk_entry_get_text(this.entryHandle);
        }
        if (pos[0] == -1) {
            pos[0] = (int)OS.g_utf8_strlen(ptr, -1L);
        }
        if ((newText = this.verifyText(oldText, start = (int)OS.g_utf8_offset_to_utf16_offset(ptr, pos[0]), start)) != oldText) {
            int[] newStart = new int[1];
            int[] newEnd = new int[1];
            GTK.gtk_editable_get_selection_bounds(this.entryHandle, newStart, newEnd);
            if (newText != null) {
                if (newStart[0] != newEnd[0]) {
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
                    GTK.gtk_editable_delete_selection(this.entryHandle);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
                }
                byte[] buffer3 = Converter.wcsToMbcs(newText, false);
                OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
                GTK.gtk_editable_insert_text(this.entryHandle, buffer3, buffer3.length, pos);
                OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
                newStart[0] = newEnd[0] = pos[0];
            }
            pos[0] = newEnd[0];
            if (newStart[0] != newEnd[0]) {
                this.fixStart = newStart[0];
                this.fixEnd = newEnd[0];
            }
            C.memmove(position, pos, 4L);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.insert_text);
        }
        return 0L;
    }

    @Override
    long gtk_key_press_event(long widget, long event) {
        long result = super.gtk_key_press_event(widget, event);
        if (result != 0L) {
            this.gdkEventKey = 0L;
            this.fixIM();
            return result;
        }
        if (this.gdkEventKey == -1L) {
            result = 1L;
        }
        this.gdkEventKey = 0L;
        if ((this.style & 8) == 0) {
            int oldIndex;
            int newIndex = oldIndex = GTK.gtk_combo_box_get_active(this.handle);
            int[] eventKeyval = new int[1];
            if (GTK.GTK4) {
                eventKeyval[0] = GDK.gdk_key_event_get_keyval(event);
            } else {
                GDK.gdk_event_get_keyval(event, eventKeyval);
            }
            switch (eventKeyval[0]) {
                case 65364: 
                case 65433: {
                    if (oldIndex == this.items.length - 1) break;
                    newIndex = oldIndex + 1;
                    break;
                }
                case 65362: 
                case 65431: {
                    if (oldIndex == -1 || oldIndex == 0) break;
                    newIndex = oldIndex - 1;
                    break;
                }
                case 65365: 
                case 65434: {
                    newIndex = 0;
                    break;
                }
                case 65366: 
                case 65435: {
                    newIndex = this.items.length - 1;
                }
            }
            if (newIndex != oldIndex) {
                GTK.gtk_combo_box_set_active(this.handle, newIndex);
                return 1L;
            }
        }
        return result;
    }

    @Override
    long gtk_populate_popup(long widget, long menu) {
        if ((this.style & 0x4000000) != 0) {
            GTK.gtk_widget_set_direction(menu, 2);
            GTK3.gtk_container_forall(menu, this.display.setDirectionProc, 2L);
        }
        return 0L;
    }

    @Override
    long gtk_selection_done(long menushell) {
        int index = GTK.gtk_combo_box_get_active(this.handle);
        this.unselected = false;
        if (this.indexSelected == -1) {
            this.indexSelected = index;
        } else if (index != -1 && this.indexSelected == index) {
            this.sendSelectionEvent(13);
        }
        return 0L;
    }

    @Override
    long gtk_style_updated(long widget) {
        this.setButtonHandle(this.findButtonHandle());
        this.setMenuHandle(this.findMenuHandle());
        return super.gtk_style_updated(widget);
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > start || start >= this.items.length) {
            return -1;
        }
        for (int i = start; i < this.items.length; ++i) {
            if (!string.equals(this.items[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    boolean isFocusHandle(long widget) {
        if (this.buttonHandle != 0L && widget == this.buttonHandle) {
            return true;
        }
        if (this.entryHandle != 0L && widget == this.entryHandle) {
            return true;
        }
        return super.isFocusHandle(widget);
    }

    @Override
    long paintSurface() {
        long childHandle = this.entryHandle != 0L ? this.entryHandle : this.handle;
        GTK.gtk_widget_realize(childHandle);
        long surface = this.gtk_widget_get_surface(childHandle);
        if ((this.style & 8) != 0) {
            return surface;
        }
        return surface;
    }

    public void paste() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            GTK3.gtk_editable_paste_clipboard(this.entryHandle);
        }
    }

    @Override
    long parentingHandle() {
        return this.fixedHandle;
    }

    @Override
    void register() {
        long imContext;
        super.register();
        if (this.buttonHandle != 0L) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.entryHandle != 0L) {
            this.display.addWidget(this.entryHandle, this);
        }
        if (this.popupHandle != 0L) {
            this.display.addWidget(this.popupHandle, this);
        }
        if (this.menuHandle != 0L) {
            this.display.addWidget(this.menuHandle, this);
        }
        if ((imContext = this.imContext()) != 0L) {
            this.display.addWidget(imContext, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.menuHandle != 0L) {
            OS.g_object_unref(this.menuHandle);
        }
        if (this.buttonHandle != 0L) {
            OS.g_object_unref(this.buttonHandle);
        }
        if (this.buttonBoxHandle != 0L) {
            OS.g_object_unref(this.buttonBoxHandle);
        }
        if (this.cellBoxHandle != 0L) {
            OS.g_object_unref(this.cellBoxHandle);
        }
        this.entryHandle = 0L;
        this.buttonHandle = 0L;
        this.menuHandle = 0L;
        this.buttonBoxHandle = 0L;
        this.cellBoxHandle = 0L;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.textRenderer = 0L;
        this.fixIM();
    }

    public void remove(int index) {
        this.checkWidget();
        if (0 > index || index >= this.items.length) {
            this.error(6);
        }
        String[] oldItems = this.items;
        String[] newItems = new String[oldItems.length - 1];
        System.arraycopy(oldItems, 0, newItems, 0, index);
        System.arraycopy(oldItems, index + 1, newItems, index, oldItems.length - index - 1);
        this.items = newItems;
        if (GTK.gtk_combo_box_get_active(this.handle) == index) {
            this.clearText();
        }
        if (this.handle != 0L) {
            GTK.gtk_combo_box_text_remove(this.handle, index);
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (0 > start || start > end || end >= this.items.length) {
            this.error(6);
        }
        String[] oldItems = this.items;
        String[] newItems = new String[oldItems.length - (end - start + 1)];
        System.arraycopy(oldItems, 0, newItems, 0, start);
        System.arraycopy(oldItems, end + 1, newItems, start, oldItems.length - end - 1);
        this.items = newItems;
        int index = GTK.gtk_combo_box_get_active(this.handle);
        if (start <= index && index <= end) {
            this.clearText();
        }
        this.gtk_combo_box_toggle_wrap(false);
        for (int i = end; i >= start; --i) {
            if (this.handle == 0L) continue;
            GTK.gtk_combo_box_text_remove(this.handle, i);
        }
        this.gtk_combo_box_toggle_wrap(true);
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        this.items = new String[0];
        this.clearText();
        this.gtk_combo_box_text_remove_all();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSegmentListener(SegmentListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            return;
        }
        int selected = GTK.gtk_combo_box_get_active(this.handle);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_combo_box_set_active(this.handle, index);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        if ((this.style & 8) != 0 && selected != index) {
            this.sendEvent(24);
        }
        this.unselected = false;
    }

    void setButtonBackgroundGdkRGBA(GdkRGBA rgba) {
        this.buttonBackground = rgba == null ? this.defaultButtonBackground() : rgba;
        String color = this.display.gtk_rgba_to_css_string(this.buttonBackground);
        String css = "* {background: " + color + ";}\n";
        this.cssButtonBackground = css;
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssButtonBackground, this.cssButtonForeground, 8);
        long buttonContext = GTK.gtk_widget_get_style_context(this.buttonHandle);
        if (this.buttonProvider == 0L) {
            this.buttonProvider = GTK.gtk_css_provider_new();
            GTK.gtk_style_context_add_provider(buttonContext, this.buttonProvider, 600);
            OS.g_object_unref(this.buttonProvider);
        }
        if (GTK.GTK4) {
            GTK4.gtk_css_provider_load_from_data(this.buttonProvider, Converter.wcsToMbcs(finalCss, true), -1L);
        } else {
            GTK3.gtk_css_provider_load_from_data(this.buttonProvider, Converter.wcsToMbcs(finalCss, true), -1L, null);
        }
    }

    void setButtonForegroundGdkRGBA(GdkRGBA rgba) {
        GdkRGBA toSet = rgba != null ? rgba : this.display.COLOR_WIDGET_FOREGROUND_RGBA;
        String color = this.display.gtk_rgba_to_css_string(toSet);
        String css = "* {color: " + color + ";}\n";
        this.cssButtonForeground = css;
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssButtonBackground, this.cssButtonForeground, 16);
        long buttonContext = GTK.gtk_widget_get_style_context(this.buttonHandle);
        if (this.buttonProvider == 0L) {
            this.buttonProvider = GTK.gtk_css_provider_new();
            GTK.gtk_style_context_add_provider(buttonContext, this.buttonProvider, 600);
            OS.g_object_unref(this.buttonProvider);
        }
        if (GTK.GTK4) {
            GTK4.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs(finalCss, true), -1L);
        } else {
            GTK3.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs(finalCss, true), -1L, null);
        }
    }

    @Override
    void setBackgroundGdkRGBA(long context, long handle, GdkRGBA rgba) {
        String menuColor;
        String color;
        this.background = rgba == null ? this.defaultBackground() : rgba;
        if (rgba != null) {
            menuColor = color = this.display.gtk_rgba_to_css_string(rgba);
        } else {
            color = (this.style & 8) != 0 ? this.display.gtk_rgba_to_css_string(this.display.COLOR_WIDGET_BACKGROUND_RGBA) : this.display.gtk_rgba_to_css_string(this.display.COLOR_LIST_BACKGROUND_RGBA);
            menuColor = this.display.gtk_rgba_to_css_string(this.display.COLOR_LIST_BACKGROUND_RGBA);
        }
        String css = "* {background: " + color + ";}\n";
        GdkRGBA selectedBackground = this.display.getSystemColor((int)26).handle;
        GdkRGBA selectedForeground = this.display.getSystemColor((int)27).handle;
        css = css + "entry selection {background-color: " + this.display.gtk_rgba_to_css_string(selectedBackground) + ";}\n";
        css = css + "entry selection {color: " + this.display.gtk_rgba_to_css_string(selectedForeground) + ";}";
        this.cssBackground = css;
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        if (this.entryHandle == 0L || (this.style & 8) != 0) {
            this.gtk_css_provider_load_from_css(GTK.gtk_widget_get_style_context(this.buttonHandle), finalCss);
        } else {
            this.gtk_css_provider_load_from_css(GTK.gtk_widget_get_style_context(this.entryHandle), finalCss);
            this.setButtonBackgroundGdkRGBA(rgba);
        }
        String menuCss = "menu { background: " + menuColor + ";}";
        if (GTK.GTK4) {
            GTK4.gtk_css_provider_load_from_data(this.getComboProvider(), Converter.wcsToMbcs(menuCss, true), -1L);
        } else {
            GTK3.gtk_css_provider_load_from_data(this.getComboProvider(), Converter.wcsToMbcs(menuCss, true), -1L, null);
        }
    }

    long getComboProvider() {
        if (this.comboProvider == 0L) {
            this.comboProvider = GTK.gtk_css_provider_new();
            GTK.gtk_style_context_add_provider(GTK.gtk_widget_get_style_context(this.menuHandle), this.comboProvider, 600);
            OS.g_object_unref(this.comboProvider);
        }
        return this.comboProvider;
    }

    @Override
    void setBackgroundGdkRGBA(GdkRGBA rgba) {
        super.setBackgroundGdkRGBA(rgba);
        if (this.entryHandle != 0L) {
            this.setBackgroundGdkRGBA(this.entryHandle, rgba);
        }
        this.setBackgroundGdkRGBA(this.fixedHandle, rgba);
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int newHeight = height;
        if (resize) {
            newHeight = Math.max(this.getTextHeightInPixels(), height);
        }
        return super.setBounds(x, y, width, newHeight, move, resize);
    }

    void setButtonHandle(long widget) {
        if (this.buttonHandle == widget) {
            return;
        }
        if (this.buttonHandle != 0L) {
            this.display.removeWidget(this.buttonHandle);
            OS.g_object_unref(this.buttonHandle);
        }
        this.buttonHandle = widget;
        if (this.buttonHandle != 0L) {
            OS.g_object_ref(this.buttonHandle);
            this.display.addWidget(this.buttonHandle, this);
            this.hookEvents(new long[]{this.buttonHandle});
        }
    }

    void setMenuHandle(long widget) {
        if (this.menuHandle == widget) {
            return;
        }
        if (this.menuHandle != 0L) {
            this.display.removeWidget(this.menuHandle);
            OS.g_object_unref(this.menuHandle);
        }
        this.menuHandle = widget;
        if (this.menuHandle != 0L) {
            OS.g_object_ref(this.menuHandle);
            this.display.addWidget(this.menuHandle, this);
            this.hookEvents(new long[]{this.menuHandle});
        }
    }

    @Override
    void setFontDescription(long font) {
        super.setFontDescription(font);
        if (this.entryHandle != 0L) {
            this.setFontDescription(this.entryHandle, font);
        }
        OS.g_object_set(this.textRenderer, OS.font_desc, font, 0L);
        if ((this.style & 8) != 0) {
            int index = GTK.gtk_combo_box_get_active(this.handle);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_combo_box_set_active(this.handle, -1);
            GTK.gtk_combo_box_set_active(this.handle, index);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        }
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA rgba) {
        if (this.entryHandle != 0L) {
            this.setForegroundGdkRGBA(this.entryHandle, rgba);
        }
        if ((this.style & 8) == 0 && this.buttonHandle != 0L) {
            this.setButtonForegroundGdkRGBA(rgba);
        }
        OS.g_object_set(this.textRenderer, OS.foreground_rgba, rgba, 0L);
        super.setForegroundGdkRGBA(rgba);
    }

    @Override
    void setInitialBounds() {
        if ((this.state & 0x200) != 0 && (this.state & 0x400) != 0) {
            long topHandle = this.topHandle();
            GtkAllocation allocation = new GtkAllocation();
            allocation.x = (this.parent.style & 0x8000000) != 0 ? this.parent.getClientWidth() : 0;
            allocation.y = 0;
            GTK.gtk_widget_set_visible(topHandle, true);
            if (GTK.GTK4) {
                GTK4.gtk_widget_size_allocate(topHandle, allocation, -1);
            } else {
                GTK.gtk_widget_get_preferred_size(topHandle, null, null);
                GTK3.gtk_widget_set_allocation(topHandle, allocation);
            }
        } else {
            super.setInitialBounds();
        }
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > index || index >= this.items.length) {
            this.error(5);
        }
        this.items[index] = string;
        if (this.handle != 0L) {
            GTK.gtk_combo_box_text_remove(this.handle, index);
        }
        this.gtk_combo_box_insert(string, index);
        if ((this.style & 0x4000000) != 0 && this.popupHandle != 0L) {
            GTK3.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
        }
    }

    public void setItems(String ... items) {
        int i;
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        for (i = 0; i < items.length; ++i) {
            if (items[i] != null) continue;
            this.error(5);
        }
        this.items = new String[items.length];
        System.arraycopy(items, 0, this.items, 0, items.length);
        this.clearText();
        this.gtk_combo_box_text_remove_all();
        for (i = 0; i < items.length; ++i) {
            String string = items[i];
            this.gtk_combo_box_insert(string, i);
            if ((this.style & 0x4000000) == 0 || this.popupHandle == 0L) continue;
            GTK3.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
        }
    }

    private void gtk_combo_box_text_remove_all() {
        this.gtk_combo_box_toggle_wrap(false);
        if (this.handle != 0L) {
            GTK.gtk_combo_box_text_remove_all(this.handle);
        }
        this.gtk_combo_box_toggle_wrap(true);
    }

    public void setListVisible(boolean visible) {
        this.checkWidget();
        if (visible) {
            GTK.gtk_combo_box_popup(this.handle);
        } else {
            GTK.gtk_combo_box_popdown(this.handle);
        }
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        if ((this.style & 0x4000000) != 0 || !create) {
            int dir;
            int n = dir = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.entryHandle != 0L) {
                GTK.gtk_widget_set_direction(this.entryHandle, dir);
            }
            if (this.cellHandle != 0L) {
                GTK.gtk_widget_set_direction(this.cellHandle, dir);
            }
            if (!create && this.popupHandle != 0L) {
                GTK3.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, dir);
            }
        }
    }

    @Override
    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            return;
        }
        if (this.entryHandle != 0L) {
            long textPtr = 0L;
            if (GTK.GTK4) {
                long bufferHandle = GTK4.gtk_entry_get_buffer(this.entryHandle);
                textPtr = GTK.gtk_entry_buffer_get_text(bufferHandle);
            } else {
                textPtr = GTK3.gtk_entry_get_text(this.entryHandle);
            }
            int start = (int)OS.g_utf16_offset_to_utf8_offset(textPtr, selection.x);
            int end = (int)OS.g_utf16_offset_to_utf8_offset(textPtr, selection.y);
            GTK.gtk_editable_set_position(this.entryHandle, start);
            GTK.gtk_editable_select_region(this.entryHandle, start, end);
        }
    }

    public void setText(String string) {
        long ptr;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int index = this.indexOf(string);
            if (index == -1) {
                return;
            }
            this.select(index);
            return;
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, (int)OS.g_utf16_strlen(ptr = GTK3.gtk_entry_get_text(this.entryHandle), -1L))) == null) {
            return;
        }
        byte[] buffer = Converter.wcsToMbcs(string, true);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
        if (GTK.GTK4) {
            long bufferHandle = GTK4.gtk_entry_get_buffer(this.entryHandle);
            GTK.gtk_entry_buffer_set_text(bufferHandle, buffer, string.length());
        } else {
            GTK3.gtk_entry_set_text(this.entryHandle, buffer);
        }
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
        this.sendEvent(24);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        if (this.entryHandle != 0L) {
            GTK.gtk_entry_set_max_length(this.entryHandle, limit);
        }
    }

    @Override
    void setToolTipText(Shell shell, String newString) {
        if (this.entryHandle != 0L) {
            this.setToolTipText(this.entryHandle, newString);
        }
        if (this.buttonHandle != 0L) {
            this.setToolTipText(this.buttonHandle, newString);
        }
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        this.visibleCount = count;
    }

    @Override
    boolean checkSubwindow() {
        return false;
    }

    @Override
    boolean translateTraversal(long event) {
        int[] key = new int[1];
        if (GTK.GTK4) {
            key[0] = GDK.gdk_key_event_get_keyval(event);
        } else {
            GDK.gdk_event_get_keyval(event, key);
        }
        switch (key[0]) {
            case 65293: 
            case 65421: {
                long imContext = this.imContext();
                if (imContext == 0L) break;
                long[] preeditString = new long[1];
                GTK.gtk_im_context_get_preedit_string(imContext, preeditString, null, null);
                if (preeditString[0] == 0L) break;
                int length = C.strlen(preeditString[0]);
                OS.g_free(preeditString[0]);
                if (length == 0) break;
                return false;
            }
        }
        return super.translateTraversal(event);
    }

    String verifyText(String string, int start, int end) {
        long eventPtr;
        if (string.length() == 0 && start == end) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        long l = eventPtr = GTK.GTK4 ? 0L : GTK3.gtk_get_current_event();
        if (eventPtr != 0L) {
            int type = GDK.gdk_event_get_event_type(eventPtr);
            type = Combo.fixGdkEventTypeValues(type);
            switch (type) {
                case 8: {
                    this.setKeyState(event, eventPtr);
                }
            }
            this.gdk_event_free(eventPtr);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

