/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.office.PropertySet;
import writer2latex.office.SectionStyle;
import writer2latex.util.Misc;

public class PageMaster
extends SectionStyle {
    private String sPageUsage = null;
    private boolean bHasFootnoteSep = false;
    private PropertySet footnoteSep = new PropertySet();
    private boolean bHasHeaderStyle = false;
    private PropertySet headerStyle = new PropertySet();
    private boolean bHasFooterStyle = false;
    private PropertySet footerStyle = new PropertySet();

    public String getPageUsage() {
        return this.sPageUsage;
    }

    public boolean hasFootnoteSep() {
        return this.bHasFootnoteSep;
    }

    public String getFootnoteProperty(String sPropName) {
        return this.footnoteSep.getProperty(sPropName);
    }

    public boolean hasHeaderStyle() {
        return this.bHasHeaderStyle;
    }

    public String getHeaderProperty(String sPropName) {
        return this.headerStyle.getProperty(sPropName);
    }

    public boolean hasFooterStyle() {
        return this.bHasFooterStyle;
    }

    public String getFooterProperty(String sPropName) {
        return this.footerStyle.getProperty(sPropName);
    }

    public void loadStyleFromDOM(Node node) {
        Element fnsNode;
        Element properties;
        Element fsNode;
        super.loadStyleFromDOM(node);
        this.sPageUsage = Misc.getAttribute(node, "style:page-usage");
        Element hsNode = Misc.getChildByTagName(node, "style:header-style");
        if (hsNode != null) {
            this.bHasHeaderStyle = true;
            Element hsProperties = Misc.getChildByTagName(hsNode, "style:properties");
            if (hsProperties != null) {
                this.headerStyle.loadFromDOM(hsProperties);
            }
        }
        if ((fsNode = Misc.getChildByTagName(node, "style:footer-style")) != null) {
            this.bHasFooterStyle = true;
            Element fsProperties = Misc.getChildByTagName(fsNode, "style:properties");
            if (fsProperties != null) {
                this.footerStyle.loadFromDOM(fsProperties);
            }
        }
        if ((properties = Misc.getChildByTagName(node, "style:properties")) != null && (fnsNode = Misc.getChildByTagName(properties, "style:footnote-sep")) != null) {
            this.bHasFootnoteSep = true;
            this.footnoteSep.loadFromDOM(fnsNode);
        }
    }
}

