/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
* Portions Copyright (C) Ruediger Klehn (2014)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder.tests;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import GoGrinder.FileWorks;

public class StringChecker {
    int num;

    /** Creates a new instance of StringChecker */
    public StringChecker() throws Exception { 
        System.out.println("We need a folder with resource files (messages*.properties) from the .jar file.");
        File[] checkThisFolderF = FileWorks.selectFolder(1, "Select folder with properties files", "This folder!", "", false);
        if (checkThisFolderF[0].getPath().equals("")){
          System.out.println("\n No folder, no checking.");  // .err. -> .out.
          return;
        }
        System.out.println(""); // would be good to give the folder by command line and hand it over // .err. -> .out.
        System.out.println("Checking files in folder \"" + checkThisFolderF[0].getPath() + "\" for strings..."); //$NON-NLS-1$ //$NON-NLS-2$ 
               // .err. -> .out.
        System.out.println("We compare the resource files to \"messages.properties\", which has the default strings. \n");
        num = 0; // .err. -> .out.
        
        checkDir(checkThisFolderF[0]); //$NON-NLS-1$ 
    }  
    
    //	Check to make sure all property files contain
    //	the same set of strings
    public void checkDir(File dir) throws Exception { 
    	ArrayList propFiles = new ArrayList();
    	ArrayList filenames = new ArrayList();
    	
    	File [] files = dir.listFiles();
    	for (int i = 0; i < files.length; i++) {
			File f = files[i];
			if(f.getName().endsWith(".properties")) { //$NON-NLS-1$
				Properties p = new Properties();
				p.load(new FileInputStream(f));
				propFiles.add(p);
				filenames.add(f.getName());
			}
		}
    	if (filenames.size() < 2) {
    	  System.out.println("\n Not enough *.properties files in " + dir.getPath() + "\n"
    	                   + "Counted " + filenames.size() + " .properties files.");  // .err. -> .out.
    	  return;
      }
// instead of console: redirect output to file (or logfile?) (in /tmp?), then open message box with path to file (and open file?)
    	HashMap [] missingProps = new HashMap[propFiles.size()];
    	for(int i = 0; i < missingProps.length; i++)
    		missingProps[i] = new HashMap();
    	Properties p = (Properties)propFiles.get(0);
    	Iterator iter = p.keySet().iterator();
    	while(iter.hasNext()) {
    		String key = (String)iter.next();
    		for(int i = 1; i < propFiles.size(); i++) {
    			Properties prop = (Properties)propFiles.get(i);
    			String val = prop.getProperty(key);
    			if(val == null)
    				missingProps[i].put(key, ((Properties)propFiles.get(0)).get(key));
    			else prop.remove(key);
    		}
    	}
    	
    	for(int i = 0; i < missingProps.length; i++) {
    		if(missingProps[i].size() == 0)
    			continue;
    		
    		System.out.println(""); // .err. -> .out.
    		System.out.println(""); // .err. -> .out.
    		System.out.println("*** " + filenames.get(i) + " ***:");  //$NON-NLS-1$//$NON-NLS-2$ // .err. -> .out.
    		System.out.println(""); // .err. -> .out.
    		iter = missingProps[i].keySet().iterator();
    		while(iter.hasNext()) {
    			String key = (String)iter.next();
    			System.out.println(key + "=" + missingProps[i].get(key)); //$NON-NLS-1$ // .err. -> .out.
    		}
    	}
    	
    	for(int i = 1; i < propFiles.size(); i++) {
    		p = (Properties)propFiles.get(i);
    		iter = p.keySet().iterator();
    		while(iter.hasNext()) {
    			String key = (String)iter.next();
    			System.out.println("\n Key " + key + " is not in all files"); //$NON-NLS-1$ //$NON-NLS-2$ // .err. -> .out.
    		}
    	}
    }
    
    public static void main(String[] args) {
    	try {
    		new StringChecker();
    	}
    	catch(Exception e) {
    		e.printStackTrace();
    	}
    }
    
}
