/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.master;

import gen.core.filters.Files;
import gen.core.filters.Filter;
import gen.core.filters.Filters;
import java.util.List;
import java.util.Objects;

public final class FiltersUtil {
    private FiltersUtil() {
    }

    public static boolean filtersEqual(Filters o1, Filters o2) {
        if (o1 == o2) {
            return true;
        }
        return o1.isIgnoreFileContext() == o2.isIgnoreFileContext() && o1.isPreserveSpaces() == o2.isPreserveSpaces() && o1.isRemoveSpacesNonseg() == o2.isRemoveSpacesNonseg() && o1.isRemoveTags() == o2.isRemoveTags() && FiltersUtil.filterListsEqual(o1.getFilters(), o2.getFilters());
    }

    private static boolean filterListsEqual(List<Filter> filters, List<Filter> filters2) {
        if (filters == filters2) {
            return true;
        }
        if (filters.size() != filters2.size()) {
            return false;
        }
        for (int i = 0; i < filters.size(); ++i) {
            if (FiltersUtil.filterObjsEqual(filters.get(i), filters2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean filterObjsEqual(Filter filter, Filter filter2) {
        if (filter == filter2) {
            return true;
        }
        return filter.isEnabled() == filter2.isEnabled() && Objects.equals(filter.getClassName(), filter2.getClassName()) && FiltersUtil.filesEqual(filter.getFiles(), filter2.getFiles()) && FiltersUtil.optionsEqual(filter.getOption(), filter2.getOption());
    }

    private static boolean optionsEqual(List<Filter.Option> option, List<Filter.Option> option2) {
        if (option == option2) {
            return true;
        }
        if (option.size() != option2.size()) {
            return false;
        }
        for (int i = 0; i < option.size(); ++i) {
            if (FiltersUtil.optionObjsEqual(option.get(i), option2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean optionObjsEqual(Filter.Option option, Filter.Option option2) {
        if (option == option2) {
            return true;
        }
        return Objects.equals(option.getName(), option2.getName()) && Objects.equals(option.getValue(), option2.getValue());
    }

    private static boolean filesEqual(List<Files> files, List<Files> files2) {
        if (files == files2) {
            return true;
        }
        if (files.size() != files2.size()) {
            return false;
        }
        for (int i = 0; i < files.size(); ++i) {
            if (FiltersUtil.fileObjsEqual(files.get(i), files2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean fileObjsEqual(Files files, Files files2) {
        if (files == files2) {
            return true;
        }
        return Objects.equals(files.getSourceEncoding(), files2.getSourceEncoding()) && Objects.equals(files.getSourceFilenameMask(), files2.getSourceFilenameMask()) && Objects.equals(files.getTargetEncoding(), files2.getTargetEncoding()) && Objects.equals(files.getTargetFilenamePattern(), files2.getTargetFilenamePattern());
    }
}

