/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Set;
import org.testng.IInvokedMethod;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;

final class ExceptionUtils {
    private ExceptionUtils() {
    }

    static Throwable getExceptionDetails(ITestContext context, Object instance) {
        Set<ITestResult> configResults = context.getFailedConfigurations().getAllResults();
        if (configResults.isEmpty()) {
            configResults = context.getSkippedConfigurations().getAllResults();
        }
        if (configResults.isEmpty()) {
            return ExceptionUtils.getConfigFailureException(context);
        }
        for (ITestResult configResult : configResults) {
            if (!ExceptionUtils.sameInstance(configResult, instance)) continue;
            return configResult.getThrowable();
        }
        return configResults.iterator().next().getThrowable();
    }

    private static boolean sameInstance(ITestResult configResult, Object instance) {
        return instance.equals(configResult.getInstance());
    }

    private static Throwable getConfigFailureException(ITestContext context) {
        for (IInvokedMethod method : context.getSuite().getAllInvokedMethods()) {
            ITestNGMethod m = method.getTestMethod();
            if (!m.isBeforeSuiteConfiguration() || method.getTestResult().isSuccess()) continue;
            return method.getTestResult().getThrowable();
        }
        return null;
    }
}

