/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.Signature;
import com.jcraft.jsch.Util;
import com.jcraft.jsch.jbcrypt.BCrypt;
import java.util.Arrays;

class KeyPairDeferred
extends KeyPair {
    private KeyPair delegate;

    KeyPairDeferred(JSch jsch) {
        super(jsch);
    }

    @Override
    public boolean decrypt(String _passphrase) {
        return this.decrypt(Util.str2byte(_passphrase));
    }

    @Override
    public boolean decrypt(byte[] _passphrase) {
        try {
            if (!this.isEncrypted()) {
                return true;
            }
            if (_passphrase == null) {
                this.jsch.getInstanceLogger().log(3, "no passphrase set.");
                return false;
            }
            this.initCipher(_passphrase);
            byte[] plain = new byte[this.data.length];
            this.cipher.update(this.data, 0, this.data.length, plain, 0);
            int type = KeyPairDeferred.readOpenSSHKeyv1(plain);
            this.delegate = KeyPairDeferred.getKeyPair(this.jsch, null, null, null, false, plain, this.getPublicKeyBlob(), type, 4, this.publicKeyComment, this.cipher, null, null);
            return this.delegate != null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not sucessfully decrypt openssh v1 key", e);
        }
    }

    private void initCipher(byte[] _passphrase) throws Exception {
        if (!"bcrypt".equals(this.kdfName)) {
            throw new IllegalStateException("No support for KDF '" + this.kdfName + "'.");
        }
        Buffer opts = new Buffer(this.kdfOptions);
        byte[] keyiv = new byte[48];
        new BCrypt().pbkdf(_passphrase, opts.getString(), opts.getInt(), keyiv);
        Arrays.fill(_passphrase, (byte)0);
        byte[] key = Arrays.copyOfRange(keyiv, 0, 32);
        byte[] iv = Arrays.copyOfRange(keyiv, 32, 48);
        this.cipher.init(1, key, iv);
    }

    @Override
    void generate(int key_size) throws JSchException {
        throw new UnsupportedOperationException();
    }

    @Override
    byte[] getBegin() {
        return this.requireDecrypted(this.delegate).getBegin();
    }

    @Override
    byte[] getEnd() {
        return this.requireDecrypted(this.delegate).getEnd();
    }

    @Override
    public int getKeySize() {
        return this.requireDecrypted(this.delegate).getKeySize();
    }

    @Override
    public byte[] getSignature(byte[] data) {
        return this.requireDecrypted(this.delegate).getSignature(data);
    }

    @Override
    public byte[] getSignature(byte[] data, String alg) {
        return this.requireDecrypted(this.delegate).getSignature(data, alg);
    }

    @Override
    public Signature getVerifier() {
        return this.requireDecrypted(this.delegate).getVerifier();
    }

    @Override
    public Signature getVerifier(String alg) {
        return this.requireDecrypted(this.delegate).getVerifier(alg);
    }

    @Override
    public byte[] forSSHAgent() throws JSchException {
        return this.requireDecrypted(this.delegate).forSSHAgent();
    }

    @Override
    byte[] getPrivateKey() {
        return this.requireDecrypted(this.delegate).getPrivateKey();
    }

    @Override
    byte[] getKeyTypeName() {
        return this.requireDecrypted(this.delegate).getKeyTypeName();
    }

    @Override
    public int getKeyType() {
        return this.requireDecrypted(this.delegate).getKeyType();
    }

    @Override
    boolean parse(byte[] data) {
        return this.requireDecrypted(this.delegate).parse(data);
    }

    @Override
    public byte[] getPublicKeyBlob() {
        return this.delegate != null ? this.delegate.getPublicKeyBlob() : null;
    }

    @Override
    public String getPublicKeyComment() {
        return this.requireDecrypted(this.delegate).getPublicKeyComment();
    }

    @Override
    public String getFingerPrint() {
        return this.requireDecrypted(this.delegate).getFingerPrint();
    }

    @Override
    public boolean isEncrypted() {
        return this.delegate != null ? this.delegate.isEncrypted() : super.isEncrypted();
    }

    private <T> T requireDecrypted(T obj) {
        if (obj == null) {
            throw new IllegalStateException("encrypted key has not been decrypted yet.");
        }
        return obj;
    }
}

