/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.phrasetable;

import edu.berkeley.nlp.lm.ConfigOptions;
import edu.berkeley.nlp.lm.WordIndexer;
import edu.berkeley.nlp.lm.io.LmReaderCallback;
import edu.berkeley.nlp.lm.map.HashNgramMap;
import edu.berkeley.nlp.lm.phrasetable.PhraseTableCounts;
import edu.berkeley.nlp.lm.phrasetable.PhraseTableValueContainer;

public class MosesPhraseTableReaderCallback<W>
implements LmReaderCallback<PhraseTableCounts> {
    private final HashNgramMap<PhraseTableValueContainer.PhraseTableValues> phrases;

    public MosesPhraseTableReaderCallback(WordIndexer<W> wordIndexer) {
        PhraseTableValueContainer values = new PhraseTableValueContainer(wordIndexer.getOrAddIndexFromString("<<sep>>"), 5);
        this.phrases = HashNgramMap.createExplicitWordHashNgramMap(values, new ConfigOptions(), 20, false);
    }

    @Override
    public void call(int[] ngram, int startPos, int endPos, PhraseTableCounts value, String words) {
        for (int ngramOrder = 0; ngramOrder < endPos - startPos; ++ngramOrder) {
            this.phrases.put(ngram, startPos, startPos + ngramOrder + 1, new PhraseTableValueContainer.TargetTranslationsValues());
        }
        this.phrases.put(ngram, startPos, endPos, new PhraseTableValueContainer.FeaturePhraseTableValues(value.features));
    }

    @Override
    public void cleanup() {
        this.phrases.trim();
    }

    public HashNgramMap<PhraseTableValueContainer.PhraseTableValues> getMap() {
        return this.phrases;
    }
}

