/*
 * Decompiled with CFR 0.152.
 */
package jflex;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jflex.Action;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EOFActions {
    private Map<Integer, Action> actions = new HashMap<Integer, Action>();
    private Action defaultAction;
    private int numLexStates;

    public void setNumLexStates(int num) {
        this.numLexStates = num;
    }

    public void add(List<Integer> stateList, Action action) {
        if (stateList != null && stateList.size() > 0) {
            for (Integer state : stateList) {
                this.add(state, action);
            }
        } else {
            this.defaultAction = action.getHigherPriority(this.defaultAction);
            for (int state = 0; state < this.numLexStates; ++state) {
                if (this.actions.get(state) == null) continue;
                Action oldAction = this.actions.get(state);
                this.actions.put(state, oldAction.getHigherPriority(action));
            }
        }
    }

    public void add(Integer state, Action action) {
        if (this.actions.get(state) == null) {
            this.actions.put(state, action);
        } else {
            Action oldAction = this.actions.get(state);
            this.actions.put(state, oldAction.getHigherPriority(action));
        }
    }

    public boolean isEOFAction(Object a) {
        if (a == this.defaultAction) {
            return true;
        }
        for (Action action : this.actions.values()) {
            if (a != action) continue;
            return true;
        }
        return false;
    }

    public Action getAction(int state) {
        return this.actions.get(state);
    }

    public Action getDefault() {
        return this.defaultAction;
    }

    public int numActions() {
        return this.actions.size();
    }
}

