/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.cassandra.schema.KeyspaceMetadata;

public final class Keyspaces
implements Iterable<KeyspaceMetadata> {
    private final ImmutableMap<String, KeyspaceMetadata> keyspaces;

    private Keyspaces(Builder builder) {
        this.keyspaces = builder.keyspaces.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Keyspaces none() {
        return Keyspaces.builder().build();
    }

    public static Keyspaces of(KeyspaceMetadata ... keyspaces) {
        return Keyspaces.builder().add(keyspaces).build();
    }

    @Override
    public Iterator<KeyspaceMetadata> iterator() {
        return this.keyspaces.values().iterator();
    }

    public Stream<KeyspaceMetadata> stream() {
        return this.keyspaces.values().stream();
    }

    public Keyspaces filter(Predicate<KeyspaceMetadata> predicate) {
        Builder builder = Keyspaces.builder();
        this.stream().filter(predicate).forEach(builder::add);
        return builder.build();
    }

    MapDifference<String, KeyspaceMetadata> diff(Keyspaces other) {
        return Maps.difference(this.keyspaces, other.keyspaces);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Keyspaces && this.keyspaces.equals(((Keyspaces)o).keyspaces);
    }

    public int hashCode() {
        return this.keyspaces.hashCode();
    }

    public String toString() {
        return this.keyspaces.values().toString();
    }

    public static final class Builder {
        private final ImmutableMap.Builder<String, KeyspaceMetadata> keyspaces = new ImmutableMap.Builder();

        private Builder() {
        }

        public Keyspaces build() {
            return new Keyspaces(this);
        }

        public Builder add(KeyspaceMetadata keyspace) {
            this.keyspaces.put((Object)keyspace.name, (Object)keyspace);
            return this;
        }

        public Builder add(KeyspaceMetadata ... keyspaces) {
            for (KeyspaceMetadata keyspace : keyspaces) {
                this.add(keyspace);
            }
            return this;
        }

        public Builder add(Iterable<KeyspaceMetadata> keyspaces) {
            keyspaces.forEach(this::add);
            return this;
        }
    }
}

